/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisInfo.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.authorization.permit.dto.SearchUserDto;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.code.plus.dto.CodePlusDto;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleRefService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.job.core.enums.ExecuteType;
import com.jxdinfo.hussar.support.job.core.enums.ProcessorType;
import com.jxdinfo.hussar.support.job.core.enums.TimeExpressionType;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.spc.adapter.api.dict.service.IDictAPIService;
import com.jxdinfo.spc.adapter.api.dict.vo.DictApiVo;
import com.jxdinfo.spc.adapter.api.job.dto.JobInfoApiDto;
import com.jxdinfo.spc.adapter.api.job.service.IJobApiService;
import com.jxdinfo.spc.adapter.api.organUser.service.IOrganUserApiService;
import com.jxdinfo.spc.adapter.api.oss.service.IAttachmentManagerApiService;
import com.jxdinfo.spc.adapter.api.oss.vo.AttachmentManagerModelApiVo;
import com.jxdinfo.spc.core.analysisDataSource.model.AnalysisDataSource;
import com.jxdinfo.spc.core.analysisDataSource.model.HistoryDataSource;
import com.jxdinfo.spc.core.analysisDataSource.service.IAnalysisDataSourceService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.constant.AnalysisInfoFieldConstant;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dao.AnalysisInfoMapper;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AnalysisBaseDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AnalysisInfoDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AnalysisInfoQueryDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AnalysisParamDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AbnormalData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AnalysisInfoEntity;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.BinomialProbability;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.Boxplot;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.ControlData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.FieldTypeCompareEntity;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.HistoryAnalysis;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.HistoryResult;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.NormalTest;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.ProcessCapability;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.AbnormalDataService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.AsyncAnalysisInfoService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.BinomialProbabilityService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.BoxplotService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.ControlDataService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.FieldTypeCompareService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.FilterFieldInfoService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.IAnalysisInfoService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.NormalTestService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.ProcessCapabilityService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.util.ImportUtil;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.AnalysisInfoCountVo;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.AnalysisInfoVo;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.AnalysisResultVO;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.FilterFieldInfoVo;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.FilterFieldListVo;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.ImportVo;
import com.jxdinfo.spc.core.analysisManage.analysisTool.dto.BasicStatisticDataDto;
import com.jxdinfo.spc.core.analysisManage.analysisTool.entity.ChartStatistic;
import com.jxdinfo.spc.core.analysisManage.analysisTool.service.SpcService;
import com.jxdinfo.spc.core.analysisManage.analysisTool.vo.ChartStatisticVo;
import com.jxdinfo.spc.core.analysisManage.relationRule.model.RelationRuleEntity;
import com.jxdinfo.spc.core.analysisManage.relationRule.service.IRelationRuleService;
import com.jxdinfo.spc.core.analysisManage.relationRule.vo.RelationRuleVO;
import com.jxdinfo.spc.core.analysisManage.relationRule.vo.RuleDictVo;
import com.jxdinfo.spc.core.analysisManage.relationWarnObject.model.RelationWarnObjectEntity;
import com.jxdinfo.spc.core.analysisManage.relationWarnObject.service.IRelationWarnObjectService;
import com.jxdinfo.spc.core.baseManage.baseConfig.dto.BaseConfigDto;
import com.jxdinfo.spc.core.baseManage.baseConfig.model.ProcessVariableEntity;
import com.jxdinfo.spc.core.baseManage.baseConfig.service.IBaseConfigService;
import com.jxdinfo.spc.core.baseManage.baseConfig.service.IProcessVariableService;
import com.jxdinfo.spc.core.baseManage.baseConfig.vo.ProcessVariableVo;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.model.ControlProject;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.model.ControlProjectType;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.service.ControlProjectService;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.service.ControlProjectTypeService;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.vo.ControlProjectVo;
import com.jxdinfo.spc.core.changeAnalysisRecord.model.ChangeAnalysisRecordEntity;
import com.jxdinfo.spc.core.changeAnalysisRecord.service.IChangeAnalysisRecordService;
import com.jxdinfo.spc.core.common.config.SpcProperties;
import com.jxdinfo.spc.core.common.constant.CommonConstant;
import com.jxdinfo.spc.core.common.dto.SpcMessageDto;
import com.jxdinfo.spc.core.common.service.IMessageSendService;
import com.jxdinfo.spc.core.common.service.ISpcBaseConfigService;
import com.jxdinfo.spc.core.common.util.CommonUtils;
import com.jxdinfo.spc.core.common.vo.SpcBaseConfigVo;
import com.jxdinfo.spc.core.dataPool.service.IDataPoolDataService;
import com.jxdinfo.spc.core.dataPool.vo.DataPoolDataVo;
import com.jxdinfo.spc.core.operatelog.common.enums.LogType;
import com.jxdinfo.spc.core.operatelog.context.OperateLogContext;
import com.jxdinfo.spc.core.operatelog.context.OperateLogContextBuilder;
import com.jxdinfo.spc.core.operatelog.dto.OperateLogAPIDTO;
import com.jxdinfo.spc.core.operatelog.model.OperateLog;
import com.jxdinfo.spc.core.operatelog.service.OperateLogAPIService;
import com.jxdinfo.spc.core.operatelog.service.OperateLogService;
import com.jxdinfo.spc.core.operatelog.util.DiffUtil;
import com.jxdinfo.spc.core.operatelog.vo.ChangeValue;
import com.jxdinfo.spc.core.operatelog.vo.JsonItem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AnalysisInfoServiceImpl
extends HussarServiceImpl<AnalysisInfoMapper, AnalysisInfoEntity>
implements IAnalysisInfoService {
    @Resource
    private AnalysisInfoMapper analysisInfoMapper;
    @Resource
    private IRelationRuleService relationRuleService;
    @Resource
    private IRelationWarnObjectService relationWarnObjectService;
    @Resource
    private IAnalysisDataSourceService analysisDataSourceService;
    @Resource
    private ISysCodeRuleRefService sysCodeRuleRefService;
    @Autowired
    private IBaseConfigService baseConfigService;
    @Resource
    private FilterFieldInfoService filterFieldInfoService;
    @Resource
    private FieldTypeCompareService fieldTypeCompareService;
    @Resource
    private IDictAPIService dictApiService;
    @Resource
    private IProcessVariableService processVariableService;
    @Resource
    private IAttachmentManagerApiService attachmentManagerApiService;
    @Resource
    private ISpcBaseConfigService spcBaseConfigService;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private ControlDataService controlDataService;
    @Resource
    private IChangeAnalysisRecordService changeAnalysisRecordService;
    @Resource
    private ProcessCapabilityService processCapabilityService;
    @Resource
    private NormalTestService normalTestService;
    @Resource
    private BoxplotService boxplotService;
    @Resource
    private AbnormalDataService abnormalDataService;
    @Resource
    private IJobApiService jobApiService;
    @Resource
    private OperateLogAPIService operateLogAPIService;
    @Resource
    private OperateLogService operateLogService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ControlProjectService controlProjectService;
    @Resource
    private ControlProjectTypeService controlProjectTypeService;
    @Resource
    private IMessageSendService messageSendService;
    @Resource
    private SpcProperties spcProperties;
    @Resource
    private SpcService spcService;
    @Resource
    private AsyncAnalysisInfoService asyncAnalysisInfoService;
    @Resource
    private IOrganUserApiService organUserApiService;
    @Resource
    private BinomialProbabilityService binomialProbabilityService;
    @Resource
    private IDataPoolDataService dataPoolDataService;

    @Override
    @HussarTransactional
    public Long save(AnalysisInfoDto analysisInfoDto) {
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        AnalysisInfoEntity analysisInfoEntity = this.saveAnalysisInfo(analysisInfoDto, user, date);
        OperateLogAPIDTO operateLogAPIDTO = OperateLogAPIDTO.fromBusiness(LogType.ANALYSIS_ADD, null, analysisInfoEntity.getAnalysisId(), analysisInfoEntity.getAnalysisCode());
        OperateLogContext context = OperateLogContextBuilder.create(operateLogAPIDTO).build();
        this.operateLogAPIService.save(context);
        return analysisInfoEntity.getAnalysisId();
    }

    @Override
    public AnalysisInfoEntity saveAnalysisInfo(AnalysisInfoDto analysisInfoDto, SecurityUser user, LocalDateTime date) {
        AnalysisInfoEntity analysisInfoEntity = (AnalysisInfoEntity)((Object)BeanUtil.copy((Object)analysisInfoDto, AnalysisInfoEntity.class));
        if (HussarUtils.isEmpty((Object)((Object)analysisInfoEntity)) || HussarUtils.isNotEmpty((Object)analysisInfoEntity.getAnalysisId())) {
            throw new HussarException("\u5f53\u524d\u5206\u6790\u56fe\u5df2\u5b58\u5728");
        }
        CodePlusDto codePlusDto = new CodePlusDto();
        codePlusDto.setRuleCode("ANALYSIS_CODE");
        String analysisCode = this.sysCodeRuleRefService.getCurrentCodeByCache(codePlusDto);
        analysisInfoEntity.setCreatorName(user.getUserName());
        analysisInfoEntity.setLastEditorName(user.getUserName());
        analysisInfoEntity.setAnalysisCode(analysisCode);
        analysisInfoEntity.setIsPause("0");
        analysisInfoEntity.setChargePersonId(user.getUserId());
        analysisInfoEntity.setChargePersonName(user.getUserName());
        analysisInfoEntity.setAnalysisStatus("1");
        analysisInfoEntity.setIsPolling("0");
        analysisInfoEntity.setLastSort(0);
        if ("1".equals(analysisInfoEntity.getDataType()) || "xmr".equals(analysisInfoEntity.getAnalysisType())) {
            SpcBaseConfigVo spcBaseConfigVo = this.spcBaseConfigService.getSpcBaseConfigByKey("virtual_sub_group_size");
            analysisInfoEntity.setVirtualSubgroupSize(Integer.parseInt(spcBaseConfigVo.getConfigValue()));
        } else {
            analysisInfoEntity.setVirtualSubgroupSize(analysisInfoEntity.getSubgroupSize());
        }
        if ("3".equals(analysisInfoDto.getSourceType()) || HussarUtils.isNotEmpty(analysisInfoDto.getAnalysisDataSourceList()) || HussarUtils.isNotEmpty((Object)analysisInfoDto.getFileId())) {
            analysisInfoEntity.setDataStatus("1");
        } else {
            analysisInfoEntity.setDataStatus("0");
        }
        if (HussarUtils.isNotEmpty((Object)analysisInfoDto.getFilterFieldList()) && "3".equals(analysisInfoDto.getSourceType())) {
            Iterator<RelationWarnObjectEntity> filterConditions = JSONObject.toJSONString((Object)analysisInfoDto.getFilterFieldList());
            analysisInfoEntity.setFilterConditions((String)((Object)filterConditions));
        }
        if ("3".equals(analysisInfoDto.getSourceType()) && HussarUtils.isEmpty((Object)analysisInfoDto.getRefreshInterval())) {
            analysisInfoEntity.setIsPause("1");
            analysisInfoEntity.setAnalysisStatus("3");
        }
        this.save((BaseEntity)analysisInfoEntity);
        if (HussarUtils.isNotEmpty(analysisInfoDto.getRelationRuleEntityList())) {
            for (RelationRuleEntity relationRuleEntity : analysisInfoDto.getRelationRuleEntityList()) {
                relationRuleEntity.setAnalysisId(analysisInfoEntity.getAnalysisId());
                relationRuleEntity.setCreatorName(user.getUserName());
                relationRuleEntity.setLastEditorName(user.getUserName());
            }
            this.relationRuleService.saveBatch(analysisInfoDto.getRelationRuleEntityList());
        }
        if (HussarUtils.isNotEmpty(analysisInfoDto.getRelationWarnObjectEntityList())) {
            for (RelationWarnObjectEntity relationWarnObjectEntity : analysisInfoDto.getRelationWarnObjectEntityList()) {
                relationWarnObjectEntity.setAnalysisId(analysisInfoEntity.getAnalysisId());
            }
            this.relationWarnObjectService.saveBatch(analysisInfoDto.getRelationWarnObjectEntityList());
        }
        List analysisDataSourceList = analysisInfoDto.getAnalysisDataSourceList();
        if (HussarUtils.isNotEmpty((Object)analysisInfoDto.getFileId()) && "1".equals(analysisInfoDto.getSourceType())) {
            String cache = "analysisImport" + analysisInfoDto.getFileId();
            analysisDataSourceList = (List)DefaultCacheUtil.get((Object)cache);
        }
        if (HussarUtils.isNotEmpty(analysisDataSourceList)) {
            for (AnalysisDataSource analysisDataSource : analysisDataSourceList) {
                analysisDataSource.setAnalysisId(analysisInfoEntity.getAnalysisId());
                analysisDataSource.setCreatorName(user.getUserName());
                analysisDataSource.setLastEditorName(user.getUserName());
                analysisDataSource.setIsExclude("0");
                analysisDataSource.setAnalysisType(analysisInfoEntity.getAnalysisType());
            }
            this.analysisDataSourceService.saveBatch(analysisDataSourceList);
            analysisInfoEntity.setAnalysisDataSourceList(analysisDataSourceList);
        }
        if (HussarUtils.isNotEmpty((Object)analysisInfoDto.getFileId())) {
            this.attachmentManagerApiService.updateBusinessIdByFileId(analysisInfoEntity.getAnalysisId(), analysisInfoDto.getFileId());
        }
        return analysisInfoEntity;
    }

    @Override
    public Boolean update(AnalysisInfoDto analysisInfoDto) {
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        AnalysisInfoEntity oldAnalysisInfoEntity = (AnalysisInfoEntity)((Object)this.getById(analysisInfoDto.getAnalysisId()));
        List oldRelationWarnObjectEntityList = this.relationWarnObjectService.list((Wrapper)new LambdaQueryWrapper().eq(RelationWarnObjectEntity::getAnalysisId, (Object)oldAnalysisInfoEntity.getAnalysisId()));
        AnalysisInfoEntity analysisInfoEntity = this.updateAnalysisInfo(oldAnalysisInfoEntity, analysisInfoDto, user, date);
        if (HussarUtils.isEmpty((Object)((Object)oldAnalysisInfoEntity))) {
            return true;
        }
        this.saveOperateLogBaseInfo(oldAnalysisInfoEntity, analysisInfoEntity);
        this.saveOperateLogGroup(oldAnalysisInfoEntity, analysisInfoEntity, oldRelationWarnObjectEntityList, analysisInfoDto.getRelationWarnObjectEntityList());
        this.saveOperateLogDataSource(oldAnalysisInfoEntity, analysisInfoEntity);
        return true;
    }

    @Override
    public AnalysisInfoEntity updateAnalysisInfo(AnalysisInfoEntity oldAnalysisInfo, AnalysisInfoDto analysisInfoDto, SecurityUser user, LocalDateTime date) {
        Object analysisDataSourceList;
        AnalysisInfoEntity analysisInfoEntity = (AnalysisInfoEntity)((Object)BeanUtil.copy((Object)analysisInfoDto, AnalysisInfoEntity.class));
        if (HussarUtils.isNotEmpty((Object)oldAnalysisInfo.getJobId())) {
            assert (analysisInfoEntity != null);
            analysisInfoEntity.setJobId(oldAnalysisInfo.getJobId());
        }
        if (HussarUtils.isEmpty((Object)((Object)analysisInfoEntity)) || HussarUtils.isEmpty((Object)analysisInfoEntity.getAnalysisId())) {
            throw new HussarException("\u5f53\u524d\u5206\u6790\u56fe\u4e0d\u5b58\u5728");
        }
        analysisInfoEntity.setLastAnalysisTime(date);
        analysisInfoEntity.setLastEditor(user.getUserId());
        analysisInfoEntity.setLastEditorName(user.getUserName());
        analysisInfoEntity.setIsPause("0");
        analysisInfoEntity.setIsPolling("0");
        analysisInfoEntity.setLastSort(0);
        analysisInfoEntity.setAnalysisStatus("1");
        if ("3".equals(analysisInfoDto.getSourceType()) || HussarUtils.isNotEmpty(analysisInfoDto.getAnalysisDataSourceList()) || HussarUtils.isNotEmpty((Object)analysisInfoDto.getFileId())) {
            analysisInfoEntity.setDataStatus("1");
        } else {
            analysisInfoEntity.setDataStatus("0");
        }
        if (HussarUtils.isNotEmpty((Object)analysisInfoDto.getFilterFieldList()) && "3".equals(analysisInfoDto.getSourceType())) {
            String filterConditions = JSONObject.toJSONString((Object)analysisInfoDto.getFilterFieldList());
            analysisInfoEntity.setFilterConditions(filterConditions);
        }
        this.updateById((BaseEntity)analysisInfoEntity);
        if (("2".equals(oldAnalysisInfo.getAnalysisStatus()) || "3".equals(oldAnalysisInfo.getAnalysisStatus())) && "1".equals(analysisInfoEntity.getAnalysisStatus())) {
            analysisDataSourceList = this.analysisDataSourceService.list((Wrapper)new LambdaQueryWrapper().eq(AnalysisDataSource::getAnalysisId, (Object)analysisInfoEntity.getAnalysisId()));
            this.saveHistoryDataSource((List<AnalysisDataSource>)analysisDataSourceList, oldAnalysisInfo.getHistoryAnalysisId());
            AnalysisResultVO analysisResultVO = this.analysisResult(analysisInfoEntity.getAnalysisId(), oldAnalysisInfo.getDataType(), null);
            if (HussarUtils.isNotEmpty((Object)analysisResultVO)) {
                this.saveHistoryResult(oldAnalysisInfo, analysisResultVO);
            }
        }
        this.relationRuleService.remove((Wrapper)new LambdaUpdateWrapper().eq(RelationRuleEntity::getAnalysisId, (Object)analysisInfoEntity.getAnalysisId()));
        if (HussarUtils.isNotEmpty(analysisInfoDto.getRelationRuleEntityList())) {
            for (RelationRuleEntity relationRuleEntity : analysisInfoDto.getRelationRuleEntityList()) {
                relationRuleEntity.setAnalysisId(analysisInfoEntity.getAnalysisId());
                relationRuleEntity.setCreatorName(user.getUserName());
                relationRuleEntity.setLastEditorName(user.getUserName());
            }
            this.relationRuleService.saveBatch(analysisInfoDto.getRelationRuleEntityList());
        }
        this.relationWarnObjectService.remove((Wrapper)new LambdaUpdateWrapper().eq(RelationWarnObjectEntity::getAnalysisId, (Object)analysisInfoEntity.getAnalysisId()));
        if (HussarUtils.isNotEmpty(analysisInfoDto.getRelationWarnObjectEntityList())) {
            for (RelationWarnObjectEntity relationWarnObjectEntity : analysisInfoDto.getRelationWarnObjectEntityList()) {
                relationWarnObjectEntity.setAnalysisId(analysisInfoEntity.getAnalysisId());
            }
            this.relationWarnObjectService.saveBatch(analysisInfoDto.getRelationWarnObjectEntityList());
        }
        if ("1".equals(analysisInfoDto.getChangeAnalysisDataSource())) {
            this.analysisDataSourceService.remove((Wrapper)new LambdaUpdateWrapper().eq(AnalysisDataSource::getAnalysisId, (Object)analysisInfoEntity.getAnalysisId()));
            analysisDataSourceList = analysisInfoDto.getAnalysisDataSourceList();
            if (HussarUtils.isNotEmpty((Object)analysisInfoDto.getFileId()) && "1".equals(analysisInfoDto.getSourceType())) {
                String cache = "analysisImport" + analysisInfoDto.getFileId();
                analysisDataSourceList = (List)DefaultCacheUtil.get((Object)cache);
            }
            if (HussarUtils.isNotEmpty((Object)analysisDataSourceList)) {
                Iterator iterator = analysisDataSourceList.iterator();
                while (iterator.hasNext()) {
                    AnalysisDataSource analysisDataSource = (AnalysisDataSource)((Object)iterator.next());
                    analysisDataSource.setAnalysisId(analysisInfoEntity.getAnalysisId());
                    analysisDataSource.setCreatorName(user.getUserName());
                    analysisDataSource.setLastEditorName(user.getUserName());
                    analysisDataSource.setIsExclude("0");
                }
                this.analysisDataSourceService.saveBatch((Collection)analysisDataSourceList);
                analysisInfoEntity.setAnalysisDataSourceList((List<AnalysisDataSource>)analysisDataSourceList);
            }
            if (HussarUtils.isNotEmpty((Object)analysisInfoDto.getFileId())) {
                this.attachmentManagerApiService.updateBusinessIdByFileId(analysisInfoEntity.getAnalysisId(), analysisInfoDto.getFileId());
            }
        }
        return analysisInfoEntity;
    }

    @Override
    public void saveOperateLogBaseInfo(AnalysisInfoEntity oldAnalysisInfoEntity, AnalysisInfoEntity analysisInfoEntity) {
        String labelPrefix1 = "";
        String labelPrefix2 = "";
        switch (analysisInfoEntity.getAnalysisType()) {
            case "xr": {
                labelPrefix1 = AnalysisInfoFieldConstant.XBAR_R[0];
                labelPrefix2 = AnalysisInfoFieldConstant.XBAR_R[1];
                break;
            }
            case "xs": {
                labelPrefix1 = AnalysisInfoFieldConstant.XBAR_S[0];
                labelPrefix2 = AnalysisInfoFieldConstant.XBAR_S[1];
                break;
            }
            case "x_r": {
                labelPrefix1 = AnalysisInfoFieldConstant.X_R[0];
                labelPrefix2 = AnalysisInfoFieldConstant.X_R[1];
                break;
            }
            case "xmr": {
                labelPrefix1 = AnalysisInfoFieldConstant.X_MR[0];
                labelPrefix2 = AnalysisInfoFieldConstant.X_MR[1];
                break;
            }
        }
        List<JsonItem> baseInfoJsonItems = DiffUtil.diff(oldAnalysisInfoEntity, analysisInfoEntity, DiffUtil.of("\u9636\u6bb5", AnalysisInfoEntity::getAnalysisStage, DiffUtil.mapKeyStringFormatterLazy(() -> this.sysDicRefService.getDicListByType("analysis_stage"), DicVo::getValue, DicVo::getLabel)), DiffUtil.of("\u63a7\u5236\u56fe\u7c7b\u578b", AnalysisInfoEntity::getAnalysisType, DiffUtil.mapKeyStringFormatterLazy(() -> this.sysDicRefService.getDicListByType("control_chart_type"), DicVo::getValue, DicVo::getLabel)), DiffUtil.of("USL", AnalysisInfoEntity::getUsl), DiffUtil.of("SL", AnalysisInfoEntity::getSl), DiffUtil.of("LSL", AnalysisInfoEntity::getLsl), DiffUtil.of("\u5b50\u7ec4\u5bb9\u91cf", AnalysisInfoEntity::getSubgroupSize), DiffUtil.of(labelPrefix1 + "\u81ea\u5b9a\u4e49UCL", AnalysisInfoEntity::getUcl), DiffUtil.of(labelPrefix1 + "\u81ea\u5b9a\u4e49CL", AnalysisInfoEntity::getCl), DiffUtil.of(labelPrefix1 + "\u81ea\u5b9a\u4e49LCL", AnalysisInfoEntity::getLcl), DiffUtil.of(labelPrefix2 + "\u81ea\u5b9a\u4e49UCL", AnalysisInfoEntity::getUclr), DiffUtil.of(labelPrefix2 + "\u81ea\u5b9a\u4e49CL", AnalysisInfoEntity::getClr), DiffUtil.of(labelPrefix2 + "\u81ea\u5b9a\u4e49LCL", AnalysisInfoEntity::getLclr));
        if (HussarUtils.isNotEmpty(baseInfoJsonItems)) {
            OperateLogAPIDTO operateLogAPIDTO = OperateLogAPIDTO.fromBusiness(LogType.ANALYSIS_UPDATE, baseInfoJsonItems, analysisInfoEntity.getAnalysisId(), analysisInfoEntity.getAnalysisCode());
            OperateLogContext context = OperateLogContextBuilder.create(operateLogAPIDTO).build();
            this.operateLogAPIService.save(context);
        }
    }

    @Override
    public void saveOperateLogGroup(AnalysisInfoEntity oldAnalysisInfoEntity, AnalysisInfoEntity analysisInfoEntity, List<RelationWarnObjectEntity> oldRelationWarnObjectEntityList, List<RelationWarnObjectEntity> relationWarnObjectEntityList) {
        ArrayList<JsonItem> groupJsonItems = new ArrayList<JsonItem>();
        if (!oldAnalysisInfoEntity.getGroupId().equals(analysisInfoEntity.getGroupId())) {
            groupJsonItems.addAll(DiffUtil.diff(oldAnalysisInfoEntity, analysisInfoEntity, DiffUtil.of("\u5224\u5f02\u89c4\u5219\u7ec4", AnalysisInfoEntity::getGroupName)));
        }
        if (this.hasDifferenceWarningObject(oldRelationWarnObjectEntityList, relationWarnObjectEntityList)) {
            ArrayList oldList = new ArrayList();
            ArrayList newList = new ArrayList();
            oldList.addAll(oldRelationWarnObjectEntityList.stream().filter(a -> a.getObjectType().equals("2")).collect(Collectors.toList()));
            oldList.addAll(oldRelationWarnObjectEntityList.stream().filter(a -> a.getObjectType().equals("1")).collect(Collectors.toList()));
            oldList.addAll(oldRelationWarnObjectEntityList.stream().filter(a -> a.getObjectType().equals("0")).collect(Collectors.toList()));
            newList.addAll(relationWarnObjectEntityList.stream().filter(a -> a.getObjectType().equals("2")).collect(Collectors.toList()));
            newList.addAll(relationWarnObjectEntityList.stream().filter(a -> a.getObjectType().equals("1")).collect(Collectors.toList()));
            newList.addAll(relationWarnObjectEntityList.stream().filter(a -> a.getObjectType().equals("0")).collect(Collectors.toList()));
            String oldWarnObjectName = oldList.stream().map(RelationWarnObjectEntity::getBusinessName).collect(Collectors.joining("\uff0c"));
            String newWarnObjectName = newList.stream().map(RelationWarnObjectEntity::getBusinessName).collect(Collectors.joining("\uff0c"));
            ChangeValue changeValue = new ChangeValue(HussarUtils.isNotEmpty((Object)oldWarnObjectName) ? oldWarnObjectName : "\u65e0", HussarUtils.isNotEmpty((Object)newWarnObjectName) ? newWarnObjectName : "\u65e0");
            JsonItem jsonItem = new JsonItem();
            jsonItem.setItemKey("\u544a\u8b66\u7528\u6237");
            jsonItem.setItemValue(changeValue);
            groupJsonItems.add(jsonItem);
        }
        if (HussarUtils.isNotEmpty(groupJsonItems)) {
            OperateLogAPIDTO operateLogAPIDTO = OperateLogAPIDTO.fromBusiness(LogType.ANALYSIS_UPDATE_JUDGEMENT, groupJsonItems, analysisInfoEntity.getAnalysisId(), analysisInfoEntity.getAnalysisCode());
            OperateLogContext context = OperateLogContextBuilder.create(operateLogAPIDTO).build();
            this.operateLogAPIService.save(context);
        }
    }

    @Override
    public void saveOperateLogDataSource(AnalysisInfoEntity oldAnalysisInfoEntity, AnalysisInfoEntity analysisInfoEntity) {
        ArrayList<JsonItem> dataSourceJsonItems = new ArrayList<JsonItem>();
        if (!oldAnalysisInfoEntity.getSourceType().equals(analysisInfoEntity.getSourceType())) {
            dataSourceJsonItems.addAll(DiffUtil.diff(oldAnalysisInfoEntity, analysisInfoEntity, DiffUtil.of("\u6570\u636e\u6e90\u7c7b\u578b", AnalysisInfoEntity::getSourceType, DiffUtil.mapKeyStringFormatterLazy(() -> this.sysDicRefService.getDicListByType("analysis_data_source"), DicVo::getValue, DicVo::getLabel))));
        }
        if (HussarUtils.isNotEmpty(dataSourceJsonItems)) {
            OperateLogAPIDTO operateLogAPIDTO = OperateLogAPIDTO.fromBusiness(LogType.ANALYSIS_UPDATE_DATA, dataSourceJsonItems, analysisInfoEntity.getAnalysisId(), analysisInfoEntity.getAnalysisCode());
            OperateLogContext context = OperateLogContextBuilder.create(operateLogAPIDTO).build();
            this.operateLogAPIService.save(context);
        }
    }

    public boolean hasDifferenceWarningObject(List<RelationWarnObjectEntity> oldList, List<RelationWarnObjectEntity> newList) {
        if (HussarUtils.isEmpty(oldList) && HussarUtils.isEmpty(newList)) {
            return false;
        }
        if (HussarUtils.isEmpty(oldList) || HussarUtils.isEmpty(newList)) {
            return true;
        }
        Map oldMap = oldList.stream().filter(e -> HussarUtils.isNotEmpty((Object)e) && HussarUtils.isNotEmpty((Object)e.getObjectType()) && HussarUtils.isNotEmpty((Object)e.getBusinessId())).collect(Collectors.groupingBy(RelationWarnObjectEntity::getObjectType, Collectors.mapping(RelationWarnObjectEntity::getBusinessId, Collectors.toSet())));
        Map newMap = newList.stream().filter(e -> HussarUtils.isNotEmpty((Object)e) && HussarUtils.isNotEmpty((Object)e.getObjectType()) && HussarUtils.isNotEmpty((Object)e.getBusinessId())).collect(Collectors.groupingBy(RelationWarnObjectEntity::getObjectType, Collectors.mapping(RelationWarnObjectEntity::getBusinessId, Collectors.toSet())));
        for (int type = 0; type <= 2; ++type) {
            Set newIds;
            Set oldIds = oldMap.getOrDefault(String.valueOf(type), new HashSet());
            if (oldIds.equals(newIds = (Set)newMap.getOrDefault(String.valueOf(type), new HashSet()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void downLoadMeasureTemplate(HttpServletResponse response, Integer subgroupSize) {
        try {
            int sampleRowCount;
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet("\u8ba1\u91cf\u578b\u6a21\u677f");
            XSSFCellStyle style = workbook.createCellStyle();
            XSSFFont font = workbook.createFont();
            font.setFontHeightInPoints((short)10);
            font.setFontName("\u5b8b\u4f53");
            font.setBold(true);
            style.setFont((Font)font);
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            style.setBorderTop(BorderStyle.THIN);
            style.setBorderBottom(BorderStyle.THIN);
            style.setBorderLeft(BorderStyle.THIN);
            style.setBorderRight(BorderStyle.THIN);
            List variables = this.processVariableService.list((Wrapper)new LambdaQueryWrapper().eq(ProcessVariableEntity::getIsShow, (Object)"1"));
            List variablesNameList = variables.stream().map(ProcessVariableEntity::getVariableName).collect(Collectors.toList());
            ArrayList<String> samples = new ArrayList<String>();
            if (HussarUtils.isNotEmpty((Object)subgroupSize) && subgroupSize > 0) {
                for (int i = 1; i <= subgroupSize; ++i) {
                    samples.add("\u6837\u672c" + i);
                }
            }
            ArrayList<List<String>> rowDataList = new ArrayList<List<String>>();
            rowDataList.add(Arrays.asList("", "\u68c0\u9a8c\u65e5\u671f(XXXX-XX-XX)"));
            ArrayList<String> groupRow = new ArrayList<String>();
            groupRow.add("");
            groupRow.add("\u7ec4\u522b");
            for (int i = 1; i <= 25; ++i) {
                groupRow.add(String.valueOf(i));
            }
            rowDataList.add(groupRow);
            int varRowCount = variablesNameList.size();
            if (varRowCount > 0) {
                rowDataList.add(Arrays.asList("\u5c5e\u6027\u5b57\u6bb5", (String)variablesNameList.get(0)));
                for (int i = 1; i < varRowCount; ++i) {
                    rowDataList.add(Arrays.asList("", (String)variablesNameList.get(i)));
                }
            }
            if ((sampleRowCount = samples.size()) > 0) {
                rowDataList.add(Arrays.asList("\u68c0\u6d4b\u6837\u672c", (String)samples.get(0)));
                for (int i = 1; i < sampleRowCount; ++i) {
                    rowDataList.add(Arrays.asList("", (String)samples.get(i)));
                }
            }
            if (varRowCount > 1) {
                int varStartRow = 2;
                int varEndRow = varStartRow + varRowCount - 1;
                CellRangeAddress varRegion = new CellRangeAddress(varStartRow, varEndRow, 0, 0);
                sheet.addMergedRegion(varRegion);
            }
            if (sampleRowCount > 1) {
                int sampleStartRow = 2 + varRowCount;
                int sampleEndRow = sampleStartRow + sampleRowCount - 1;
                CellRangeAddress sampleRegion = new CellRangeAddress(sampleStartRow, sampleEndRow, 0, 0);
                sheet.addMergedRegion(sampleRegion);
            }
            for (int rowIndex = 0; rowIndex < rowDataList.size(); ++rowIndex) {
                Row row = sheet.createRow(rowIndex);
                List rowData = (List)rowDataList.get(rowIndex);
                row.setHeightInPoints(30.0f);
                Cell cellA = row.createCell(0);
                cellA.setCellStyle((CellStyle)style);
                cellA.setCellValue((String)rowData.get(0));
                Cell cellB = row.createCell(1);
                cellB.setCellStyle((CellStyle)style);
                cellB.setCellValue((String)rowData.get(1));
                if (rowIndex == 1) {
                    for (int colIndex = 2; colIndex < 27; ++colIndex) {
                        Cell cell = row.createCell(colIndex);
                        cell.setCellStyle((CellStyle)style);
                        cell.setCellValue((double)(colIndex - 1));
                    }
                }
                sheet.setColumnWidth(0, Math.max(sheet.getColumnWidth(0), (((String)rowData.get(0)).getBytes().length + 2) * 256));
                sheet.setColumnWidth(1, Math.max(sheet.getColumnWidth(1), (((String)rowData.get(1)).getBytes().length + 2) * 256));
            }
            response.reset();
            String fileName = "\u8ba1\u91cf\u578b\u6a21\u677f";
            String encodedFileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setHeader("Content-disposition", "attachment; filename*=utf-8''" + encodedFileName + ".xlsx");
            workbook.write((OutputStream)response.getOutputStream());
            workbook.close();
        }
        catch (IOException e) {
            throw new BaseException("\u8ba1\u91cf\u578b\u6a21\u677f\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            throw new BaseException("\u8ba1\u91cf\u578b\u6a21\u677f\u751f\u6210\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @Override
    public void downLoadCountTemplate(HttpServletResponse response, Integer subgroupSize, String countingType) {
        String templateName = "\u8ba1\u6570\u578b\u6a21\u677f";
        try {
            int sampleRowCount;
            XSSFWorkbook workbook = new XSSFWorkbook();
            ArrayList<String> samples = new ArrayList<String>();
            if ("1".equals(countingType)) {
                samples.add("\u4e0d\u5408\u683c\u6570");
                templateName = "\u4e0d\u5408\u683c\u6570\u8ba1\u6570\u578b\u6a21\u677f";
            } else {
                samples.add("\u7f3a\u9677\u6570");
                templateName = "\u7f3a\u9677\u6570\u8ba1\u6570\u578b\u6a21\u677f";
            }
            samples.add(0, "\u68c0\u6d4b\u6570\u91cf");
            XSSFSheet sheet = workbook.createSheet(templateName);
            XSSFCellStyle style = workbook.createCellStyle();
            XSSFFont font = workbook.createFont();
            font.setFontHeightInPoints((short)10);
            font.setFontName("\u5b8b\u4f53");
            font.setBold(true);
            style.setFont((Font)font);
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            style.setBorderTop(BorderStyle.THIN);
            style.setBorderBottom(BorderStyle.THIN);
            style.setBorderLeft(BorderStyle.THIN);
            style.setBorderRight(BorderStyle.THIN);
            List variables = this.processVariableService.list((Wrapper)new LambdaQueryWrapper().eq(ProcessVariableEntity::getIsShow, (Object)"1"));
            List variablesNameList = variables.stream().map(ProcessVariableEntity::getVariableName).collect(Collectors.toList());
            ArrayList<List<String>> rowDataList = new ArrayList<List<String>>();
            rowDataList.add(Arrays.asList("", "\u68c0\u9a8c\u65e5\u671f(XXXX-XX-XX)"));
            ArrayList<String> groupRow = new ArrayList<String>();
            groupRow.add("");
            groupRow.add("\u7ec4\u522b");
            for (int i = 1; i <= 25; ++i) {
                groupRow.add(String.valueOf(i));
            }
            rowDataList.add(groupRow);
            int varRowCount = variablesNameList.size();
            if (varRowCount > 0) {
                rowDataList.add(Arrays.asList("\u5c5e\u6027\u5b57\u6bb5", (String)variablesNameList.get(0)));
                for (int i = 1; i < varRowCount; ++i) {
                    rowDataList.add(Arrays.asList("", (String)variablesNameList.get(i)));
                }
            }
            if ((sampleRowCount = samples.size()) > 0) {
                rowDataList.add(Arrays.asList("\u68c0\u6d4b\u503c", (String)samples.get(0)));
                for (int i = 1; i < sampleRowCount; ++i) {
                    rowDataList.add(Arrays.asList("", (String)samples.get(i)));
                }
            }
            if (varRowCount > 1) {
                int varStartRow = 2;
                int varEndRow = varStartRow + varRowCount - 1;
                CellRangeAddress varRegion = new CellRangeAddress(varStartRow, varEndRow, 0, 0);
                sheet.addMergedRegion(varRegion);
            }
            if (sampleRowCount > 1) {
                int sampleStartRow = 2 + varRowCount;
                int sampleEndRow = sampleStartRow + sampleRowCount - 1;
                CellRangeAddress sampleRegion = new CellRangeAddress(sampleStartRow, sampleEndRow, 0, 0);
                sheet.addMergedRegion(sampleRegion);
            }
            for (int rowIndex = 0; rowIndex < rowDataList.size(); ++rowIndex) {
                Cell cell;
                int colIndex;
                Row row = sheet.createRow(rowIndex);
                List rowData = (List)rowDataList.get(rowIndex);
                row.setHeightInPoints(30.0f);
                Cell cellA = row.createCell(0);
                cellA.setCellStyle((CellStyle)style);
                cellA.setCellValue((String)rowData.get(0));
                Cell cellB = row.createCell(1);
                cellB.setCellStyle((CellStyle)style);
                cellB.setCellValue((String)rowData.get(1));
                if (rowIndex == 1) {
                    for (colIndex = 2; colIndex < 27; ++colIndex) {
                        cell = row.createCell(colIndex);
                        cell.setCellStyle((CellStyle)style);
                        cell.setCellValue((double)(colIndex - 1));
                    }
                }
                if (HussarUtils.isNotEmpty((Object)subgroupSize) && rowIndex == 2 + varRowCount && ((String)rowData.get(1)).equals("\u68c0\u6d4b\u6570\u91cf")) {
                    for (colIndex = 2; colIndex < 27; ++colIndex) {
                        cell = row.createCell(colIndex);
                        cell.setCellStyle((CellStyle)style);
                        cell.setCellValue((double)subgroupSize.intValue());
                    }
                }
                sheet.setColumnWidth(0, Math.max(sheet.getColumnWidth(0), (((String)rowData.get(0)).getBytes().length + 2) * 256));
                sheet.setColumnWidth(1, Math.max(sheet.getColumnWidth(1), (((String)rowData.get(1)).getBytes().length + 2) * 256));
            }
            response.reset();
            String fileName = templateName;
            String encodedFileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setHeader("Content-disposition", "attachment; filename*=utf-8''" + encodedFileName + ".xlsx");
            workbook.write((OutputStream)response.getOutputStream());
            workbook.close();
        }
        catch (IOException e) {
            throw new BaseException(templateName + "\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            throw new BaseException(templateName + "\u751f\u6210\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @Override
    @HussarTransactional
    public Long importMeasure(MultipartFile file, Integer subgroupSize, String analysisType) {
        ArrayList<Map<Integer, String>> rawAllRows = null;
        try {
            rawAllRows = ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream()).sheet().headRowNumber(Integer.valueOf(0))).doReadSync();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (rawAllRows.isEmpty()) {
            throw new HussarException("Excel\u6587\u4ef6\u4e3a\u7a7a");
        }
        ArrayList<Map<Integer, String>> filteredRows = new ArrayList<Map<Integer, String>>();
        for (Map map : rawAllRows) {
            LinkedHashMap filteredRow = new LinkedHashMap();
            for (Map.Entry entry : map.entrySet()) {
                String value = (String)entry.getValue();
                if (value == null || value.trim().isEmpty()) continue;
                filteredRow.put(entry.getKey(), value);
            }
            filteredRows.add(filteredRow);
        }
        rawAllRows = filteredRows;
        Map<String, Integer> keyRowMap = this.findKeyRowIndexesMeasure(rawAllRows, subgroupSize);
        Map<String, Integer> map = this.calculateRowCountsMeasure(rawAllRows, keyRowMap, subgroupSize);
        int variableCount = map.get("variableCount");
        List visibleVariables = this.processVariableService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProcessVariableEntity::getIsShow, (Object)"1")).orderByAsc(ProcessVariableEntity::getVariableId));
        ArrayList<String> templateAliases = new ArrayList<String>();
        for (int i = 0; i < variableCount; ++i) {
            int variableStartRow = keyRowMap.get("variableStartRow");
            int currentRowIndex = variableStartRow + i;
            if (currentRowIndex >= rawAllRows.size()) {
                throw new HussarException("\u6a21\u677f\u5c5e\u6027\u5b57\u6bb5\u884c\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5c11\u7b2c" + (i + 1) + "\u4e2a\u5c5e\u6027\u5b57\u6bb5");
            }
            Map currentRow = (Map)rawAllRows.get(currentRowIndex);
            String alias = currentRow.getOrDefault(1, "").trim();
            if (alias.isEmpty()) {
                throw new HussarException("\u6a21\u677f\u7b2c" + (currentRowIndex + 1) + "\u884cB\u5217\u7684\u5c5e\u6027\u522b\u540d\u4e3a\u7a7a");
            }
            templateAliases.add(alias);
        }
        Map<Integer, String> fieldMap = ImportUtil.buildFieldMap(visibleVariables, templateAliases);
        List<AnalysisDataSource> entities = this.parseDynamicColumnsMeasure(rawAllRows, keyRowMap, map, fieldMap, analysisType);
        if (entities.size() < 3 * subgroupSize) {
            throw new HussarException("\u8ba1\u91cf\u578b\u5bfc\u5165\u70b9\u4f4d\u6570\u91cf\u9700\u8981\u5927\u4e8e2");
        }
        ApiResponse response = null;
        AttachmentManagerModelApiVo attachment = null;
        try {
            response = this.attachmentManagerApiService.uploadFileWithDrag(file, null);
            attachment = (AttachmentManagerModelApiVo)response.getData();
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
        String cacheKey = "analysisImport" + attachment.getId();
        DefaultCacheUtil.put((Object)cacheKey, entities, (long)7200L);
        return attachment.getId();
    }

    private void validateVariableAliases(List<Map<Integer, String>> rawAllRows, Map<String, Integer> keyRowMap, int variableCount, List<ProcessVariableEntity> visibleVariables) {
        List systemAliases = visibleVariables.stream().sorted(Comparator.comparing(ProcessVariableEntity::getVariableId)).map(ProcessVariableEntity::getVariableName).collect(Collectors.toList());
        int variableStartRow = keyRowMap.get("variableStartRow");
        ArrayList<String> templateAliases = new ArrayList<String>();
        for (int i = 0; i < variableCount; ++i) {
            int currentRowIndex = variableStartRow + i;
            if (currentRowIndex >= rawAllRows.size()) {
                throw new HussarException("\u6a21\u677f\u5c5e\u6027\u5b57\u6bb5\u884c\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5c11\u7b2c" + (i + 1) + "\u4e2a\u5c5e\u6027\u5b57\u6bb5");
            }
            Map<Integer, String> currentRow = rawAllRows.get(currentRowIndex);
            String alias = currentRow.getOrDefault(1, "").trim();
            if (alias.isEmpty()) {
                throw new HussarException("\u6a21\u677f\u7b2c" + (currentRowIndex + 1) + "\u884cB\u5217\u7684\u5c5e\u6027\u522b\u540d\u4e3a\u7a7a");
            }
            templateAliases.add(alias);
        }
        ArrayList<String> matchedAliases = new ArrayList<String>();
        for (String templateAlias : templateAliases) {
            if (!systemAliases.contains(templateAlias)) continue;
            matchedAliases.add(templateAlias);
        }
        if (matchedAliases.isEmpty()) {
            throw new HussarException("\u65e0\u5c5e\u6027\u5b57\u6bb5\u4e0e\u7cfb\u7edf\u663e\u793a\u5b57\u6bb5\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u6216\u7cfb\u7edf\u914d\u7f6e");
        }
    }

    private List<AnalysisDataSource> parseDynamicColumnsMeasure(List<Map<Integer, String>> rawAllRows, Map<String, Integer> keyRowMap, Map<String, Integer> countMap, Map<Integer, String> fieldMap, String analysisType) {
        ArrayList<AnalysisDataSource> entities = new ArrayList<AnalysisDataSource>();
        int variableCount = countMap.get("variableCount");
        int sampleCount = countMap.get("sampleCount");
        int detectTimeRow = keyRowMap.get("detectTimeRow");
        int groupNumRow = keyRowMap.get("groupNumRow");
        int sampleStartRow = keyRowMap.get("sampleStartRow");
        Map<Integer, String> groupNumRowData = rawAllRows.get(sampleStartRow);
        Set validColumns = groupNumRowData.keySet().stream().filter(col -> col >= 2).filter(col -> StringUtils.hasText((String)((String)groupNumRowData.get(col)))).collect(Collectors.toSet());
        if (validColumns.isEmpty()) {
            throw new HussarException("\u672a\u627e\u5230\u6709\u6548\u6570\u636e\u5217\uff08\u4eceC\u5217\u5f00\u59cb\uff09");
        }
        Iterator iterator = validColumns.iterator();
        while (iterator.hasNext()) {
            String value;
            int rowIndex;
            String groupNum;
            int col2 = (Integer)iterator.next();
            String detectTime = "";
            if (HussarUtils.isNotEmpty((Object)rawAllRows.get(detectTimeRow).get(col2))) {
                detectTime = rawAllRows.get(detectTimeRow).get(col2).trim();
            }
            if (HussarUtils.isEmpty((Object)(groupNum = rawAllRows.get(groupNumRow).get(col2).trim()))) {
                throw new HussarException("\u7ec4\u522b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList<String> variableValues = new ArrayList<String>();
            for (int i = 0; i < variableCount; ++i) {
                int variableStartRow = keyRowMap.get("variableStartRow");
                rowIndex = variableStartRow + i;
                if (rowIndex >= rawAllRows.size()) {
                    throw new HussarException("\u6a21\u677f\u5c5e\u6027\u5b57\u6bb5\u884c\u4e0d\u5b8c\u6574\uff0c\u5904\u7406\u7b2c" + (i + 1) + "\u4e2a\u5c5e\u6027\u65f6\u884c\u7d22\u5f15\u8d8a\u754c");
                }
                value = HussarUtils.isNotEmpty((Object)rawAllRows.get(rowIndex).getOrDefault(col2, "")) ? rawAllRows.get(rowIndex).getOrDefault(col2, "").trim() : "";
                variableValues.add(value);
            }
            ArrayList<String> sampleValues = new ArrayList<String>();
            for (int i = 0; i < sampleCount; ++i) {
                rowIndex = sampleStartRow + i;
                if (rowIndex >= rawAllRows.size()) {
                    throw new HussarException("\u6a21\u677f\u6837\u672c\u884c\u4e0d\u5b8c\u6574\uff0c\u5904\u7406\u7b2c" + (i + 1) + "\u4e2a\u6837\u672c\u65f6\u884c\u7d22\u5f15\u8d8a\u754c");
                }
                if (HussarUtils.isEmpty((Object)rawAllRows.get(rowIndex).getOrDefault(col2, ""))) {
                    throw new HussarException("\u6a21\u677f\u6837\u672c\u884c\u4e0d\u5b8c\u6574\uff0c\u5904\u7406\u7b2c" + (i + 1) + "\u4e2a\u6837\u672c\u65f6\u6837\u672c\u4e0d\u8db3");
                }
                value = rawAllRows.get(rowIndex).getOrDefault(col2, "").trim();
                sampleValues.add(value);
            }
            for (int s = 0; s < sampleCount; ++s) {
                AnalysisDataSource entity = new AnalysisDataSource();
                entity.setDetectTime(detectTime);
                entity.setGroupNum(groupNum);
                entity.setAnalysisType(analysisType);
                ImportUtil.setFieldValues(entity, fieldMap, variableValues);
                entity.setSampleValue((String)sampleValues.get(s));
                entities.add(entity);
            }
        }
        return entities;
    }

    private Map<String, Integer> findKeyRowIndexesMeasure(List<Map<Integer, String>> rawAllRows, Integer subgroupSize) {
        String value;
        HashMap<String, Integer> keyRowMap = new HashMap<String, Integer>();
        int groupIndex = 0;
        block0: for (int rowIndex = 0; rowIndex < rawAllRows.size(); ++rowIndex) {
            Map<Integer, String> row = rawAllRows.get(rowIndex);
            for (String cellValue : row.values()) {
                if (cellValue == null) continue;
                value = cellValue.trim();
                if (value.contains("\u68c0\u9a8c\u65e5\u671f") && !keyRowMap.containsKey("detectTimeRow")) {
                    keyRowMap.put("detectTimeRow", rowIndex);
                    continue block0;
                }
                if (value.contains("\u7ec4\u522b") && !keyRowMap.containsKey("groupNumRow")) {
                    groupIndex = rowIndex;
                    keyRowMap.put("groupNumRow", rowIndex);
                    continue block0;
                }
                if (value.contains("\u5c5e\u6027\u5b57\u6bb5") && !keyRowMap.containsKey("variableStartRow")) {
                    keyRowMap.put("variableStartRow", rowIndex);
                    continue block0;
                }
                if (!value.contains("\u68c0\u6d4b\u6837\u672c") || keyRowMap.containsKey("sampleStartRow")) continue;
                keyRowMap.put("sampleStartRow", rowIndex);
                continue block0;
            }
        }
        ArrayList<String> missingRows = new ArrayList<String>();
        if (!keyRowMap.containsKey("detectTimeRow")) {
            missingRows.add("\u68c0\u9a8c\u65e5\u671f\u884c");
        }
        if (!keyRowMap.containsKey("groupNumRow")) {
            missingRows.add("\u7ec4\u522b\u884c");
        }
        if (!keyRowMap.containsKey("sampleStartRow")) {
            missingRows.add("\u68c0\u6d4b\u6837\u672c\u884c");
        }
        if (!missingRows.isEmpty()) {
            throw new HussarException("\u6a21\u677f\u7f3a\u5c11\u5fc5\u8981\u884c\uff1a" + String.join((CharSequence)"\u3001", missingRows));
        }
        if (groupIndex != 0) {
            Map<Integer, String> groupMap = rawAllRows.get(groupIndex);
            HashSet<String> groupValues = new HashSet<String>();
            for (int col = 2; col < groupMap.size(); ++col) {
                value = groupMap.get(col);
                if (HussarUtils.isEmpty((Object)value)) {
                    throw new HussarException("\u7ec4\u522b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
                }
                if (groupValues.add(value)) continue;
                throw new HussarException("\u7ec4\u522b\u4e0d\u5141\u8bb8\u5b58\u5728\u91cd\u590d\u503c");
            }
        }
        return keyRowMap;
    }

    private Map<String, Integer> calculateRowCountsMeasure(List<Map<Integer, String>> rawAllRows, Map<String, Integer> keyRowMap, int subgroupSize) {
        Map<Integer, String> row;
        String bColumnValue;
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        Integer variableStartRow = keyRowMap.get("variableStartRow");
        int sampleStartRow = keyRowMap.get("sampleStartRow");
        if (HussarUtils.isNotEmpty((Object)variableStartRow)) {
            int variableCount = sampleStartRow - variableStartRow;
            if (variableCount < 0) {
                throw new HussarException("\u5c5e\u6027\u5b57\u6bb5\u884c\u4e0d\u80fd\u4f4d\u4e8e\u68c0\u6d4b\u6837\u672c\u884c\u4e4b\u540e");
            }
            countMap.put("variableCount", variableCount);
        } else {
            countMap.put("variableCount", 0);
        }
        int actualSampleCount = 0;
        for (int rowIndex = sampleStartRow; rowIndex < rawAllRows.size() && (bColumnValue = (row = rawAllRows.get(rowIndex)).getOrDefault(1, "").trim()).matches("\u6837\u672c\\d+"); ++rowIndex) {
            ++actualSampleCount;
        }
        if (actualSampleCount != subgroupSize) {
            throw new HussarException("\u6837\u672c\u6570\u91cf\u4e0d\u5339\u914d\uff01\u671f\u671b" + subgroupSize + "\u884c\uff0c\u5b9e\u9645" + actualSampleCount + "\u884c");
        }
        countMap.put("sampleCount", actualSampleCount);
        return countMap;
    }

    @Override
    @HussarTransactional
    public ImportVo importCount(MultipartFile file, Integer subgroupSize, String analysisType) {
        ArrayList<Map<Integer, String>> rawAllRows = null;
        try {
            rawAllRows = ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream()).sheet().headRowNumber(Integer.valueOf(0))).doReadSync();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (rawAllRows.isEmpty()) {
            throw new HussarException("Excel\u6587\u4ef6\u4e3a\u7a7a");
        }
        ArrayList<Map<Integer, String>> filteredRows = new ArrayList<Map<Integer, String>>();
        for (Map map : rawAllRows) {
            LinkedHashMap filteredRow = new LinkedHashMap();
            for (Map.Entry entry : map.entrySet()) {
                String value = (String)entry.getValue();
                if (value == null || value.trim().isEmpty()) continue;
                filteredRow.put(entry.getKey(), value);
            }
            filteredRows.add(filteredRow);
        }
        rawAllRows = filteredRows;
        Map<String, Integer> keyRowMap = this.findKeyRowIndexesCount(rawAllRows, analysisType, subgroupSize);
        Map<String, Integer> map = this.calculateRowCountsCount(rawAllRows, keyRowMap);
        int variableCount = map.get("variableCount");
        List visibleVariables = this.processVariableService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProcessVariableEntity::getIsShow, (Object)"1")).orderByAsc(ProcessVariableEntity::getVariableId));
        List<String> templateAliases = this.validateVariableAliasesCount(rawAllRows, keyRowMap, variableCount, visibleVariables);
        Map<Integer, String> fieldMap = ImportUtil.buildFieldMap(visibleVariables, templateAliases);
        List<AnalysisDataSource> entities = this.parseDynamicColumnsCount(rawAllRows, keyRowMap, map, fieldMap, analysisType);
        ApiResponse response = null;
        AttachmentManagerModelApiVo attachment = null;
        try {
            response = this.attachmentManagerApiService.uploadFileWithDrag(file, null);
            attachment = (AttachmentManagerModelApiVo)response.getData();
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
        String cacheKey = "analysisImport" + attachment.getId();
        DefaultCacheUtil.put((Object)cacheKey, entities, (long)7200L);
        ImportVo importVo = new ImportVo();
        importVo.setFieldId(attachment.getId());
        if ("p".equals(analysisType) || "u".equals(analysisType)) {
            int detectNumTotal = (int)entities.stream().map(AnalysisDataSource::getDetectNum).count();
            int sampleAvg = (int)Math.floor(detectNumTotal / entities.size());
            importVo.setSubgroupSize(sampleAvg);
        }
        return importVo;
    }

    private List<String> validateVariableAliasesCount(List<Map<Integer, String>> rawAllRows, Map<String, Integer> keyRowMap, int variableCount, List<ProcessVariableEntity> visibleVariables) {
        ArrayList<String> templateAliases = new ArrayList<String>();
        for (int i = 0; i < variableCount; ++i) {
            int variableStartRow = keyRowMap.get("variableStartRow");
            int currentRowIndex = variableStartRow + i;
            if (currentRowIndex >= rawAllRows.size()) {
                throw new HussarException("\u6a21\u677f\u5c5e\u6027\u5b57\u6bb5\u884c\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5c11\u7b2c" + (i + 1) + "\u4e2a\u5c5e\u6027\u5b57\u6bb5");
            }
            Map<Integer, String> currentRow = rawAllRows.get(currentRowIndex);
            String alias = currentRow.getOrDefault(1, "").trim();
            if (alias.isEmpty()) {
                throw new HussarException("\u6a21\u677f\u7b2c" + (currentRowIndex + 1) + "\u884cB\u5217\u7684\u5c5e\u6027\u522b\u540d\u4e3a\u7a7a");
            }
            templateAliases.add(alias);
        }
        List systemAliases = visibleVariables.stream().sorted(Comparator.comparing(ProcessVariableEntity::getVariableId)).map(ProcessVariableEntity::getVariableName).collect(Collectors.toList());
        ArrayList<String> matchedAliases = new ArrayList<String>();
        for (String templateAlias : templateAliases) {
            if (!systemAliases.contains(templateAlias)) continue;
            matchedAliases.add(templateAlias);
        }
        return templateAliases;
    }

    private List<AnalysisDataSource> parseDynamicColumnsCount(List<Map<Integer, String>> rawAllRows, Map<String, Integer> keyRowMap, Map<String, Integer> countMap, Map<Integer, String> fieldMap, String analysisType) {
        ArrayList<AnalysisDataSource> entities = new ArrayList<AnalysisDataSource>();
        int variableCount = countMap.get("variableCount");
        int valueCount = countMap.get("valueCount");
        int detectTimeRow = keyRowMap.get("detectTimeRow");
        int groupNumRow = keyRowMap.get("groupNumRow");
        int valueStartRow = keyRowMap.get("valueStartRow");
        Map<Integer, String> groupNumRowData = rawAllRows.get(valueStartRow);
        Set validColumns = groupNumRowData.keySet().stream().filter(col -> col >= 2).filter(col -> StringUtils.hasText((String)((String)groupNumRowData.get(col)))).collect(Collectors.toSet());
        if (validColumns.isEmpty()) {
            throw new HussarException("\u672a\u627e\u5230\u6709\u6548\u6570\u636e\u5217\uff08\u4eceC\u5217\u5f00\u59cb\uff09");
        }
        Iterator iterator = validColumns.iterator();
        while (iterator.hasNext()) {
            int rowIndex;
            String groupNum;
            int col2 = (Integer)iterator.next();
            String detectDate = "";
            if (HussarUtils.isNotEmpty((Object)rawAllRows.get(detectTimeRow).get(col2))) {
                detectDate = rawAllRows.get(detectTimeRow).get(col2).trim();
            }
            if (HussarUtils.isEmpty((Object)(groupNum = rawAllRows.get(groupNumRow).get(col2).trim()))) {
                throw new HussarException("\u7ec4\u522b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList<String> variableValues = new ArrayList<String>();
            for (int i = 0; i < variableCount; ++i) {
                int variableStartRow = keyRowMap.get("variableStartRow");
                rowIndex = variableStartRow + i;
                if (rowIndex >= rawAllRows.size()) {
                    throw new HussarException("\u6a21\u677f\u5c5e\u6027\u5b57\u6bb5\u884c\u4e0d\u5b8c\u6574\uff0c\u5904\u7406\u7b2c" + (i + 1) + "\u4e2a\u5c5e\u6027\u65f6\u884c\u7d22\u5f15\u8d8a\u754c");
                }
                String value = HussarUtils.isNotEmpty((Object)rawAllRows.get(rowIndex).getOrDefault(col2, "")) ? rawAllRows.get(rowIndex).getOrDefault(col2, "").trim() : "";
                variableValues.add(value);
            }
            ArrayList<String> valueValues = new ArrayList<String>();
            for (int i = 0; i < valueCount; ++i) {
                rowIndex = valueStartRow + i;
                if (rowIndex >= rawAllRows.size()) {
                    throw new HussarException("\u6a21\u677f\u68c0\u6d4b\u503c\u884c\u4e0d\u5b8c\u6574\uff0c\u5904\u7406\u7b2c" + (i + 1) + "\u4e2a\u68c0\u6d4b\u503c\u65f6\u884c\u7d22\u5f15\u8d8a\u754c");
                }
                Map<Integer, String> rowData = rawAllRows.get(rowIndex);
                String value = null;
                String a = rawAllRows.get(rowIndex).get(col2);
                if (!HussarUtils.isEmpty((Object)rawAllRows.get(rowIndex).get(col2)) || !"c".equals(analysisType) || i != 0) {
                    value = rowData.getOrDefault(col2, "").trim();
                }
                valueValues.add(value);
            }
            AnalysisDataSource entity = new AnalysisDataSource();
            entity.setDetectTime(detectDate);
            entity.setGroupNum(groupNum);
            if (HussarUtils.isEmpty(valueValues.get(1)) && "np".equals(analysisType)) {
                throw new HussarException("\u68c0\u6d4b\u6570\u91cf\u884c\u548c\u4e0d\u5408\u683c\u6570\u884c\u5217\u6570\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f");
            }
            entity.setFailNum(Integer.valueOf((String)valueValues.get(1)));
            if (!"c".equals(analysisType) || !HussarUtils.isEmpty(valueValues.get(0))) {
                entity.setDetectNum(Integer.valueOf((String)valueValues.get(0)));
                if (entity.getDetectNum() < entity.getFailNum()) {
                    if ("np".equals(analysisType) || "p".equals(analysisType)) {
                        throw new HussarException("\u68c0\u6d4b\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u4e0d\u5408\u683c\u54c1\u6570");
                    }
                    if ("u".equals(analysisType)) {
                        throw new HussarException("\u68c0\u6d4b\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7f3a\u9677\u6570");
                    }
                }
            }
            entity.setAnalysisType(analysisType);
            ImportUtil.setFieldValues(entity, fieldMap, variableValues);
            entities.add(entity);
        }
        return entities;
    }

    private Map<String, Integer> findKeyRowIndexesCount(List<Map<Integer, String>> rawAllRows, String analysisType, Integer subgroupSize) {
        HashMap<String, Integer> keyRowMap = new HashMap<String, Integer>();
        HashMap<String, List<String>> keyRowPatterns = new HashMap<String, List<String>>();
        keyRowPatterns.put("detectTimeRow", Arrays.asList("\u68c0\u9a8c\u65e5\u671f", "\u68c0\u6d4b\u65e5\u671f"));
        keyRowPatterns.put("groupNumRow", Arrays.asList("\u7ec4\u522b", "\u7ec4\u53f7"));
        keyRowPatterns.put("variableStartRow", Arrays.asList("\u5c5e\u6027\u5b57\u6bb5", "\u5c5e\u6027\u5217"));
        int groupIndex = 0;
        int variableIndex = 0;
        List<String> valueRowPatterns = "np".equals(analysisType) || "p".equals(analysisType) ? Arrays.asList("\u68c0\u6d4b\u503c", "\u4e0d\u5408\u683c\u54c1\u6570") : Arrays.asList("\u68c0\u6d4b\u503c", "\u7f3a\u9677\u6570");
        keyRowPatterns.put("valueStartRow", valueRowPatterns);
        for (int rowIndex = 0; rowIndex < rawAllRows.size(); ++rowIndex) {
            Map<Integer, String> row = rawAllRows.get(rowIndex);
            block1: for (Map.Entry<Integer, String> cellEntry : row.entrySet()) {
                String cellValue = cellEntry.getValue();
                if (cellValue == null) continue;
                String value = cellValue.trim();
                for (Map.Entry patternEntry : keyRowPatterns.entrySet()) {
                    String key = (String)patternEntry.getKey();
                    if (value.contains("\u7ec4\u522b") && !keyRowMap.containsKey("groupNumRow")) {
                        groupIndex = rowIndex;
                    }
                    if (value.contains("\u68c0\u6d4b\u503c") && !keyRowMap.containsKey("valueStartRow")) {
                        variableIndex = rowIndex;
                    }
                    List patterns = (List)patternEntry.getValue();
                    if (keyRowMap.containsKey(key) || !patterns.stream().anyMatch(p -> value.contains((CharSequence)p))) continue;
                    keyRowMap.put(key, rowIndex);
                    continue block1;
                }
            }
        }
        ArrayList<String> missingRows = new ArrayList<String>();
        if (!keyRowMap.containsKey("detectTimeRow")) {
            missingRows.add("\u68c0\u9a8c\u65e5\u671f\u884c");
        }
        if (!keyRowMap.containsKey("groupNumRow")) {
            missingRows.add("\u7ec4\u522b\u884c");
        }
        if (!keyRowMap.containsKey("valueStartRow")) {
            missingRows.add("\u68c0\u6d4b\u503c\u884c");
        }
        if (!missingRows.isEmpty()) {
            throw new HussarException("\u6a21\u677f\u7f3a\u5c11\u5fc5\u8981\u884c\uff1a" + String.join((CharSequence)"\u3001", missingRows));
        }
        if (groupIndex != 0) {
            Map<Integer, String> groupMap = rawAllRows.get(groupIndex);
            HashSet<String> groupValues = new HashSet<String>();
            for (int col = 2; col < groupMap.size(); ++col) {
                String value = groupMap.get(col);
                if (HussarUtils.isEmpty((Object)value)) {
                    throw new HussarException("\u7ec4\u522b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
                }
                if (groupValues.add(value)) continue;
                throw new HussarException("\u7ec4\u522b\u4e0d\u5141\u8bb8\u5b58\u5728\u91cd\u590d\u503c");
            }
        }
        if (("np".equals(analysisType) || "c".equals(analysisType)) && variableIndex != 0) {
            Map<Integer, String> variableMap = rawAllRows.get(variableIndex);
            for (int col = 2; col < variableMap.size(); ++col) {
                String value = variableMap.get(col);
                if (HussarUtils.isEmpty((Object)value) && "np".equals(analysisType)) {
                    throw new HussarException("\u68c0\u6d4b\u6570\u91cf\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
                }
                if (String.valueOf(subgroupSize).equals(value) || !"np".equals(analysisType)) continue;
                throw new HussarException("\u6a21\u677f\u68c0\u6d4b\u6570\u91cf\u4e0e\u5b50\u7ec4\u5bb9\u91cf\u4e0d\u540c");
            }
        }
        return keyRowMap;
    }

    private Map<String, Integer> calculateRowCountsCount(List<Map<Integer, String>> rawAllRows, Map<String, Integer> keyRowMap) {
        Map<Integer, String> row;
        String bColumnValue;
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        Integer variableStartRow = keyRowMap.get("variableStartRow");
        int valueStartRow = keyRowMap.get("valueStartRow");
        if (HussarUtils.isNotEmpty((Object)variableStartRow)) {
            int variableCount = valueStartRow - variableStartRow;
            if (variableCount <= 0) {
                throw new HussarException("\u5c5e\u6027\u5b57\u6bb5\u884c\u4e0d\u80fd\u5c11\u4e8e1\u884c\u6216\u4f4d\u4e8e\u68c0\u6d4b\u503c\u884c\u4e4b\u540e");
            }
            countMap.put("variableCount", variableCount);
        } else {
            countMap.put("variableCount", 0);
        }
        int actualValueCount = 0;
        for (int rowIndex = valueStartRow; rowIndex < rawAllRows.size() && (bColumnValue = (row = rawAllRows.get(rowIndex)).getOrDefault(1, "").trim()).matches("\u68c0\u6d4b\u6570\u91cf|\u4e0d\u5408\u683c\u6570|\u7f3a\u9677\u6570"); ++rowIndex) {
            ++actualValueCount;
        }
        if (actualValueCount != 2) {
            throw new HussarException("\u68c0\u6d4b\u503c\u884c\u6570\u4e0d\u5339\u914d\uff01\u671f\u671b2\u884c\uff0c\u5b9e\u9645" + actualValueCount + "\u884c");
        }
        countMap.put("valueCount", actualValueCount);
        return countMap;
    }

    @Override
    public IPage<AnalysisInfoVo> queryPage(AnalysisInfoQueryDto dto) {
        Page page = new Page((long)dto.getCurrent().intValue(), (long)dto.getSize().intValue());
        if (HussarUtils.isNotEmpty((Object)dto.getKeyword())) {
            dto.setKeyword(dto.getKeyword().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        List<AnalysisInfoVo> list = this.analysisInfoMapper.listAnalysisInfo((Page<AnalysisInfoVo>)page, dto);
        List controlChartTypeList = this.dictApiService.getDictList("control_chart_type");
        Map<String, Object> controlChartTypeMap = controlChartTypeList.stream().collect(Collectors.toMap(DictApiVo::getValue, DictApiVo::getLabel));
        LinkedHashMap analysisStageMap = this.dictApiService.getDictMapByType("analysis_stage");
        LinkedHashMap dataStatusMap = this.dictApiService.getDictMapByType("analysis_data_status");
        LinkedHashMap analysisStatusMap = this.dictApiService.getDictMapByType("analysis_status");
        LinkedHashMap featureTypeMap = this.dictApiService.getDictMapByType("feature_type");
        list.forEach(item -> {
            if (HussarUtils.isNotEmpty((Object)item.getChartType()) && controlChartTypeMap.containsKey(item.getChartType())) {
                item.setChartType(controlChartTypeMap.get(item.getChartType()).toString());
            }
            if (HussarUtils.isNotEmpty((Object)item.getDataType()) && controlChartTypeMap.containsKey(item.getDataType())) {
                item.setDataType(controlChartTypeMap.get(item.getDataType()).toString());
            }
            if (HussarUtils.isNotEmpty((Object)item.getAnalysisStage()) && analysisStageMap.containsKey(item.getAnalysisStage())) {
                item.setAnalysisStage(analysisStageMap.get(item.getAnalysisStage()).toString());
            }
            if (HussarUtils.isNotEmpty((Object)item.getDataStatus()) && dataStatusMap.containsKey(item.getDataStatus())) {
                item.setDataStatus(dataStatusMap.get(item.getDataStatus()).toString());
            }
            if (HussarUtils.isNotEmpty((Object)item.getAnalysisStatus()) && analysisStatusMap.containsKey(item.getAnalysisStatus())) {
                item.setAnalysisStatus(analysisStatusMap.get(item.getAnalysisStatus()).toString());
            }
            if (HussarUtils.isNotEmpty((Object)item.getFeatureType()) && featureTypeMap.containsKey(item.getFeatureType())) {
                item.setFeatureType(featureTypeMap.get(item.getFeatureType()).toString());
            }
        });
        return page.setRecords(list);
    }

    @Override
    @HussarTransactional
    public Boolean delete(List<String> analysisId) {
        List analysisIdLongList = analysisId.stream().map(Long::parseLong).collect(Collectors.toList());
        List analysList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(AnalysisInfoEntity::getAnalysisId, analysisIdLongList)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        List<Long> jobIdList = analysList.stream().map(AnalysisInfoEntity::getJobId).collect(Collectors.toList());
        jobIdList.forEach(jobId -> {
            if (jobId != null) {
                this.jobApiService.physicalDeleteJob(jobId);
            }
        });
        return this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(AnalysisInfoEntity::getAnalysisId, analysisIdLongList)).set(HussarDelflagEntity::getDelFlag, (Object)"1"));
    }

    @Override
    public List<FilterFieldInfoVo> getFilterFieldList(Long controlProjectId) {
        List filterFieldInfoList = this.filterFieldInfoService.list();
        List fieldTypeCompareEntityList = this.fieldTypeCompareService.list();
        List dictApiVoList = this.dictApiService.getDictList("compare_type");
        List filterFieldInfoVoList = HussarUtils.copyProperties((Collection)filterFieldInfoList, FilterFieldInfoVo.class);
        for (FilterFieldInfoVo filterFieldInfoVo : filterFieldInfoVoList) {
            filterFieldInfoVo.setFieldType("1");
            String fieldType = filterFieldInfoVo.getFilterFieldType();
            List<DictApiVo> compareTypeList = AnalysisInfoServiceImpl.setCompares(fieldType, fieldTypeCompareEntityList, dictApiVoList);
            filterFieldInfoVo.setCompareTypeList(compareTypeList);
        }
        BaseConfigDto baseConfigDto = new BaseConfigDto();
        baseConfigDto.setControlProjectId(controlProjectId);
        List<ProcessVariableVo> processVariableList = this.baseConfigService.filedList(baseConfigDto);
        for (ProcessVariableVo processVariableVo : processVariableList) {
            FilterFieldInfoVo fieldInfoVo = new FilterFieldInfoVo();
            fieldInfoVo.setFilterFieldLabel(processVariableVo.getVariableName());
            fieldInfoVo.setFilterFieldType(processVariableVo.getVariableType());
            fieldInfoVo.setFilterFieldName(processVariableVo.getVariableFileName());
            fieldInfoVo.setFieldType("2");
            String fieldType = processVariableVo.getVariableType();
            List<DictApiVo> compareTypeList = AnalysisInfoServiceImpl.setCompares(fieldType, fieldTypeCompareEntityList, dictApiVoList);
            fieldInfoVo.setCompareTypeList(compareTypeList);
            fieldInfoVo.setEnumOptionList(processVariableVo.getEnumOptionList());
            filterFieldInfoVoList.add(fieldInfoVo);
        }
        return filterFieldInfoVoList;
    }

    @Override
    public AnalysisInfoVo formQuery(Long analysisId, String historyAnalysisId) {
        AttachmentManagerModelApiVo fileVo;
        HistoryAnalysis historyAnalysis;
        if (HussarUtils.isNotEmpty((Object)historyAnalysisId) && HussarUtils.isNotEmpty((Object)(historyAnalysis = (HistoryAnalysis)this.mongoTemplate.findById((Object)historyAnalysisId, HistoryAnalysis.class)))) {
            String warnObject;
            List<String> warnObjectList;
            String judgmentRuleInfo;
            List<String> judgmentRuleList;
            AttachmentManagerModelApiVo fileVo2;
            AnalysisInfoVo vo = new AnalysisInfoVo();
            String chartBaseInfo = historyAnalysis.getChartBaseInfo();
            vo = CommonUtils.copyJsonVarToObject(chartBaseInfo, vo);
            if (HussarUtils.isNotEmpty((Object)vo.getFileId()) && HussarUtils.isNotEmpty((Object)(fileVo2 = this.attachmentManagerApiService.getByFileId(vo.getFileId())))) {
                vo.setFileName(fileVo2.getFileName());
            }
            if (HussarUtils.isNotEmpty(judgmentRuleList = CommonUtils.convertJsonToList(judgmentRuleInfo = historyAnalysis.getJudgmentRuleInfo()))) {
                ArrayList<RelationRuleEntity> relationRuleEntityList = new ArrayList<RelationRuleEntity>();
                for (String judgmentRule : judgmentRuleList) {
                    RelationRuleEntity relationRuleEntity = new RelationRuleEntity();
                    relationRuleEntity = CommonUtils.copyJsonVarToObject(judgmentRule, relationRuleEntity);
                    relationRuleEntityList.add(relationRuleEntity);
                }
                vo.setRelationRuleEntityList(relationRuleEntityList);
            }
            if (HussarUtils.isNotEmpty(warnObjectList = CommonUtils.convertJsonToList(warnObject = historyAnalysis.getWarnObject()))) {
                ArrayList<RelationWarnObjectEntity> relationWarnObjectEntityList = new ArrayList<RelationWarnObjectEntity>();
                for (String warnObjectStr : warnObjectList) {
                    RelationWarnObjectEntity relationWarnObjectEntity = new RelationWarnObjectEntity();
                    relationWarnObjectEntity = CommonUtils.copyJsonVarToObject(warnObjectStr, relationWarnObjectEntity);
                    relationWarnObjectEntityList.add(relationWarnObjectEntity);
                }
                vo.setRelationWarnObjectEntityList(relationWarnObjectEntityList);
                this.transferDict(vo);
            }
            return vo;
        }
        AnalysisInfoVo analysisInfoVo = this.analysisInfoMapper.formQuery(analysisId);
        this.transferDict(analysisInfoVo);
        String filterConditons = analysisInfoVo.getFilterConditons();
        if (HussarUtils.isNotEmpty((Object)filterConditons)) {
            FilterFieldListVo filterFieldListVo = (FilterFieldListVo)JSONObject.parseObject((String)filterConditons, FilterFieldListVo.class);
            analysisInfoVo.setFilterFieldListVo(filterFieldListVo);
        }
        LambdaQueryWrapper relationRuleQueryWrapper = new LambdaQueryWrapper();
        relationRuleQueryWrapper.eq(RelationRuleEntity::getAnalysisId, (Object)analysisId);
        List relationRuleEntityList = this.relationRuleService.list((Wrapper)relationRuleQueryWrapper);
        analysisInfoVo.setRelationRuleEntityList(relationRuleEntityList);
        LambdaQueryWrapper relationWarnObjectQueryWrapper = new LambdaQueryWrapper();
        relationWarnObjectQueryWrapper.eq(RelationWarnObjectEntity::getAnalysisId, (Object)analysisId);
        List relationWarnObjectEntityList = this.relationWarnObjectService.list((Wrapper)relationWarnObjectQueryWrapper);
        analysisInfoVo.setRelationWarnObjectEntityList(relationWarnObjectEntityList);
        if ("2".equals(analysisInfoVo.getSourceType())) {
            LambdaQueryWrapper analysisDataSourceLambdaQueryWrapper = new LambdaQueryWrapper();
            analysisDataSourceLambdaQueryWrapper.eq(AnalysisDataSource::getAnalysisId, (Object)analysisId);
            List analysisDataSourceList = this.analysisDataSourceService.list((Wrapper)analysisDataSourceLambdaQueryWrapper);
            analysisInfoVo.setAnalysisDataSourceList(analysisDataSourceList);
        }
        if (HussarUtils.isNotEmpty((Object)analysisInfoVo.getFileId()) && HussarUtils.isNotEmpty((Object)(fileVo = this.attachmentManagerApiService.getByFileId(analysisInfoVo.getFileId())))) {
            analysisInfoVo.setFileName(fileVo.getFileName());
        }
        return analysisInfoVo;
    }

    @Override
    public AnalysisInfoVo formQueryShort(Long analysisId, String historyAnalysisId) {
        HistoryAnalysis historyAnalysis;
        AnalysisInfoEntity analysisInfoEntity = (AnalysisInfoEntity)((Object)this.getById(analysisId));
        if (HussarUtils.isNotEmpty((Object)historyAnalysisId) && !historyAnalysisId.equals(analysisInfoEntity.getHistoryAnalysisId()) && HussarUtils.isNotEmpty((Object)(historyAnalysis = (HistoryAnalysis)this.mongoTemplate.findById((Object)historyAnalysisId, HistoryAnalysis.class)))) {
            String chartBaseInfo = historyAnalysis.getChartBaseInfo();
            AnalysisInfoVo vo = new AnalysisInfoVo();
            vo = CommonUtils.copyJsonVarToObject(chartBaseInfo, vo);
            this.transferDict(vo);
            return vo;
        }
        AnalysisInfoVo analysisInfoVo = this.analysisInfoMapper.formQuery(analysisId);
        this.transferDict(analysisInfoVo);
        return analysisInfoVo;
    }

    private void transferDict(AnalysisInfoVo analysisInfoVo) {
        List controlChartTypeList = this.dictApiService.getDictList("control_chart_type");
        Map<String, Object> controlChartTypeMap = controlChartTypeList.stream().collect(Collectors.toMap(DictApiVo::getValue, DictApiVo::getLabel));
        if (HussarUtils.isNotEmpty((Object)analysisInfoVo.getDataType()) && controlChartTypeMap.containsKey(analysisInfoVo.getDataType())) {
            analysisInfoVo.setDataTypeLabel(controlChartTypeMap.get(analysisInfoVo.getDataType()).toString());
        }
        if (HussarUtils.isNotEmpty((Object)analysisInfoVo.getAnalysisType()) && controlChartTypeMap.containsKey(analysisInfoVo.getAnalysisType())) {
            analysisInfoVo.setAnalysisTypeLabel(controlChartTypeMap.get(analysisInfoVo.getAnalysisType()).toString());
        }
        LinkedHashMap analysisStageMap = this.dictApiService.getDictMapByType("analysis_stage");
        if (HussarUtils.isNotEmpty((Object)analysisInfoVo.getAnalysisStage()) && analysisStageMap.containsKey(analysisInfoVo.getAnalysisStage())) {
            analysisInfoVo.setAnalysisStageLabel(analysisStageMap.get(analysisInfoVo.getAnalysisStage()).toString());
        }
        LinkedHashMap analysisDataSource = this.dictApiService.getDictMapByType("analysis_data_source");
        if (HussarUtils.isNotEmpty((Object)analysisInfoVo.getSourceType()) && analysisDataSource.containsKey(analysisInfoVo.getSourceType())) {
            analysisInfoVo.setSourceTypeLabel(analysisDataSource.get(analysisInfoVo.getSourceType()).toString());
        }
        LinkedHashMap timeUnitMap = this.dictApiService.getDictMapByType("time_unit");
        if (HussarUtils.isNotEmpty((Object)analysisInfoVo.getIntervalType()) && analysisDataSource.containsKey(analysisInfoVo.getIntervalType())) {
            analysisInfoVo.setIntervalTypeLabel(timeUnitMap.get(analysisInfoVo.getIntervalType()).toString());
        }
    }

    private static List<DictApiVo> setCompares(String fieldType, List<FieldTypeCompareEntity> fieldTypeCompareEntityList, List<DictApiVo> dictApiVoList) {
        FieldTypeCompareEntity fieldTypeCompare = fieldTypeCompareEntityList.stream().filter(fieldTypeCompareEntity -> fieldTypeCompareEntity.getFieldType().equals(fieldType)).findFirst().get();
        if (HussarUtils.isNotEmpty((Object)fieldTypeCompare.getFilterFieldCompares())) {
            List<String> compareList = Arrays.asList(fieldTypeCompare.getFilterFieldCompares().split(","));
            return dictApiVoList.stream().filter(dictApiVo -> compareList.contains(dictApiVo.getValue())).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    @HussarTransactional
    public String detailAnalysis(Long analysisId) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime now = LocalDateTime.now();
        AnalysisInfoEntity analysisInfo = (AnalysisInfoEntity)((Object)this.getById(analysisId));
        if ("3".equals(analysisInfo.getSourceType())) {
            List<AnalysisDataSource> analysisDataSourceList = this.getDataSuitableForAnalysis(analysisInfo);
            if (HussarUtils.isEmpty(analysisDataSourceList)) {
                this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(AnalysisInfoEntity::getAnalysisId, (Object)analysisInfo.getAnalysisId())).set(AnalysisInfoEntity::getIsPolling, (Object)"2"));
                analysisInfo.setIsPolling("2");
            } else {
                this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(AnalysisInfoEntity::getAnalysisId, (Object)analysisInfo.getAnalysisId())).set(AnalysisInfoEntity::getIsPolling, (Object)"1"));
                analysisInfo.setIsPolling("1");
            }
        } else {
            this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(AnalysisInfoEntity::getAnalysisId, (Object)analysisInfo.getAnalysisId())).set(AnalysisInfoEntity::getIsPolling, (Object)"1"));
            analysisInfo.setIsPolling("1");
        }
        if (HussarUtils.isNotEmpty((Object)analysisInfo.getHistoryAnalysisId())) {
            this.saveChangeAnalysisRecord(analysisInfo, user, now);
        }
        if ("3".equals(analysisInfo.getSourceType())) {
            this.dynamicAnalysis(analysisInfo, user, now);
        } else {
            if (HussarUtils.isNotEmpty((Object)analysisInfo.getHistoryAnalysisId())) {
                this.deleteAnalysisResult(analysisInfo);
            }
            this.asyncAnalysisInfoService.analysis(analysisInfo, user, now, null, null);
        }
        OperateLogAPIDTO operateLogAPIDTO = OperateLogAPIDTO.fromBusiness(LogType.ANALYSIS_EXECUTE_DETAIL, null, analysisInfo.getAnalysisId(), analysisInfo.getAnalysisCode());
        OperateLogContext context = OperateLogContextBuilder.create(operateLogAPIDTO).build();
        this.operateLogAPIService.save(context);
        return analysisInfo.getIsPolling();
    }

    @Override
    public AnalysisBaseDto initializeBaseInfo(AnalysisInfoEntity analysisInfo, List<AnalysisDataSource> analysisDataSourceList, List<RelationRuleEntity> relationRuleEntityList) {
        List<RelationRuleVO> relationRuleVOList;
        AnalysisBaseDto analysisBaseDto = new AnalysisBaseDto();
        String analysisType = "1".equals(analysisInfo.getDataType()) ? "1" : "";
        if (HussarUtils.isNotEmpty(relationRuleEntityList)) {
            relationRuleVOList = BeanUtil.copyProperties(relationRuleEntityList, RelationRuleVO.class);
            List<RuleDictVo> ruleDictVoList = this.relationRuleService.getRuleDictList(relationRuleVOList.stream().map(RelationRuleVO::getRuleDictId).collect(Collectors.toList()));
            relationRuleVOList.forEach(relationRuleVO -> {
                RuleDictVo temp = ruleDictVoList.stream().filter(ruleDictVo -> ruleDictVo.getRuleDictId().equals(relationRuleVO.getRuleDictId())).findFirst().orElse(null);
                if (HussarUtils.isNotEmpty((Object)temp)) {
                    relationRuleVO.setJudgmentDictNum(temp.getJudgementRuleNum());
                    relationRuleVO.setAnalysisType(temp.getAnalysisType());
                }
            });
            if (HussarUtils.isNotEmpty((Object)analysisType)) {
                relationRuleVOList = relationRuleVOList.stream().filter(relationRuleVO -> analysisType.equals(relationRuleVO.getAnalysisType())).collect(Collectors.toList());
            }
            analysisBaseDto.setRelationRuleVOList(relationRuleVOList);
        } else {
            relationRuleVOList = this.relationRuleService.getRelationRuleWithOldNum(analysisInfo.getAnalysisId(), analysisType);
            analysisBaseDto.setRelationRuleVOList(relationRuleVOList);
        }
        List relationWarnObjectEntityList = this.relationWarnObjectService.list((Wrapper)new LambdaQueryWrapper().eq(RelationWarnObjectEntity::getAnalysisId, (Object)analysisInfo.getAnalysisId()));
        if (HussarUtils.isEmpty(analysisDataSourceList)) {
            analysisDataSourceList = this.analysisDataSourceService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AnalysisDataSource::getAnalysisId, (Object)analysisInfo.getAnalysisId())).eq(AnalysisDataSource::getIsExclude, (Object)"0"));
        }
        analysisBaseDto.setRelationWarnObjectEntityList(relationWarnObjectEntityList);
        analysisBaseDto.setAnalysisDataSourceList(analysisDataSourceList);
        return analysisBaseDto;
    }

    @Override
    public void relationAbnormalData(AnalysisResultVO analysisResultVO, AnalysisInfoEntity analysisInfo, List<AbnormalData> abnormalDataList) {
        List<ControlData> controlDataList = analysisResultVO.getControlData();
        String firstAnalysisResult = controlDataList.get(0).getAnalysisResult();
        String secondAnalysisResult = "";
        List secondChartStatistic = new ArrayList();
        List secondChartStatisticVo = new ArrayList();
        if (!"1".equals(analysisInfo.getDataType())) {
            secondAnalysisResult = controlDataList.get(1).getAnalysisResult();
            secondChartStatistic = JSONObject.parseArray((String)secondAnalysisResult, ChartStatistic.class);
            secondChartStatisticVo = BeanUtil.copy(secondChartStatistic, ChartStatisticVo.class);
        }
        HashSet<String> secondChartTypes = new HashSet<String>(Arrays.asList("2", "4", "5"));
        List firstChartStatistic = JSONObject.parseArray((String)firstAnalysisResult, ChartStatistic.class);
        List firstChartStatisticVo = BeanUtil.copy((Collection)firstChartStatistic, ChartStatisticVo.class);
        for (AbnormalData abnormalData : abnormalDataList) {
            if (!HussarUtils.isNotEmpty((Object)abnormalData.getAbnormalSort())) continue;
            if (secondChartTypes.contains(abnormalData.getChartType())) {
                ((ChartStatisticVo)secondChartStatisticVo.get(abnormalData.getAbnormalSort() - 1)).setAbnormalDataId(String.valueOf(abnormalData.getAbnormalDataId()));
                continue;
            }
            ((ChartStatisticVo)firstChartStatisticVo.get(abnormalData.getAbnormalSort() - 1)).setAbnormalDataId(String.valueOf(abnormalData.getAbnormalDataId()));
        }
        String newFirstChartStatisticVo = JSONObject.toJSONString((Object)firstChartStatisticVo);
        controlDataList.get(0).setAnalysisResult(newFirstChartStatisticVo);
        if (HussarUtils.isNotEmpty(secondChartStatisticVo)) {
            String newSecondChartStatisticVo = JSONObject.toJSONString(secondChartStatisticVo);
            controlDataList.get(1).setAnalysisResult(newSecondChartStatisticVo);
        }
    }

    @Override
    public Boolean generateWarningMessage(AnalysisResultVO analysisResultVO, AnalysisInfoEntity analysisInfo, List<RelationWarnObjectEntity> relationWarnObjectEntityList) {
        try {
            List<ControlData> controlDataList = analysisResultVO.getControlData();
            if (HussarUtils.isNotEmpty(controlDataList)) {
                for (ControlData controlData : controlDataList) {
                    List relationRuleEntityList;
                    String judgmentResult = controlData.getJudgmentResult();
                    if (HussarUtils.isEmpty((Object)judgmentResult)) continue;
                    ObjectMapper objectMapper = new ObjectMapper();
                    List mapList = (List)objectMapper.readValue(judgmentResult, List.class);
                    ArrayList<String> ruleIdList = new ArrayList<String>();
                    for (Map map : mapList) {
                        String ruleId = (String)map.get("relationRuleId");
                        ruleIdList.add(ruleId);
                    }
                    if (!HussarUtils.isNotEmpty(ruleIdList) || !HussarUtils.isNotEmpty((Object)(relationRuleEntityList = this.relationRuleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RelationRuleEntity::getIsWarning, (Object)"1")).in(RelationRuleEntity::getRelationRuleId, ruleIdList))))) continue;
                    int count = relationRuleEntityList.size();
                    StringBuilder content = new StringBuilder();
                    for (int i = 0; i < relationRuleEntityList.size(); ++i) {
                        RelationRuleEntity relationRuleEntity = (RelationRuleEntity)((Object)relationRuleEntityList.get(i));
                        List tempList = mapList.stream().filter(a -> ((String)a.get("relationRuleId")).equals(String.valueOf(relationRuleEntity.getRelationRuleId()))).collect(Collectors.toList());
                        if (!HussarUtils.isNotEmpty(tempList)) continue;
                        String judgmentName = (String)((Map)tempList.get(0)).get("judgmentName");
                        List nodes = (List)((Map)tempList.get(0)).get("nodes");
                        content.append("\u3010" + (i + 1) + "\u3011").append(judgmentName).append("\uff1a").append(String.join((CharSequence)",", nodes)).append("\n");
                    }
                    Long projectId = analysisInfo.getControlProjectId();
                    ControlProject controlProject = (ControlProject)((Object)this.controlProjectService.getById(projectId));
                    String projectName = controlProject.getControlProjectName();
                    ControlProjectType controlProjectType = (ControlProjectType)((Object)this.controlProjectTypeService.getById(controlProject.getTypeId()));
                    String pathName = controlProjectType.getTypeNamePath();
                    List assignerIdList = relationWarnObjectEntityList.stream().filter(a -> a.getObjectType().equals("0")).map(RelationWarnObjectEntity::getBusinessId).collect(Collectors.toList());
                    List roles = relationWarnObjectEntityList.stream().filter(a -> a.getObjectType().equals("1")).map(RelationWarnObjectEntity::getBusinessId).collect(Collectors.toList());
                    SearchUserDto searchUserDto = new SearchUserDto();
                    searchUserDto.setRoleIds(roles);
                    List userList = this.organUserApiService.getUsersByOrganUserRole(searchUserDto);
                    assignerIdList.addAll(userList.stream().map(UserVo::getId).collect(Collectors.toList()));
                    List chargePerson = relationWarnObjectEntityList.stream().filter(a -> a.getObjectType().equals("2")).collect(Collectors.toList());
                    if (HussarUtils.isNotEmpty(chargePerson)) {
                        assignerIdList.add(analysisInfo.getChargePersonId());
                    }
                    String assignerIds = assignerIdList.stream().map(String::valueOf).collect(Collectors.joining(","));
                    String currentTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    String warningContent = String.format("\u5206\u6790\u56fe\u7f16\u7801\uff1a%s\n\u63a7\u5236\u9879\u76ee\uff1a%s-%s\n\u5f02\u5e38\u53d1\u751f\u65f6\u95f4\uff1a%s\n\u5171\u89e6\u53d1\u5e76\u544a\u8b66%d\u6761\u5224\u5f02\u89c4\u5219\uff0c\u8be6\u60c5\u5982\u4e0b\uff1a\n%s", analysisInfo.getAnalysisCode(), pathName, projectName, currentTime, count, content);
                    this.pushWarningMessage(warningContent, assignerIds, analysisInfo.getAnalysisId(), Long.parseLong(analysisInfo.getHistoryAnalysisId()));
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void pushWarningMessage(String content, String assignerIds, Long analysisId, Long historyAnalysisId) {
        String title = "\u5f02\u5e38\u544a\u8b66";
        String contentJqx = title + content;
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = new SecurityUser();
        user.setUserId(CommonConstant.SYS_USE_ID);
        user.setUserName("\u7cfb\u7edf");
        SpcMessageDto addSysMessageType = this.messageSendService.defaultMessage(title, content, date, user, assignerIds, String.format("/spc/analysisInfo?analysisId=%s&historyAnalysisId=%s", analysisId, historyAnalysisId), "");
        this.messageSendService.sendMessage(addSysMessageType);
    }

    @Override
    public void dynamicAnalysis(AnalysisInfoEntity analysisInfo, SecurityUser user, LocalDateTime now) {
        Long jobId;
        Long analysisId = analysisInfo.getAnalysisId();
        if (HussarUtils.isNotEmpty((Object)analysisInfo.getHistoryAnalysisId())) {
            // empty if block
        }
        if (HussarUtils.isEmpty((Object)(jobId = this.saveOrUpdateJob(analysisInfo)))) {
            throw new HussarException("\u5b9a\u65f6\u4efb\u52a1\u751f\u6210\u5931\u8d25");
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.eq(AnalysisInfoEntity::getAnalysisId, (Object)analysisId)).set(AnalysisInfoEntity::getJobId, (Object)jobId);
        this.update((Wrapper)updateWrapper);
    }

    private Long saveOrUpdateJob(AnalysisInfoEntity analysisInfo) {
        JobInfoApiDto jobInfoApiDto = new JobInfoApiDto();
        if (HussarUtils.isNotEmpty((Object)analysisInfo.getJobId())) {
            this.jobApiService.deleteJob(analysisInfo.getJobId());
            jobInfoApiDto.setId(null);
        }
        jobInfoApiDto.setJobName(analysisInfo.getAnalysisCode());
        jobInfoApiDto.setAppId(Long.valueOf(543099687121723392L));
        if (HussarUtils.isNotEmpty((Object)analysisInfo.getRefreshInterval()) && HussarUtils.isNotEmpty((Object)analysisInfo.getIntervalType())) {
            Integer refreshInterval = analysisInfo.getRefreshInterval();
            switch (analysisInfo.getIntervalType()) {
                case "2": {
                    refreshInterval = refreshInterval * 1000;
                    break;
                }
                case "3": {
                    refreshInterval = refreshInterval * 60 * 1000;
                    break;
                }
                case "4": {
                    refreshInterval = refreshInterval * 3600 * 1000;
                    break;
                }
                case "5": {
                    refreshInterval = refreshInterval * 24 * 3600 * 1000;
                    break;
                }
            }
            jobInfoApiDto.setTimeExpressionType(TimeExpressionType.FIXED_RATE);
            jobInfoApiDto.setTimeExpression(refreshInterval.toString());
        } else {
            jobInfoApiDto.setTimeExpressionType(TimeExpressionType.CRON);
            jobInfoApiDto.setTimeExpression(this.getCronAfterXSeconds(3));
            jobInfoApiDto.setJobDescription("once");
        }
        jobInfoApiDto.setExecuteType(ExecuteType.STANDALONE);
        jobInfoApiDto.setProcessorType(ProcessorType.BUILT_IN);
        jobInfoApiDto.setProcessorInfo("com.jxdinfo.spc.core.analysisManage.analysisInfo.job.DynamicAnalysisJob");
        jobInfoApiDto.setMaxInstanceNum(Integer.valueOf(0));
        jobInfoApiDto.setInstanceRetryNum(Integer.valueOf(0));
        jobInfoApiDto.setEnable(true);
        jobInfoApiDto.setTenantCode("0");
        return this.jobApiService.saveJob(jobInfoApiDto);
    }

    public String getCronAfterXSeconds(int x) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime targetTime = now.plusSeconds(x);
        return String.format("%d %d %d %d %d ?", targetTime.getSecond(), targetTime.getMinute(), targetTime.getHour(), targetTime.getDayOfMonth(), targetTime.getMonthValue());
    }

    @Override
    public AnalysisParamDto initializeParamDto(AnalysisInfoEntity analysisInfo, SecurityUser user, LocalDateTime now, List<RelationRuleVO> relationRuleVOList, List<AnalysisDataSource> analysisDataSourceList) {
        AnalysisParamDto analysisParamDto = new AnalysisParamDto();
        analysisParamDto.setAnalysisId(analysisInfo.getAnalysisId());
        analysisParamDto.setUsl(analysisInfo.getUsl());
        analysisParamDto.setSl(analysisInfo.getSl());
        analysisParamDto.setLsl(analysisInfo.getLsl());
        analysisParamDto.setUcl(analysisInfo.getUcl());
        analysisParamDto.setCl(analysisInfo.getCl());
        analysisParamDto.setLcl(analysisInfo.getLcl());
        analysisParamDto.setUclr(analysisInfo.getUclr());
        analysisParamDto.setClr(analysisInfo.getClr());
        analysisParamDto.setLclr(analysisInfo.getLclr());
        analysisParamDto.setSubgroupSize(String.valueOf(analysisInfo.getSubgroupSize()));
        analysisParamDto.setDataType(analysisInfo.getDataType());
        analysisParamDto.setChartType(analysisInfo.getAnalysisType());
        analysisParamDto.setCreator(user.getId());
        analysisParamDto.setCreatorName(user.getUserName());
        analysisParamDto.setCreateTime(now);
        analysisParamDto.setRelationRuleList(relationRuleVOList);
        SpcBaseConfigVo decimalNumConfig = this.spcBaseConfigService.getSpcBaseConfigByKey("decimal_num");
        analysisParamDto.setDecimalNum(Integer.parseInt(decimalNumConfig.getConfigValue()));
        analysisParamDto.setBoxplotGroupSize(analysisInfo.getVirtualSubgroupSize());
        List<List<AnalysisDataSource>> dataList = this.initializeDataSourceList(analysisDataSourceList, analysisInfo);
        analysisParamDto.setDataList(dataList);
        return analysisParamDto;
    }

    private List<List<AnalysisDataSource>> initializeDataSourceList(List<AnalysisDataSource> analysisDataSourceList, AnalysisInfoEntity analysisInfo) {
        ArrayList<List<AnalysisDataSource>> dataList = new ArrayList<List<AnalysisDataSource>>();
        int totalSize = analysisDataSourceList.size();
        int subgroupSize = analysisInfo.getSubgroupSize();
        if ("1".equals(analysisInfo.getDataType())) {
            subgroupSize = 1;
        }
        int pointSize = totalSize / subgroupSize;
        for (int i = 0; i < pointSize; ++i) {
            int start = i * subgroupSize;
            int end = start + subgroupSize;
            List<AnalysisDataSource> subList = analysisDataSourceList.subList(start, end);
            dataList.add(new ArrayList<AnalysisDataSource>(subList));
        }
        return dataList;
    }

    @Override
    public void deleteAnalysisResult(AnalysisInfoEntity analysisInfo) {
        this.controlDataService.remove((Wrapper)new LambdaQueryWrapper().eq(ControlData::getAnalysisId, (Object)analysisInfo.getAnalysisId()));
        this.boxplotService.remove((Wrapper)new LambdaQueryWrapper().eq(Boxplot::getAnalysisId, (Object)analysisInfo.getAnalysisId()));
        if ("0".equals(analysisInfo.getDataType())) {
            this.processCapabilityService.remove((Wrapper)new LambdaQueryWrapper().eq(ProcessCapability::getAnalysisId, (Object)analysisInfo.getAnalysisId()));
            this.normalTestService.remove((Wrapper)new LambdaQueryWrapper().eq(NormalTest::getAnalysisId, (Object)analysisInfo.getAnalysisId()));
        }
        if ("p".equals(analysisInfo.getAnalysisType())) {
            this.binomialProbabilityService.remove((Wrapper)new LambdaQueryWrapper().eq(BinomialProbability::getAnalysisId, (Object)analysisInfo.getAnalysisId()));
        }
    }

    @Override
    public void saveChangeAnalysisRecord(AnalysisInfoEntity analysisInfo, SecurityUser user, LocalDateTime now) {
        ChangeAnalysisRecordEntity changeAnalysisRecordEntity = (ChangeAnalysisRecordEntity)BeanUtil.copy((Object)((Object)analysisInfo), ChangeAnalysisRecordEntity.class);
        changeAnalysisRecordEntity.setCreator(user.getId());
        changeAnalysisRecordEntity.setCreatorName(user.getUserName());
        changeAnalysisRecordEntity.setCreateTime(now);
        this.changeAnalysisRecordService.save(changeAnalysisRecordEntity);
    }

    @Override
    public void saveAnalysisResult(AnalysisInfoEntity analysisInfo, AnalysisResultVO analysisResultVO) {
        this.controlDataService.saveBatch(analysisResultVO.getControlData());
        this.boxplotService.saveBatch(analysisResultVO.getBoxplotList());
        if ("0".equals(analysisInfo.getDataType())) {
            this.processCapabilityService.save(analysisResultVO.getProcessCapability());
            if (HussarUtils.isNotEmpty((Object)analysisResultVO.getNormalTest())) {
                this.normalTestService.save(analysisResultVO.getNormalTest());
            }
        }
        if ("p".equals(analysisInfo.getAnalysisType()) && HussarUtils.isNotEmpty((Object)analysisResultVO.getBinomialProbability())) {
            this.binomialProbabilityService.save(analysisResultVO.getBinomialProbability());
        }
    }

    @Override
    public void saveHistoryResult(AnalysisInfoEntity analysisInfo, AnalysisResultVO analysisResultVO) {
        HistoryResult historyResult = new HistoryResult();
        HashSet<String> countingTypes = new HashSet<String>(Arrays.asList("7", "8", "9", "10"));
        List<ControlData> controlDataList = analysisResultVO.getControlData();
        String firstData = JSONObject.toJSONString((Object)controlDataList.get(0));
        String secondData = "";
        if ("0".equals(analysisInfo.getDataType())) {
            secondData = JSONObject.toJSONString((Object)controlDataList.get(1));
        }
        if (countingTypes.contains(controlDataList.get(0).getChartType())) {
            historyResult.setFirstControlData(firstData);
        } else {
            historyResult.setFirstControlData(firstData);
            historyResult.setSecondControlData(secondData);
        }
        List<Boxplot> boxplotList = analysisResultVO.getBoxplotList();
        String boxplotData = JSONObject.toJSONString(boxplotList);
        historyResult.setBoxplotData(boxplotData);
        if ("0".equals(analysisInfo.getDataType())) {
            NormalTest normalTest = analysisResultVO.getNormalTest();
            ProcessCapability processCapability = analysisResultVO.getProcessCapability();
            String normalTestData = JSONObject.toJSONString((Object)normalTest);
            String processCapabilityData = JSONObject.toJSONString((Object)processCapability);
            historyResult.setNormalTestData(normalTestData);
            historyResult.setProcessCapability(processCapabilityData);
        }
        if ("p".equals(analysisInfo.getAnalysisType())) {
            String binomialProbability = JSONObject.toJSONString((Object)analysisResultVO.getBinomialProbability());
            historyResult.setBinomialProbability(binomialProbability);
        }
        historyResult.setId(analysisInfo.getHistoryAnalysisId());
        this.mongoTemplate.save((Object)historyResult);
    }

    @Override
    public void saveHistoryAnalysis(AnalysisInfoEntity analysisInfo, AnalysisResultVO analysisResultVO, List<RelationRuleVO> relationRuleVOList, List<RelationWarnObjectEntity> relationWarnObjectEntityList) {
        List relationRuleList = BeanUtil.copy(relationRuleVOList, RelationRuleEntity.class);
        HistoryAnalysis historyAnalysis = new HistoryAnalysis();
        historyAnalysis.setId(analysisInfo.getHistoryAnalysisId());
        List<ControlProjectVo> controlProjectList = this.analysisInfoMapper.getControlProjectInfoById(analysisInfo.getControlProjectId());
        if (HussarUtils.isNotEmpty(controlProjectList)) {
            analysisInfo.setTypeNamePath(controlProjectList.get(0).getTypeNamePath());
            analysisInfo.setControlProjectName(controlProjectList.get(0).getControlProjectName());
        }
        String historyAnalysisInfo = JSONObject.toJSONString((Object)((Object)analysisInfo));
        historyAnalysis.setChartBaseInfo(historyAnalysisInfo);
        String judgmentRuleInfo = JSONObject.toJSONString((Object)relationRuleList);
        String warnObject = JSONObject.toJSONString(relationWarnObjectEntityList);
        historyAnalysis.setJudgmentRuleInfo(judgmentRuleInfo);
        historyAnalysis.setWarnObject(warnObject);
        this.mongoTemplate.save((Object)historyAnalysis);
    }

    @Override
    public void saveHistoryDataSource(List<AnalysisDataSource> dataList, String historyId) {
        HistoryDataSource historyDataSource = new HistoryDataSource();
        historyDataSource.setId(historyId);
        String dataSource = JSONObject.toJSONString(dataList);
        historyDataSource.setDataSource(dataSource);
        this.mongoTemplate.save((Object)historyDataSource);
    }

    private void deleteHistory(String historyId) {
        this.mongoTemplate.remove(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)historyId)), HistoryAnalysis.class);
        this.mongoTemplate.remove(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)historyId)), HistoryDataSource.class);
        this.mongoTemplate.remove(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)historyId)), HistoryResult.class);
    }

    @Override
    public boolean updateChargePerson(AnalysisInfoDto dto) {
        List<Long> analysisIdList = dto.getAnlysisIdList();
        if (HussarUtils.isNotEmpty(analysisIdList)) {
            List oldAnalysisInfoEntityList = this.list((Wrapper)new LambdaQueryWrapper().in(AnalysisInfoEntity::getAnalysisId, analysisIdList));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(AnalysisInfoEntity::getAnalysisId, analysisIdList);
            updateWrapper.set(AnalysisInfoEntity::getChargePersonId, (Object)dto.getChargePersonId());
            updateWrapper.set(AnalysisInfoEntity::getChargePersonName, (Object)dto.getChargePersonName());
            boolean isSuccess = this.update((Wrapper)updateWrapper);
            if (isSuccess) {
                ArrayList<OperateLogContext> contextList = new ArrayList<OperateLogContext>();
                oldAnalysisInfoEntityList.forEach(oldAnalysisInfoEntity -> {
                    ChangeValue changeValue = new ChangeValue(HussarUtils.isNotEmpty((Object)oldAnalysisInfoEntity.getChargePersonName()) ? oldAnalysisInfoEntity.getChargePersonName() : "\u65e0", HussarUtils.isNotEmpty((Object)dto.getChargePersonName()) ? dto.getChargePersonName() : "\u65e0");
                    JsonItem jsonItem = new JsonItem();
                    jsonItem.setItemKey("\u8d1f\u8d23\u4eba");
                    jsonItem.setItemValue(changeValue);
                    OperateLogAPIDTO operateLogAPIDTO = OperateLogAPIDTO.fromBusiness(LogType.ANALYSIS_UPDATE_CHARGER, Collections.singletonList(jsonItem), oldAnalysisInfoEntity.getAnalysisId(), oldAnalysisInfoEntity.getAnalysisCode());
                    OperateLogContext context = OperateLogContextBuilder.create(operateLogAPIDTO).build();
                    contextList.add(context);
                });
                if (HussarUtils.isNotEmpty(contextList)) {
                    this.operateLogAPIService.batchSave(contextList);
                }
            }
            return isSuccess;
        }
        throw new HussarException("\u8bf7\u9009\u62e9\u63a7\u5236\u56fe");
    }

    @Override
    public AnalysisResultVO analysisResult(Long analysisId, String dataType, String historyAnalysisId) {
        AnalysisResultVO analysisResultVO = new AnalysisResultVO();
        if (HussarUtils.isNotEmpty((Object)historyAnalysisId)) {
            HistoryResult historyResult;
            String chartBaseInfo;
            AnalysisInfoVo analysisBaseInfo;
            HistoryAnalysis historyAnalysis = (HistoryAnalysis)this.mongoTemplate.findById((Object)historyAnalysisId, HistoryAnalysis.class);
            String analysisType = "";
            if (HussarUtils.isNotEmpty((Object)historyAnalysis) && HussarUtils.isNotEmpty((Object)(analysisBaseInfo = CommonUtils.copyJsonVarToObject(chartBaseInfo = historyAnalysis.getChartBaseInfo(), new AnalysisInfoVo())))) {
                analysisType = analysisBaseInfo.getAnalysisType();
            }
            if (HussarUtils.isNotEmpty((Object)(historyResult = (HistoryResult)this.mongoTemplate.findById((Object)String.valueOf(historyAnalysisId), HistoryResult.class)))) {
                String binomialProbabilityStr;
                String firstControlData;
                if ("0".equals(dataType)) {
                    firstControlData = historyResult.getFirstControlData();
                    String secondControlData = historyResult.getSecondControlData();
                    ControlData firstControlDataObject = CommonUtils.copyJsonVarToObject(firstControlData, new ControlData());
                    ControlData secondControlDataObject = CommonUtils.copyJsonVarToObject(secondControlData, new ControlData());
                    analysisResultVO.setControlData(Arrays.asList(firstControlDataObject, secondControlDataObject));
                    String normalTestData = historyResult.getNormalTestData();
                    NormalTest normalTest = CommonUtils.copyJsonVarToObject(normalTestData, new NormalTest());
                    analysisResultVO.setNormalTest(normalTest);
                    ProcessCapability processCapability = CommonUtils.copyJsonVarToObject(historyResult.getProcessCapability(), new ProcessCapability());
                    analysisResultVO.setProcessCapability(processCapability);
                } else {
                    firstControlData = historyResult.getFirstControlData();
                    ControlData firstControlDataObject = CommonUtils.copyJsonVarToObject(firstControlData, new ControlData());
                    analysisResultVO.setControlData(Collections.singletonList(firstControlDataObject));
                }
                String boxplotData = historyResult.getBoxplotData();
                List<String> boxplotDataList = CommonUtils.convertJsonToList(boxplotData);
                if (HussarUtils.isNotEmpty(boxplotDataList)) {
                    ArrayList<Boxplot> boxplotList = new ArrayList<Boxplot>();
                    boxplotDataList.forEach(jsonStr -> {
                        Boxplot boxplot = CommonUtils.copyJsonVarToObject(jsonStr, new Boxplot());
                        boxplotList.add(boxplot);
                    });
                    analysisResultVO.setBoxplotList(boxplotList);
                }
                if ("p".equals(analysisType) && HussarUtils.isNotEmpty((Object)(binomialProbabilityStr = historyResult.getBinomialProbability()))) {
                    BinomialProbability binomialProbability = CommonUtils.copyJsonVarToObject(binomialProbabilityStr, new BinomialProbability());
                    analysisResultVO.setBinomialProbability(binomialProbability);
                }
            }
            return analysisResultVO;
        }
        List controlData = this.controlDataService.list((Wrapper)new LambdaQueryWrapper().eq(ControlData::getAnalysisId, (Object)analysisId));
        if (HussarUtils.isEmpty((Object)controlData)) {
            return null;
        }
        analysisResultVO.setControlData(controlData);
        List boxplotList = this.boxplotService.list((Wrapper)new LambdaQueryWrapper().eq(Boxplot::getAnalysisId, (Object)analysisId));
        analysisResultVO.setBoxplotList(boxplotList);
        if ("0".equals(dataType)) {
            ProcessCapability processCapability = (ProcessCapability)this.processCapabilityService.getOne((Wrapper)new LambdaQueryWrapper().eq(ProcessCapability::getAnalysisId, (Object)analysisId));
            analysisResultVO.setProcessCapability(processCapability);
            NormalTest normalTest = (NormalTest)this.normalTestService.getOne((Wrapper)new LambdaQueryWrapper().eq(NormalTest::getAnalysisId, (Object)analysisId));
            analysisResultVO.setNormalTest(normalTest);
        } else {
            List binomialProbabilitiyList;
            AnalysisInfoEntity analysisInfo = (AnalysisInfoEntity)((Object)this.getById(analysisId));
            if (HussarUtils.isNotEmpty((Object)((Object)analysisInfo)) && "p".equals(analysisInfo.getAnalysisType()) && HussarUtils.isNotEmpty((Object)(binomialProbabilitiyList = this.binomialProbabilityService.list((Wrapper)new LambdaQueryWrapper().eq(BinomialProbability::getAnalysisId, (Object)analysisId))))) {
                analysisResultVO.setBinomialProbability((BinomialProbability)binomialProbabilitiyList.get(0));
            }
        }
        return analysisResultVO;
    }

    @Override
    @HussarTransactional
    public Long saveAndAnalysis(AnalysisInfoDto analysisInfoDto) {
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        AnalysisInfoEntity analysisInfo = this.saveAnalysisInfo(analysisInfoDto, user, date);
        if ("3".equals(analysisInfo.getSourceType())) {
            List<AnalysisDataSource> analysisDataSourceList = this.getDataSuitableForAnalysis(analysisInfo);
            if (HussarUtils.isEmpty(analysisDataSourceList)) {
                this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(AnalysisInfoEntity::getAnalysisId, (Object)analysisInfo.getAnalysisId())).set(AnalysisInfoEntity::getIsPolling, (Object)"2"));
                analysisInfo.setIsPolling("2");
            } else {
                this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(AnalysisInfoEntity::getAnalysisId, (Object)analysisInfo.getAnalysisId())).set(AnalysisInfoEntity::getIsPolling, (Object)"1"));
                analysisInfo.setIsPolling("1");
            }
            this.dynamicAnalysis(analysisInfo, user, date);
        } else {
            this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(AnalysisInfoEntity::getAnalysisId, (Object)analysisInfo.getAnalysisId())).set(AnalysisInfoEntity::getIsPolling, (Object)"1"));
            analysisInfo.setIsPolling("1");
            this.asyncAnalysisInfoService.analysis(analysisInfo, user, date, analysisInfo.getAnalysisDataSourceList(), analysisInfoDto.getRelationRuleEntityList());
        }
        OperateLogAPIDTO operateLogAPIDTO = OperateLogAPIDTO.fromBusiness(LogType.ANALYSIS_ADD, null, analysisInfo.getAnalysisId(), analysisInfo.getAnalysisCode());
        OperateLogContext context = OperateLogContextBuilder.create(operateLogAPIDTO).build();
        this.operateLogAPIService.save(context);
        OperateLogAPIDTO operateLogAPIDTO2 = OperateLogAPIDTO.fromBusiness(LogType.ANALYSIS_EXECUTE_SAVE, null, analysisInfo.getAnalysisId(), analysisInfo.getAnalysisCode());
        OperateLogContext context2 = OperateLogContextBuilder.create(operateLogAPIDTO2).build();
        this.operateLogAPIService.save(context2);
        return analysisInfo.getAnalysisId();
    }

    @Override
    @HussarTransactional
    public Boolean updateAndAnalysis(AnalysisInfoDto analysisInfoDto) {
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        AnalysisInfoEntity oldAnalysisInfoEntity = (AnalysisInfoEntity)((Object)this.getById(analysisInfoDto.getAnalysisId()));
        List oldRelationWarnObjectEntityList = this.relationWarnObjectService.list((Wrapper)new LambdaQueryWrapper().eq(RelationWarnObjectEntity::getAnalysisId, (Object)analysisInfoDto.getAnalysisId()));
        AnalysisInfoEntity analysisInfo = this.updateAnalysisInfo(oldAnalysisInfoEntity, analysisInfoDto, user, date);
        if (HussarUtils.isNotEmpty((Object)analysisInfo.getHistoryAnalysisId())) {
            this.saveChangeAnalysisRecord(analysisInfo, user, date);
        }
        if ("3".equals(analysisInfo.getSourceType())) {
            List<AnalysisDataSource> analysisDataSourceList = this.getDataSuitableForAnalysis(analysisInfo);
            if (HussarUtils.isEmpty(analysisDataSourceList)) {
                this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(AnalysisInfoEntity::getAnalysisId, (Object)analysisInfo.getAnalysisId())).set(AnalysisInfoEntity::getIsPolling, (Object)"2"));
                analysisInfo.setIsPolling("2");
            } else {
                this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(AnalysisInfoEntity::getAnalysisId, (Object)analysisInfo.getAnalysisId())).set(AnalysisInfoEntity::getIsPolling, (Object)"1"));
                analysisInfo.setIsPolling("1");
            }
            this.dynamicAnalysis(analysisInfo, user, date);
        } else {
            this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(AnalysisInfoEntity::getAnalysisId, (Object)analysisInfo.getAnalysisId())).set(AnalysisInfoEntity::getIsPolling, (Object)"1"));
            analysisInfo.setIsPolling("1");
            if (HussarUtils.isNotEmpty((Object)analysisInfo.getHistoryAnalysisId())) {
                this.deleteAnalysisResult(analysisInfo);
            }
            this.asyncAnalysisInfoService.analysis(analysisInfo, user, date, analysisInfo.getAnalysisDataSourceList(), analysisInfoDto.getRelationRuleEntityList());
        }
        if (HussarUtils.isEmpty((Object)((Object)oldAnalysisInfoEntity))) {
            return true;
        }
        List<RelationWarnObjectEntity> newRelationWarnObjectEntityList = analysisInfoDto.getRelationWarnObjectEntityList();
        AnalysisInfoEntity newAnalysisInfoEntity = (AnalysisInfoEntity)((Object)BeanUtil.copyProperties((Object)analysisInfoDto, AnalysisInfoEntity.class));
        if (HussarUtils.isNotEmpty((Object)((Object)newAnalysisInfoEntity))) {
            this.saveOperateLogBaseInfo(oldAnalysisInfoEntity, newAnalysisInfoEntity);
            this.saveOperateLogGroup(oldAnalysisInfoEntity, newAnalysisInfoEntity, oldRelationWarnObjectEntityList, newRelationWarnObjectEntityList);
            this.saveOperateLogDataSource(oldAnalysisInfoEntity, newAnalysisInfoEntity);
        }
        OperateLogAPIDTO operateLogAPIDTO = OperateLogAPIDTO.fromBusiness(LogType.ANALYSIS_EXECUTE_SAVE, null, analysisInfoDto.getAnalysisId(), analysisInfoDto.getAnalysisCode());
        OperateLogContext context = OperateLogContextBuilder.create(operateLogAPIDTO).build();
        this.operateLogAPIService.save(context);
        return true;
    }

    @Override
    public void endAnalysis(AnalysisInfoDto analysisInfoDto) {
        AnalysisInfoEntity analysisInfo = (AnalysisInfoEntity)((Object)this.getById(analysisInfoDto.getAnalysisId()));
        if (HussarUtils.isNotEmpty((Object)((Object)analysisInfo))) {
            analysisInfo.setIsPause(String.valueOf(1 - Integer.parseInt(analysisInfo.getIsPause())));
            this.updateById((BaseEntity)analysisInfo);
            if (HussarUtils.isNotEmpty((Object)analysisInfo.getJobId())) {
                this.jobApiService.disableJob(analysisInfo.getJobId());
            }
        }
        OperateLogAPIDTO operateLogAPIDTO = OperateLogAPIDTO.fromBusiness(LogType.ANALYSIS_END, null, analysisInfoDto.getAnalysisId(), analysisInfoDto.getAnalysisCode());
        OperateLogContext context = OperateLogContextBuilder.create(operateLogAPIDTO).build();
        this.operateLogAPIService.save(context);
    }

    @Override
    public String recoverAnalysis(AnalysisInfoDto analysisInfoDto) {
        AnalysisInfoEntity analysisInfo = (AnalysisInfoEntity)((Object)this.getById(analysisInfoDto.getAnalysisId()));
        if (HussarUtils.isNotEmpty((Object)((Object)analysisInfo)) && analysisInfo.getIsPause().equals("1")) {
            analysisInfo.setIsPause("0");
            this.updateById((BaseEntity)analysisInfo);
            if (HussarUtils.isNotEmpty((Object)analysisInfo.getJobId())) {
                this.jobApiService.enableJob(analysisInfo.getJobId());
            }
        }
        return analysisInfo.getIsPolling();
    }

    @Override
    public Boolean updateStyleJson(AnalysisInfoDto dto) {
        String styleJson = dto.getStyleJson();
        return this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(AnalysisInfoEntity::getStyleJson, (Object)styleJson)).eq(AnalysisInfoEntity::getAnalysisId, (Object)dto.getAnalysisId()));
    }

    @Override
    public List<Boxplot> boxplotAnalysis(AnalysisInfoDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        AnalysisInfoEntity analysisInfo = (AnalysisInfoEntity)((Object)this.getById(dto.getAnalysisId()));
        analysisInfo.setVirtualSubgroupSize(dto.getVirtualSubgroupSize());
        this.updateById((BaseEntity)analysisInfo);
        List analysisDataSourceList = this.analysisDataSourceService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AnalysisDataSource::getAnalysisId, (Object)dto.getAnalysisId())).eq(AnalysisDataSource::getIsExclude, (Object)"0"));
        AnalysisParamDto analysisParamDto = this.initializeParamDto(analysisInfo, user, date, null, analysisDataSourceList);
        BasicStatisticDataDto basicStatisticDataDto = this.spcService.getBasicStatisticData(analysisParamDto);
        List<Boxplot> boxplotList = this.spcService.generateBoxplot(analysisParamDto, basicStatisticDataDto.getTotalNodeBigList(), basicStatisticDataDto.getNodeBigList(), basicStatisticDataDto.getFailNodeList(), basicStatisticDataDto.getDetectNodeList());
        this.boxplotService.remove((Wrapper)new LambdaQueryWrapper().eq(Boxplot::getAnalysisId, (Object)dto.getAnalysisId()));
        this.boxplotService.saveBatch(boxplotList);
        String newChartBaseInfo = JSONObject.toJSONString((Object)((Object)analysisInfo));
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)analysisInfo.getHistoryAnalysisId()));
        Update update = new Update();
        update.set("chartBaseInfo", (Object)newChartBaseInfo);
        this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, HistoryAnalysis.class);
        String newBoxplot = JSONObject.toJSONString(boxplotList);
        Query boxQuery = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)analysisInfo.getHistoryAnalysisId()));
        Update boxUpdate = new Update();
        boxUpdate.set("boxplotData", (Object)newBoxplot);
        this.mongoTemplate.updateFirst(boxQuery, (UpdateDefinition)boxUpdate, HistoryResult.class);
        return boxplotList;
    }

    @Override
    public AnalysisInfoCountVo getAnalysisInfoCount(Long analysisId, String historyAnalysisId) {
        AnalysisInfoEntity analysisInfoEntity = (AnalysisInfoEntity)((Object)this.getById(analysisId));
        if (HussarUtils.isNotEmpty((Object)historyAnalysisId) && !historyAnalysisId.equals(analysisInfoEntity.getHistoryAnalysisId())) {
            long abnormalCount = this.abnormalDataService.count((Wrapper)new LambdaQueryWrapper().eq(AbnormalData::getHistoryAnalysisId, (Object)historyAnalysisId));
            AnalysisInfoCountVo analysisInfoCountVo = new AnalysisInfoCountVo();
            analysisInfoCountVo.setAbnormalDataCount(abnormalCount);
            return analysisInfoCountVo;
        }
        long abnormalCount = this.abnormalDataService.count((Wrapper)new LambdaQueryWrapper().eq(AbnormalData::getAnalysisId, (Object)analysisId));
        long changeAnalysisRecordCount = this.changeAnalysisRecordService.count((Wrapper)new LambdaQueryWrapper().eq(ChangeAnalysisRecordEntity::getAnalysisId, (Object)analysisId));
        AnalysisInfoCountVo analysisInfoCountVo = new AnalysisInfoCountVo();
        analysisInfoCountVo.setAbnormalDataCount(abnormalCount);
        analysisInfoCountVo.setChangeAnalysisRecordCount(changeAnalysisRecordCount);
        Long operateLogCount = this.operateLogService.count((Wrapper)new LambdaQueryWrapper().eq(OperateLog::getBusinessId, (Object)analysisId));
        analysisInfoCountVo.setOperateLogCount(operateLogCount);
        return analysisInfoCountVo;
    }

    @Override
    public List<AnalysisDataSource> getDataSuitableForAnalysis(AnalysisInfoEntity analysisInfo) {
        LocalDateTime date = LocalDateTime.now();
        String filterFieldJson = analysisInfo.getFilterConditions();
        FilterFieldListVo filterFieldListVo = (FilterFieldListVo)JSONObject.parseObject((String)filterFieldJson, FilterFieldListVo.class);
        AtomicReference<Object> temp = new AtomicReference<Object>(null);
        for (FilterFieldInfoVo filterFieldInfoVo2 : filterFieldListVo.getFilterFieldInfoVoList()) {
            filterFieldInfoVo2.setFilterFieldName(this.toUpperUnderline(filterFieldInfoVo2.getFilterFieldName()));
            filterFieldInfoVo2.setTableName("SDPD");
            if (!"KEYWORD".equals(filterFieldInfoVo2.getFilterFieldName())) continue;
            temp.set(BeanUtil.copyProperties((Object)filterFieldInfoVo2, FilterFieldInfoVo.class));
        }
        if (HussarUtils.isNotEmpty(temp.get())) {
            String specialSql = "(" + this.generateKeywordSql(((FilterFieldInfoVo)temp.get()).getFilterFieldCompare(), ((FilterFieldInfoVo)temp.get()).getFieldValue().getValue(), "SCP.CONTROL_PROJECT_NAME") + " OR " + this.generateKeywordSql(((FilterFieldInfoVo)temp.get()).getFilterFieldCompare(), ((FilterFieldInfoVo)temp.get()).getFieldValue().getValue(), "SDPD.CONTROL_PROJECT_ID") + ")";
            ((FilterFieldInfoVo)temp.get()).setFilterFieldName(specialSql);
            ((FilterFieldInfoVo)temp.get()).setFilterFieldType("99");
            filterFieldListVo.getFilterFieldInfoVoList().add(temp.get());
        }
        filterFieldListVo.getFilterFieldInfoVoList().removeIf(filterFieldInfoVo -> "KEYWORD".equals(filterFieldInfoVo.getFilterFieldName()));
        int lastSort = analysisInfo.getLastSort();
        int size = analysisInfo.getLatestPoint() * analysisInfo.getSubgroupSize();
        List<DataPoolDataVo> dataPoolDataVoList = this.dataPoolDataService.listData(filterFieldListVo, lastSort, size, analysisInfo.getControlProjectId());
        ArrayList<AnalysisDataSource> analysisDataSourceList = new ArrayList<AnalysisDataSource>();
        for (DataPoolDataVo dataPoolDataVo : dataPoolDataVoList) {
            AnalysisDataSource dataSource = (AnalysisDataSource)((Object)HussarUtils.copyProperties((Object)dataPoolDataVo, AnalysisDataSource.class));
            assert (dataSource != null);
            dataSource.setPoolId(dataPoolDataVo.getPoolDataId());
            dataSource.setAnalysisId(analysisInfo.getAnalysisId());
            dataSource.setIsExclude("0");
            dataSource.setCreateTime(date);
            analysisDataSourceList.add(dataSource);
        }
        if (analysisDataSourceList.size() < size) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        analysisDataSourceList.forEach(analysisDataSource -> {
            LocalDateTime dateTime = LocalDateTime.parse(analysisDataSource.getDetectTime());
            analysisDataSource.setDetectTime(dateTime.format(formatter));
        });
        return analysisDataSourceList;
    }

    public String toUpperUnderline(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (this.isUpperUnderlineFormat(str)) {
            return str;
        }
        if (str.matches("^field\\d+$")) {
            return str.toUpperCase().replaceAll("(\\d+)", "_$1");
        }
        return str.replaceAll("([A-Z])|(\\d+)", "_$1$2").toUpperCase().replaceAll("^_", "");
    }

    private boolean isUpperUnderlineFormat(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        return str.matches("^[A-Z][A-Z0-9_]*(_[A-Z0-9]+)*$");
    }

    private String generateKeywordSql(String compareType, String value, String fieldName) {
        switch (compareType) {
            case "1": {
                return String.format(" %s = '%s' ", fieldName, value);
            }
            case "2": {
                return String.format(" %s != '%s' ", fieldName, value);
            }
            case "3": {
                return " " + fieldName + " LIKE '%" + value + "%'";
            }
            case "4": {
                return " " + fieldName + " IS NOT NULL";
            }
            case "5": {
                return " " + fieldName + " IS NULL";
            }
            case "6": {
                return String.format(" REGEXP_LIKE(%s, '%s')", fieldName, value);
            }
            case "7": {
                return String.format(" NOT REGEXP_LIKE(%s, '%s')", fieldName, value);
            }
        }
        return "";
    }
}

