/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisInfo.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.spc.adapter.api.dict.service.IDictAPIService;
import com.jxdinfo.spc.adapter.api.dict.vo.DictApiVo;
import com.jxdinfo.spc.core.analysisDataSource.model.AnalysisDataSource;
import com.jxdinfo.spc.core.analysisDataSource.service.IAnalysisDataSourceService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dao.AbnormalDataMapper;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AbnormalDataDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AbnormalSnapshotDocument;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AbnormalData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.ControlData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.repository.AbnormalSnapshotRepository;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.AbnormalDataService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.ControlDataService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.AbnormalDataVo;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.AnalysisResultVO;
import com.jxdinfo.spc.core.common.util.CommonUtils;
import com.jxdinfo.spc.core.common.util.TimeFlagTransferUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class AbnormalDataServiceImpl
extends ServiceImpl<AbnormalDataMapper, AbnormalData>
implements AbnormalDataService {
    @Autowired
    private AbnormalDataMapper abnormalDataMapper;
    @Autowired
    private AbnormalSnapshotRepository abnormalSnapshotRepository;
    @Autowired
    private ControlDataService controlDataService;
    @Resource
    private IAnalysisDataSourceService analysisDataSourceService;
    @Resource
    private IDictAPIService dictAPIService;
    @Resource
    private MongoTemplate mongoTemplate;

    @Override
    public Page<AbnormalDataVo> queryPageByAnalysisId(AbnormalDataDto dto) {
        Page page = dto.getPage();
        this.transfer(dto);
        Page<AbnormalDataVo> abnormalDataVoPage = this.abnormalDataMapper.queryPageByAnalysisId(page, dto);
        List abnormalDataVoList = abnormalDataVoPage.getRecords();
        for (AbnormalDataVo abnormalDataVo : abnormalDataVoList) {
            String analysisDataSource = abnormalDataVo.getAnalysisDataSource();
            if (!HussarUtils.isNotEmpty((Object)analysisDataSource)) continue;
            abnormalDataVo.setAnalysisDataSourcesList(JSONObject.parseArray((String)analysisDataSource, AnalysisDataSource.class));
        }
        this.transferDict(abnormalDataVoList);
        return abnormalDataVoPage;
    }

    @Override
    public boolean handle(AbnormalDataDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(AbnormalData::getAbnormalDataId, dto.getAbnormalDataIdList());
        updateWrapper.set(AbnormalData::getHandleState, (Object)"1");
        updateWrapper.set(AbnormalData::getHandleMeasure, (Object)dto.getHandleMeasure());
        updateWrapper.set(AbnormalData::getAbnormalReason, (Object)dto.getAbnormalReason());
        updateWrapper.set(AbnormalData::getHandlerId, (Object)user.getUserId());
        updateWrapper.set(AbnormalData::getHandlerName, (Object)user.getUserName());
        updateWrapper.set(AbnormalData::getHandleTime, (Object)LocalDateTime.now());
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public Map<String, String> saveSnapshot(AnalysisResultVO analysisResultVO) {
        List<AbnormalData> abnormalDataList = analysisResultVO.getAbnormalData();
        List<ControlData> controlDataList = analysisResultVO.getControlData();
        Map<String, List<AbnormalData>> abnormalDataMap = abnormalDataList.stream().collect(Collectors.groupingBy(AbnormalData::getChartType));
        Map<String, List<ControlData>> controlDataMap = controlDataList.stream().collect(Collectors.groupingBy(ControlData::getChartType));
        HashMap<String, String> abnormalSnapshotMap = new HashMap<String, String>();
        for (Map.Entry<String, List<AbnormalData>> map : abnormalDataMap.entrySet()) {
            List<ControlData> thisControlDataList;
            if (!HussarUtils.isNotEmpty(map.getValue()) || !CollectionUtil.isNotEmpty(thisControlDataList = controlDataMap.get(map.getKey()))) continue;
            AbnormalSnapshotDocument abnormalSnapshotDocument = new AbnormalSnapshotDocument();
            String controlDataJson = JSONObject.toJSONString((Object)thisControlDataList.get(0));
            abnormalSnapshotDocument.setAbnormalData(controlDataJson);
            abnormalSnapshotDocument = (AbnormalSnapshotDocument)this.abnormalSnapshotRepository.save(abnormalSnapshotDocument);
            abnormalSnapshotMap.put(map.getKey(), abnormalSnapshotDocument.getId());
        }
        return abnormalSnapshotMap;
    }

    @Override
    public Page<AbnormalDataVo> queryPage(AbnormalDataDto dto) {
        Page page = dto.getPage();
        this.transfer(dto);
        if (HussarUtils.isNotEmpty((Object)dto.getKeyword())) {
            dto.setKeyword(dto.getKeyword().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        if (HussarUtils.isNotEmpty((Object)dto.getTypePath())) {
            dto.setTypePath(dto.getTypePath().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        dto.setIsWarning("1");
        Page<AbnormalDataVo> abnormalDataVoPage = this.abnormalDataMapper.queryPage(page, dto);
        List abnormalDataVoList = abnormalDataVoPage.getRecords();
        for (AbnormalDataVo abnormalDataVo : abnormalDataVoList) {
            String analysisDataSource = abnormalDataVo.getAnalysisDataSource();
            if (!HussarUtils.isNotEmpty((Object)analysisDataSource)) continue;
            abnormalDataVo.setAnalysisDataSourcesList(JSONObject.parseArray((String)analysisDataSource, AnalysisDataSource.class));
        }
        this.transferDict(abnormalDataVoList);
        return abnormalDataVoPage;
    }

    @Override
    public ControlData getSnapshot(Long abnormalDataId) {
        AbnormalData abnormalData = (AbnormalData)((Object)this.getById(abnormalDataId));
        if (abnormalData != null) {
            try {
                AbnormalSnapshotDocument document = (AbnormalSnapshotDocument)this.abnormalSnapshotRepository.findById(abnormalData.getAbnormalSnapshotId()).get();
                return (ControlData)JSONObject.parseObject((String)document.getAbnormalData(), ControlData.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public boolean saveSnapshot() {
        ControlData controlData = (ControlData)this.controlDataService.getById(Long.valueOf(1L));
        AbnormalSnapshotDocument document = new AbnormalSnapshotDocument();
        if (controlData != null) {
            document.setAbnormalData(JSONObject.toJSONString((Object)controlData));
            document = (AbnormalSnapshotDocument)this.abnormalSnapshotRepository.save(document);
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(AbnormalData::getAbnormalDataId, (Object)986879879534334000L);
        updateWrapper.set(AbnormalData::getAbnormalSnapshotId, (Object)document.getId());
        return this.update((Wrapper)updateWrapper);
    }

    private void transfer(AbnormalDataDto dto) {
        dto.setCreateTime(TimeFlagTransferUtil.transfer(dto.getCreateTime()));
    }

    @Override
    public AbnormalDataVo getAbnormalDataDetailById(Long abnormalDataId) {
        AbnormalData abnormalData = (AbnormalData)((Object)this.getById(abnormalDataId));
        if (HussarUtils.isNotEmpty((Object)((Object)abnormalData))) {
            AbnormalDataVo abnormalDataVo = (AbnormalDataVo)((Object)BeanUtil.copyProperties((Object)((Object)abnormalData), AbnormalDataVo.class));
            List analysisDataSourcesList = this.analysisDataSourceService.list((Wrapper)new LambdaQueryWrapper().eq(AnalysisDataSource::getAnalysisId, (Object)abnormalData.getAnalysisId()));
            if (HussarUtils.isNotEmpty((Object)analysisDataSourcesList)) {
                assert (abnormalDataVo != null);
                abnormalDataVo.setAnalysisDataSourcesList(analysisDataSourcesList);
            }
            return abnormalDataVo;
        }
        return null;
    }

    @Override
    public AbnormalDataVo getSampleDataList(Long abnormalDataId) {
        AbnormalDataVo abnormalDataVo = new AbnormalDataVo();
        AbnormalData abnormalData = (AbnormalData)((Object)this.getById(abnormalDataId));
        if (HussarUtils.isNotEmpty((Object)((Object)abnormalData)) && HussarUtils.isNotEmpty((Object)abnormalData.getAnalysisDataSource())) {
            List<String> sampleDataStrList = CommonUtils.convertJsonToList(abnormalData.getAnalysisDataSource());
            if (HussarUtils.isNotEmpty(sampleDataStrList)) {
                ArrayList<AnalysisDataSource> sampleDataList = new ArrayList<AnalysisDataSource>();
                sampleDataStrList.forEach(sampleDataStr -> {
                    AnalysisDataSource sampleData = new AnalysisDataSource();
                    sampleData = CommonUtils.copyJsonVarToObject(sampleDataStr, sampleData);
                    sampleDataList.add(sampleData);
                });
                abnormalDataVo.setSampleDataSourcesList(sampleDataList);
            }
            return abnormalDataVo;
        }
        return null;
    }

    private void transferDict(List<AbnormalDataVo> abnormalDataVoList) {
        List chartTypeList = this.dictAPIService.getDictList("chart_type");
        Map<String, Object> chartTypeMap = chartTypeList.stream().collect(Collectors.toMap(DictApiVo::getValue, DictApiVo::getLabel));
        List isWarnList = this.dictAPIService.getDictList("yes_no");
        Map<String, Object> isWarnMap = isWarnList.stream().collect(Collectors.toMap(DictApiVo::getValue, DictApiVo::getLabel));
        abnormalDataVoList.forEach(abnormalDataVo -> {
            if (HussarUtils.isNotEmpty((Object)abnormalDataVo.getChartType()) && chartTypeMap.containsKey(abnormalDataVo.getChartType())) {
                abnormalDataVo.setChartTypeLabel(chartTypeMap.get(abnormalDataVo.getChartType()).toString());
                abnormalDataVo.setIsWarning(isWarnMap.get(HussarUtils.isNotEmpty((Object)abnormalDataVo.getIsWarning()) ? abnormalDataVo.getIsWarning() : "0").toString());
            }
        });
    }
}

