/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisDataSource.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.spc.adapter.api.dict.service.IDictAPIService;
import com.jxdinfo.spc.adapter.api.dict.vo.DictApiVo;
import com.jxdinfo.spc.core.analysisDataSource.dao.AnalysisDataSourceMapper;
import com.jxdinfo.spc.core.analysisDataSource.dto.DataSourceDto;
import com.jxdinfo.spc.core.analysisDataSource.model.AnalysisDataSource;
import com.jxdinfo.spc.core.analysisDataSource.model.HistoryDataSource;
import com.jxdinfo.spc.core.analysisDataSource.service.IAnalysisDataSourceService;
import com.jxdinfo.spc.core.analysisDataSource.vo.AnalysisDataSourcePageVo;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AnalysisInfoEntity;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.AsyncAnalysisInfoService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.IAnalysisInfoService;
import com.jxdinfo.spc.core.common.util.CommonUtils;
import com.jxdinfo.spc.core.common.util.TimeFlagTransferUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class AnalysisDataSourceServiceImpl
extends HussarServiceImpl<AnalysisDataSourceMapper, AnalysisDataSource>
implements IAnalysisDataSourceService {
    private static final String RETURN_CODE = "0";
    @Resource
    private AnalysisDataSourceMapper analysisDataSourceMapper;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private IAnalysisInfoService analysisInfoService;
    @Resource
    private AsyncAnalysisInfoService asyncAnalysisInfoService;
    @Resource
    private IDictAPIService dictApiService;

    @Override
    public List<AnalysisDataSource> queryList(DataSourceDto dto) {
        List<String> dataSourceStrList;
        HistoryDataSource historyDataSource;
        this.queryCondition(dto);
        if (HussarUtils.isNotEmpty((Object)dto.getHistoryAnalysisId()) && HussarUtils.isNotEmpty((Object)(historyDataSource = (HistoryDataSource)this.mongoTemplate.findById((Object)dto.getHistoryAnalysisId(), HistoryDataSource.class))) && HussarUtils.isNotEmpty(dataSourceStrList = CommonUtils.convertJsonToList(historyDataSource.getDataSource()))) {
            List<AnalysisDataSource> dataSourceList = new ArrayList<AnalysisDataSource>();
            for (String jsonStr : dataSourceStrList) {
                AnalysisDataSource dataSource = CommonUtils.copyJsonVarToObject(jsonStr, new AnalysisDataSource());
                dataSourceList.add(dataSource);
            }
            if (HussarUtils.isNotEmpty(dataSourceList)) {
                if (HussarUtils.isNotEmpty((Object)dto.getIsExclude())) {
                    dataSourceList = dataSourceList.stream().filter(a -> dto.getIsExclude().equals(a.getIsExclude())).collect(Collectors.toList());
                }
                if (HussarUtils.isNotEmpty(dto.getDetectorList())) {
                    dataSourceList = dataSourceList.stream().filter(a -> dto.getDetectorList().contains(a.getDetector())).collect(Collectors.toList());
                }
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                if (HussarUtils.isNotEmpty((Object)dto.getDetectTime()) && HussarUtils.isNotEmpty((Object)dto.getDetectTime().getStart())) {
                    dataSourceList = dataSourceList.stream().filter(a -> LocalDate.parse(a.getDetectTime(), formatter).isAfter(dto.getDetectTime().getStart()) || LocalDate.parse(a.getDetectTime(), formatter).isEqual(dto.getDetectTime().getStart())).collect(Collectors.toList());
                }
                if (HussarUtils.isNotEmpty((Object)dto.getDetectTime()) && HussarUtils.isNotEmpty((Object)dto.getDetectTime().getEnd())) {
                    dataSourceList = dataSourceList.stream().filter(a -> LocalDate.parse(a.getDetectTime(), formatter).isBefore(dto.getDetectTime().getEnd()) || LocalDate.parse(a.getDetectTime(), formatter).isEqual(dto.getDetectTime().getEnd())).collect(Collectors.toList());
                }
            }
            return dataSourceList;
        }
        List<AnalysisDataSource> queryList = this.analysisDataSourceMapper.queryList(dto);
        this.transferDict(queryList);
        return queryList;
    }

    private void transferDict(List<AnalysisDataSource> analysisDataSourceList) {
        List isExcludeList = this.dictApiService.getDictList("yes_no");
        Map<String, Object> isExcludeListMap = isExcludeList.stream().collect(Collectors.toMap(DictApiVo::getValue, DictApiVo::getLabel));
        if (HussarUtils.isNotEmpty(analysisDataSourceList)) {
            analysisDataSourceList.forEach(analysisDataSource -> {
                if (HussarUtils.isNotEmpty((Object)analysisDataSource.getIsExclude()) && isExcludeListMap.containsKey(analysisDataSource.getIsExclude())) {
                    analysisDataSource.setIsExclude(isExcludeListMap.get(analysisDataSource.getIsExclude()).toString());
                }
            });
        }
    }

    @Override
    public AnalysisDataSourcePageVo queryPage(DataSourceDto dto) {
        List<String> dataSourceStrList;
        HistoryDataSource historyDataSource;
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        this.queryCondition(dto);
        if (HussarUtils.isNotEmpty((Object)dto.getHistoryAnalysisId()) && HussarUtils.isNotEmpty((Object)(historyDataSource = (HistoryDataSource)this.mongoTemplate.findById((Object)dto.getHistoryAnalysisId(), HistoryDataSource.class))) && HussarUtils.isNotEmpty(dataSourceStrList = CommonUtils.convertJsonToList(historyDataSource.getDataSource()))) {
            List<AnalysisDataSource> dataSourceList = new ArrayList<AnalysisDataSource>();
            for (String jsonStr : dataSourceStrList) {
                AnalysisDataSource dataSource = CommonUtils.copyJsonVarToObject(jsonStr, new AnalysisDataSource());
                dataSourceList.add(dataSource);
            }
            if (HussarUtils.isNotEmpty(dataSourceList)) {
                if (HussarUtils.isNotEmpty((Object)dto.getIsExclude())) {
                    dataSourceList = dataSourceList.stream().filter(a -> dto.getIsExclude().equals(a.getIsExclude())).collect(Collectors.toList());
                }
                if (HussarUtils.isNotEmpty(dto.getDetectorList())) {
                    dataSourceList = dataSourceList.stream().filter(a -> dto.getDetectorList().contains(a.getDetector())).collect(Collectors.toList());
                }
                if (HussarUtils.isNotEmpty((Object)dto.getDetectorName())) {
                    dataSourceList = dataSourceList.stream().filter(a -> HussarUtils.isNotEmpty((Object)a.getDetectorName()) && a.getDetectorName().contains(dto.getDetectorName())).collect(Collectors.toList());
                }
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                if (HussarUtils.isNotEmpty((Object)dto.getDetectTime()) && HussarUtils.isNotEmpty((Object)dto.getDetectTime().getStart())) {
                    dataSourceList = dataSourceList.stream().filter(a -> LocalDate.parse(a.getDetectTime(), formatter).isAfter(dto.getDetectTime().getStart()) || LocalDate.parse(a.getDetectTime(), formatter).isEqual(dto.getDetectTime().getStart())).collect(Collectors.toList());
                }
                if (HussarUtils.isNotEmpty((Object)dto.getDetectTime()) && HussarUtils.isNotEmpty((Object)dto.getDetectTime().getEnd())) {
                    dataSourceList = dataSourceList.stream().filter(a -> LocalDate.parse(a.getDetectTime(), formatter).isBefore(dto.getDetectTime().getEnd()) || LocalDate.parse(a.getDetectTime(), formatter).isEqual(dto.getDetectTime().getEnd())).collect(Collectors.toList());
                }
            }
            long count = dataSourceList.size();
            dataSourceList = dataSourceList.stream().skip((long)(dto.getCurrent() - 1) * (long)dto.getSize()).limit(dto.getSize()).collect(Collectors.toList());
            AnalysisDataSourcePageVo pageVo = new AnalysisDataSourcePageVo();
            pageVo.setData(dataSourceList);
            pageVo.setCount(count);
            pageVo.setCode(RETURN_CODE);
            return pageVo;
        }
        Page<AnalysisDataSource> queryPage = this.analysisDataSourceMapper.queryPage((Page<AnalysisDataSource>)page, dto);
        AnalysisDataSourcePageVo pageVo = new AnalysisDataSourcePageVo();
        pageVo.setData(queryPage.getRecords());
        pageVo.setCount(queryPage.getTotal());
        pageVo.setCode(RETURN_CODE);
        return pageVo;
    }

    @Override
    public void removeOldest(AnalysisInfoEntity analysisInfoEntity) {
        this.analysisDataSourceMapper.removeOldest(analysisInfoEntity);
    }

    private void queryCondition(DataSourceDto dto) {
        dto.setDetectTime(TimeFlagTransferUtil.transfer(dto.getDetectTime()));
    }

    @Override
    public Boolean excludeAnalysis(DataSourceDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime now = LocalDateTime.now();
        List<AnalysisDataSource> analysisDataSourceList = this.list((Wrapper)new LambdaQueryWrapper().in(AnalysisDataSource::getSourceId, dto.getSourceIdList()));
        analysisDataSourceList.forEach(analysisDataSource -> analysisDataSource.setIsExclude(dto.getIsExclude()));
        this.updateBatchById(analysisDataSourceList);
        analysisDataSourceList = analysisDataSourceList.stream().filter(a -> RETURN_CODE.equals(a.getIsExclude()) && dto.getAnalysisId().equals(a.getAnalysisId())).collect(Collectors.toList());
        AnalysisInfoEntity analysisInfoEntity = (AnalysisInfoEntity)((Object)this.analysisInfoService.getById(dto.getAnalysisId()));
        this.asyncAnalysisInfoService.analysis(analysisInfoEntity, user, now, analysisDataSourceList, null);
        return true;
    }
}

