/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.push.sdk;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.setting.Setting;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.mp.im.model.ArticleBean;
import com.jxdinfo.mp.im.model.ArticleMsgBean;
import com.jxdinfo.mp.im.model.AutoReplyMsgBean;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.EventMsgBean;
import com.jxdinfo.mp.im.model.FileMsgBean;
import com.jxdinfo.mp.im.model.ImgMsgBean;
import com.jxdinfo.mp.im.model.LocationMsgBean;
import com.jxdinfo.mp.im.model.MentionMsgBean;
import com.jxdinfo.mp.im.model.NoticeMsgBean;
import com.jxdinfo.mp.im.model.ProblemBean;
import com.jxdinfo.mp.im.model.TextMsgBean;
import com.jxdinfo.mp.im.model.VCardMsgBean;
import com.jxdinfo.mp.im.model.VoiceMsgBean;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;

public class PushService {
    private static volatile PushService instance;
    private static final ConcurrentHashMap<String, HashMap<String, String>> TOKEN_CACHE;
    private static final Setting SETTING;

    private PushService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PushService getInstance() {
        if (instance != null) return instance;
        Class<PushService> clazz = PushService.class;
        synchronized (PushService.class) {
            if (instance != null) return instance;
            instance = new PushService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public <T extends BaseMsgBean> Boolean postMessage(T msgBean, List<String> userIds) {
        return this.postMessage(msgBean, userIds, SETTING.get("pubId"), SETTING.get("password"), SETTING.get("companyId"), SETTING.get("companyName"), SETTING.get("server"));
    }

    public <T extends BaseMsgBean> Boolean postMessage(T msgBean, List<String> userIds, String pubId, String password, String companyId, String companyName, String server) {
        String access_token;
        if (StrUtil.isEmpty(server)) {
            server = SETTING.get("server");
        }
        if (StrUtil.isEmpty(access_token = PushService.getJqxToken(pubId, password, server))) {
            return false;
        }
        if (msgBean == null) {
            return false;
        }
        msgBean.setCompID(companyId);
        msgBean.setCompName(companyName);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("baseMsgBean", msgBean);
        params.put("msgType", msgBean.getMsgType());
        params.put("mode", msgBean.getMode());
        params.put("receiverIds", CollUtil.join(userIds.iterator(), (CharSequence)","));
        HashMap<String, String> headerMap = MapUtil.newHashMap();
        headerMap.put("Authorization", access_token);
        return HttpUtil.createPost(server + "/v1/message").body(JSONObject.toJSONString(params)).execute().body().contains("true");
    }

    public <T extends EventMsgBean> Boolean postEventMessage(T msgBean, List<String> userIds) {
        msgBean.setCompanyID(SETTING.get("companyId"));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("msg", msgBean);
        params.put("userid", CollUtil.join(userIds.iterator(), (CharSequence)","));
        HashMap<String, String> headerMap = MapUtil.newHashMap();
        headerMap.put("Authorization", "");
        return HttpUtil.createPost(SETTING.get("server") + "/push/v1/message/event").body(JSONObject.toJSONString(params)).execute().body().contains("true");
    }

    private static HashMap<String, Object> buildTokenRequestParams(String id, String key) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("client_id", "mobile");
        params.put("client_secret", "mobile");
        params.put("grant_type", "password");
        params.put("scope", "read write");
        params.put("username", id);
        params.put("password", key);
        return params;
    }

    private static String getJqxToken(String id, String key, String server) {
        String curToken = "";
        HashMap<String, Object> params = PushService.buildTokenRequestParams(id, SecureUtil.md5(key).toUpperCase());
        String cacheKey = id + key;
        HashMap<String, String> cacheToken = TOKEN_CACHE.get(cacheKey);
        String oldToken = "";
        if (cacheToken != null) {
            return cacheToken.get("access_token") + "";
        }
        cacheToken = PushService.requestToken(params, server);
        if (!oldToken.equals(cacheToken.get("access_token"))) {
            TOKEN_CACHE.put(cacheKey, cacheToken);
        }
        return cacheToken.get("access_token");
    }

    private static HashMap<String, String> requestToken(HashMap<String, Object> params, String server) {
        return (HashMap)JSON.parseObject((String)HttpUtil.post(server + "/oauth/token", params), HashMap.class);
    }

    private String postFile(File file) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("file", file);
        return String.valueOf(((JSONObject)((HashMap)JSON.parseObject((String)HttpUtil.post(SETTING.get("efsServer") + "attachment/uploadFileWithDragThumbnail", params), HashMap.class)).get("data")).get((Object)"id"));
    }

    private BaseMsgBean buildBaseMsgBean() {
        BaseMsgBean baseMsgBean = new BaseMsgBean();
        baseMsgBean.setMsgID(UUID.randomUUID().toString().toUpperCase());
        baseMsgBean.setMsgTime(DateUtil.now());
        baseMsgBean.setSenderCode("admin");
        baseMsgBean.setSenderName("\u7cfb\u7edf");
        baseMsgBean.setResource("system");
        baseMsgBean.setStatus(BaseMsgBean.Status.RECEIVEING);
        return baseMsgBean;
    }

    private <T extends BaseMsgBean> BaseMsgBean buildBaseMsgBean(BaseMsgBean.Mode mode, BaseMsgBean.MsgType msgType, String receiverCode, String receiverName, T baseMsgBean) {
        baseMsgBean.setMsgID(UUID.randomUUID().toString().toUpperCase());
        baseMsgBean.setMsgTime(DateUtil.now());
        baseMsgBean.setSenderCode("admin");
        baseMsgBean.setSenderName("\u7cfb\u7edf");
        baseMsgBean.setResource("system");
        baseMsgBean.setStatus(BaseMsgBean.Status.RECEIVEING);
        baseMsgBean.setMode(mode);
        baseMsgBean.setMsgType(msgType);
        baseMsgBean.setReceiverCode(receiverCode);
        baseMsgBean.setReceiverName(receiverName);
        return baseMsgBean;
    }

    public TextMsgBean buildTextMsgBean(String body) {
        return this.buildTextMsgBean(body, BaseMsgBean.Mode.PUBPLAT);
    }

    public TextMsgBean buildTextMsgBean(String body, BaseMsgBean.Mode mode) {
        return this.buildTextMsgBean(body, mode, SETTING.get("pubId"), SETTING.get("pubName"));
    }

    public TextMsgBean buildTextMsgBean(String body, BaseMsgBean.Mode mode, String receiverCode, String receiverName) {
        TextMsgBean textMsgBean = (TextMsgBean)this.buildBaseMsgBean(mode, BaseMsgBean.MsgType.TEXT, receiverCode, receiverName, new TextMsgBean());
        textMsgBean.setBody(body);
        return textMsgBean;
    }

    public ImgMsgBean buildImgMsgBean(File file) {
        return this.buildImgMsgBean(file, BaseMsgBean.Mode.PUBPLAT);
    }

    public ImgMsgBean buildImgMsgBean(File file, BaseMsgBean.Mode mode) {
        return this.buildImgMsgBean(file, mode, SETTING.get("pubId"), SETTING.get("pubName"));
    }

    public ImgMsgBean buildImgMsgBean(File file, BaseMsgBean.Mode mode, String receiverCode, String receiverName) {
        ImgMsgBean imgMsgBean = (ImgMsgBean)this.buildBaseMsgBean(mode, BaseMsgBean.MsgType.IMAGE, receiverCode, receiverName, new ImgMsgBean());
        String fileId = this.postFile(file);
        imgMsgBean.setFileID(fileId);
        imgMsgBean.setFileName(file.getName());
        imgMsgBean.setFileSize(String.valueOf(FileUtil.size(file) / 1024L));
        try {
            BufferedImage sourceImg = ImageIO.read(new FileInputStream(file));
            if (sourceImg != null) {
                imgMsgBean.setWidth(sourceImg.getWidth());
                imgMsgBean.setHeight(sourceImg.getHeight());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return imgMsgBean;
    }

    public FileMsgBean buildFileMsgBean(File file) {
        return this.buildFileMsgBean(file, BaseMsgBean.Mode.PUBPLAT);
    }

    public FileMsgBean buildFileMsgBean(File file, BaseMsgBean.Mode mode) {
        return this.buildFileMsgBean(file, mode, SETTING.get("pubId"), SETTING.get("pubName"));
    }

    public FileMsgBean buildFileMsgBean(File file, BaseMsgBean.Mode mode, String receiverCode, String receiverName) {
        FileMsgBean fileMsgBean = (FileMsgBean)this.buildBaseMsgBean(mode, BaseMsgBean.MsgType.FILETYPE, receiverCode, receiverName, new FileMsgBean());
        String fileId = this.postFile(file);
        if (StrUtil.isEmpty(fileId)) {
            return null;
        }
        fileMsgBean.setFileID(fileId);
        fileMsgBean.setBody(file.getName());
        fileMsgBean.setFileName(file.getName());
        fileMsgBean.setFileSize((float)FileUtil.size(file) / 1024.0f);
        fileMsgBean.setFileStatus(FileMsgBean.FileStatus.UPLOADING);
        fileMsgBean.setFileType(PushService.getFileType(file.getName()));
        fileMsgBean.setMd5("");
        return fileMsgBean;
    }

    public ArticleMsgBean buildArticleMsgBean(List<ArticleBean> articleBeanList) {
        return this.buildArticleMsgBean(articleBeanList, BaseMsgBean.Mode.PUBPLAT);
    }

    public ArticleMsgBean buildArticleMsgBean(List<ArticleBean> articleBeanList, BaseMsgBean.Mode mode) {
        return this.buildArticleMsgBean(articleBeanList, mode, SETTING.get("pubId"), SETTING.get("pubName"));
    }

    public ArticleMsgBean buildArticleMsgBean(List<ArticleBean> articleBeanList, BaseMsgBean.Mode mode, String receiverCode, String receiverName) {
        ArticleMsgBean articleMsgBean = (ArticleMsgBean)this.buildBaseMsgBean(mode, BaseMsgBean.MsgType.ARTICLES, receiverCode, receiverName, new ArticleMsgBean());
        articleBeanList.forEach(articleBean -> articleBean.setArticleMsgId(articleMsgBean.getMsgID()));
        articleMsgBean.setArticles(articleBeanList);
        if (articleMsgBean.getArticles() != null && articleMsgBean.getArticles().size() > 0) {
            ArticleBean artBean = (ArticleBean)articleMsgBean.getArticles().get(0);
            String body = artBean == null ? "" : artBean.getTitle();
            articleMsgBean.setBody(body);
        }
        return articleMsgBean;
    }

    public ArticleBean buildArticle(String title, String subTitle, File imgFile, String url, String webUrl, ArticleBean.LinkType linkType, String bid, String showOrder) {
        String fileId = "";
        if (imgFile != null) {
            fileId = this.postFile(imgFile);
        }
        ArticleBean articleBean = new ArticleBean();
        articleBean.setTitle(title);
        articleBean.setSubTitle(subTitle);
        articleBean.setFileID(fileId);
        articleBean.setUrl(url);
        articleBean.setWebUrl(webUrl);
        articleBean.setLinkType(linkType);
        articleBean.setShowOrder(showOrder);
        articleBean.setBid(bid);
        return articleBean;
    }

    public ArticleBean buildArticle(String title, String subTitle, File imgFile, String url, ArticleBean.LinkType linkType, String bid, String showOrder) {
        return this.buildArticle(title, subTitle, imgFile, url, url, linkType, bid, showOrder);
    }

    public VCardMsgBean buildVCardMsgBean(String userId, String userName, String phoneNum, String email, String position, String organiseName, String companyName, int recommendType, String fromName, String imageData) {
        return this.buildVCardMsgBean(userId, userName, phoneNum, email, position, organiseName, companyName, recommendType, fromName, imageData, BaseMsgBean.Mode.PUBPLAT);
    }

    public VCardMsgBean buildVCardMsgBean(String userId, String userName, String phoneNum, String email, String position, String organiseName, String companyName, int recommendType, String fromName, String imageData, BaseMsgBean.Mode mode) {
        return this.buildVCardMsgBean(userId, userName, phoneNum, email, position, organiseName, companyName, recommendType, fromName, imageData, mode, SETTING.get("pubId"), SETTING.get("pubName"));
    }

    public VCardMsgBean buildVCardMsgBean(String userId, String userName, String phoneNum, String email, String position, String organiseName, String companyName, int recommendType, String fromName, String imageData, BaseMsgBean.Mode mode, String receiverCode, String receiverName) {
        VCardMsgBean vCardMsgBean = (VCardMsgBean)this.buildBaseMsgBean(mode, BaseMsgBean.MsgType.VCARD, receiverCode, receiverName, new VCardMsgBean());
        vCardMsgBean.setUserId(Long.valueOf(userId));
        vCardMsgBean.setUserName(userName);
        vCardMsgBean.setPhoneNum(phoneNum);
        vCardMsgBean.setEmail(email);
        vCardMsgBean.setPositon(position);
        vCardMsgBean.setOrganiseName(organiseName);
        vCardMsgBean.setCompanyName(companyName);
        vCardMsgBean.setRecommendType(recommendType);
        vCardMsgBean.setFromName(fromName);
        vCardMsgBean.setImageData(imageData);
        return vCardMsgBean;
    }

    public LocationMsgBean buildLocationMsgBean(String locationInfo, String locationName, String latitude, String longitude, File file) {
        return this.buildLocationMsgBean(locationInfo, locationName, latitude, longitude, file, BaseMsgBean.Mode.PUBPLAT);
    }

    public LocationMsgBean buildLocationMsgBean(String locationInfo, String locationName, String latitude, String longitude, File file, BaseMsgBean.Mode mode) {
        return this.buildLocationMsgBean(locationInfo, locationName, latitude, longitude, file, mode, SETTING.get("pubId"), SETTING.get("pubName"));
    }

    public LocationMsgBean buildLocationMsgBean(String locationInfo, String locationName, String latitude, String longitude, File file, BaseMsgBean.Mode mode, String receiverCode, String receiverName) {
        LocationMsgBean locationMsgBean = (LocationMsgBean)this.buildBaseMsgBean(mode, BaseMsgBean.MsgType.LOCATION, receiverCode, receiverName, new LocationMsgBean());
        locationMsgBean.setLocationInfo(locationInfo);
        locationMsgBean.setLocationName(locationName);
        locationMsgBean.setLatitude(latitude);
        locationMsgBean.setLongitude(longitude);
        locationMsgBean.setThumbnailId(Long.valueOf(this.postFile(file)));
        locationMsgBean.setThumbnailName(file.getName());
        locationMsgBean.setFileSize(String.valueOf(FileUtil.size(file) / 1024L));
        locationMsgBean.setFileStatus(LocationMsgBean.FileStatus.UPLOADSUCCESS);
        return locationMsgBean;
    }

    public VoiceMsgBean buildVoiceMsgBean(File file) {
        return this.buildVoiceMsgBean(file, BaseMsgBean.Mode.PUBPLAT);
    }

    public VoiceMsgBean buildVoiceMsgBean(File file, BaseMsgBean.Mode mode) {
        return this.buildVoiceMsgBean(file, mode, SETTING.get("pubId"), SETTING.get("pubName"));
    }

    public VoiceMsgBean buildVoiceMsgBean(File file, BaseMsgBean.Mode mode, String receiverCode, String receiverName) {
        VoiceMsgBean voiceMsgBean = (VoiceMsgBean)this.buildBaseMsgBean(mode, BaseMsgBean.MsgType.AUDIO, receiverCode, receiverName, new VoiceMsgBean());
        voiceMsgBean.setLength(Math.toIntExact(PushService.getAmrDuration(file)));
        voiceMsgBean.setFileName(file.getName());
        voiceMsgBean.setFileID(this.postFile(file));
        voiceMsgBean.setFileStatus(VoiceMsgBean.FileStatus.UPLOADSUCCESS);
        return voiceMsgBean;
    }

    public MentionMsgBean buildMentionMsgBean(String mentionId) {
        return this.buildMentionMsgBean(mentionId, BaseMsgBean.Mode.PUBPLAT);
    }

    public MentionMsgBean buildMentionMsgBean(String mentionId, BaseMsgBean.Mode mode) {
        return this.buildMentionMsgBean(mentionId, mode, SETTING.get("pubId"), SETTING.get("pubName"));
    }

    public MentionMsgBean buildMentionMsgBean(String mentionId, BaseMsgBean.Mode mode, String receiverCode, String receiverName) {
        MentionMsgBean mentionMsgBean = (MentionMsgBean)this.buildBaseMsgBean(mode, BaseMsgBean.MsgType.MENTION, receiverCode, receiverName, new MentionMsgBean());
        mentionMsgBean.setMentionId(mentionId);
        return mentionMsgBean;
    }

    public NoticeMsgBean buildNoticeMsgBean(BaseMsgBean.Mode mode, String receiverCode, String receiverName) {
        NoticeMsgBean notice = (NoticeMsgBean)this.buildBaseMsgBean(mode, BaseMsgBean.MsgType.NOTICE, receiverCode, receiverName, new NoticeMsgBean());
        notice.setEventType(NoticeMsgBean.EventType.BLANK);
        return notice;
    }

    public EventMsgBean buildEventMsgBean(BaseMsgBean.Mode mode) {
        EventMsgBean eventMsgBean = new EventMsgBean();
        eventMsgBean.setMode(mode);
        eventMsgBean.setSenderCode("admin");
        eventMsgBean.setSenderResource("system");
        eventMsgBean.setEventType(EventMsgBean.EventType.BLANK);
        return eventMsgBean;
    }

    public ProblemBean buildProblemBean(String objId, String describe, String url) {
        ProblemBean problemBean = new ProblemBean();
        problemBean.setObjid(objId);
        problemBean.setDescribe(describe);
        problemBean.setUrl(url);
        return problemBean;
    }

    public AutoReplyMsgBean buildAutoReplyMsgBean(String content, List<ProblemBean> problemBeans, String msgReceiverName, String msgReceiverCode) {
        return this.buildAutoReplyMsgBean(content, problemBeans, msgReceiverName, msgReceiverCode, BaseMsgBean.Mode.PUBPLAT);
    }

    public AutoReplyMsgBean buildAutoReplyMsgBean(String content, List<ProblemBean> problemBeans, String msgReceiverName, String msgReceiverCode, BaseMsgBean.Mode mode) {
        return this.buildAutoReplyMsgBean(content, problemBeans, msgReceiverName, msgReceiverCode, mode, SETTING.get("pubId"), SETTING.get("pubName"));
    }

    public AutoReplyMsgBean buildAutoReplyMsgBean(String content, List<ProblemBean> problemBeans, String msgReceiverName, String msgReceiverCode, BaseMsgBean.Mode mode, String receiverCode, String receiverName) {
        AutoReplyMsgBean autoReplyMsgBean = (AutoReplyMsgBean)this.buildBaseMsgBean(mode, BaseMsgBean.MsgType.AUTOREPLY, receiverCode, receiverName, new AutoReplyMsgBean());
        autoReplyMsgBean.setContent(content);
        autoReplyMsgBean.setMsgReceiverCode(Long.valueOf(msgReceiverCode));
        autoReplyMsgBean.setMsgReceiverName(msgReceiverCode);
        for (int i = 0; i < problemBeans.size(); ++i) {
            problemBeans.get(i).setShowOrder(String.valueOf(i));
            problemBeans.get(i).setBid(autoReplyMsgBean.getMsgID());
        }
        autoReplyMsgBean.setProblems(problemBeans);
        return autoReplyMsgBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getAmrDuration(File file) {
        long duration = -1L;
        int[] packedSize = new int[]{12, 13, 15, 17, 19, 20, 26, 31, 5, 0, 0, 0, 0, 0, 0, 0};
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            long length = file.length();
            int pos = 6;
            int frameCount = 0;
            int packedPos = -1;
            byte[] datas = new byte[1];
            while ((long)pos <= length) {
                randomAccessFile.seek(pos);
                if (randomAccessFile.read(datas, 0, 1) != 1) {
                    duration = length > 0L ? (length - 6L) / 650L : 0L;
                    break;
                }
                packedPos = datas[0] >> 3 & 0xF;
                pos += packedSize[packedPos] + 1;
                ++frameCount;
            }
            duration += (long)(frameCount * 20);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return duration;
    }

    private static FileMsgBean.FileType getFileType(String fileName) {
        String fileType = FileUtil.extName(fileName);
        if (fileType != null) {
            if (fileType.contains("doc") || fileType.contains("docx")) {
                return FileMsgBean.FileType.WORD;
            }
            if (fileType.contains("zip") || fileType.contains("rar") || fileType.contains("jar") || fileType.contains("cab") || fileType.contains("iso") || fileType.contains("gz")) {
                return FileMsgBean.FileType.ZIP;
            }
            if (fileType.contains("avi") || fileType.contains("rmvb") || fileType.contains("rm") || fileType.contains("asf") || fileType.contains("divx") || fileType.contains("mpg") || fileType.contains("mpeg") || fileType.contains("mpe") || fileType.contains("wmv") || fileType.contains("mp4") || fileType.contains("mkv") || fileType.contains("vob")) {
                return FileMsgBean.FileType.VIDEO;
            }
            if (fileType.contains("txt")) {
                return FileMsgBean.FileType.TEXTFILE;
            }
            if (fileType.contains("ppt") || fileType.contains("pptx")) {
                return FileMsgBean.FileType.PPT;
            }
            if (fileType.contains("pdf")) {
                return FileMsgBean.FileType.PPT;
            }
            if (fileType.contains("bmp") || fileType.contains("pcx") || fileType.contains("png") || fileType.contains("jpeg") || fileType.contains("gif") || fileType.contains("tiff") || fileType.contains("jpg")) {
                return FileMsgBean.FileType.IMAGEFILE;
            }
            if (fileType.contains("xls") || fileType.contains("xlsx")) {
                return FileMsgBean.FileType.EXCEL;
            }
            if (fileType.contains("mp3") || fileType.contains("wav") || fileType.contains("cda") || fileType.contains("midi") || fileType.contains("ogg") || fileType.contains("amr")) {
                return FileMsgBean.FileType.AUDIOFILE;
            }
            return FileMsgBean.FileType.OTHERFILE;
        }
        return FileMsgBean.FileType.OTHERFILE;
    }

    static {
        TOKEN_CACHE = new ConcurrentHashMap(10);
        SETTING = new Setting("mp_push.setting", CharsetUtil.CHARSET_UTF_8, true);
    }
}

