/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.util;

import com.jxdinfo.mp.im.model.FileMsgBean;

public class FileTool {
    public static FileMsgBean.FileType getFileType(String fileName) {
        String fileType = FileTool.extName(fileName).toLowerCase();
        if (fileType != null) {
            if (fileType.contains("doc") || fileType.contains("docx")) {
                return FileMsgBean.FileType.WORD;
            }
            if (fileType.contains("zip") || fileType.contains("rar") || fileType.contains("jar") || fileType.contains("cab") || fileType.contains("iso") || fileType.contains("gz")) {
                return FileMsgBean.FileType.ZIP;
            }
            if (fileType.contains("avi") || fileType.contains("rmvb") || fileType.contains("rm") || fileType.contains("asf") || fileType.contains("divx") || fileType.contains("mpg") || fileType.contains("mpeg") || fileType.contains("mpe") || fileType.contains("wmv") || fileType.contains("mp4") || fileType.contains("mkv") || fileType.contains("vob")) {
                return FileMsgBean.FileType.VIDEO;
            }
            if (fileType.contains("txt")) {
                return FileMsgBean.FileType.TEXTFILE;
            }
            if (fileType.contains("ppt") || fileType.contains("pptx")) {
                return FileMsgBean.FileType.PPT;
            }
            if (fileType.contains("pdf")) {
                return FileMsgBean.FileType.PPT;
            }
            if (fileType.contains("bmp") || fileType.contains("pcx") || fileType.contains("png") || fileType.contains("jpeg") || fileType.contains("gif") || fileType.contains("tiff") || fileType.contains("jpg")) {
                return FileMsgBean.FileType.IMAGEFILE;
            }
            if (fileType.contains("xls") || fileType.contains("xlsx")) {
                return FileMsgBean.FileType.EXCEL;
            }
            if (fileType.contains("mp3") || fileType.contains("wav") || fileType.contains("cda") || fileType.contains("midi") || fileType.contains("ogg") || fileType.contains("amr")) {
                return FileMsgBean.FileType.AUDIOFILE;
            }
            return FileMsgBean.FileType.OTHERFILE;
        }
        return FileMsgBean.FileType.OTHERFILE;
    }

    public static String extName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        String ext = fileName.substring(index + 1);
        return FileTool.containsAny(ext, '/', '\\') ? "" : ext;
    }

    public static boolean containsAny(CharSequence str, char ... testChars) {
        if (!FileTool.isEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (!FileTool.contains(testChars, str.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean contains(char[] array, char value) {
        return FileTool.indexOf(array, value) > -1;
    }

    public static int indexOf(char[] array, char value) {
        if (null != array) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }
}

