/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.zone.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.annotation.Permission;
import com.jxdinfo.mp.common.model.AdminEnum;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.zone.ZoneVO;
import com.jxdinfo.mp.common.utils.StringUtil;
import com.jxdinfo.mp.zone.model.file.ZoneZoneFileDTO;
import com.jxdinfo.mp.zone.model.type.TypeDO;
import com.jxdinfo.mp.zone.model.type.TypeVO;
import com.jxdinfo.mp.zone.model.zone.ZoneDO;
import com.jxdinfo.mp.zone.model.zone.ZoneDTO;
import com.jxdinfo.mp.zone.service.FileService;
import com.jxdinfo.mp.zone.service.TypeService;
import com.jxdinfo.mp.zone.service.ZoneService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u5de5\u4f5c\u5708\u76f8\u5173\u540e\u53f0\u7ba1\u7406"})
@ApiVersion
@RestController
@RequestMapping(value={"/v1/management/zones"})
public class ZoneManageController {
    @Resource
    private Environment environment;
    @Resource
    private ZoneService zoneService;
    @Resource
    private FileService fileService;
    @Resource
    private TypeService typeService;
    @Resource
    private RedisTemplate redisTemplate;

    @ApiOperation(value="\u83b7\u53d6\u5de5\u4f5c\u5708\u5217\u8868")
    @GetMapping
    public Result<PageDTO<ZoneVO>> getManageZoneList(@RequestParam(defaultValue="1") @ApiParam(value="\u9875\u7801") int pageNum, @RequestParam(defaultValue="20") @ApiParam(value="\u9875\u9762\u5927\u5c0f") int pageSize, @RequestParam(required=false) @ApiParam(value="\u5de5\u4f5c\u7fa4\u5185\u5bb9") String searchKey, @RequestParam(required=false) @ApiParam(value="\u90e8\u95e8id") Long deptID, @RequestParam(required=false) @ApiParam(value="\u7c7b\u578bid") Long typeID, @ApiIgnore @LoginUser(isFull=true) CurrentLoginUser currentLoginUser) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        return Result.succeed((Object)this.zoneService.getManageZoneList(pageDTO, searchKey, deptID, typeID, currentLoginUser));
    }

    @ApiOperation(value="\u83b7\u53d6\u5de5\u4f5c\u5708\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    public Result<ZoneVO> getManageZoneInfo(@RequestParam(value="id") @ApiParam(value="\u5de5\u4f5c\u5708id") Long msgID) {
        return this.zoneService.getManageZoneInfo(msgID);
    }

    @ApiOperation(value="\u5220\u9664\u8bc4\u8bba")
    @PostMapping(value={"/deleteComment/{id}"})
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE, AdminEnum.ZONE_MANAGER_ROLE})
    public Result<Boolean> deleteComment(@PathVariable(value="id") @ApiParam Long commentID) {
        return Result.succeed((Object)this.zoneService.deleteZoneComment(commentID));
    }

    @ApiOperation(value="\u7f6e\u9876\u6216\u53d6\u6d88\u7f6e\u9876")
    @GetMapping(value={"/setTopStatus"})
    public Result<Boolean> setTopStatus(@RequestParam(value="id") @ApiParam(value="\u5de5\u4f5c\u5708id") Long msgID, @RequestParam @ApiParam(value="\u5de5\u4f5c\u5708\u662f\u5426\u7f6e\u9876") int top, @ApiIgnore @LoginUser(isFull=true) CurrentLoginUser currentLoginUser) {
        if (this.zoneService.isMine(currentLoginUser, msgID) || this.zoneService.isAdmin(currentLoginUser)) {
            ZoneDO zoneDO = new ZoneDO();
            zoneDO.setMsgID(msgID);
            zoneDO.setTop(Integer.valueOf(top));
            this.zoneService.updateById((Object)zoneDO);
            this.redisTemplate.opsForHash().put((Object)this.zoneService.zoneKey(), (Object)msgID, (Object)this.zoneService.getZoneVO(msgID));
            return Result.succeed((Object)true);
        }
        return Result.failed((String)"\u60a8\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u8be5\u64cd\u4f5c\uff01");
    }

    @ApiOperation(value="\u5220\u9664\u5de5\u4f5c\u5708")
    @PostMapping(value={"/deleteZone"})
    public Result<Boolean> deleteZone(@RequestBody @ApiParam(value="\u5de5\u4f5c\u5708id\u5217\u8868") List<Long> ids, @ApiIgnore @LoginUser(isFull=true) CurrentLoginUser currentLoginUser) {
        if (!this.zoneService.isAdmin(currentLoginUser)) {
            boolean allIsMine;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"SENDER_CODE", (Object)currentLoginUser.getId());
            List myIds = this.zoneService.list((Wrapper)queryWrapper).stream().map(ZoneDO::getMsgID).collect(Collectors.toList());
            myIds.retainAll(ids);
            boolean bl = allIsMine = myIds.size() == ids.size();
            if (!allIsMine) {
                return Result.failed((String)"\u60a8\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u8be5\u64cd\u4f5c\uff01");
            }
        }
        return Result.succeed((Object)this.zoneService.deleteZone(ids));
    }

    @ApiOperation(value="\u65b0\u589e\u5de5\u4f5c\u5708\u6d88\u606f")
    @PostMapping(value={"/saveZone"})
    public Result<Boolean> saveZone(@RequestBody @ApiParam ZoneDTO zoneDTO, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        ZoneDO zoneDO = new ZoneDO();
        BeanUtils.copyProperties((Object)zoneDTO, (Object)zoneDO);
        zoneDO.setMsgID(Long.valueOf(IdWorker.getId((Object)zoneDO)));
        if (zoneDO.getDeptID() == null) {
            zoneDO.setDeptID(BaseSecurityUtil.getUser().getTenantId());
        }
        zoneDO.setSenderCode(currentLoginUser.getId());
        zoneDO.setSenderName(currentLoginUser.getUserName());
        zoneDO.setSenderDeptID(currentLoginUser.getDeptId());
        zoneDO.setSenderDeptName(currentLoginUser.getDeptName());
        zoneDO.setAllowComment(Integer.valueOf(1));
        zoneDO.setAllowPraise(Integer.valueOf(1));
        zoneDO.setMsgTime(LocalDateTime.now());
        if ("1".equals(zoneDTO.getZoneType())) {
            zoneDO.setUrl(this.environment.getProperty("mp.multi-tenant.OUT_NET_URL") + "/article.html?objId=" + zoneDO.getUrl() + "&companyId=" + BaseSecurityUtil.getUser().getTenantId());
        }
        zoneDO.setZoneType("ARTICLE");
        zoneDO.setTop(Integer.valueOf(0));
        this.zoneService.save((Object)zoneDO);
        ZoneVO zoneVO = new ZoneVO();
        BeanUtils.copyProperties((Object)zoneDO, (Object)zoneVO);
        zoneVO.setAllowPraise(Boolean.valueOf(zoneDO.getAllowPraise() == 1));
        zoneVO.setAllowComment(Boolean.valueOf(zoneDO.getAllowComment() == 1));
        zoneVO.setFileList(zoneDTO.getFileList());
        TypeDO typeDO = (TypeDO)this.typeService.getById((Serializable)zoneVO.getTypeID());
        if (ToolUtil.isNotEmpty((Object)typeDO)) {
            zoneVO.setTypeName(typeDO.getTypeName());
        }
        try {
            zoneVO.setMsgTime(zoneDO.getMsgTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss:SSS")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.redisTemplate.opsForHash().put((Object)this.zoneService.zoneKey(), (Object)zoneDO.getMsgID(), (Object)zoneVO);
        return Result.succeed((Object)true);
    }

    @ApiOperation(value="\u83b7\u53d6\u5de5\u4f5c\u5708\u4fee\u6539\u8303\u56f4")
    @GetMapping(value={"/range"})
    public Result<List<Map<String, String>>> getSendRange() {
        return Result.succeed((Object)this.zoneService.getSendRange());
    }

    @ApiOperation(value="\u4fee\u6539\u5de5\u4f5c\u5708")
    @PostMapping(value={"/updateZone"})
    public Result<Boolean> updateZone(@RequestBody ZoneDO zoneDO, @ApiIgnore @LoginUser(isFull=true) CurrentLoginUser currentLoginUser) {
        if (this.zoneService.isAdmin(currentLoginUser) || this.zoneService.isMine(currentLoginUser, zoneDO.getMsgID())) {
            if (zoneDO.getDeptID() == null) {
                zoneDO.setDeptID(BaseSecurityUtil.getUser().getTenantId());
            }
            this.zoneService.updateById((Object)zoneDO);
            this.redisTemplate.opsForHash().put((Object)this.zoneService.zoneKey(), (Object)zoneDO.getMsgID(), (Object)this.zoneService.getZoneVO(zoneDO.getMsgID()));
            return Result.succeed((Object)this.zoneService.updateById((Object)zoneDO));
        }
        return Result.failed((String)"\u60a8\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u8be5\u64cd\u4f5c\uff01");
    }

    @ApiOperation(value="\u83b7\u53d6\u5de5\u4f5c\u5708\u6587\u4ef6\u5217\u8868")
    @GetMapping(value={"/files"})
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE, AdminEnum.ZONE_MANAGER_ROLE})
    public Result<PageDTO<ZoneZoneFileDTO>> searchFileList(@RequestParam(defaultValue="1") @ApiParam Integer pageNum, @RequestParam(defaultValue="20") @ApiParam Integer pageSize, @RequestParam(required=false) @ApiParam String searchKey) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageSize(pageSize);
        pageDTO.setPageNum(pageNum);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.like(!StrUtil.isEmpty((CharSequence)searchKey), (Object)"F.FILE_NAME", (Object)StringUtil.replaceSpecialChar((String)searchKey))).orderByDesc((Object)"F.CREATE_TIME");
        return Result.succeed((Object)this.fileService.getFileList(pageDTO, (Wrapper)queryWrapper));
    }

    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u8be6\u60c5")
    @GetMapping(value={"/files/detail"})
    public Result<ZoneZoneFileDTO> getFile(@RequestParam(required=false) @ApiParam Long fileID) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(fileID != null, (Object)"FILE_ID", (Object)fileID);
        return Result.succeed((Object)this.fileService.getFile((Wrapper)queryWrapper));
    }

    @ApiOperation(value="\u6587\u4ef6\u5220\u9664")
    @PostMapping(value={"/deleteFile"})
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE, AdminEnum.ZONE_MANAGER_ROLE})
    public Result<Boolean> deleteFile(@RequestBody @ApiParam(value="\u6587\u4ef6id") List<Long> ids) {
        return Result.succeed((Object)this.fileService.removeByIds(ids));
    }

    @ApiOperation(value="\u83b7\u53d6\u7c7b\u578b\u5217\u8868")
    @GetMapping(value={"/types"})
    public Result<PageDTO<TypeVO>> getTypeList(@RequestParam(defaultValue="1") @ApiParam(value="\u9875\u7801") int pageNum, @RequestParam(defaultValue="20") @ApiParam(value="\u9875\u9762\u5927\u5c0f") int pageSize, @RequestParam(required=false) @ApiParam(value="\u7c7b\u578b") String searchKey, @RequestParam(required=false) @ApiParam(value="\u90e8\u95e8id") String deptID) {
        return Result.succeed((Object)this.typeService.getTypeList(pageNum, pageSize, searchKey, deptID));
    }

    @ApiOperation(value="\u83b7\u53d6\u7c7b\u578b\u8be6\u60c5")
    @GetMapping(value={"/types/{id}"})
    public Result<TypeDO> getTypeInfo(@PathVariable(value="id") String typeID) {
        return Result.succeed((Object)this.typeService.getById((Serializable)((Object)typeID)));
    }

    @ApiOperation(value="\u65b0\u589e\u7c7b\u578b")
    @PostMapping(value={"/saveType"})
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE, AdminEnum.ZONE_MANAGER_ROLE})
    public Result<Boolean> saveType(@RequestBody TypeDO typeDO, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        if (typeDO.getDeptID() == null) {
            typeDO.setDeptID(BaseSecurityUtil.getUser().getTenantId());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"DEPT_ID", (Object)typeDO.getDeptID())).orderByDesc((Object)"SHOW_ORDER");
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(1));
        pageDTO.setPageSize(Integer.valueOf(1));
        IPage iPage = this.typeService.page((IPage)pageDTO, (Wrapper)queryWrapper);
        if (CollUtil.isNotEmpty((Collection)iPage.getRecords())) {
            typeDO.setShowOrder(Integer.valueOf(((TypeDO)iPage.getRecords().get(0)).getShowOrder() + 1));
        } else {
            typeDO.setShowOrder(Integer.valueOf(1));
        }
        typeDO.setTypeID(Long.valueOf(IdWorker.getId((Object)typeDO)));
        return Result.succeed((Object)this.typeService.save((Object)typeDO));
    }

    @ApiOperation(value="\u5220\u9664\u7c7b\u578b")
    @PostMapping(value={"/deleteTypes"})
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE, AdminEnum.ZONE_MANAGER_ROLE})
    public Result<Boolean> deleteTypes(@RequestBody List<Long> ids) {
        return Result.succeed((Object)this.typeService.removeByIds(ids));
    }

    @ApiOperation(value="\u7c7b\u578b\u6392\u5e8f\u4e0a\u79fb\u4e0b\u79fb")
    @PostMapping(value={"/types/updateTypeShowOrder"})
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE, AdminEnum.ZONE_MANAGER_ROLE})
    public Result<Boolean> updateTypeShowOrder(@RequestParam @ApiParam(value="\u7c7b\u578bID") String typeID, @RequestParam @ApiParam(value="\u90e8\u95e8ID") String deptID, @RequestParam @ApiParam(value="\u4e0a\u62c9\u4e0b\u62c9\u7684\u7c7b\u578bID") String removeTypeID, @RequestParam @ApiParam(value="\u4e0a\u79fb\u4e0b\u79fb\uff1a0\uff0c1") int type) {
        return Result.succeed((Object)this.typeService.updateTypeOrder(typeID, removeTypeID, type, deptID));
    }

    @ApiOperation(value="\u7c7b\u578b\u4fee\u6539")
    @PostMapping(value={"/types/change"})
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE, AdminEnum.ZONE_MANAGER_ROLE})
    public Result<Boolean> editType(@RequestBody TypeDO typeDO) {
        if (typeDO.getDeptID() == null) {
            typeDO.setDeptID(BaseSecurityUtil.getUser().getTenantId());
        }
        return Result.succeed((Object)this.typeService.updateById((Object)typeDO));
    }
}

