/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.zone.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.utils.StringUtil;
import com.jxdinfo.mp.zone.dao.TypeMapper;
import com.jxdinfo.mp.zone.model.type.TypeDO;
import com.jxdinfo.mp.zone.model.type.TypeVO;
import com.jxdinfo.mp.zone.service.TypeService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class TypeServiceImpl
extends ServiceImpl<TypeMapper, TypeDO>
implements TypeService {
    @Resource
    private TypeMapper typeMapper;
    @Resource
    private IHussarBaseOrganizationBoService organizationBoService;
    @Resource
    private IHussarBaseUserBoService userBoService;

    public boolean updateTypeOrder(String typeID, String removeTypeID, int type, String deptID) {
        TypeDO typeDO = (TypeDO)this.typeMapper.selectById((Serializable)((Object)typeID));
        TypeDO removeType = (TypeDO)this.typeMapper.selectById((Serializable)((Object)removeTypeID));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StrUtil.isNotEmpty((CharSequence)deptID), (Object)"DEPT_ID", (Object)deptID);
        if (type == 1) {
            ((QueryWrapper)queryWrapper.gt((Object)"SHOW_ORDER", (Object)removeType.getShowOrder())).le((Object)"SHOW_ORDER", (Object)typeDO.getShowOrder());
            this.typeMapper.dwindleOrder((Wrapper)queryWrapper);
            removeType.setShowOrder(typeDO.getShowOrder());
            this.typeMapper.updateById(removeType);
        } else {
            ((QueryWrapper)queryWrapper.ge((Object)"SHOW_ORDER", (Object)typeDO.getShowOrder())).lt((Object)"SHOW_ORDER", (Object)removeType.getShowOrder());
            this.typeMapper.increaseOrder((Wrapper)queryWrapper);
            removeType.setShowOrder(typeDO.getShowOrder());
            this.typeMapper.updateById(removeType);
        }
        return true;
    }

    public TypeDO getOne(Wrapper<TypeDO> queryWrapper, boolean throwEx) {
        return (TypeDO)super.getOne(queryWrapper, throwEx);
    }

    public PageDTO<TypeVO> getTypeList(int pageNum, int pageSize, String searchKey, String deptID) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        Long tenantId = BaseSecurityUtil.getUser().getTenantId();
        PageDTO<TypeVO> typeList = this.typeMapper.getTypeList(pageDTO, StringUtil.replaceSpecialChar((String)searchKey), deptID, tenantId);
        if (typeList.getList().isEmpty()) {
            return new PageDTO();
        }
        List typeVOList = typeList.getList();
        List creatorIds = typeList.getList().stream().map(HussarBaseEntity::getCreator).collect(Collectors.toList());
        Map userInfo = this.userBoService.getUserInfo(creatorIds);
        typeVOList.forEach(f -> {
            SysUsers sysUsers = (SysUsers)userInfo.get(f.getCreator());
            if (ToolUtil.isNotEmpty((Object)sysUsers)) {
                f.setCreateUserName(sysUsers.getUserName());
            }
        });
        typeList.setList(typeVOList);
        typeList.getList().forEach(list -> {
            if ((list.getDeptName() == null || list.getDeptName().isEmpty()) && list.getDeptID().equals(BaseSecurityUtil.getUser().getTenantId())) {
                list.setDeptName(BaseSecurityUtil.getUser().getTenantName());
            }
        });
        return typeList;
    }

    public boolean save(TypeDO entity) {
        return super.save((Object)entity);
    }

    public boolean removeByIds(Collection<?> idList) {
        return super.removeByIds(idList);
    }

    public long count(Wrapper<TypeDO> queryWrapper) {
        return super.count(queryWrapper);
    }

    public TypeDO getById(Serializable id) {
        return (TypeDO)super.getById(id);
    }

    public boolean updateById(TypeDO entity) {
        return super.updateById((Object)entity);
    }

    public boolean update(TypeDO entity, Wrapper<TypeDO> updateWrapper) {
        return super.update((Object)entity, updateWrapper);
    }

    public List<TypeDO> list(Wrapper<TypeDO> queryWrapper) {
        return super.list(queryWrapper);
    }

    public <E extends IPage<TypeDO>> E page(E page, Wrapper<TypeDO> queryWrapper) {
        return (E)super.page(page, queryWrapper);
    }
}

