/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.zone.ueditor.config;

import cn.hutool.core.lang.UUID;
import cn.hutool.http.ContentType;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.jxdinfo.mp.zone.ueditor.config.FileUtils;
import com.jxdinfo.mp.zone.ueditor.config.Global;
import com.jxdinfo.mp.zone.ueditor.config.model.ReturnUploadImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@Scope(value="prototype")
@RequestMapping(value={"/ueditor"})
public class UeditorController {
    private static final Logger log = LoggerFactory.getLogger(UeditorController.class);
    @Resource
    private Environment environment;

    @ResponseBody
    @RequestMapping(value={"/upload"})
    public void upload(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        ReturnUploadImage rui = null;
        rui = new ReturnUploadImage();
        MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
        MultipartFile multipartFile1 = multipartHttpServletRequest.getFile("upfile");
        String tempDir = "/ueditor/image/info";
        File tempDirFile = new File(tempDir);
        if (!tempDirFile.exists()) {
            tempDirFile.mkdirs();
        }
        String tempFile = UUID.randomUUID().toString() + multipartFile1.getOriginalFilename();
        File targetFile = new File(tempDir, tempFile);
        try {
            multipartFile1.transferTo(targetFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String fileServerURL = this.environment.getProperty("mp.multi-tenant.file_server_url");
        String fileResponse = ((HttpRequest)HttpRequest.post((String)(fileServerURL + "?accountId=F02D3F15-FDA6-48BD-B916-66C10D0024B2&secretKey=73bf4b07d37f1a3037e1c2e1ec48eadb")).header("Content-Type", ContentType.MULTIPART.toString())).form("file", targetFile).execute().body();
        log.error("UEditor\u8f6c\u5b58\u56fe\u7247\uff1a" + fileResponse);
        try {
            JSONObject jsonObject = new JSONObject((Object)fileResponse);
            int code = (Integer)jsonObject.get((Object)"errcode");
            if (code == 200) {
                Long fileID = (Long)jsonObject.get((Object)"data");
                rui.setTitle(targetFile.getName());
                rui.setOriginal(multipartFile1.getOriginalFilename());
                rui.setState("SUCCESS");
                rui.setUrl(fileServerURL + fileID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String result = JSONUtil.toJsonStr((Object)rui);
        PrintWriter writer = response.getWriter();
        writer.write(result);
        writer.close();
    }

    @ResponseBody
    @RequestMapping(value={"/ueditorUploadConnet"})
    public Object getConfigJson(String action) {
        if (action == null) {
            return "\u51fa\u73b0\u9519\u8bef!";
        }
        if (action.equals("config")) {
            return this.getConfig();
        }
        return null;
    }

    private String getConfig() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        String ctx = request.getContextPath();
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("imageActionName", "uploadimage");
        config.put("imageUrl", "/ueditor/upload-img");
        config.put("imageFieldName", "upfile");
        config.put("imageMaxSize", "2048000");
        config.put("imageUrlPrefix", ctx);
        config.put("imageCompressEnable", false);
        config.put("imageCompressBorder", 1600);
        config.put("imageInsertAlign", "none");
        config.put("imageUrlPrefix", "");
        String[] imageFormat = new String[]{".png", ".jpg", ".jpeg", ".gif", ".bmp"};
        config.put("imageAllowFiles", imageFormat);
        config.put("imagePathFormat", "/ueditor/jsp/upload/image/{yyyy}{mm}{dd}/{time}{rand:6}");
        String configJson = JSONUtil.toJsonStr(config);
        System.out.println(configJson);
        return configJson;
    }

    @ResponseBody
    @RequestMapping(value={"/upload-img"})
    public String uploadImg(MultipartFile upfile) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String path = Global.getConfig("thumbnail_url");
        path = path + "/ueditor/image/info";
        String fileName1 = upfile.getOriginalFilename();
        File file1 = new File(fileName1);
        File newFile1 = FileUtils.renameFile(file1);
        String newFileName1 = newFile1.getName();
        StringBuffer newPaths1 = new StringBuffer(path);
        newPaths1.append("\\");
        newPaths1.append(newFileName1);
        String newPath1 = newPaths1.toString();
        File targetFile1 = new File(path, newFileName1);
        try {
            upfile.transferTo(targetFile1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return path;
    }
}

