/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.push.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.eatthepath.pushy.apns.ApnsClient;
import com.eatthepath.pushy.apns.ApnsClientBuilder;
import com.eatthepath.pushy.apns.ApnsPushNotification;
import com.eatthepath.pushy.apns.util.ApnsPayloadBuilder;
import com.eatthepath.pushy.apns.util.SimpleApnsPayloadBuilder;
import com.eatthepath.pushy.apns.util.SimpleApnsPushNotification;
import com.eatthepath.pushy.apns.util.TokenUtil;
import com.eatthepath.pushy.apns.util.concurrent.PushNotificationFuture;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.push.model.MPMessage;
import com.jxdinfo.mp.push.model.MpMessageDTO;
import com.jxdinfo.push.model.Response;
import com.jxdinfo.push.model.message.Action;
import com.jxdinfo.push.model.message.Message;
import com.jxdinfo.push.service.PushService;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u79fb\u52a8\u7aef\u63a8\u9001\u901a\u77e5\u7c7b"})
@RequestMapping(value={"/v1"})
@RestController
public class MobilePushController {
    private static final Logger log = LoggerFactory.getLogger(MobilePushController.class);
    @Resource
    private Environment environment;
    private ApnsClient apnsClient;
    private ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    @PostMapping(value={"/notice/android"})
    public Result<Boolean> pushAndroid(@RequestBody MpMessageDTO mpMessageDTO) {
        PushService pushService = PushService.builder().environment(Integer.valueOf(0)).audienceType(Integer.valueOf(1)).tokenList(JSONObject.parseArray((String)mpMessageDTO.getDeviceToken(), String.class)).messageType(Integer.valueOf(0)).platform(Integer.valueOf(0)).build();
        Response response = pushService.sendMessage(this.getMessage(mpMessageDTO));
        log.error("\u8fd4\u56de\u4fe1\u606f\uff1a" + response.getMsg());
        if (response.getSuccess().booleanValue()) {
            return Result.succeed((Object)true);
        }
        return Result.succeed((Object)false);
    }

    @PostMapping(value={"/notice/ios"})
    public Result<Boolean> pushIos(@RequestBody MpMessageDTO mpMessageDTO) {
        List list = JSONObject.parseArray((String)mpMessageDTO.getDeviceToken(), String.class).stream().filter(i -> StrUtil.isNotEmpty((CharSequence)i)).collect(Collectors.toList());
        if (CollUtil.isEmpty(list)) {
            log.info("*****ios deviceToken\u4e3a\u7a7a*****");
            return Result.failed((String)"ios deviceToken\u4e3a\u7a7a");
        }
        MPMessage mpMessage = mpMessageDTO.getMpMessage();
        this.threadPoolExecutor.execute(() -> this.apnsPush(list, mpMessage));
        return Result.succeed((Object)true);
    }

    private void apnsPush(List<String> tokens, MPMessage mpMessage) {
        if (this.apnsClient == null) {
            this.initApnsClient();
        }
        SimpleApnsPayloadBuilder payloadBuilder = new SimpleApnsPayloadBuilder();
        payloadBuilder.setBadgeNumber(Integer.valueOf(mpMessage.getBadge()));
        payloadBuilder.setAlertTitle(mpMessage.getTitle());
        payloadBuilder.setAlertBody(mpMessage.getContent());
        if (mpMessage.getCustomFields() != null) {
            mpMessage.getCustomFields().entrySet().forEach(arg_0 -> MobilePushController.lambda$apnsPush$2((ApnsPayloadBuilder)payloadBuilder, arg_0));
        }
        if (mpMessage.getRing().booleanValue()) {
            payloadBuilder.setSound("default");
        } else if (mpMessage.getVibrate().booleanValue()) {
            payloadBuilder.setSound("detection.aiff");
        } else {
            payloadBuilder.setSound("");
        }
        String payload = payloadBuilder.build();
        tokens.forEach(i -> {
            PushNotificationFuture sendNotificationFuture = this.apnsClient.sendNotification((ApnsPushNotification)new SimpleApnsPushNotification(TokenUtil.sanitizeTokenString((String)i), "com.jxdinfo.jqx", payload));
            sendNotificationFuture.whenComplete((response, cause) -> {
                if (response != null) {
                    if (!response.isAccepted()) {
                        log.error("Notification rejected by the APNs gateway:" + response.getRejectionReason());
                        log.error("The bad deviceToken is " + i);
                        response.getTokenInvalidationTimestamp().ifPresent(timestamp -> log.error("\t\u2026and the token is invalid as of " + timestamp));
                    }
                } else {
                    log.error(cause.getMessage());
                }
            });
        });
    }

    private void initApnsClient() {
        try {
            this.apnsClient = new ApnsClientBuilder().setApnsServer("api.push.apple.com").setClientCredentials(new ClassPathResource("wKgCrl5fPxyATbTRAAANV7dAIpY686.p12").getInputStream(), this.environment.getProperty("mp.push.iOS.password")).build();
        }
        catch (Exception e) {
            log.info(e.getMessage());
            log.error("ios get pushy apns client failed!");
        }
    }

    private Message getMessage(MpMessageDTO mpMessageDTO) {
        MPMessage mpMessage = mpMessageDTO.getMpMessage();
        Message message = new Message();
        message.setTitle(mpMessage.getTitle());
        message.setContent(mpMessage.getContent());
        message.setRing(Integer.valueOf(mpMessage.getRing() == null ? 0 : (mpMessage.getRing() != false ? 1 : 0)));
        message.setRingRaw(mpMessage.getRing_raw());
        message.setVibrate(Integer.valueOf(mpMessage.getVibrate() == null ? 0 : (mpMessage.getVibrate() != false ? 1 : 0)));
        Action action = new Action();
        if (mpMessage.getAction() != null) {
            action.setType(Integer.valueOf(mpMessage.getAction().getM_actionType()));
            action.setIntent(mpMessage.getAction().getM_intent());
        }
        message.setAction(action);
        return message;
    }

    private static /* synthetic */ void lambda$apnsPush$2(ApnsPayloadBuilder payloadBuilder, Map.Entry i) {
        payloadBuilder.addCustomProperty((String)i.getKey(), i.getValue());
    }
}

