/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.push.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.config.OrganizationProperties;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.utils.Uuid2LongUtil;
import com.jxdinfo.mp.im.model.ArticleMsgBean;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.FileMsgBean;
import com.jxdinfo.mp.im.model.ImgMsgBean;
import com.jxdinfo.mp.im.model.LocationMsgBean;
import com.jxdinfo.mp.im.model.MeetingMsgBean;
import com.jxdinfo.mp.im.model.TextMsgBean;
import com.jxdinfo.mp.im.model.VCardMsgBean;
import com.jxdinfo.mp.im.model.VoiceMsgBean;
import com.jxdinfo.mp.im.model.WithDrawMsgBean;
import com.jxdinfo.mp.im.model.push.PushMessageDTO;
import com.jxdinfo.mp.im.model.push.PushMessageJsonBeanDTO;
import com.jxdinfo.mp.push.model.PushEventMessageDTO;
import com.jxdinfo.mp.push.service.MessageProducerService;
import io.swagger.annotations.Api;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api
@ApiVersion
@RequestMapping(value={"v1"})
@RestController
public class SendMessageController {
    @Resource
    private MessageProducerService messageProducerService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private OrganizationProperties organizationProperties;
    protected static final Logger logger = LoggerFactory.getLogger(SendMessageController.class);

    @PostMapping(value={"/message"})
    public Result<Boolean> pushMessage(@RequestBody PushMessageJsonBeanDTO pushMessageJsonBeanDTO) {
        PushMessageDTO pushMessageDTO = (PushMessageDTO)BeanUtil.copyProperties((Object)pushMessageJsonBeanDTO, PushMessageDTO.class);
        BaseMsgBean baseMsgBean = (BaseMsgBean)pushMessageJsonBeanDTO.getBaseMsgBean().toJavaObject(BaseMsgBean.class);
        if (baseMsgBean.getMsgType().equals((Object)BaseMsgBean.MsgType.ARTICLES)) {
            baseMsgBean = (BaseMsgBean)pushMessageJsonBeanDTO.getBaseMsgBean().toJavaObject(ArticleMsgBean.class);
        }
        if (baseMsgBean.getMsgType().equals((Object)BaseMsgBean.MsgType.TEXT)) {
            baseMsgBean = (BaseMsgBean)pushMessageJsonBeanDTO.getBaseMsgBean().toJavaObject(TextMsgBean.class);
        }
        if (baseMsgBean.getMsgType().equals((Object)BaseMsgBean.MsgType.FILETYPE)) {
            baseMsgBean = (BaseMsgBean)pushMessageJsonBeanDTO.getBaseMsgBean().toJavaObject(FileMsgBean.class);
        }
        if (baseMsgBean.getMsgType().equals((Object)BaseMsgBean.MsgType.WITHDRAW)) {
            baseMsgBean = (BaseMsgBean)pushMessageJsonBeanDTO.getBaseMsgBean().toJavaObject(WithDrawMsgBean.class);
        }
        logger.info("\u53d1\u9001\u6d88\u606f----{}----\u8fdb\u884c\u4e2d", (Object)JSONObject.toJSONString((Object)pushMessageJsonBeanDTO));
        pushMessageDTO.setBaseMsgBean(baseMsgBean);
        pushMessageDTO.setMsgType(baseMsgBean.getMsgType());
        pushMessageDTO.setMode(baseMsgBean.getMode());
        return Result.succeed((Object)this.messageProducerService.sendMessage(pushMessageDTO));
    }

    @RequestMapping(value={"/service/sendMess"})
    public JSONObject sendMessage(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        JSONObject resultJson = new JSONObject();
        logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb");
        String token = request.getParameter("access_token");
        String msgType = request.getParameter("type");
        String msg = request.getParameter("msg");
        String userID = request.getParameter("userId");
        if (StrUtil.isEmpty((CharSequence)msg)) {
            resultJson.put("success", (Object)"false");
            resultJson.put("error", (Object)"msg\u4e0d\u80fd\u4e3a\u7a7a\u53c2\u6570");
        }
        logger.info("\u53d1\u9001\u6d88\u606f----" + msg + "----\u8fdb\u884c\u4e2d");
        logger.info("\u53d1\u9001\u6d88\u606f\u4eba----" + userID + "----\u8fdb\u884c\u4e2d");
        BaseMsgBean baseMsgBean = (BaseMsgBean.MsgType.IMAGE.ordinal() + "").equals(msgType) ? (BaseMsgBean)JSON.parseObject((String)msg, ImgMsgBean.class) : ((BaseMsgBean.MsgType.AUDIO.ordinal() + "").equals(msgType) ? (BaseMsgBean)JSON.parseObject((String)msg, VoiceMsgBean.class) : ((BaseMsgBean.MsgType.FILETYPE.ordinal() + "").equals(msgType) ? (BaseMsgBean)JSON.parseObject((String)msg, FileMsgBean.class) : ((BaseMsgBean.MsgType.VCARD.ordinal() + "").equals(msgType) ? (BaseMsgBean)JSON.parseObject((String)msg, VCardMsgBean.class) : ((BaseMsgBean.MsgType.ARTICLES.ordinal() + "").equals(msgType) ? (BaseMsgBean)JSON.parseObject((String)msg, ArticleMsgBean.class) : ((BaseMsgBean.MsgType.LOCATION.ordinal() + "").equals(msgType) ? (BaseMsgBean)JSON.parseObject((String)msg, LocationMsgBean.class) : ((BaseMsgBean.MsgType.MEETING.ordinal() + "").equals(msgType) ? (BaseMsgBean)JSON.parseObject((String)msg, MeetingMsgBean.class) : (BaseMsgBean)JSON.parseObject((String)msg, BaseMsgBean.class)))))));
        String mode = baseMsgBean.getMode().ordinal() + "";
        if (StrUtil.isEmpty((CharSequence)baseMsgBean.getCompID())) {
            baseMsgBean.setCompID("6E7C22BB-D0DF-446D-8EA6-E66ECC910FDA");
            baseMsgBean.setCompName("\u91d1\u73b0\u4ee3\u4fe1\u606f\u4ea7\u4e1a\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        }
        if (mode.equals(BaseMsgBean.Mode.PUBPLAT.ordinal() + "")) {
            baseMsgBean.setSenderCode("admin");
            baseMsgBean.setSenderName("\u7cfb\u7edf");
            baseMsgBean.setResource("system");
        }
        Long receiverCode = null;
        try {
            receiverCode = Long.parseLong(baseMsgBean.getReceiverCode());
        }
        catch (Exception e) {
            receiverCode = Uuid2LongUtil.getUniqueId((String)baseMsgBean.getReceiverCode());
        }
        SysApplicationVo sysApplicationVo = (SysApplicationVo)this.sysApplicationService.getAppDetail(receiverCode).getData();
        baseMsgBean.setReceiverName(sysApplicationVo.getAppName());
        baseMsgBean.setMsgType(BaseMsgBean.MsgType.values()[Integer.parseInt(msgType)]);
        PushMessageDTO pushMessageDTO = new PushMessageDTO();
        pushMessageDTO.setBaseMsgBean(baseMsgBean);
        if (StringUtils.isNotEmpty((CharSequence)userID)) {
            pushMessageDTO.setReceiverIds("@all".equals(URLDecoder.decode(userID, "utf-8")) ? "" : userID);
        }
        pushMessageDTO.setMsgType(baseMsgBean.getMsgType());
        pushMessageDTO.setMode(baseMsgBean.getMode());
        this.messageProducerService.sendMessage(pushMessageDTO);
        resultJson.put("success", (Object)true);
        logger.info("\u53d1\u9001\u6d88\u606f\u7ed3\u675f");
        return resultJson;
    }

    @PostMapping(value={"/message/event"})
    public Result<Boolean> pushEventMessage(@RequestBody PushEventMessageDTO pushMessageDTO) {
        return Result.succeed((Object)this.messageProducerService.sendEventMessage(pushMessageDTO));
    }
}

