/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.push.service.impl;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.mp.common.utils.Uuid2LongUtil;
import com.jxdinfo.mp.im.model.ArticleBean;
import com.jxdinfo.mp.im.model.ArticleMsgBean;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.EventMsgBean;
import com.jxdinfo.mp.im.model.FileMsgBean;
import com.jxdinfo.mp.im.model.ImgMsgBean;
import com.jxdinfo.mp.im.model.NoticeMsgBean;
import com.jxdinfo.mp.im.model.WithDrawMsgBean;
import com.jxdinfo.mp.im.model.push.PushMessageDTO;
import com.jxdinfo.mp.im.model.single.MessageDO;
import com.jxdinfo.mp.im.model.single.MessageOffline;
import com.jxdinfo.mp.im.service.IAppPermissionService;
import com.jxdinfo.mp.push.controller.SendMessageController;
import com.jxdinfo.mp.push.dao.Contact3Mapper;
import com.jxdinfo.mp.push.model.EimAppPushLogDO;
import com.jxdinfo.mp.push.model.PushEventMessageDTO;
import com.jxdinfo.mp.push.service.EimAppPushLogService;
import com.jxdinfo.mp.push.service.MessageProducerService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.jms.core.JmsMessagingTemplate;
import org.springframework.stereotype.Service;

@Service
public class MessageProducerServiceImpl
implements MessageProducerService {
    @Resource
    private JmsMessagingTemplate jmsMessagingTemplate;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private Contact3Mapper contact3Mapper;
    @Resource
    private IAppPermissionService appPermissionService;
    @Resource
    private EimAppPushLogService eimAppPushLogService;
    protected static final Logger logger = LoggerFactory.getLogger(SendMessageController.class);

    public Boolean sendMessage(PushMessageDTO pushMessageDTO) {
        long start = System.currentTimeMillis();
        pushMessageDTO = this.transferUuid2Long(pushMessageDTO);
        logger.info("\u63a8\u9001\u6d88\u606f\u8017\u65f61\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
        Boolean flag = this.setPushUser(pushMessageDTO);
        if (flag.booleanValue()) {
            PushMessageDTO finalPushMessageDTO = pushMessageDTO;
            ThreadUtil.execAsync(() -> this.jmsMessagingTemplate.convertAndSend("eimv5_pushMessage_queue", (Object)JSON.toJSONString((Object)finalPushMessageDTO)));
        }
        long end = System.currentTimeMillis();
        logger.info("\u63a8\u9001\u6d88\u606f\u8017\u65f6\uff1a{}ms", (Object)(end - start));
        return true;
    }

    private Boolean setPushUser(PushMessageDTO pushMessageDTO) {
        BaseMsgBean baseMsgBean = pushMessageDTO.getBaseMsgBean();
        if (baseMsgBean == null) {
            return true;
        }
        if (ToolUtil.isNotEmpty((Object)baseMsgBean.getMode()) && baseMsgBean.getMode().equals((Object)BaseMsgBean.Mode.PUBPLAT)) {
            EimAppPushLogDO eimAppPushLogDO;
            Long pubPlatID = Long.parseLong(baseMsgBean.getReceiverCode());
            List permissionUserIds = this.appPermissionService.getPubPlatPermissionUserIds(pubPlatID);
            List<Object> pubplatReceiverCode = new ArrayList();
            List<String> pubplatReceiverCodeWithAuth = new ArrayList();
            ArrayList<String> pubplatReceiverCodeWithoutAuth = new ArrayList<String>();
            if (ToolUtil.isNotEmpty((Object)baseMsgBean.getReceiverCode()) && ToolUtil.isNotEmpty((Object)pushMessageDTO.getReceiverIds())) {
                if (ToolUtil.isNotEmpty((Object)pushMessageDTO.getReceiverIds())) {
                    pubplatReceiverCode = Arrays.asList(pushMessageDTO.getReceiverIds().split(","));
                    for (String string : pubplatReceiverCode) {
                        List temp = permissionUserIds.stream().filter(a -> a.equals(code)).collect(Collectors.toList());
                        if (ToolUtil.isNotEmpty(temp)) {
                            pubplatReceiverCodeWithAuth.add(string);
                            continue;
                        }
                        pubplatReceiverCodeWithoutAuth.add(string);
                    }
                }
                baseMsgBean.setPubplatReceiverCode(String.join((CharSequence)",", pubplatReceiverCodeWithAuth));
            } else if (StringUtil.isEmpty((Object)pushMessageDTO.getReceiverIds())) {
                pubplatReceiverCodeWithAuth = permissionUserIds;
                baseMsgBean.setPubplatReceiverCode(String.join((CharSequence)",", permissionUserIds));
            }
            ArrayList<EimAppPushLogDO> eimAppPushLogDOS = new ArrayList<EimAppPushLogDO>();
            for (String code : pubplatReceiverCodeWithAuth) {
                try {
                    eimAppPushLogDO = new EimAppPushLogDO();
                    eimAppPushLogDO.setAppId(Long.valueOf(Long.parseLong(baseMsgBean.getReceiverCode())));
                    eimAppPushLogDO.setUserId(Long.valueOf(Long.parseLong(code)));
                    eimAppPushLogDO.setResultType("1");
                    eimAppPushLogDO.setCreateTime(LocalDateTime.now());
                    eimAppPushLogDO.setMsgId(Long.valueOf(Long.parseLong(baseMsgBean.getMsgID())));
                    eimAppPushLogDOS.add(eimAppPushLogDO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (String code : pubplatReceiverCodeWithoutAuth) {
                try {
                    eimAppPushLogDO = new EimAppPushLogDO();
                    eimAppPushLogDO.setAppId(Long.valueOf(Long.parseLong(baseMsgBean.getReceiverCode())));
                    eimAppPushLogDO.setUserId(Long.valueOf(Long.parseLong(code)));
                    eimAppPushLogDO.setResultType("0");
                    eimAppPushLogDO.setCreateTime(LocalDateTime.now());
                    eimAppPushLogDO.setMsgId(Long.valueOf(Long.parseLong(baseMsgBean.getMsgID())));
                    eimAppPushLogDOS.add(eimAppPushLogDO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.eimAppPushLogService.saveBatch(eimAppPushLogDOS);
            return !CollectionUtil.isEmpty(pubplatReceiverCodeWithAuth);
        }
        return true;
    }

    @NotNull
    public Boolean sendEventMessage(PushEventMessageDTO pushEventMessageDTO) {
        if (pushEventMessageDTO.getMsg().getEventType().equals((Object)EventMsgBean.EventType.MEETING_CLOSE)) {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"msgType").is((Object)13).and("key").is((Object)pushEventMessageDTO.getMsg().getObjID()));
            Update update = Update.update((String)"meetingStatus", (Object)0);
            this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, MessageDO.class);
            this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, MessageOffline.class);
        }
        this.jmsMessagingTemplate.convertAndSend("eimv5_pushEventMessage_queue", (Object)JSON.toJSONString((Object)pushEventMessageDTO));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public PushMessageDTO transferUuid2Long(PushMessageDTO pushMessageDTO) {
        WithDrawMsgBean withDrawMsgBean;
        ImgMsgBean imgMsgBean;
        FileMsgBean fileMsgBean;
        BaseMsgBean baseMsgBean;
        List<Object> receivers = new ArrayList();
        ArrayList<Object> longIdReceivers = new ArrayList<Object>();
        if (!StrUtil.isEmptyOrUndefined((CharSequence)pushMessageDTO.getReceiverIds())) {
            receivers = Arrays.asList(pushMessageDTO.getReceiverIds().split(","));
            for (String string : receivers) {
                Long longID;
                try {
                    longID = Long.parseLong(string);
                }
                catch (Exception e) {
                    longID = Uuid2LongUtil.getUniqueId((String)string);
                }
                longIdReceivers.add(String.valueOf(longID));
            }
            pushMessageDTO.setReceiverIds(longIdReceivers.stream().collect(Collectors.joining(",")));
        }
        if (!StrUtil.isEmptyOrUndefined((CharSequence)(baseMsgBean = pushMessageDTO.getBaseMsgBean()).getMsgID())) {
            void var5_8;
            try {
                String string = String.valueOf(Long.parseLong(baseMsgBean.getMsgID()));
            }
            catch (Exception e) {
                String string = String.valueOf(Uuid2LongUtil.getUniqueId((String)baseMsgBean.getMsgID()));
            }
            baseMsgBean.setMsgID((String)var5_8);
        }
        if (!(StrUtil.isEmptyOrUndefined((CharSequence)baseMsgBean.getSenderCode()) || baseMsgBean.getSenderCode().equals("admin") || baseMsgBean.getSenderCode().equals("Admin"))) {
            String senderCode;
            try {
                senderCode = String.valueOf(Long.parseLong(baseMsgBean.getSenderCode()));
            }
            catch (Exception e) {
                senderCode = String.valueOf(Uuid2LongUtil.getUniqueId((String)baseMsgBean.getSenderCode()));
            }
            baseMsgBean.setSenderCode(senderCode);
        }
        List<Object> receiverCode = new ArrayList();
        if (!StrUtil.isEmptyOrUndefined((CharSequence)baseMsgBean.getReceiverCode())) {
            receiverCode = Arrays.asList(baseMsgBean.getReceiverCode().split(","));
            longIdReceivers = new ArrayList();
            for (Object s : receiverCode) {
                void var10_17;
                try {
                    String string = String.valueOf(Long.parseLong((String)s));
                }
                catch (Exception e) {
                    String string = String.valueOf(Uuid2LongUtil.getUniqueId((String)s));
                }
                longIdReceivers.add(var10_17);
            }
            baseMsgBean.setReceiverCode(longIdReceivers.stream().collect(Collectors.joining(",")));
        }
        List<Object> pubplatMsgReceiver = new ArrayList();
        if (!StrUtil.isEmptyOrUndefined((CharSequence)baseMsgBean.getPubplatReceiverCode())) {
            pubplatMsgReceiver = Arrays.asList(baseMsgBean.getPubplatReceiverCode().split(","));
            longIdReceivers = new ArrayList();
            for (String string : pubplatMsgReceiver) {
                Object id;
                try {
                    id = String.valueOf(Long.parseLong(string));
                }
                catch (Exception exception) {
                    id = String.valueOf(Uuid2LongUtil.getUniqueId((String)string));
                }
                longIdReceivers.add(id);
            }
            baseMsgBean.setPubplatReceiverCode(longIdReceivers.stream().collect(Collectors.joining(",")));
        }
        if (!StrUtil.isEmptyOrUndefined((CharSequence)baseMsgBean.getCompID()) && baseMsgBean.getCompID().equals("6E7C22BB-D0DF-446D-8EA6-E66ECC910FDA")) {
            baseMsgBean.setCompID("0");
        }
        if (BaseMsgBean.MsgType.ARTICLES.equals((Object)baseMsgBean.getMsgType()) && baseMsgBean instanceof ArticleMsgBean) {
            ArticleMsgBean articleMsgBean = (ArticleMsgBean)baseMsgBean;
            List list = articleMsgBean.getArticles();
            for (ArticleBean articleBean : list) {
                String fileId;
                if (!StrUtil.isEmptyOrUndefined((CharSequence)articleBean.getFileID())) {
                    String fileId2 = articleBean.getFileID();
                    try {
                        fileId2 = String.valueOf(Long.parseLong(fileId2));
                    }
                    catch (Exception e) {
                        fileId2 = String.valueOf(Uuid2LongUtil.getUniqueId((String)fileId2));
                    }
                    articleBean.setFileID(fileId2);
                }
                if (!StrUtil.isEmptyOrUndefined((CharSequence)articleBean.getArticleMsgId())) {
                    fileId = articleBean.getArticleMsgId();
                    try {
                        fileId = String.valueOf(Long.parseLong(fileId));
                    }
                    catch (Exception e) {
                        fileId = String.valueOf(Uuid2LongUtil.getUniqueId((String)fileId));
                    }
                    articleBean.setArticleMsgId(fileId);
                }
                if (StrUtil.isEmptyOrUndefined((CharSequence)articleBean.getObjID())) continue;
                fileId = articleBean.getObjID();
                try {
                    fileId = String.valueOf(Long.parseLong(fileId));
                }
                catch (Exception e) {
                    fileId = String.valueOf(Uuid2LongUtil.getUniqueId((String)fileId));
                }
                articleBean.setObjID(fileId);
            }
        }
        if (BaseMsgBean.MsgType.FILETYPE.equals((Object)baseMsgBean.getMsgType()) && baseMsgBean instanceof FileMsgBean && !StrUtil.isEmptyOrUndefined((CharSequence)(fileMsgBean = (FileMsgBean)baseMsgBean).getFileID())) {
            void var10_27;
            String string = fileMsgBean.getFileID();
            try {
                String string2 = String.valueOf(Long.parseLong(string));
            }
            catch (Exception e) {
                String string3 = String.valueOf(Uuid2LongUtil.getUniqueId((String)string));
            }
            fileMsgBean.setFileID((String)var10_27);
        }
        if (BaseMsgBean.MsgType.IMAGE.equals((Object)baseMsgBean.getMsgType()) && baseMsgBean instanceof ImgMsgBean && !StrUtil.isEmptyOrUndefined((CharSequence)(imgMsgBean = (ImgMsgBean)baseMsgBean).getFileID())) {
            void var10_32;
            String string = imgMsgBean.getFileID();
            try {
                String string4 = String.valueOf(Long.parseLong(string));
            }
            catch (Exception e) {
                String string5 = String.valueOf(Uuid2LongUtil.getUniqueId((String)string));
            }
            imgMsgBean.setFileID((String)var10_32);
        }
        if (BaseMsgBean.MsgType.NOTICE.equals((Object)baseMsgBean.getMsgType()) && baseMsgBean instanceof NoticeMsgBean) {
            NoticeMsgBean noticeMsgBean = (NoticeMsgBean)baseMsgBean;
            ArrayList arrayList = new ArrayList();
            if (!StrUtil.isEmptyOrUndefined((CharSequence)noticeMsgBean.getReceiver())) {
                List<String> list = Arrays.asList(noticeMsgBean.getReceiver().split(","));
                longIdReceivers = new ArrayList();
                for (String string : list) {
                    String id;
                    try {
                        id = String.valueOf(Long.parseLong(string));
                    }
                    catch (Exception e) {
                        id = String.valueOf(Uuid2LongUtil.getUniqueId((String)string));
                    }
                    longIdReceivers.add(id);
                }
                noticeMsgBean.setReceiver(longIdReceivers.stream().collect(Collectors.joining(",")));
            }
        }
        if (BaseMsgBean.MsgType.WITHDRAW.equals((Object)baseMsgBean.getMsgType()) && baseMsgBean instanceof WithDrawMsgBean && !StrUtil.isEmptyOrUndefined((CharSequence)(withDrawMsgBean = (WithDrawMsgBean)baseMsgBean).getObjMsgID())) {
            void var10_40;
            String string = withDrawMsgBean.getObjMsgID();
            try {
                String string6 = String.valueOf(Long.parseLong(string));
            }
            catch (Exception e) {
                String string7 = String.valueOf(Uuid2LongUtil.getUniqueId((String)string));
            }
            withDrawMsgBean.setObjMsgID((String)var10_40);
        }
        pushMessageDTO.setBaseMsgBean(baseMsgBean);
        return pushMessageDTO;
    }
}

