/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.push.consumer;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.incrementer.DefaultIdentifierGenerator;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.mp.common.utils.GsonUtil;
import com.jxdinfo.mp.im.model.ArticleBean;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.NoticeMsgBean;
import com.jxdinfo.mp.im.model.single.MessageArticleDO;
import com.jxdinfo.mp.im.model.single.MessageDO;
import com.jxdinfo.mp.im.model.single.MessageFileDO;
import com.jxdinfo.mp.im.model.single.MessageOffline;
import com.jxdinfo.mp.im.model.single.ProblemAutoReplyDO;
import com.jxdinfo.mp.push.consumer.MessageBatchService;
import com.jxdinfo.mp.push.model.MessageArticleDTO;
import com.jxdinfo.mp.push.model.MessageDTO;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.springframework.beans.BeanUtils;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

@Component
public class MessageConsumer {
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private MessageBatchService messageBatchService;

    @JmsListener(destination="eimv5_FirstQueue")
    public void receiveFirstQueue(ActiveMQTextMessage msgObject) throws JMSException {
        MessageDTO messageDTO = (MessageDTO)JSON.parseObject((String)msgObject.getText(), MessageDTO.class);
        MessageDO messageDO = new MessageDO();
        BeanUtils.copyProperties((Object)messageDTO, (Object)messageDO);
        if (messageDTO.getMsgType() != BaseMsgBean.MsgType.WITHDRAW) {
            messageDO.setMsgTime(Long.valueOf(DateUtil.parse((String)messageDTO.getMsgTime(), (String)"yyyy-MM-dd HH:mm:ss:SSS").getTime()));
        } else {
            messageDO.setMsgTime(Long.valueOf(DateUtil.parse((String)messageDTO.getMsgTime(), (String)"yyyy-MM-dd HH:mm:ss:SSS").getTime()));
        }
        if (messageDTO.getMsgType() == BaseMsgBean.MsgType.LOCATION && ToolUtil.isNotEmpty((Object)messageDTO.getThumbnailId())) {
            messageDO.setThumbnailId(String.valueOf(messageDTO.getThumbnailId()));
        }
        if (messageDTO.getMsgType() == BaseMsgBean.MsgType.WITHDRAW && ToolUtil.isNotEmpty((Object)messageDTO.getObjMsgID())) {
            messageDO.setObjMsgID(String.valueOf(messageDTO.getObjMsgID()));
        }
        messageDO.setReceiverName(StrUtil.isEmpty((CharSequence)messageDTO.getReceiverName()) ? "" : messageDTO.getReceiverName());
        messageDO.setStatus(Integer.valueOf(messageDTO.getStatus() == null ? 0 : messageDTO.getStatus().ordinal()));
        messageDO.setMsgType(Integer.valueOf(messageDTO.getMsgType().ordinal()));
        messageDO.setMode(Integer.valueOf(messageDTO.getMode().ordinal()));
        messageDO.setRead(Integer.valueOf(messageDTO.getRead() == null ? 0 : messageDTO.getRead().ordinal()));
        messageDO.setEventType(Integer.valueOf(messageDTO.getEventType() == null ? 0 : messageDTO.getEventType().ordinal()));
        messageDO.setObjMsgType(Integer.valueOf(messageDTO.getObjMsgType() == null ? 0 : messageDTO.getObjMsgType().ordinal()));
        messageDO.setMeetingType(Integer.valueOf(messageDTO.getMeetingType() == null ? 0 : messageDTO.getMeetingType().ordinal()));
        messageDO.setPubplatReceiverCode(messageDTO.getPubplatReceiverCode());
        this.messageBatchService.addMessage(messageDO);
        if (messageDTO.getMsgType() == BaseMsgBean.MsgType.AUDIO || messageDTO.getMsgType() == BaseMsgBean.MsgType.FILETYPE || messageDTO.getMsgType() == BaseMsgBean.MsgType.IMAGE || messageDTO.getMsgType() == BaseMsgBean.MsgType.LOCATION) {
            System.out.println("\u5b58\u50a8\u6587\u4ef6\uff1a" + GsonUtil.getInstance().toJson((Object)messageDTO));
            this.saveFileObject(messageDTO);
        }
        if (messageDTO.getMsgType() == BaseMsgBean.MsgType.ARTICLES) {
            this.saveArticleBean(messageDTO);
        }
        if (messageDTO.getMsgType() == BaseMsgBean.MsgType.AUTOREPLY) {
            this.saveProblem(messageDTO);
        }
    }

    private void saveProblem(MessageDTO messageDTO) {
        messageDTO.getProblems().forEach(problemBean -> {
            ProblemAutoReplyDO problemAutoReplyDO = new ProblemAutoReplyDO();
            problemAutoReplyDO.setAutoReplyMsgId(Long.valueOf(Long.parseLong(messageDTO.getMsgID())));
            BeanUtils.copyProperties((Object)problemBean, (Object)problemAutoReplyDO);
            this.mongoTemplate.save((Object)problemAutoReplyDO);
        });
    }

    @JmsListener(destination="eimv5_OfflineQueue")
    public void receiveOfflineQueue(ActiveMQTextMessage msgObject) throws JMSException {
        if (msgObject.getText() == null) {
            return;
        }
        MessageDTO messageDTO = (MessageDTO)JSON.parseObject((String)msgObject.getText(), MessageDTO.class);
        MessageOffline messageOfflineDO = new MessageOffline();
        BeanUtils.copyProperties((Object)messageDTO, (Object)messageOfflineDO);
        if (messageDTO.getMsgType() != BaseMsgBean.MsgType.WITHDRAW) {
            messageOfflineDO.setMsgTime(Long.valueOf(DateUtil.parse((String)messageDTO.getMsgTime(), (String)"yyyy-MM-dd HH:mm:ss:SSS").getTime()));
        } else {
            messageOfflineDO.setMsgTime(Long.valueOf(DateUtil.parse((String)messageDTO.getObjMsgTime(), (String)"yyyy-MM-dd HH:mm:ss:SSS").getTime()));
        }
        if (messageDTO.getMsgType() == BaseMsgBean.MsgType.LOCATION && ToolUtil.isNotEmpty((Object)messageDTO.getThumbnailId())) {
            messageOfflineDO.setThumbnailId(String.valueOf(messageDTO.getThumbnailId()));
        }
        if (messageDTO.getMsgType() == BaseMsgBean.MsgType.WITHDRAW && ToolUtil.isNotEmpty((Object)messageDTO.getObjMsgID())) {
            messageOfflineDO.setObjMsgID(String.valueOf(messageDTO.getObjMsgID()));
        }
        System.out.println("eimv5_OfflineQueue\uff1a\u6d88\u606fID" + messageOfflineDO.getMsgID());
        messageOfflineDO.setReceiverName(StrUtil.isEmpty((CharSequence)messageDTO.getReceiverName()) ? "" : messageDTO.getReceiverName());
        messageOfflineDO.setStatus(Integer.valueOf(messageDTO.getStatus() == null ? 0 : messageDTO.getStatus().ordinal()));
        messageOfflineDO.setMsgType(Integer.valueOf(messageDTO.getMsgType().ordinal()));
        messageOfflineDO.setMode(Integer.valueOf(messageDTO.getMode().ordinal()));
        messageOfflineDO.setRead(Integer.valueOf(messageDTO.getRead() == null ? 0 : messageDTO.getRead().ordinal()));
        messageOfflineDO.setEventType(Integer.valueOf(messageDTO.getEventType() == null ? 0 : messageDTO.getEventType().ordinal()));
        messageOfflineDO.setObjMsgType(Integer.valueOf(messageDTO.getObjMsgType() == null ? 0 : messageDTO.getObjMsgType().ordinal()));
        messageOfflineDO.setMeetingType(Integer.valueOf(messageDTO.getMeetingType() == null ? 0 : messageDTO.getMeetingType().ordinal()));
        messageOfflineDO.setPubplatReceiverCode(messageDTO.getPubplatReceiverCode() == null ? null : messageDTO.getPubplatReceiverCode());
        this.messageBatchService.addOfflineMessage(messageOfflineDO);
    }

    private void saveFileObject(MessageDTO messageDTO) {
        MessageFileDO messageFileDO = new MessageFileDO();
        BeanUtils.copyProperties((Object)messageDTO, (Object)messageFileDO);
        if (messageDTO.getFileSize() != null && !messageDTO.getFileSize().toLowerCase().contains("b")) {
            messageFileDO.setFileSize(Float.parseFloat(messageDTO.getFileSize()));
        }
        messageFileDO.setMsgID(Long.valueOf(Long.parseLong(messageDTO.getMsgID())));
        if (messageDTO.getMsgType() == BaseMsgBean.MsgType.FILETYPE) {
            messageFileDO.setFileType(messageDTO.getFileType().ordinal());
            messageFileDO.setFileStatus(messageDTO.getFileStatus().ordinal());
            messageFileDO.setMd5(messageDTO.getMd5());
        }
        if (messageDTO.getMsgType() == BaseMsgBean.MsgType.IMAGE) {
            messageFileDO.setFileStatus(messageDTO.getFileStatus().ordinal());
            messageFileDO.setWidth(messageDTO.getWidth());
            messageFileDO.setHeight(messageDTO.getHeight());
        }
        if (messageDTO.getMsgType() == BaseMsgBean.MsgType.AUDIO) {
            messageFileDO.setFileStatus(messageDTO.getFileStatus().ordinal());
            messageFileDO.setLength(Integer.parseInt(messageDTO.getLength()));
        }
        if (messageDTO.getMsgType() == BaseMsgBean.MsgType.LOCATION) {
            messageFileDO.setFileID(messageDTO.getThumbnailId());
            messageFileDO.setFileName(messageDTO.getThumbnailName());
        }
        this.mongoTemplate.save((Object)messageFileDO);
    }

    private void saveArticleBean(MessageDTO messageDTO) {
        List articleDTOList = JSON.parseArray((String)messageDTO.getArticles(), MessageArticleDTO.class);
        DefaultIdentifierGenerator defaultIdentifierGenerator = new DefaultIdentifierGenerator();
        if (!CollUtil.isEmpty((Collection)articleDTOList)) {
            for (MessageArticleDTO messageArticleDTO : articleDTOList) {
                MessageArticleDO messageArticleDO = new MessageArticleDO();
                BeanUtils.copyProperties((Object)messageArticleDTO, (Object)messageArticleDO);
                messageArticleDO.setShowOrder(Integer.valueOf(articleDTOList.indexOf(messageArticleDTO)));
                messageArticleDO.setArticleMsgId(messageDTO.getMsgID());
                ArticleBean.LinkType linkType = messageArticleDTO.getLinkType();
                messageArticleDO.setLinkType(linkType == null ? null : Integer.valueOf(linkType.ordinal()));
                messageArticleDO.setPubplatReceiverCode(messageDTO.getPubplatReceiverCode());
                if (messageArticleDO.getObjID() == null || "".equals(messageArticleDO.getObjID())) {
                    messageArticleDO.setObjID(Long.valueOf(IdWorker.getId((Object)messageArticleDO)));
                }
                this.mongoTemplate.save((Object)messageArticleDO);
            }
        }
    }

    private void dealVideoMessage(MessageDTO messageDTO) {
        this.mongoTemplate.updateMulti(new Query((CriteriaDefinition)Criteria.where((String)"value").is((Object)messageDTO.getKey())), (UpdateDefinition)Update.update((String)"eventType", (Object)NoticeMsgBean.EventType.VIDEOEND.ordinal()), "message");
        this.mongoTemplate.updateMulti(new Query((CriteriaDefinition)Criteria.where((String)"value").is((Object)messageDTO.getKey())), (UpdateDefinition)Update.update((String)"eventType", (Object)NoticeMsgBean.EventType.VIDEOEND.ordinal()), "messageOffline");
        if (messageDTO.getEventType() == NoticeMsgBean.EventType.VIDEOEND) {
            this.mongoTemplate.updateMulti(new Query((CriteriaDefinition)Criteria.where((String)"value").is((Object)messageDTO.getValue())), (UpdateDefinition)Update.update((String)"eventType", (Object)NoticeMsgBean.EventType.VIDEOEND.ordinal()), "message");
            this.mongoTemplate.updateMulti(new Query((CriteriaDefinition)Criteria.where((String)"value").is((Object)messageDTO.getValue())), (UpdateDefinition)Update.update((String)"eventType", (Object)NoticeMsgBean.EventType.VIDEOEND.ordinal()), "messageOffline");
        }
    }
}

