/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.push.consumer;

import com.jxdinfo.mp.push.consumer.TimestampedObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;

public class BatchSaver<T>
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(BatchSaver.class);
    private final ConcurrentLinkedQueue<TimestampedObject<T>> queue = new ConcurrentLinkedQueue();
    private final int batchSize;
    private final long intervalMs;
    private final MongoTemplate mongoTemplate;
    private final Class<T> clazz;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final String persistenceFilePath;
    private final int maxQueueSize = 10000;

    public BatchSaver(MongoTemplate mongoTemplate, Class<T> clazz, int batchSize, long intervalMs) {
        this.mongoTemplate = mongoTemplate;
        this.clazz = clazz;
        this.batchSize = batchSize;
        this.intervalMs = intervalMs;
        this.persistenceFilePath = System.getProperty("java.io.tmpdir") + File.separator + "batch_saver_" + clazz.getSimpleName() + ".dat";
        this.scheduler.scheduleAtFixedRate(this::batchInsert, intervalMs, intervalMs, TimeUnit.MILLISECONDS);
        this.restoreFromDisk();
    }

    public boolean add(T obj) {
        if (this.queue.size() >= 10000) {
            this.persistToDisk();
            return false;
        }
        this.queue.offer(new TimestampedObject<T>(obj, System.currentTimeMillis()));
        return true;
    }

    private void batchInsert() {
        try {
            TimestampedObject<T> timestampedObj;
            this.restoreFromDisk();
            ArrayList<T> batch = new ArrayList<T>();
            while (batch.size() < this.batchSize && (timestampedObj = this.queue.poll()) != null) {
                batch.add(timestampedObj.getObject());
            }
            if (!batch.isEmpty()) {
                logger.info("\u6279\u91cf\u63d2\u5165\u6570\u636e\uff1a{} {}", (Object)batch.size(), (Object)this.clazz.getName());
                this.mongoTemplate.insert(batch, this.clazz);
                this.deletePersistenceFile();
            }
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u63d2\u5165\u6570\u636e\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void deletePersistenceFile() {
        File file = new File(this.persistenceFilePath);
        if (file.exists()) {
            if (file.delete()) {
                logger.info("\u6210\u529f\u5220\u9664\u6301\u4e45\u5316\u6587\u4ef6: {}", (Object)this.persistenceFilePath);
            } else {
                logger.warn("\u5220\u9664\u6301\u4e45\u5316\u6587\u4ef6\u5931\u8d25: {}", (Object)this.persistenceFilePath);
            }
        }
    }

    private void persistToDisk() {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.persistenceFilePath));){
            ArrayList<TimestampedObject<T>> list = new ArrayList<TimestampedObject<T>>(this.queue);
            oos.writeObject(list);
            this.queue.removeAll(list);
        }
        catch (IOException e) {
            logger.error("\u6301\u4e45\u5316\u6570\u636e\u5230\u78c1\u76d8\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void restoreFromDisk() {
        File file = new File(this.persistenceFilePath);
        if (!file.exists()) {
            return;
        }
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
            List list = (List)ois.readObject();
            this.queue.addAll(list);
            logger.info("\u4ece\u78c1\u76d8\u6062\u590d\u6570\u636e\u5230\u961f\u5217: {} \u6761 {}", (Object)list.size(), (Object)this.clazz.getName());
        }
        catch (IOException | ClassNotFoundException e) {
            logger.error("\u4ece\u78c1\u76d8\u6062\u590d\u6570\u636e\u5230\u961f\u5217\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

