/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.push.consumer;

import com.jxdinfo.mp.im.model.single.MessageDO;
import com.jxdinfo.mp.im.model.single.MessageOffline;
import com.jxdinfo.mp.push.consumer.BatchSaver;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class MessageBatchService {
    private final BatchSaver<MessageDO> messageSaver;
    private final BatchSaver<MessageOffline> offlineSaver;
    @Resource
    private MongoTemplate mongoTemplate;

    public MessageBatchService(MongoTemplate mongoTemplate) {
        this.messageSaver = new BatchSaver<MessageDO>(mongoTemplate, MessageDO.class, 100, 1500L);
        this.offlineSaver = new BatchSaver<MessageOffline>(mongoTemplate, MessageOffline.class, 100, 1500L);
    }

    public void addMessage(MessageDO messageDO) {
        boolean added = this.messageSaver.add(messageDO);
        if (!added) {
            System.err.println("\u6d88\u606f\u961f\u5217\u5df2\u6ee1\uff0c\u672a\u80fd\u6dfb\u52a0\u6d88\u606f\u5230\u78c1\u76d8: " + messageDO.getId());
        }
    }

    public void addOfflineMessage(MessageOffline messageOffline) {
        boolean added = this.offlineSaver.add(messageOffline);
        if (!added) {
            System.err.println("\u79bb\u7ebf\u6d88\u606f\u961f\u5217\u5df2\u6ee1\uff0c\u672a\u80fd\u6dfb\u52a0\u79bb\u7ebf\u6d88\u606f\u5230\u78c1\u76d8: " + messageOffline.getId());
        }
    }

    @PreDestroy
    public void shutdown() {
        System.out.println("\u6b63\u5728\u5173\u95edMessageBatchService...");
        System.out.println("MessageBatchService\u5df2\u5173\u95ed");
    }
}

