/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.mp.common.model.HeadingImg;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.common.model.organization.ContactVO;
import com.jxdinfo.mp.organization.model.linkman.UserStaffVo;
import com.jxdinfo.mp.organization.service.ContactService;
import com.jxdinfo.mp.organization.service.IOrganizationBoService;
import com.jxdinfo.mp.organization.service.LinkManService;
import com.jxdinfo.mp.organization.service.UserService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OrganizationBOServiceImpl
implements IOrganizationBoService {
    @Resource
    ContactService contactService;
    @Resource
    LinkManService linkManService;
    @Resource
    private UserService userService;

    public List<Long> getChildrenList(Long orgID) {
        List orgIDList = this.contactService.getAllChildList(orgID);
        orgIDList.removeIf(n -> n.equals(orgID));
        return orgIDList;
    }

    public List<Long> getAllParentList(Long orgID) {
        return this.contactService.getAllParentList(orgID);
    }

    public List<SysStru> getAllOrgList() {
        List organizationBoList = this.contactService.getAllOrgList();
        return BeanUtil.copyProperties((Collection)organizationBoList, SysStru.class);
    }

    public List<RosterVO> searchContact(Long orgID, String userName, PageDTO<RosterVO> pageDTO) {
        if (pageDTO == null) {
            pageDTO = new PageDTO();
            pageDTO.setPageSize(Integer.valueOf(-1));
            pageDTO.setPageNum(Integer.valueOf(1));
        }
        Long userID = null;
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user != null) {
            userID = user.getUserId();
        }
        if (userID == null) {
            return this.contactService.searchContact(userName, orgID, pageDTO, userID).getList();
        }
        return this.contactService.searchContactWithIsFriend(userName, orgID, pageDTO, userID).getList();
    }

    public List<UserStaffVo> searchContactByUserName(String userName) {
        Long userID = null;
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user != null) {
            userID = user.getUserId();
        }
        return this.contactService.searchContactByUserName(userName, userID);
    }

    public Page<RosterVO> getLinkManList(PageInfo pageInfo) {
        Long userID = null;
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user != null) {
            userID = user.getUserId();
        }
        return this.linkManService.getLinkManList(pageInfo, userID);
    }

    public PageVO<ContactVO> getContactInfo(Long orgID, int pageSize, int pageNum) {
        return this.contactService.getContactInfo(orgID, false, Integer.valueOf(pageSize), Integer.valueOf(pageNum));
    }

    public UserStaffVo getLinkManInfo(Long friendID) {
        Long userID = null;
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user != null) {
            userID = user.getUserId();
        }
        return this.linkManService.getLinkManInfo(userID, friendID);
    }

    public List<HeadingImg> queryUserHeadFileID(List<Long> userIDs) {
        return this.linkManService.queryUserHeadFileID(userIDs);
    }

    public List<UserStaffVo> queryUserByUserID(List<Long> userIDs, String searchKey, String orgIDs, String roleIDs, int pageNum, int pageSize) {
        Long userID = null;
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user != null) {
            userID = user.getUserId();
        }
        return this.userService.getUser(userIDs, searchKey, userID, pageNum, pageSize, orgIDs, roleIDs);
    }

    public SysUsers userDetail(Long userID) {
        Long currentUserId = null;
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user != null) {
            currentUserId = user.getUserId();
        }
        return this.linkManService.userDetail(userID, currentUserId);
    }

    public List<OrganizationTreeVo> selectOrgList(String isShow, String searchKey, Long parentOrgID, int pageSize, int pageNum) {
        isShow = isShow == null ? "1" : isShow;
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        return this.contactService.getOrgTree(isShow, searchKey, parentOrgID, pageDTO);
    }

    public PageVO<UserStaffVo> searchUser(String searchKey, List<Long> orgIDs, String roleIDs, String isShow, int pageSize, int pageNum, Long objID) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        Long currentUserId = null;
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user != null) {
            currentUserId = user.getUserId();
        }
        return this.contactService.searchUser(currentUserId, searchKey, orgIDs, roleIDs, isShow, pageDTO, objID);
    }

    public PageVO<RosterVO> getReceiver(Long msgID, int pageNum, int pageSize, String searchKey, String orgIDs, String roleIDs) {
        PageDTO pageDTO = new PageDTO();
        PageVO pageVO = new PageVO();
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        BeanUtil.copyProperties((Object)this.contactService.getReceiver(msgID, pageDTO, searchKey, orgIDs, roleIDs), (Object)pageVO);
        return pageVO;
    }
}

