/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.annotation.Permission;
import com.jxdinfo.mp.common.model.AdminEnum;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.organization.model.feedback.ProblemCommonDO;
import com.jxdinfo.mp.organization.model.feedback.ProblemCommonDTO;
import com.jxdinfo.mp.organization.model.feedback.ProblemDO;
import com.jxdinfo.mp.organization.model.feedback.ProblemDTO;
import com.jxdinfo.mp.organization.model.feedback.ProblemModuleDO;
import com.jxdinfo.mp.organization.model.feedback.ProblemTypeDO;
import com.jxdinfo.mp.organization.service.ProblemCommonService;
import com.jxdinfo.mp.organization.service.ProblemFileService;
import com.jxdinfo.mp.organization.service.ProblemModuleService;
import com.jxdinfo.mp.organization.service.ProblemService;
import com.jxdinfo.mp.organization.service.ProblemTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u95ee\u9898\u53cd\u9988"})
@RestController
@ApiVersion
@RequestMapping(value={"/problem"})
public class FeedBackController {
    @Resource
    private ProblemCommonService problemCommonService;
    @Resource
    private ProblemFileService problemFileService;
    @Resource
    private ProblemTypeService problemTypeService;
    @Resource
    private ProblemModuleService problemModuleService;
    @Resource
    private ProblemService problemService;

    @PostMapping(value={"common"})
    @ApiOperation(value="\u65b0\u589e\u5e38\u89c1\u95ee\u9898")
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> saveCommonProblem(@RequestBody ProblemCommonDTO commonProblemDTO) {
        return Result.succeed((Object)this.problemCommonService.saveCommonProblem(commonProblemDTO));
    }

    @PostMapping(value={"updateCommonProblem"})
    @ApiOperation(value="\u4fee\u6539\u5e38\u89c1\u95ee\u9898")
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> updateCommonProblem(@RequestBody ProblemCommonDTO commonProblemDTO) {
        return Result.succeed((Object)this.problemCommonService.updateCommonProblem(commonProblemDTO));
    }

    @GetMapping(value={"removeCommonProblem"})
    @ApiOperation(value="\u5220\u9664\u5e38\u89c1\u95ee\u9898")
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> removeCommonProblem(@RequestParam String problemId) {
        return Result.succeed((Object)this.problemCommonService.removeCommonProblem(problemId));
    }

    @GetMapping(value={"getCommonProblemList"})
    @ApiOperation(value="\u83b7\u53d6\u5e38\u89c1\u95ee\u9898\u5217\u8868")
    public Result<PageDTO<ProblemCommonDO>> getCommonProblemList(@RequestParam(value="pageDTO") @ApiParam(value="\u5206\u9875\u53c2\u6570") PageDTO<ProblemCommonDO> pageDTO, @RequestParam @ApiParam(value="\u641c\u7d22\u6761\u4ef6") String searchKey) {
        return Result.succeed((Object)this.problemCommonService.getCommonProblemList(pageDTO, searchKey));
    }

    @GetMapping(value={"getCommonProblem"})
    @ApiOperation(value="\u83b7\u53d6\u5e38\u89c1\u95ee\u9898\u8be6\u60c5")
    public Result<ProblemCommonDTO> getCommonProblem(@RequestParam String problemId) {
        return Result.succeed((Object)this.problemCommonService.getCommonProblem(problemId));
    }

    @PostMapping(value={"type"})
    @ApiOperation(value="\u65b0\u589e\u95ee\u9898\u7c7b\u578b")
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> saveType(@RequestBody ProblemTypeDO problemTypeDO) {
        return Result.succeed((Object)this.problemCommonService.saveType(problemTypeDO));
    }

    @PatchMapping(value={"type"})
    @ApiOperation(value="\u4fee\u6539\u95ee\u9898\u7c7b\u578b")
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> updateType(@RequestBody ProblemTypeDO problemTypeDO) {
        problemTypeDO.setModifyTime(DateUtil.now());
        return Result.succeed((Object)this.problemTypeService.updateById((Object)problemTypeDO));
    }

    @DeleteMapping(value={"type/{id}"})
    @ApiOperation(value="\u5220\u9664\u95ee\u9898\u7c7b\u578b")
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> removeType(@PathVariable String id) {
        return Result.succeed((Object)this.problemTypeService.removeByIds(Arrays.asList(id.split(","))));
    }

    @GetMapping(value={"type"})
    @ApiOperation(value="\u83b7\u53d6\u95ee\u9898\u7c7b\u578b\u5217\u8868")
    public Result<PageDTO<ProblemTypeDO>> getTypeList(@RequestParam(defaultValue="1") int pageNum, @RequestParam(defaultValue="20") int pageSize) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        pageDTO.setSize((long)pageSize);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByAsc((Object)"CREATETIME");
        return Result.succeed((Object)((PageDTO)this.problemTypeService.page((IPage)pageDTO, (Wrapper)queryWrapper)));
    }

    @PostMapping(value={"module"})
    @ApiOperation(value="\u65b0\u589e\u95ee\u9898\u6a21\u5757")
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> saveModule(@RequestBody ProblemModuleDO problemModuleDO) {
        problemModuleDO.setModuleID(Long.valueOf(IdWorker.getId((Object)problemModuleDO)));
        problemModuleDO.setCreateTime(DateUtil.now());
        problemModuleDO.setModifyTime(DateUtil.now());
        return Result.succeed((Object)this.problemModuleService.save((Object)problemModuleDO));
    }

    @PatchMapping(value={"module"})
    @ApiOperation(value="\u4fee\u6539\u95ee\u9898\u6a21\u5757")
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> updateModule(@RequestBody ProblemModuleDO problemModuleDO) {
        problemModuleDO.setModifyTime(DateUtil.now());
        return Result.succeed((Object)this.problemModuleService.updateById((Object)problemModuleDO));
    }

    @DeleteMapping(value={"module/{id}"})
    @ApiOperation(value="\u5220\u9664\u95ee\u9898\u6a21\u5757")
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> removeModule(@PathVariable String id) {
        return Result.succeed((Object)this.problemModuleService.removeByIds(Arrays.asList(id.split(","))));
    }

    @GetMapping(value={"module"})
    @ApiOperation(value="\u83b7\u53d6\u95ee\u9898\u6a21\u5757\u5217\u8868")
    public Result<PageDTO<ProblemModuleDO>> getModuleList(@RequestParam(defaultValue="1") int pageNum, @RequestParam(defaultValue="20") int pageSize) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        pageDTO.setSize((long)pageSize);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByAsc((Object)"CREATETIME");
        return Result.succeed((Object)((PageDTO)this.problemModuleService.page((IPage)pageDTO, (Wrapper)queryWrapper)));
    }

    @PostMapping
    @ApiOperation(value="\u65b0\u589e\u95ee\u9898\u53cd\u9988")
    public Result<Boolean> saveProblem(@RequestBody ProblemDTO problemDTO, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        if (currentLoginUser == null) {
            return Result.failed((String)"\u975e\u767b\u5f55\u7528\u6237\u65e0\u6cd5\u63d0\u4ea4\u95ee\u9898\u53cd\u9988\uff01");
        }
        problemDTO.setQuestioner(currentLoginUser.getUserName());
        problemDTO.setQuestionerID(currentLoginUser.getId());
        problemDTO.setCreateTime(DateUtil.now());
        problemDTO.setModifyTime(DateUtil.now());
        problemDTO.setProblemID(Long.valueOf(IdWorker.getId((Object)problemDTO)));
        return Result.succeed((Object)this.problemService.saveProblem(problemDTO));
    }

    @PatchMapping
    @ApiOperation(value="\u4fee\u6539\u95ee\u9898\u53cd\u9988")
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> updateProblem(@RequestBody ProblemDO problemDO, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        problemDO.setResponder(currentLoginUser.getUserName());
        problemDO.setResponderID(currentLoginUser.getId());
        problemDO.setRespondTime(DateUtil.now());
        return Result.succeed((Object)this.problemService.updateById((Object)problemDO));
    }

    @GetMapping
    @ApiOperation(value="\u83b7\u53d6\u95ee\u9898\u53cd\u9988\u5217\u8868")
    public Result<PageDTO<ProblemDO>> getProblemList(@RequestParam(defaultValue="1") int pageNum, @RequestParam(defaultValue="20") int pageSize, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @RequestParam @ApiParam(value="\u67e5\u770b\u81ea\u5df1\u4f20\u6570\u5b57 \u67e5\u770b\u6240\u6709\u4e0d\u4f20\u53c2") Integer isMine, @RequestParam(required=false) @ApiParam(value="\u7c7b\u578bid") String typeID, @RequestParam(required=false) @ApiParam(value="\u6a21\u5757\u540d") String moduleName, @RequestParam(required=false) @ApiParam(value="\u72b6\u6001") Integer status) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        pageDTO.setSize((long)pageSize);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (isMine != null) {
            if (currentLoginUser == null) {
                return Result.failed((String)"\u975e\u767b\u5f55\u7528\u6237\u65e0\u6cd5\u67e5\u770b\u95ee\u9898\u53cd\u9988\u8bb0\u5f55\uff01");
            }
            queryWrapper.eq((Object)"QUESTIONERID", (Object)String.valueOf(currentLoginUser.getId()));
        }
        if (StrUtil.isNotEmpty((CharSequence)typeID)) {
            queryWrapper.eq((Object)"TYPEID", (Object)typeID);
        }
        if (StrUtil.isNotEmpty((CharSequence)moduleName)) {
            queryWrapper.eq((Object)"MODULENAME", (Object)moduleName);
        }
        if (status != null) {
            queryWrapper.eq((Object)"DATASTATUS", (Object)status);
        }
        queryWrapper.orderByDesc((Object)"CREATETIME");
        return Result.succeed((Object)((PageDTO)this.problemService.page((IPage)pageDTO, (Wrapper)queryWrapper)));
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u83b7\u53d6\u95ee\u9898\u53cd\u9988\u8be6\u60c5")
    public Result<ProblemDTO> getProblem(@PathVariable String id) {
        ProblemDTO problemDTO = new ProblemDTO();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"BUSINESSID", (Object)id)).orderByAsc((Object)"CREATETIME");
        BeanUtil.copyProperties((Object)this.problemService.getById((Serializable)((Object)id)), (Object)problemDTO, (String[])new String[0]);
        problemDTO.setFiles(this.problemFileService.list((Wrapper)queryWrapper));
        return Result.succeed((Object)problemDTO);
    }
}

