/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.organization.controller;

import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.organization.model.collection.CollectionDO;
import com.jxdinfo.mp.organization.model.collection.CollectionDTO;
import com.jxdinfo.mp.organization.model.collection.ReceiverDTO;
import com.jxdinfo.mp.organization.service.CollectionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u6536\u85cf\u529f\u80fd", tags={"\u6536\u85cf\u529f\u80fd"})
@RestController
@RequestMapping(value={"/collection"})
public class CollectionController {
    @Resource
    private CollectionService collectionService;

    @ApiOperation(value="\u6dfb\u52a0\u6536\u85cf")
    @PostMapping(value={"saveCollection"})
    public Result<Boolean> collection(@RequestBody @ApiParam(value="\u6536\u85cf\u4fe1\u606f\u5b9e\u4f53\u7c7b") CollectionDTO collectionDTO, @ApiIgnore @LoginUser CurrentLoginUser loginUser) {
        return this.collectionService.collection(collectionDTO, loginUser);
    }

    @ApiOperation(value="\u53d6\u6d88\u6536\u85cf")
    @GetMapping(value={"/cancelCollection"})
    public Result<Boolean> cancelCollection(@RequestParam(value="collectID") @ApiParam(value="\u6536\u85cfID\u6216\u8005contentID") Long collectID, @ApiIgnore @LoginUser CurrentLoginUser loginUser) {
        return this.collectionService.cancelCollection(collectID, loginUser);
    }

    @ApiOperation(value="\u83b7\u53d6\u6536\u85cf\u5217\u8868\uff08\u641c\u7d22\uff09")
    @GetMapping(value={"getCollectionList"})
    public Result<PageVO<CollectionDO>> getCollectionList(@ApiIgnore @LoginUser CurrentLoginUser loginUser, @RequestParam(required=false) @ApiParam(value="\u641c\u7d22\u5173\u952e\u5b57") String searchKey, @RequestParam(required=false) @ApiParam(value="\u6536\u85cf\u5185\u5bb9\u7c7b\u578b") Integer collectType, @ApiParam(value="\u5206\u9875\u53c2\u6570") PageInfo page) {
        return this.collectionService.getCollectionList(loginUser, searchKey, collectType, page);
    }

    @ApiOperation(value="\u6536\u85cf\u8f6c\u53d1")
    @PostMapping(value={"forwardCollection"})
    public Result<Boolean> forwardCollection(@RequestParam @ApiParam(value="\u6536\u85cfID") Long collectionID, @RequestBody @ApiParam(value="\u63a5\u6536\u4eba\u5b9e\u4f53\u7c7b") List<ReceiverDTO> receiverDTOList, @ApiIgnore @LoginUser CurrentLoginUser loginUser) {
        return Result.succeed((Object)this.collectionService.forwardCollection(loginUser, collectionID, receiverDTOList));
    }

    @ApiOperation(value="\u83b7\u53d6\u6536\u85cf\u6570\u91cf")
    @GetMapping(value={"count"})
    public Result<Long> getCollectionNum(@ApiIgnore @LoginUser CurrentLoginUser loginUser) {
        return this.collectionService.getCollectionNum(loginUser);
    }
}

