/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.PageUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.mp.common.constant.IMConstants;
import com.jxdinfo.mp.common.model.FileVO;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.im.dao.group.VideoUserMapper;
import com.jxdinfo.mp.im.handler.MessageHandler;
import com.jxdinfo.mp.im.model.ArticleBean;
import com.jxdinfo.mp.im.model.ArticleMsgBean;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.EventMsgBean;
import com.jxdinfo.mp.im.model.FileMsgBean;
import com.jxdinfo.mp.im.model.ImgMsgBean;
import com.jxdinfo.mp.im.model.LocationMsgBean;
import com.jxdinfo.mp.im.model.NoticeMsgBean;
import com.jxdinfo.mp.im.model.VoiceMsgBean;
import com.jxdinfo.mp.im.model.WithDrawMsgBean;
import com.jxdinfo.mp.im.model.db.GroupUserDO;
import com.jxdinfo.mp.im.model.push.PushMessageDTO;
import com.jxdinfo.mp.im.model.single.MessageArticleDO;
import com.jxdinfo.mp.im.model.single.MessageDO;
import com.jxdinfo.mp.im.model.single.MessageFileDO;
import com.jxdinfo.mp.im.model.single.MessageOffline;
import com.jxdinfo.mp.im.model.single.OperationDo;
import com.jxdinfo.mp.im.model.single.ReceiptVO;
import com.jxdinfo.mp.im.model.single.SingleMessageVO;
import com.jxdinfo.mp.im.model.single.TimeDO;
import com.jxdinfo.mp.im.model.single.VideoUserVO;
import com.jxdinfo.mp.im.service.GroupManageService;
import com.jxdinfo.mp.im.service.GroupService;
import com.jxdinfo.mp.im.service.GroupUserService;
import com.jxdinfo.mp.im.service.MessageService;
import com.jxdinfo.mp.im.util.ListUtil;
import com.jxdinfo.mp.organization.model.linkman.UserStaffVo;
import com.jxdinfo.mp.organization.model.pubPlat.ApplicationExtendVo;
import com.jxdinfo.mp.organization.service.IOrganizationBoService;
import com.jxdinfo.mp.organization.service.IPubPlatService;
import com.jxdinfo.mp.organization.service.UserService;
import com.jxdinfo.mp.push.model.PushEventMessageDTO;
import com.jxdinfo.mp.push.service.MessageProducerService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.env.Environment;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MessageServiceImpl
implements MessageService {
    private static final Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private MessageHandler messageHandler;
    @Resource
    private GroupUserService groupUserService;
    @Resource
    private GroupService groupService;
    @Resource
    private GroupManageService groupManageService;
    @Resource
    private VideoUserMapper videoUserMapper;
    @Resource
    private MessageProducerService pushService;
    @Resource
    private IOrganizationBoService organizationService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private UserService userService;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private IPubPlatService pubPlatService;
    @Resource
    private Environment environment;
    private static final String BASE_MESSAGE_TIME = "msgTime";
    private static final String BASE_MESSAGE_RECEIVE_CODE = "receiverCode";
    private static final String BASE_MESSAGE_SENDER_CODE = "senderCode";
    private long day7ago = System.currentTimeMillis() - 604800000L;

    public List<OperationDo> getOperationTimeByUserId(String userID, long operationStartTimeStamp) {
        ArrayList typeList = CollUtil.newArrayList((Object[])new String[0]);
        typeList.add("read");
        typeList.add("del");
        return this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"userID").is((Object)userID)).addCriteria((CriteriaDefinition)Criteria.where((String)"type").in((Collection)typeList)).addCriteria((CriteriaDefinition)Criteria.where((String)"time").gt((Object)operationStartTimeStamp)).with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"time")})), OperationDo.class);
    }

    public PageVO<BaseMsgBean> getRecentMessages(PageVO<BaseMsgBean> pageVO, String userID, long startTimeStamp, String deviceType) {
        long start = System.currentTimeMillis();
        Pattern pattern = Pattern.compile("^.*" + userID + ".*$", 2);
        ArrayList criteriaList = CollUtil.newArrayList((Object[])new Criteria[0]);
        Criteria queryCriteria = new Criteria().orOperator(new Criteria[]{new Criteria().andOperator(new Criteria[]{Criteria.where((String)"mode").is((Object)0).and(BASE_MESSAGE_TIME).gt((Object)startTimeStamp), new Criteria().orOperator(new Criteria[]{Criteria.where((String)BASE_MESSAGE_RECEIVE_CODE).is((Object)userID), Criteria.where((String)BASE_MESSAGE_SENDER_CODE).is((Object)userID)})}), new Criteria().andOperator(new Criteria[]{Criteria.where((String)"mode").is((Object)2).and(BASE_MESSAGE_TIME).gt((Object)startTimeStamp), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"pubplatReceiverCode").is((Object)""), Criteria.where((String)"pubplatReceiverCode").regex(pattern)})})});
        List roomIdList = this.groupUserService.getAllRoomId(Long.valueOf(Long.parseLong(userID)));
        if (!CollUtil.isEmpty((Collection)roomIdList)) {
            roomIdList.forEach(groupUserVO -> {
                long joinRoomTimeStamp = groupUserVO.getCreateTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                if (groupUserVO.getLastTime() == null) {
                    groupUserVO.setLastTime(groupUserVO.getCreateTime());
                }
                long exitRoomTimeStamp = groupUserVO.getLastTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                if (groupUserVO.getDataStatus().equals("1")) {
                    criteriaList.add(new Criteria().andOperator(new Criteria[]{Criteria.where((String)BASE_MESSAGE_RECEIVE_CODE).is((Object)groupUserVO.getRoomID()).and(BASE_MESSAGE_TIME).gt((Object)Math.max(joinRoomTimeStamp, startTimeStamp))}));
                } else if (startTimeStamp < exitRoomTimeStamp) {
                    criteriaList.add(new Criteria().andOperator(new Criteria[]{Criteria.where((String)BASE_MESSAGE_RECEIVE_CODE).is((Object)groupUserVO.getRoomID()).and(BASE_MESSAGE_TIME).gt((Object)Math.max(joinRoomTimeStamp, startTimeStamp))}).and(BASE_MESSAGE_TIME).lte((Object)exitRoomTimeStamp));
                }
            });
            Criteria[] criteria1s = criteriaList.toArray(new Criteria[0]);
            queryCriteria = new Criteria().orOperator(new Criteria[]{queryCriteria, new Criteria().andOperator(new Criteria[]{Criteria.where((String)"mode").is((Object)1), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"receiver").is((Object)""), Criteria.where((String)"receiver").regex(pattern), Criteria.where((String)"receiver").is(null)}), new Criteria().orOperator(criteria1s)})});
        }
        Query query = new Query((CriteriaDefinition)queryCriteria).with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)BASE_MESSAGE_TIME)})).skip((long)(pageVO.getPageSize() * (pageVO.getPageNum() - 1))).limit(pageVO.getPageSize().intValue());
        List messageOfflineList = this.mongoTemplate.find(query, MessageOffline.class);
        ArrayList msgBeans = CollUtil.newArrayList((Object[])new BaseMsgBean[0]);
        messageOfflineList.forEach(messageDO -> msgBeans.add(this.messageHandler.execute(messageDO.getMsgType(), messageDO)));
        Criteria fileCriteria = Criteria.where((String)"msgId").in((Collection)msgBeans.stream().map(BaseMsgBean::getMsgID).map(Long::parseLong).collect(Collectors.toList()));
        List messageFileDO = this.mongoTemplate.find(new Query((CriteriaDefinition)fileCriteria), MessageFileDO.class);
        ArrayList<Object> resultMsgBean = new ArrayList<Object>();
        for (BaseMsgBean msgBean : msgBeans) {
            VoiceMsgBean.FileStatus[] status;
            MessageFileDO temp;
            List tempFile = messageFileDO.stream().filter(a -> String.valueOf(a.getMsgID()).equals(msgBean.getMsgID())).collect(Collectors.toList());
            if (msgBean.getMsgType().ordinal() == BaseMsgBean.MsgType.AUDIO.ordinal()) {
                VoiceMsgBean voiceMsgBean = (VoiceMsgBean)msgBean;
                if (ToolUtil.isNotEmpty(tempFile)) {
                    temp = (MessageFileDO)tempFile.get(0);
                    voiceMsgBean.setFileID(String.valueOf(temp.getFileID()));
                    voiceMsgBean.setFileName(temp.getFileName());
                    voiceMsgBean.setFileSize(String.valueOf(temp.getFileSize()));
                    status = VoiceMsgBean.FileStatus.values();
                    voiceMsgBean.setFileStatus(status[temp.getFileStatus()]);
                    voiceMsgBean.setLength(temp.getLength());
                }
                resultMsgBean.add(voiceMsgBean);
                continue;
            }
            if (msgBean.getMsgType().ordinal() == BaseMsgBean.MsgType.IMAGE.ordinal()) {
                ImgMsgBean imgMsgBean = (ImgMsgBean)msgBean;
                if (ToolUtil.isNotEmpty(tempFile)) {
                    temp = (MessageFileDO)tempFile.get(0);
                    imgMsgBean.setFileID(String.valueOf(temp.getFileID()));
                    imgMsgBean.setFileName(temp.getFileName());
                    imgMsgBean.setFileSize(String.valueOf(temp.getFileSize()));
                    status = ImgMsgBean.FileStatus.values();
                    imgMsgBean.setFileStatus((ImgMsgBean.FileStatus)status[temp.getFileStatus()]);
                    imgMsgBean.setHeight(temp.getHeight());
                    imgMsgBean.setWidth(temp.getWidth());
                }
                resultMsgBean.add(imgMsgBean);
                continue;
            }
            if (msgBean.getMsgType().ordinal() == BaseMsgBean.MsgType.FILETYPE.ordinal()) {
                FileMsgBean fileMsgBean = (FileMsgBean)msgBean;
                if (ToolUtil.isNotEmpty(tempFile)) {
                    temp = (MessageFileDO)tempFile.get(0);
                    fileMsgBean.setFileID(String.valueOf(temp.getFileID()));
                    fileMsgBean.setFileName(temp.getFileName());
                    FileMsgBean.FileType[] types = FileMsgBean.FileType.values();
                    fileMsgBean.setFileType(types[temp.getFileType()]);
                    FileMsgBean.FileStatus[] status2 = FileMsgBean.FileStatus.values();
                    fileMsgBean.setFileStatus(status2[temp.getFileStatus()]);
                    fileMsgBean.setFileSize(temp.getFileSize());
                }
                resultMsgBean.add(fileMsgBean);
                continue;
            }
            if (msgBean.getMsgType().ordinal() == BaseMsgBean.MsgType.LOCATION.ordinal()) {
                LocationMsgBean locationMsgBean = (LocationMsgBean)msgBean;
                if (ToolUtil.isNotEmpty(tempFile)) {
                    temp = (MessageFileDO)tempFile.get(0);
                    locationMsgBean.setFileSize(String.valueOf(temp.getFileSize()));
                    status = LocationMsgBean.FileStatus.values();
                    locationMsgBean.setFileStatus((LocationMsgBean.FileStatus)status[temp.getFileStatus()]);
                    if (ToolUtil.isNotEmpty((Object)locationMsgBean.getThumbnailId())) {
                        locationMsgBean.setThumbnailId(temp.getFileID());
                    }
                }
                resultMsgBean.add(locationMsgBean);
                continue;
            }
            if (msgBean.getMsgType().ordinal() == BaseMsgBean.MsgType.WITHDRAW.ordinal()) {
                WithDrawMsgBean withDrawMsgBean = (WithDrawMsgBean)msgBean;
                resultMsgBean.add(withDrawMsgBean);
                continue;
            }
            resultMsgBean.add(msgBean);
        }
        pageVO.setList(resultMsgBean);
        Integer count = Integer.parseInt(String.valueOf(this.mongoTemplate.count(new Query((CriteriaDefinition)queryCriteria), MessageOffline.class)));
        pageVO.setPageCount(count);
        return pageVO;
    }

    public PageVO<BaseMsgBean> getSingleMessage(String friendID, String userID, PageVO<BaseMsgBean> pageVO, String searchKey, Integer msgTypes) {
        Criteria criteria = new Criteria().orOperator(new Criteria[]{new Criteria().andOperator(new Criteria[]{Criteria.where((String)"mode").is((Object)0), new Criteria().orOperator(new Criteria[]{Criteria.where((String)BASE_MESSAGE_RECEIVE_CODE).is((Object)userID).and(BASE_MESSAGE_SENDER_CODE).is((Object)friendID), Criteria.where((String)BASE_MESSAGE_RECEIVE_CODE).is((Object)friendID).and(BASE_MESSAGE_SENDER_CODE).is((Object)userID)})})});
        PageVO<BaseMsgBean> baseMsgBeanPageVO = this.getMsg(criteria, msgTypes, searchKey, pageVO);
        return baseMsgBeanPageVO;
    }

    private PageVO<BaseMsgBean> getMsg(Criteria criteria, Integer msgTypes, String searchKey, PageVO<BaseMsgBean> pageVO) {
        List<Object> msgBeans;
        if (null != msgTypes) {
            criteria.and("msgType").is((Object)msgTypes);
        }
        if (StrUtil.isNotEmpty((CharSequence)searchKey)) {
            Pattern searchPattern = Pattern.compile("^.*" + searchKey + ".*$", 2);
            criteria.and("body").regex(searchPattern);
        }
        List messageDOS = this.mongoTemplate.find(new Query((CriteriaDefinition)criteria).with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)BASE_MESSAGE_TIME)})).skip((long)pageVO.getPageSize().intValue() * (long)(pageVO.getPageNum() - 1)).limit(pageVO.getPageSize().intValue()), MessageDO.class);
        ArrayList finalMsgBeans = msgBeans = CollUtil.newArrayList((Object[])new BaseMsgBean[0]);
        messageDOS.forEach(messageDO -> finalMsgBeans.add(this.messageHandler.execute(messageDO.getMsgType(), messageDO)));
        msgBeans = this.getMsgFilesByMsgIds(finalMsgBeans);
        CollUtil.reverse((List)msgBeans);
        pageVO.setList((List)msgBeans);
        int count = (int)this.mongoTemplate.count(new Query((CriteriaDefinition)criteria), MessageDO.class);
        pageVO.setPageCount(Integer.valueOf(count));
        return pageVO;
    }

    public PageVO<BaseMsgBean> getGroupMessage(Long groupID, Long userID, PageVO<BaseMsgBean> pageVO, String searchKey, Integer msgTypes) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"GROUP_ID", (Object)groupID)).eq((Object)"USER_ID", (Object)userID);
        GroupUserDO groupUserDO = (GroupUserDO)this.groupUserService.getOne((Wrapper)queryWrapper);
        if (null != groupUserDO && groupUserDO.getDataStatus() != 1) {
            pageVO.setPageCount(Integer.valueOf(0));
            pageVO.setList(new ArrayList());
            return pageVO;
        }
        Pattern pattern = Pattern.compile("^.*" + userID + ".*$", 2);
        Criteria criteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)BASE_MESSAGE_RECEIVE_CODE).is((Object)groupID.toString()).and("mode").is((Object)1), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"receiver").is((Object)""), Criteria.where((String)"receiver").regex(pattern), Criteria.where((String)"receiver").is(null)})});
        return this.getMsg(criteria, msgTypes, searchKey, pageVO);
    }

    public PageVO<BaseMsgBean> getPubplatMessage(Criteria criteria, PageVO<BaseMsgBean> pageVO) {
        List<Object> msgBeans;
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)BASE_MESSAGE_TIME)})).skip((long)(pageVO.getPageSize() * (pageVO.getPageNum() - 1))).limit(pageVO.getPageSize().intValue());
        List messageDOS = this.mongoTemplate.find(query, MessageDO.class);
        ArrayList finalMsgBeans = msgBeans = CollUtil.newArrayList((Object[])new BaseMsgBean[0]);
        messageDOS.forEach(messageDO -> finalMsgBeans.add(this.messageHandler.execute(messageDO.getMsgType(), messageDO)));
        CollUtil.reverse((List)msgBeans);
        msgBeans = this.getMsgFilesByMsgIds(finalMsgBeans);
        pageVO.setList((List)msgBeans);
        Query query1 = new Query((CriteriaDefinition)criteria);
        query1.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)BASE_MESSAGE_TIME)}));
        pageVO.setPageCount(Integer.valueOf((int)this.mongoTemplate.count(query1, MessageDO.class)));
        return pageVO;
    }

    public PageVO<BaseMsgBean> getPubplatHistory(Long pubplatID, PageVO<BaseMsgBean> pageVO, String typeID, String msgTitle) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and("mode").is((Object)2);
        criteria.and(BASE_MESSAGE_SENDER_CODE).is((Object)IMConstants.IM_SYSTEM_ID);
        criteria.and(BASE_MESSAGE_RECEIVE_CODE).is((Object)pubplatID);
        if (StrUtil.isNotEmpty((CharSequence)typeID)) {
            criteria.and("msgType").is((Object)BaseMsgBean.MsgType.valueOf((String)typeID).ordinal());
        }
        if (StrUtil.isNotEmpty((CharSequence)msgTitle)) {
            String regex = ".*" + msgTitle + ".*";
            criteria.and("body").regex(regex);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        List messageDOS = this.mongoTemplate.find(query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)BASE_MESSAGE_TIME)})).skip((long)(pageVO.getPageSize() * (pageVO.getPageNum() - 1))).limit(pageVO.getPageSize().intValue()), MessageDO.class);
        ArrayList msgBeans = CollUtil.newArrayList((Object[])new BaseMsgBean[0]);
        messageDOS.forEach(messageDO -> msgBeans.add(this.messageHandler.execute(messageDO.getMsgType(), messageDO)));
        CollUtil.reverse((List)msgBeans);
        pageVO.setList((List)msgBeans);
        pageVO.setPageCount(Integer.valueOf(Math.toIntExact(this.mongoTemplate.count(query, MessageDO.class))));
        return pageVO;
    }

    public PageVO<BaseMsgBean> getCustomChatMessage(Long robotID, Long userID, Long msgReceiverCode, PageVO<BaseMsgBean> pageVO) {
        List messageDOS = this.mongoTemplate.find(new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"mode").is((Object)3), new Criteria().andOperator(new Criteria[]{Criteria.where((String)BASE_MESSAGE_RECEIVE_CODE).is((Object)robotID), Criteria.where((String)"msgReceiverCode").is((Object)msgReceiverCode)})})).with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)BASE_MESSAGE_TIME)})).skip((long)(pageVO.getPageSize() * (pageVO.getPageNum() - 1))).limit(pageVO.getPageSize().intValue()), MessageDO.class);
        ArrayList msgBeans = CollUtil.newArrayList((Object[])new BaseMsgBean[0]);
        messageDOS.forEach(messageDO -> msgBeans.add(this.messageHandler.execute(messageDO.getMsgType(), messageDO)));
        CollUtil.reverse((List)msgBeans);
        pageVO.setList((List)msgBeans);
        pageVO.setPageCount(Integer.valueOf(msgBeans.size()));
        return pageVO;
    }

    public boolean updateVideoUser(Long videoID, String eventType, Long senderCode, String senderResource) {
        EventMsgBean eventMsgBean = new EventMsgBean();
        ArrayList updateList = Lists.newArrayList();
        updateList.add(senderCode);
        this.videoUserMapper.updateVideoUser(videoID, eventMsgBean.getEventType(eventType).ordinal() - 4, DateUtil.now(), updateList);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"videoId", (Object)videoID)).eq((Object)"dataStatus", (Object)5)).last("ORDER BY LAST_TIME");
        List videoUserDOList = this.videoUserMapper.selectList((Wrapper)queryWrapper);
        eventMsgBean.setMode(BaseMsgBean.Mode.GROUPCHAT);
        eventMsgBean.setEventType(eventMsgBean.getEventType(eventType));
        eventMsgBean.setObjID(String.valueOf(IdWorker.getId((Object)eventMsgBean)));
        eventMsgBean.setSenderCode(senderCode.toString());
        eventMsgBean.setSenderResource(senderResource);
        eventMsgBean.setEventTime(DateUtil.now());
        this.groupManageService.sendEventMsg(eventMsgBean, ListUtil.listToString(videoUserDOList.stream().map(v -> v.getUserID() + "").collect(Collectors.toList())));
        return true;
    }

    public List<VideoUserVO> getVideoUser(Long videoID) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"videoId", (Object)videoID)).and(wrapper -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"dataStatus", (Object)4)).or()).eq((Object)"dataStatus", (Object)5);
        })).last("ORDER BY LAST_TIME");
        List videoUserDOList = this.videoUserMapper.selectList((Wrapper)queryWrapper);
        ArrayList<VideoUserVO> list = new ArrayList<VideoUserVO>();
        videoUserDOList.forEach(item -> {
            VideoUserVO videoUserVO = new VideoUserVO();
            BeanUtils.copyProperties((Object)item, (Object)videoUserVO);
            list.add(videoUserVO);
        });
        return list;
    }

    public boolean updateVideoState(Long videoID, String eventType, String mode, Long senderCode, String senderResource) {
        if ("0".equals(mode)) {
            this.updateSingleStatus(videoID);
        } else {
            this.updateGroupVideoCallStatus(videoID, senderCode);
        }
        EventMsgBean eventMsgBean = new EventMsgBean();
        eventMsgBean.setEventType(EventMsgBean.EventType.values()[Integer.parseInt(eventType)]);
        eventMsgBean.setMode(BaseMsgBean.Mode.values()[Integer.parseInt(mode)]);
        eventMsgBean.setSenderCode(senderCode.toString());
        eventMsgBean.setSenderResource(senderResource);
        eventMsgBean.setEventTime(DateUtil.now());
        eventMsgBean.setObjID(String.valueOf(videoID));
        this.groupManageService.sendEventMsg(eventMsgBean, String.valueOf(senderCode));
        return true;
    }

    private void updateSingleStatus(Long videoID) {
        this.mongoTemplate.updateFirst(new Query((CriteriaDefinition)Criteria.where((String)"value").is((Object)videoID)), (UpdateDefinition)Update.update((String)"eventType", (Object)NoticeMsgBean.EventType.VIDEOING.ordinal()), MessageDO.class);
    }

    private void updateGroupVideoCallStatus(Long videoID, Long userID) {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(userID);
        this.videoUserMapper.updateVideoUser(videoID, 5, DateUtil.now(), list);
    }

    public int forwardMessage(Long userID, String userName, Long msgID, List<HashMap<String, String>> receiverList, String objID) {
        FileMsgBean.FileStatus fileStatus;
        MessageFileDO messageFileDO;
        ArticleMsgBean articleMsgBean;
        List userIdList = receiverList.stream().map(userMap -> Long.parseLong((String)userMap.get("userid"))).collect(Collectors.toList());
        List rosterVOList = this.userService.getUserDetailList(userIdList);
        Boolean topManager = true;
        for (RosterVO rosterVO : rosterVOList) {
            if (rosterVO.getTopManager() == null || rosterVO.getTopManager() != 1) continue;
            topManager = false;
            break;
        }
        if (!topManager.booleanValue()) {
            return -1;
        }
        BaseMsgBean baseMsgBean = this.getMessage(msgID);
        baseMsgBean.setSenderCode(userID.toString());
        baseMsgBean.setSenderName(userName);
        baseMsgBean.setMsgTime(DateUtil.now());
        baseMsgBean.setStatus(BaseMsgBean.Status.RECEIVEING);
        baseMsgBean.setRead(BaseMsgBean.Read.UNREAD);
        baseMsgBean.setResource("system");
        if (baseMsgBean.getMsgType().equals((Object)BaseMsgBean.MsgType.ARTICLES) && (articleMsgBean = (ArticleMsgBean)baseMsgBean).getArticles().size() > 1) {
            ArrayList<ArticleBean> articleBeans = new ArrayList<ArticleBean>();
            for (ArticleBean articleBean : articleMsgBean.getArticles()) {
                if (!articleBean.getObjID().equals(objID)) continue;
                articleBeans.add(articleBean);
                break;
            }
            articleMsgBean.setArticles(articleBeans);
        }
        if (baseMsgBean.getMsgType().equals((Object)BaseMsgBean.MsgType.FILETYPE)) {
            baseMsgBean = (FileMsgBean)baseMsgBean;
            messageFileDO = (MessageFileDO)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"msgId").is((Object)Long.parseLong(baseMsgBean.getMsgID()))), MessageFileDO.class);
            if (ToolUtil.isNotEmpty((Object)messageFileDO)) {
                ((FileMsgBean)baseMsgBean).setFileID(String.valueOf(messageFileDO.getFileID()));
                ((FileMsgBean)baseMsgBean).setFileName(messageFileDO.getFileName());
                ((FileMsgBean)baseMsgBean).setFileSize(messageFileDO.getFileSize());
                fileStatus = FileMsgBean.FileStatus.values()[messageFileDO.getFileStatus()];
                ((FileMsgBean)baseMsgBean).setFileStatus(fileStatus);
            }
        } else if (baseMsgBean.getMsgType().equals((Object)BaseMsgBean.MsgType.IMAGE)) {
            baseMsgBean = (ImgMsgBean)baseMsgBean;
            messageFileDO = (MessageFileDO)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"msgId").is((Object)Long.parseLong(baseMsgBean.getMsgID()))), MessageFileDO.class);
            if (ToolUtil.isNotEmpty((Object)messageFileDO)) {
                ((ImgMsgBean)baseMsgBean).setFileID(String.valueOf(messageFileDO.getFileID()));
                ((ImgMsgBean)baseMsgBean).setFileName(messageFileDO.getFileName());
                ((ImgMsgBean)baseMsgBean).setFileSize(String.valueOf(messageFileDO.getFileSize()));
                ((ImgMsgBean)baseMsgBean).setWidth(messageFileDO.getWidth());
                ((ImgMsgBean)baseMsgBean).setHeight(messageFileDO.getHeight());
                fileStatus = ImgMsgBean.FileStatus.values()[messageFileDO.getFileStatus()];
                ((ImgMsgBean)baseMsgBean).setFileStatus((ImgMsgBean.FileStatus)fileStatus);
            }
        } else if (baseMsgBean.getMsgType().equals((Object)BaseMsgBean.MsgType.AUDIO)) {
            baseMsgBean = (VoiceMsgBean)baseMsgBean;
            messageFileDO = (MessageFileDO)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"msgId").is((Object)Long.parseLong(baseMsgBean.getMsgID()))), MessageFileDO.class);
            if (ToolUtil.isNotEmpty((Object)messageFileDO)) {
                ((VoiceMsgBean)baseMsgBean).setFileID(String.valueOf(messageFileDO.getFileID()));
                ((VoiceMsgBean)baseMsgBean).setFileName(messageFileDO.getFileName());
                ((VoiceMsgBean)baseMsgBean).setFileSize(String.valueOf(messageFileDO.getFileSize()));
                ((VoiceMsgBean)baseMsgBean).setLength(messageFileDO.getLength());
                fileStatus = VoiceMsgBean.FileStatus.values()[messageFileDO.getFileStatus()];
                ((VoiceMsgBean)baseMsgBean).setFileStatus((VoiceMsgBean.FileStatus)fileStatus);
            }
        } else if (baseMsgBean.getMsgType().equals((Object)BaseMsgBean.MsgType.LOCATION)) {
            baseMsgBean = (LocationMsgBean)baseMsgBean;
            messageFileDO = (MessageFileDO)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"msgId").is((Object)Long.parseLong(baseMsgBean.getMsgID()))), MessageFileDO.class);
            if (ToolUtil.isNotEmpty((Object)messageFileDO)) {
                ((LocationMsgBean)baseMsgBean).setThumbnailId(messageFileDO.getFileID());
            }
        }
        boolean flag = false;
        for (HashMap<String, String> receiverMap : receiverList) {
            baseMsgBean.setMsgID(String.valueOf(IdWorker.getId((Object)baseMsgBean)));
            baseMsgBean.setReceiverCode(receiverMap.get("userid"));
            baseMsgBean.setReceiverName(receiverMap.get("name"));
            String type = receiverMap.get("type");
            if ("user".equals(type)) {
                baseMsgBean.setMode(BaseMsgBean.Mode.CHAT);
            } else if ("group".equals(type) || "organise".equals(type)) {
                baseMsgBean.setMode(BaseMsgBean.Mode.GROUPCHAT);
            }
            if (baseMsgBean.getMsgType().equals((Object)BaseMsgBean.MsgType.ARTICLES)) {
                ArticleMsgBean articleMsgBean2 = (ArticleMsgBean)baseMsgBean;
                ((ArticleBean)articleMsgBean2.getArticles().get(0)).setObjID(String.valueOf(IdWorker.getId(articleMsgBean2.getArticles().get(0))));
            }
            PushMessageDTO pushMessageDTO = new PushMessageDTO();
            pushMessageDTO.setBaseMsgBean(baseMsgBean);
            pushMessageDTO.setMode(baseMsgBean.getMode());
            pushMessageDTO.setMsgType(baseMsgBean.getMsgType());
            flag = this.pushService.sendMessage(pushMessageDTO);
        }
        if (!flag) {
            return -2;
        }
        return 0;
    }

    public BaseMsgBean getMessage(Long msgID) {
        MessageDO messageDO = (MessageDO)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"msgID").is((Object)msgID.toString())), MessageDO.class);
        if (messageDO == null) {
            return null;
        }
        return this.messageHandler.execute(messageDO.getMsgType(), messageDO);
    }

    public boolean updateTime(Long userID, String objID, String lastMsgTime, String mode, String action, String resource) {
        Long objId = null;
        int intmond = 0;
        if (mode.equals("GROUPCHAT") || mode.equals("1")) {
            intmond = 1;
            objId = Long.parseLong(objID);
        } else if (mode.equals("PUBPLAT") || mode.equals("2")) {
            intmond = 2;
            objId = Long.parseLong(objID);
        } else {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(SysUsers::getId, (Object)objID)).or()).eq(SysUsers::getChar1, (Object)objID);
            List sysUsersList = this.sysUsersService.list((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isEmpty((Collection)sysUsersList)) {
                return false;
            }
            objId = ((SysUsers)sysUsersList.get(0)).getId();
        }
        int entype = 1;
        if ("0".equals(action)) {
            entype = 2;
        } else if ("2".equals(action)) {
            entype = 3;
        }
        long updateTime = System.currentTimeMillis();
        String updateTimeStr = DateUtil.now();
        String type = "2".equals(action) ? "del" : "read";
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userID").is((Object)userID.toString()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"objID").is((Object)objId.toString()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type));
        List timeList = this.mongoTemplate.find(query, TimeDO.class);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (CollUtil.isEmpty((Collection)timeList)) {
            TimeDO time = new TimeDO();
            time.setObjID(objId.toString());
            time.setUserID(userID.toString());
            time.setMode(mode);
            time.setType(type);
            try {
                time.setTime(Long.valueOf(sdf.parse(updateTimeStr).getTime()));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            this.mongoTemplate.insert((Object)time);
        } else {
            Update update = Update.update((String)"time", (Object)updateTime);
            this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, TimeDO.class);
        }
        EventMsgBean msg = new EventMsgBean();
        msg.setMode(BaseMsgBean.Mode.values()[intmond]);
        msg.setEventType(EventMsgBean.EventType.values()[entype]);
        msg.setEventTime(updateTimeStr);
        msg.setObjID(String.valueOf(objId));
        msg.setSenderCode(userID.toString());
        msg.setSenderResource(resource);
        PushEventMessageDTO pushEventMessageDTO = new PushEventMessageDTO();
        pushEventMessageDTO.setMsg(msg);
        pushEventMessageDTO.setUserID(String.valueOf(userID));
        this.pushService.sendEventMessage(pushEventMessageDTO);
        return true;
    }

    public Result<Boolean> withDrawMessage(WithDrawMsgBean withDrawMsgBean, int withDrawMinutes) {
        boolean flag;
        BaseMsgBean message = this.getMessage(Long.parseLong(withDrawMsgBean.getObjMsgID()));
        if (message == null) {
            return Result.failed((String)"\u88ab\u64a4\u56de\u6d88\u606f\u4e0d\u5b58\u5728");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null) {
            return Result.failed((String)"\u7528\u6237\u672a\u767b\u5f55");
        }
        if (message.getMode() == BaseMsgBean.Mode.PUBPLAT) {
            boolean hasManagePermission = this.checkUserManageApp(message.getReceiverCode());
            if (!hasManagePermission) {
                return Result.failed((String)"\u60a8\u6ca1\u6709\u7ba1\u7406\u8be5\u5fae\u5e94\u7528\u7684\u6743\u9650");
            }
        } else {
            int minute;
            String currentUserCode = String.valueOf(user.getId());
            boolean isMessageSender = currentUserCode.equals(message.getSenderCode());
            if (!isMessageSender) {
                return Result.failed((String)"\u53ea\u80fd\u64a4\u56de\u81ea\u5df1\u53d1\u9001\u7684\u6d88\u606f");
            }
            int n = minute = withDrawMinutes <= 0 ? 3 : withDrawMinutes;
            if (minute != Integer.MAX_VALUE && System.currentTimeMillis() - DateUtil.parse((CharSequence)message.getMsgTime(), (String)"yyyy-MM-dd HH:mm:ss:SSS").getTime() > (long)minute * 60L * 1000L) {
                return Result.failed((String)("\u53ea\u80fd\u64a4\u56de\u53d1\u9001\u65f6\u95f4" + minute + "\u5206\u949f\u7684\u6d88\u606f"));
            }
        }
        BeanUtils.copyProperties((Object)message, (Object)withDrawMsgBean);
        withDrawMsgBean.setMsgTime(DateUtil.now());
        withDrawMsgBean.setMsgID(String.valueOf(IdWorker.getId((Object)withDrawMsgBean)));
        withDrawMsgBean.setBody(message.getSenderName() + "\u64a4\u56de\u4e86\u4e00\u6761\u6d88\u606f");
        withDrawMsgBean.setSenderCode(message.getSenderCode());
        withDrawMsgBean.setSenderName(message.getSenderName());
        withDrawMsgBean.setReceiverCode(message.getReceiverCode());
        withDrawMsgBean.setReceiverName(message.getReceiverName());
        withDrawMsgBean.setStatus(message.getStatus());
        withDrawMsgBean.setMsgType(BaseMsgBean.MsgType.WITHDRAW);
        withDrawMsgBean.setMode(message.getMode());
        withDrawMsgBean.setRead(message.getRead());
        withDrawMsgBean.setShowOrder(message.getShowOrder());
        withDrawMsgBean.setResource(message.getResource());
        withDrawMsgBean.setObjMsgID(message.getMsgID());
        withDrawMsgBean.setObjBody(message.getBody());
        withDrawMsgBean.setObjMsgType(message.getMsgType());
        withDrawMsgBean.setObjMsgTime(message.getMsgTime());
        PushMessageDTO pushMessageDTO = new PushMessageDTO();
        pushMessageDTO.setBaseMsgBean((BaseMsgBean)withDrawMsgBean);
        if (withDrawMsgBean.getMode() == BaseMsgBean.Mode.PUBPLAT) {
            pushMessageDTO.setReceiverIds(withDrawMsgBean.getPubplatReceiverCode());
            pushMessageDTO.setMode(withDrawMsgBean.getMode());
        }
        pushMessageDTO.setMsgType(BaseMsgBean.MsgType.WITHDRAW);
        long msgCount = this.mongoTemplate.count(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"msgID").is((Object)withDrawMsgBean.getObjMsgID())), MessageDO.class);
        if (msgCount > 0L && (flag = this.pushService.sendMessage(pushMessageDTO).booleanValue())) {
            if (withDrawMsgBean.getObjMsgType() == BaseMsgBean.MsgType.ARTICLES) {
                this.mongoTemplate.remove(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"articleMsgId").is((Object)withDrawMsgBean.getObjMsgID())), MessageArticleDO.class);
            } else if (withDrawMsgBean.getObjMsgType() == BaseMsgBean.MsgType.IMAGE || withDrawMsgBean.getObjMsgType() == BaseMsgBean.MsgType.AUDIO || withDrawMsgBean.getObjMsgType() == BaseMsgBean.MsgType.FILETYPE) {
                this.mongoTemplate.remove(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"msgId").is((Object)withDrawMsgBean.getObjMsgID())), MessageFileDO.class);
                HussarCacheUtil.evict((String)"eim_cache", (Object)("eim_message_file:" + withDrawMsgBean.getObjMsgID()));
            }
            this.mongoTemplate.remove(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"msgID").is((Object)withDrawMsgBean.getObjMsgID())), MessageDO.class);
            this.mongoTemplate.remove(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"msgID").is((Object)withDrawMsgBean.getObjMsgID())), MessageOffline.class);
        }
        return Result.succeed((Object)true);
    }

    private boolean checkUserManageApp(String receiverCode) {
        try {
            if (StrUtil.isBlank((CharSequence)receiverCode)) {
                return false;
            }
            Result result = this.pubPlatService.getPageList(null, 1, Integer.MAX_VALUE, null, "8,19");
            if (result == null || !result.getSuccess().booleanValue() || result.getData() == null) {
                return false;
            }
            List appList = ((Page)result.getData()).getRecords();
            if (CollUtil.isEmpty((Collection)appList)) {
                return false;
            }
            return appList.stream().anyMatch(app -> receiverCode.equals(String.valueOf(app.getId())));
        }
        catch (Exception e) {
            log.error("\u68c0\u67e5\u7528\u6237\u7ba1\u7406\u5fae\u5e94\u7528\u6743\u9650\u65f6\u53d1\u751f\u5f02\u5e38\uff0creceiverCode: {}", (Object)receiverCode, (Object)e);
            return false;
        }
    }

    public PageVO<SingleMessageVO> getAllSinglePeople(PageVO<SingleMessageVO> singleMessageVOPageVO, String searchKey) {
        List allUsers = this.hussarBaseUserBoService.list().stream().map(SysUsers::getId).map(String::valueOf).collect(Collectors.toList());
        List messageDOList = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"mode").is((Object)0)), MessageDO.class);
        HashSet<Long> userIDSet = new HashSet<Long>();
        messageDOList = messageDOList.stream().filter(a -> ToolUtil.isNotEmpty((Object)a.getSenderCode()) && ToolUtil.isNotEmpty((Object)a.getReceiverCode())).collect(Collectors.toList());
        for (MessageDO messageDO : messageDOList) {
            try {
                userIDSet.add(Long.parseLong(messageDO.getSenderCode()));
            }
            catch (Exception e) {
                userIDSet.add(0L);
            }
            try {
                userIDSet.add(Long.parseLong(messageDO.getReceiverCode()));
            }
            catch (Exception e) {
                userIDSet.add(0L);
            }
        }
        List rosterVOList = this.organizationService.queryUserByUserID((List)CollUtil.newArrayList(userIDSet.iterator()), searchKey, "", "", 1, -1);
        if (CollUtil.isEmpty((Collection)rosterVOList)) {
            singleMessageVOPageVO.setPageCount(Integer.valueOf(0));
            singleMessageVOPageVO.setList(null);
            return singleMessageVOPageVO;
        }
        singleMessageVOPageVO.setPageCount(Integer.valueOf(rosterVOList.size()));
        int start = PageUtil.transToStartEnd((int)singleMessageVOPageVO.getPageNum(), (int)singleMessageVOPageVO.getPageSize())[0];
        int end = PageUtil.transToStartEnd((int)singleMessageVOPageVO.getPageNum(), (int)singleMessageVOPageVO.getPageSize())[1];
        rosterVOList = rosterVOList.subList(start, Math.min(end, rosterVOList.size()));
        List userIDs = rosterVOList.stream().map(UserStaffVo::getId).collect(Collectors.toList());
        Aggregation senderAggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"mode").is((Object)0), Criteria.where((String)BASE_MESSAGE_RECEIVE_CODE).in((Collection)userIDs.stream().map(String::valueOf).collect(Collectors.toList()))})), Aggregation.group((String[])new String[]{BASE_MESSAGE_RECEIVE_CODE}).last(BASE_MESSAGE_RECEIVE_CODE).as("userID").last("receiverName").as("userName").count().as("messageNum").max(BASE_MESSAGE_TIME).as(BASE_MESSAGE_TIME)});
        ArrayList<SingleMessageVO> senderSingleMessageVOS = new ArrayList<SingleMessageVO>(this.mongoTemplate.aggregate(senderAggregation, "message", SingleMessageVO.class).getMappedResults());
        Aggregation receiverAggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"mode").is((Object)0), Criteria.where((String)BASE_MESSAGE_SENDER_CODE).in((Collection)userIDs.stream().map(String::valueOf).collect(Collectors.toList()))})), Aggregation.group((String[])new String[]{BASE_MESSAGE_SENDER_CODE}).last(BASE_MESSAGE_SENDER_CODE).as("userID").last("senderName").as("userName").count().as("messageNum").max(BASE_MESSAGE_TIME).as(BASE_MESSAGE_TIME)});
        List receiverSingleMessageVOS = this.mongoTemplate.aggregate(receiverAggregation, "message", SingleMessageVO.class).getMappedResults();
        List senderIDList = senderSingleMessageVOS.stream().map(SingleMessageVO::getUserID).collect(Collectors.toList());
        senderSingleMessageVOS.forEach(singleMessageVO -> receiverSingleMessageVOS.forEach(receiverSingleMessage -> {
            if (singleMessageVO.getUserID().equals(receiverSingleMessage.getUserID())) {
                singleMessageVO.setMessageNum(Integer.valueOf(singleMessageVO.getMessageNum() + receiverSingleMessage.getMessageNum()));
                Long msgTime1 = singleMessageVO.getMsgTime();
                Long msgTime2 = receiverSingleMessage.getMsgTime();
                if (msgTime1 >= msgTime2) {
                    singleMessageVO.setMsgTime(msgTime1);
                } else {
                    singleMessageVO.setMsgTime(msgTime2);
                }
            }
        }));
        for (SingleMessageVO receiverSingleMessage : receiverSingleMessageVOS) {
            if (senderIDList.contains(receiverSingleMessage.getUserID())) continue;
            senderSingleMessageVOS.add(receiverSingleMessage);
        }
        for (SingleMessageVO senderSingleMessageVO : senderSingleMessageVOS) {
            Long msgTime = senderSingleMessageVO.getMsgTime();
            if (!HussarUtils.isNotEmpty((Object)msgTime)) continue;
            senderSingleMessageVO.setLastMessageTime(DateUtil.format((Date)DateUtil.date((long)msgTime), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        Aggregation senderContactNumAggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"mode").is((Object)0), Criteria.where((String)BASE_MESSAGE_SENDER_CODE).in((Collection)userIDs.stream().map(String::valueOf).collect(Collectors.toList()))})), Aggregation.group((String[])new String[]{BASE_MESSAGE_SENDER_CODE}).addToSet(BASE_MESSAGE_RECEIVE_CODE).as("userIDSet").last(BASE_MESSAGE_SENDER_CODE).as("contactCode")});
        List senderContactNumMapList = this.mongoTemplate.aggregate(senderContactNumAggregation, "message", HashMap.class).getMappedResults();
        Aggregation receiverContactNumAggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"mode").is((Object)0), Criteria.where((String)BASE_MESSAGE_RECEIVE_CODE).in((Collection)userIDs.stream().map(String::valueOf).collect(Collectors.toList()))})), Aggregation.group((String[])new String[]{BASE_MESSAGE_RECEIVE_CODE}).addToSet(BASE_MESSAGE_SENDER_CODE).as("userIDSet").last(BASE_MESSAGE_RECEIVE_CODE).as("contactCode")});
        List receiverContactNumMapList = this.mongoTemplate.aggregate(receiverContactNumAggregation, "message", HashMap.class).getMappedResults();
        receiverContactNumMapList.forEach(receiverHashMap -> senderContactNumMapList.forEach(senderHashMap -> {
            if (senderHashMap.get("contactCode").equals(receiverHashMap.get("contactCode"))) {
                ((List)senderHashMap.get("userIDSet")).forEach(senderID -> {
                    HashSet set = new HashSet((List)receiverHashMap.get("userIDSet"));
                    if (!set.contains(senderID)) {
                        ((List)receiverHashMap.get("userIDSet")).add(String.valueOf(senderID));
                    }
                });
            }
        }));
        ArrayList<HashMap> resultContactNumList = new ArrayList<HashMap>(receiverContactNumMapList);
        for (HashMap map : senderContactNumMapList) {
            if (senderIDList.contains(map.get("contactCode"))) continue;
            resultContactNumList.add(map);
        }
        for (SingleMessageVO senderSingleMessageVO : senderSingleMessageVOS) {
            try {
                List tempList = messageDOList.stream().filter(a -> (a.getSenderCode().equals(senderSingleMessageVO.getUserID().toString()) || a.getReceiverCode().equals(senderSingleMessageVO.getUserID().toString())) && a.getReceiverCode().equals(a.getSenderCode())).collect(Collectors.toList());
                List tempList2 = messageDOList.stream().filter(a -> !(!a.getSenderCode().equals(senderSingleMessageVO.getUserID().toString()) && !a.getReceiverCode().equals(senderSingleMessageVO.getUserID().toString()) || allUsers.contains(a.getReceiverCode()) && allUsers.contains(a.getSenderCode()))).collect(Collectors.toList());
                senderSingleMessageVO.setMessageNum(Integer.valueOf(senderSingleMessageVO.getMessageNum() - tempList.size() - tempList2.size()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList resultSingleMessageVOS = new ArrayList(senderSingleMessageVOS);
        List finalRosterVOList = rosterVOList;
        resultSingleMessageVOS.forEach(singleMessageVO -> {
            finalRosterVOList.forEach(rosterVO -> {
                if (singleMessageVO.getUserID().equals(rosterVO.getId())) {
                    singleMessageVO.setJobNum(rosterVO.getWorkId());
                }
            });
            List mapList = resultContactNumList.stream().filter(a -> singleMessageVO.getUserID().equals((long)Double.parseDouble(a.get("contactCode") + ""))).collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(mapList)) {
                if (mapList.size() == 1) {
                    singleMessageVO.setConcatNum(Integer.valueOf(((ArrayList)((HashMap)mapList.get(0)).get("userIDSet")).size()));
                } else if (mapList.size() == 2) {
                    ArrayList list1 = (ArrayList)((HashMap)mapList.get(0)).get("userIDSet");
                    ArrayList list2 = (ArrayList)((HashMap)mapList.get(1)).get("userIDSet");
                    list1 = (ArrayList)list1.stream().filter(allUsers::contains).collect(Collectors.toList());
                    list2 = (ArrayList)list2.stream().filter(allUsers::contains).collect(Collectors.toList());
                    HashSet set1 = new HashSet(list1);
                    HashSet set2 = new HashSet(list2);
                    set2.removeAll(set1);
                    singleMessageVO.setConcatNum(Integer.valueOf(set1.size() + set2.size()));
                }
            }
        });
        for (SingleMessageVO singleMessageVO2 : resultSingleMessageVOS) {
            if (singleMessageVO2.getJobNum() != null) continue;
            singleMessageVOPageVO.setList(resultSingleMessageVOS);
            return singleMessageVOPageVO;
        }
        singleMessageVOPageVO.setList(resultSingleMessageVOS.stream().sorted(Comparator.comparing(SingleMessageVO::getJobNum)).collect(Collectors.toList()));
        return singleMessageVOPageVO;
    }

    public PageVO<SingleMessageVO> getSinglePeopleList(PageVO<SingleMessageVO> singleMessageVOPageVO, String searchKey, Long userID) {
        List<MessageDO> messageDOList = this.mongoTemplate.find(new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"mode").is((Object)0), new Criteria().orOperator(new Criteria[]{Criteria.where((String)BASE_MESSAGE_SENDER_CODE).is((Object)userID.toString()), Criteria.where((String)BASE_MESSAGE_RECEIVE_CODE).is((Object)userID.toString())})})), MessageDO.class);
        messageDOList = messageDOList.stream().filter(a -> ToolUtil.isNotEmpty((Object)a.getSenderCode()) && ToolUtil.isNotEmpty((Object)a.getReceiverCode())).collect(Collectors.toList());
        int count = 0;
        for (MessageDO messageDO2 : messageDOList) {
            if (!ToolUtil.isNotEmpty((Object)messageDO2.getSenderCode()) || !ToolUtil.isNotEmpty((Object)messageDO2.getReceiverCode()) || !messageDO2.getSenderCode().equals(messageDO2.getReceiverCode())) continue;
            ++count;
        }
        HashSet userIDSet = new HashSet();
        messageDOList.forEach(messageDO -> userIDSet.add(Long.parseLong(messageDO.getSenderCode())));
        messageDOList.forEach(messageDO -> userIDSet.add(Long.parseLong(messageDO.getReceiverCode())));
        if (count == 0) {
            userIDSet.remove(userID);
        }
        List rosterVOList = this.organizationService.queryUserByUserID((List)CollUtil.newArrayList(userIDSet.iterator()), searchKey, "", "", 1, -1);
        singleMessageVOPageVO.setPageCount(Integer.valueOf(rosterVOList.size()));
        int start = PageUtil.transToStartEnd((int)singleMessageVOPageVO.getPageNum(), (int)singleMessageVOPageVO.getPageSize())[0];
        int end = PageUtil.transToStartEnd((int)singleMessageVOPageVO.getPageNum(), (int)singleMessageVOPageVO.getPageSize())[1];
        rosterVOList = rosterVOList.subList(start, Math.min(end, rosterVOList.size()));
        List userIDs = rosterVOList.stream().map(UserStaffVo::getId).collect(Collectors.toList());
        Aggregation senderAggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"mode").is((Object)0), Criteria.where((String)BASE_MESSAGE_RECEIVE_CODE).in((Collection)userIDs.stream().map(String::valueOf).collect(Collectors.toList())), Criteria.where((String)BASE_MESSAGE_SENDER_CODE).is((Object)userID.toString())})), Aggregation.group((String[])new String[]{BASE_MESSAGE_RECEIVE_CODE}).last(BASE_MESSAGE_RECEIVE_CODE).as("userID").last("receiverName").as("userName").count().as("messageNum").max(BASE_MESSAGE_TIME).as(BASE_MESSAGE_TIME)});
        ArrayList<SingleMessageVO> senderSingleMessageVOS = new ArrayList<SingleMessageVO>(this.mongoTemplate.aggregate(senderAggregation, "message", SingleMessageVO.class).getMappedResults());
        Aggregation receiverAggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"mode").is((Object)0), Criteria.where((String)BASE_MESSAGE_SENDER_CODE).in((Collection)userIDs.stream().map(String::valueOf).collect(Collectors.toList())), Criteria.where((String)BASE_MESSAGE_RECEIVE_CODE).is((Object)userID.toString())})), Aggregation.group((String[])new String[]{BASE_MESSAGE_SENDER_CODE}).last(BASE_MESSAGE_SENDER_CODE).as("userID").last("senderName").as("userName").count().as("messageNum").max(BASE_MESSAGE_TIME).as(BASE_MESSAGE_TIME)});
        ArrayList receiverSingleMessageVOS = new ArrayList(this.mongoTemplate.aggregate(receiverAggregation, "message", SingleMessageVO.class).getMappedResults());
        List finalRosterVOList = rosterVOList;
        List senderIDList = senderSingleMessageVOS.stream().map(SingleMessageVO::getUserID).collect(Collectors.toList());
        senderSingleMessageVOS.forEach(singleMessageVO -> receiverSingleMessageVOS.forEach(receiverSingleMessage -> {
            if (singleMessageVO.getUserID().equals(receiverSingleMessage.getUserID())) {
                singleMessageVO.setMessageNum(Integer.valueOf(singleMessageVO.getMessageNum() + receiverSingleMessage.getMessageNum()));
                singleMessageVO.setLastMessageTime(String.valueOf(Math.max(singleMessageVO.getMsgTime(), receiverSingleMessage.getMsgTime())));
            }
        }));
        for (SingleMessageVO receiverSingleMessage : receiverSingleMessageVOS) {
            if (senderIDList.contains(receiverSingleMessage.getUserID())) continue;
            senderSingleMessageVOS.add(receiverSingleMessage);
        }
        for (SingleMessageVO senderSingleMessageVO : senderSingleMessageVOS) {
            if (!senderSingleMessageVO.getUserID().equals(userID)) continue;
            senderSingleMessageVO.setMessageNum(Integer.valueOf(senderSingleMessageVO.getMessageNum() - count));
        }
        ArrayList resultSingleMessageVOS = new ArrayList(senderSingleMessageVOS);
        resultSingleMessageVOS.forEach(singleMessageVO -> {
            finalRosterVOList.forEach(rosterVO -> {
                if (singleMessageVO.getUserID().equals(rosterVO.getId())) {
                    singleMessageVO.setJobNum(rosterVO.getWorkId());
                }
            });
            singleMessageVO.setLastMessageTime(DateUtil.date((long)singleMessageVO.getMsgTime()).toDateStr());
        });
        for (SingleMessageVO singleMessageVO2 : resultSingleMessageVOS) {
            if (singleMessageVO2.getJobNum() != null) continue;
            singleMessageVOPageVO.setList(resultSingleMessageVOS);
            return singleMessageVOPageVO;
        }
        singleMessageVOPageVO.setList(senderSingleMessageVOS.stream().sorted(Comparator.comparing(SingleMessageVO::getJobNum)).collect(Collectors.toList()));
        return singleMessageVOPageVO;
    }

    public PageVO<FileVO> getGroupMessageFile(Long groupID, String searchKey, PageVO<FileVO> pageVO) {
        ArrayList fileMsgBeanTypeList = CollUtil.newArrayList((Object[])new Integer[0]);
        fileMsgBeanTypeList.add(BaseMsgBean.MsgType.IMAGE.ordinal());
        fileMsgBeanTypeList.add(BaseMsgBean.MsgType.FILETYPE.ordinal());
        Pattern pattern = Pattern.compile("^.*" + searchKey + ".*$", 2);
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria.andOperator(new Criteria[]{Criteria.where((String)BASE_MESSAGE_RECEIVE_CODE).is((Object)groupID.toString()).and("mode").is((Object)1), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"msgType").in((Collection)fileMsgBeanTypeList)})})).with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)BASE_MESSAGE_TIME)}));
        pageVO.setPageCount(Integer.valueOf((int)this.mongoTemplate.count(query, "message")));
        List messageDOS = this.mongoTemplate.find(query.skip((long)(pageVO.getPageSize() * (pageVO.getPageNum() - 1))).limit(pageVO.getPageSize().intValue()), MessageDO.class);
        ArrayList msgBeans = CollUtil.newArrayList((Object[])new BaseMsgBean[0]);
        messageDOS.forEach(messageDO -> msgBeans.add(this.messageHandler.execute(messageDO.getMsgType(), messageDO)));
        CollUtil.reverse((List)msgBeans);
        ArrayList fileVOList = CollUtil.newArrayList((Object[])new FileVO[0]);
        Criteria fileCriteria = Criteria.where((String)"msgId").in((Collection)msgBeans.stream().map(BaseMsgBean::getMsgID).map(Long::parseLong).collect(Collectors.toList()));
        query = !StrUtil.isEmpty((CharSequence)searchKey) ? new Query((CriteriaDefinition)fileCriteria.andOperator(new Criteria[]{Criteria.where((String)"fileName").regex(pattern)})) : new Query((CriteriaDefinition)fileCriteria);
        List messageFileDO = this.mongoTemplate.find(query, MessageFileDO.class);
        List<Object> tempMsgBeans = msgBeans;
        tempMsgBeans = tempMsgBeans.stream().filter(a -> {
            List temp = messageFileDO.stream().filter(b -> String.valueOf(b.getMsgID()).equals(a.getMsgID())).collect(Collectors.toList());
            return ToolUtil.isNotEmpty(temp);
        }).collect(Collectors.toList());
        tempMsgBeans.forEach(baseMsgBean -> {
            FileVO fileVO = new FileVO();
            List tempFile = messageFileDO.stream().filter(a -> String.valueOf(a.getMsgID()).equals(baseMsgBean.getMsgID())).collect(Collectors.toList());
            fileVO.setMsgID(Long.valueOf(Long.parseLong(baseMsgBean.getMsgID())));
            fileVO.setUserID(Long.valueOf(Long.parseLong(baseMsgBean.getSenderCode())));
            fileVO.setUserName(baseMsgBean.getSenderName());
            fileVO.setCreateTime(baseMsgBean.getMsgTime());
            if (baseMsgBean.getMsgType().ordinal() == BaseMsgBean.MsgType.AUDIO.ordinal()) {
                VoiceMsgBean voiceMsgBean = (VoiceMsgBean)baseMsgBean;
                fileVO.setFileName(voiceMsgBean.getFileName());
                fileVO.setFileSize(Double.valueOf(voiceMsgBean.getFileSize()));
            }
            if (baseMsgBean.getMsgType().ordinal() == BaseMsgBean.MsgType.IMAGE.ordinal()) {
                ImgMsgBean imgMsgBean = (ImgMsgBean)baseMsgBean;
                fileVO.setFileName(imgMsgBean.getFileName());
                fileVO.setFileSize(Double.valueOf(imgMsgBean.getFileSize() == null ? "0" : imgMsgBean.getFileSize()));
            }
            if (baseMsgBean.getMsgType().ordinal() == BaseMsgBean.MsgType.FILETYPE.ordinal()) {
                FileMsgBean fileMsgBean = (FileMsgBean)baseMsgBean;
                fileVO.setFileName(fileMsgBean.getFileName());
                fileVO.setFileSize(Double.valueOf(fileMsgBean.getFileSize()));
            }
            if (ToolUtil.isNotEmpty(tempFile)) {
                MessageFileDO temp = (MessageFileDO)tempFile.get(0);
                fileVO.setFileID(temp.getFileID());
                fileVO.setFileName(temp.getFileName());
                fileVO.setFileSize(Double.valueOf(temp.getFileSize()));
                fileVO.setFileStatus(String.valueOf(temp.getFileStatus()));
                FileVO.FileType[] types = FileVO.FileType.values();
                fileVO.setFileType(types[temp.getFileType()]);
                fileVO.setMd5(temp.getMd5());
            }
            fileVOList.add(fileVO);
        });
        pageVO.setList((List)fileVOList);
        return pageVO;
    }

    public PageVO<FileVO> getMessageFileList(PageVO<FileVO> pageVO, String searchKey, Integer mode) {
        ArrayList fileMsgBeanTypeList = CollUtil.newArrayList((Object[])new Integer[0]);
        fileMsgBeanTypeList.add(BaseMsgBean.MsgType.AUDIO.ordinal());
        fileMsgBeanTypeList.add(BaseMsgBean.MsgType.IMAGE.ordinal());
        fileMsgBeanTypeList.add(BaseMsgBean.MsgType.FILETYPE.ordinal());
        fileMsgBeanTypeList.add(BaseMsgBean.MsgType.LOCATION.ordinal());
        Pattern pattern = Pattern.compile("^.*" + searchKey + ".*$", 2);
        Criteria fileCriteria = new Criteria();
        Criteria criteria = new Criteria();
        if (mode != null) {
            criteria = Criteria.where((String)"mode").is((Object)mode);
        }
        if (!StrUtil.isEmpty((CharSequence)searchKey)) {
            fileCriteria = Criteria.where((String)"fileName").regex(pattern);
        }
        List messageFileDO = this.mongoTemplate.find(new Query((CriteriaDefinition)fileCriteria), MessageFileDO.class);
        criteria = criteria.andOperator(new Criteria[]{Criteria.where((String)"msgId").in((Collection)messageFileDO.stream().map(MessageFileDO::getMsgID).map(String::valueOf).collect(Collectors.toList())), Criteria.where((String)"msgType").in((Collection)fileMsgBeanTypeList)});
        pageVO.setPageCount(Integer.valueOf(Math.toIntExact(this.mongoTemplate.count(new Query((CriteriaDefinition)criteria), "message"))));
        List messageDOS = this.mongoTemplate.find(new Query((CriteriaDefinition)criteria).with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)BASE_MESSAGE_TIME)})).skip((long)(pageVO.getPageSize() * (pageVO.getPageNum() - 1))).limit(pageVO.getPageSize().intValue()), MessageDO.class);
        ArrayList msgBeans = CollUtil.newArrayList((Object[])new BaseMsgBean[0]);
        messageDOS.forEach(messageDO -> msgBeans.add(this.messageHandler.execute(messageDO.getMsgType(), messageDO)));
        ArrayList fileVOList = CollUtil.newArrayList((Object[])new FileVO[0]);
        msgBeans.forEach(baseMsgBean -> {
            List tempFile = messageFileDO.stream().filter(a -> String.valueOf(a.getMsgID()).equals(baseMsgBean.getMsgID())).collect(Collectors.toList());
            FileVO fileVO = new FileVO();
            fileVO.setMsgID(Long.valueOf(Long.parseLong(baseMsgBean.getMsgID())));
            try {
                Long userId = baseMsgBean.getSenderCode().equalsIgnoreCase("admin") ? 0L : Long.parseLong(baseMsgBean.getSenderCode());
                fileVO.setUserID(userId);
                fileVO.setUserName(baseMsgBean.getSenderName());
                fileVO.setCreateTime(baseMsgBean.getMsgTime());
                if (baseMsgBean.getMsgType().ordinal() == BaseMsgBean.MsgType.AUDIO.ordinal()) {
                    VoiceMsgBean voiceMsgBean = (VoiceMsgBean)baseMsgBean;
                    fileVO.setFileName(voiceMsgBean.getFileName());
                    fileVO.setFileSize(Double.valueOf(voiceMsgBean.getFileSize() == null ? "0" : voiceMsgBean.getFileSize()));
                }
                if (baseMsgBean.getMsgType().ordinal() == BaseMsgBean.MsgType.IMAGE.ordinal()) {
                    ImgMsgBean imgMsgBean = (ImgMsgBean)baseMsgBean;
                    fileVO.setFileName(imgMsgBean.getFileName());
                    fileVO.setFileSize(Double.valueOf(imgMsgBean.getFileSize() == null ? "0" : imgMsgBean.getFileSize()));
                }
                if (baseMsgBean.getMsgType().ordinal() == BaseMsgBean.MsgType.FILETYPE.ordinal()) {
                    FileMsgBean fileMsgBean = (FileMsgBean)baseMsgBean;
                    fileVO.setFileName(fileMsgBean.getFileName());
                    fileVO.setFileSize(Double.valueOf(fileMsgBean.getFileSize() == 0.0f ? 0.0f : fileMsgBean.getFileSize()));
                }
                if (baseMsgBean.getMsgType().ordinal() == BaseMsgBean.MsgType.LOCATION.ordinal()) {
                    LocationMsgBean locationMsgBean = (LocationMsgBean)baseMsgBean;
                    fileVO.setFileID(locationMsgBean.getThumbnailId());
                    fileVO.setFileName(locationMsgBean.getThumbnailName());
                    fileVO.setFileSize(Double.valueOf(locationMsgBean.getFileSize() == null ? "0" : locationMsgBean.getFileSize()));
                }
                if (ToolUtil.isNotEmpty(tempFile)) {
                    MessageFileDO temp = (MessageFileDO)tempFile.get(0);
                    fileVO.setFileID(temp.getFileID());
                    fileVO.setFileName(temp.getFileName());
                    fileVO.setFileSize(Double.valueOf(temp.getFileSize()));
                    fileVO.setFileStatus(String.valueOf(temp.getFileStatus()));
                    FileVO.FileType[] types = FileVO.FileType.values();
                    fileVO.setFileType(types[temp.getFileType()]);
                    fileVO.setMd5(temp.getMd5());
                }
                fileVOList.add(fileVO);
            }
            catch (Exception e) {
                log.error("senderCode:" + baseMsgBean.getSenderCode() + "\u8f6clong\u5931\u8d25");
            }
        });
        pageVO.setList((List)fileVOList);
        return pageVO;
    }

    public Boolean deleteSingleHistory(Long friendID, Long userID) {
        Query query = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"mode").is((Object)0), new Criteria().orOperator(new Criteria[]{Criteria.where((String)BASE_MESSAGE_RECEIVE_CODE).is((Object)String.valueOf(friendID)).and(BASE_MESSAGE_SENDER_CODE).is((Object)String.valueOf(userID)), Criteria.where((String)BASE_MESSAGE_SENDER_CODE).is((Object)String.valueOf(friendID)).and(BASE_MESSAGE_RECEIVE_CODE).is((Object)String.valueOf(userID))})}));
        this.mongoTemplate.remove(query, "message");
        this.mongoTemplate.remove(query, "messageOffline");
        return true;
    }

    public Boolean deleteMessageFile(String msgId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"msgID").is((Object)msgId));
        this.mongoTemplate.remove(query, "message");
        this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"msgId").is((Object)msgId)), "messagefile");
        HussarCacheUtil.evict((String)"eim_cache", (Object)("eim_message_file:" + msgId));
        this.mongoTemplate.remove(query, "messageOffline");
        return true;
    }

    public Map<String, Object> getPubplatSenderCode(String pubplatID, int pageSize, String time) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List messageDOList = this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"mode").is((Object)2).and(BASE_MESSAGE_RECEIVE_CODE).is((Object)pubplatID).and(BASE_MESSAGE_TIME).gt((Object)Long.valueOf(time)).and("senderName").ne((Object)"\u7cfb\u7edf")).with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)BASE_MESSAGE_TIME)})).limit(pageSize), MessageDO.class);
        if (CollUtil.isEmpty((Collection)messageDOList)) {
            return map;
        }
        map.put("time", ((MessageDO)messageDOList.get(messageDOList.size() - 1)).getMsgTime().toString());
        ArrayList userCodeList = new ArrayList();
        messageDOList.forEach(messageDO -> {
            List list = this.organizationService.searchContactByUserName(messageDO.getReceiverName());
            if (!CollUtil.isEmpty((Collection)list)) {
                userCodeList.add(((UserStaffVo)list.get(0)).getUserName());
            }
        });
        map.put("list", userCodeList);
        return map;
    }

    public ReceiptVO getSingleReceipt(String userID, String objID) {
        OperationDo operationDo = (OperationDo)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"userID").is((Object)objID).and("objID").is((Object)userID).and("type").is((Object)"read")), OperationDo.class);
        ReceiptVO receiptVO = new ReceiptVO();
        if (operationDo == null) {
            receiptVO.setReceiptTime(Long.valueOf(0L));
        } else {
            receiptVO.setReceiptTime(Long.valueOf(operationDo.getTime()));
        }
        return receiptVO;
    }

    public List<BaseMsgBean> getMsgFilesByMsgIds(List<BaseMsgBean> msgBeanList) {
        Criteria fileCriteria = Criteria.where((String)"msgId").in((Collection)msgBeanList.stream().map(BaseMsgBean::getMsgID).map(Long::parseLong).collect(Collectors.toList()));
        List messageFileDO = this.mongoTemplate.find(new Query((CriteriaDefinition)fileCriteria), MessageFileDO.class);
        ArrayList<BaseMsgBean> resultMsgBean = new ArrayList<BaseMsgBean>();
        for (BaseMsgBean msgBean : msgBeanList) {
            VoiceMsgBean.FileStatus[] status;
            MessageFileDO temp;
            List tempFile = messageFileDO.stream().filter(a -> String.valueOf(a.getMsgID()).equals(msgBean.getMsgID())).collect(Collectors.toList());
            if (msgBean.getMsgType().ordinal() == BaseMsgBean.MsgType.AUDIO.ordinal()) {
                VoiceMsgBean voiceMsgBean = (VoiceMsgBean)msgBean;
                if (ToolUtil.isNotEmpty(tempFile)) {
                    temp = (MessageFileDO)tempFile.get(0);
                    voiceMsgBean.setFileID(String.valueOf(temp.getFileID()));
                    voiceMsgBean.setFileName(temp.getFileName());
                    voiceMsgBean.setFileSize(String.valueOf(temp.getFileSize()));
                    status = VoiceMsgBean.FileStatus.values();
                    voiceMsgBean.setFileStatus(status[temp.getFileStatus()]);
                    voiceMsgBean.setLength(temp.getLength());
                }
                resultMsgBean.add((BaseMsgBean)voiceMsgBean);
                continue;
            }
            if (msgBean.getMsgType().ordinal() == BaseMsgBean.MsgType.IMAGE.ordinal()) {
                ImgMsgBean imgMsgBean = (ImgMsgBean)msgBean;
                if (ToolUtil.isNotEmpty(tempFile)) {
                    temp = (MessageFileDO)tempFile.get(0);
                    imgMsgBean.setFileID(String.valueOf(temp.getFileID()));
                    imgMsgBean.setFileName(temp.getFileName());
                    imgMsgBean.setFileSize(String.valueOf(temp.getFileSize()));
                    status = ImgMsgBean.FileStatus.values();
                    imgMsgBean.setFileStatus((ImgMsgBean.FileStatus)status[temp.getFileStatus()]);
                    imgMsgBean.setHeight(temp.getHeight());
                    imgMsgBean.setWidth(temp.getWidth());
                }
                resultMsgBean.add((BaseMsgBean)imgMsgBean);
                continue;
            }
            if (msgBean.getMsgType().ordinal() == BaseMsgBean.MsgType.FILETYPE.ordinal()) {
                FileMsgBean fileMsgBean = (FileMsgBean)msgBean;
                if (ToolUtil.isNotEmpty(tempFile)) {
                    temp = (MessageFileDO)tempFile.get(0);
                    fileMsgBean.setFileID(String.valueOf(temp.getFileID()));
                    FileMsgBean.FileType[] types = FileMsgBean.FileType.values();
                    fileMsgBean.setFileType(types[temp.getFileType()]);
                    fileMsgBean.setFileName(temp.getFileName());
                    fileMsgBean.setFileSize(temp.getFileSize());
                    FileMsgBean.FileStatus[] status2 = FileMsgBean.FileStatus.values();
                    fileMsgBean.setFileStatus(status2[temp.getFileStatus()]);
                }
                resultMsgBean.add((BaseMsgBean)fileMsgBean);
                continue;
            }
            if (msgBean.getMsgType().ordinal() == BaseMsgBean.MsgType.LOCATION.ordinal()) {
                LocationMsgBean locationMsgBean = (LocationMsgBean)msgBean;
                if (ToolUtil.isNotEmpty(tempFile)) {
                    temp = (MessageFileDO)tempFile.get(0);
                    locationMsgBean.setFileSize(String.valueOf(temp.getFileSize()));
                    status = LocationMsgBean.FileStatus.values();
                    locationMsgBean.setFileStatus((LocationMsgBean.FileStatus)status[temp.getFileStatus()]);
                    if (ToolUtil.isNotEmpty((Object)locationMsgBean.getThumbnailId())) {
                        locationMsgBean.setThumbnailId(temp.getFileID());
                    }
                }
                resultMsgBean.add((BaseMsgBean)locationMsgBean);
                continue;
            }
            resultMsgBean.add(msgBean);
        }
        return resultMsgBean;
    }

    public List<MessageDO> getUnreadMsgNum(String userID) {
        long start = System.currentTimeMillis();
        List<MessageDO> pubpaltChatList = this.getAllPubpaltChatNum(userID);
        long pubplatTime = System.currentTimeMillis() - start;
        List<MessageDO> singleChatList = this.getSingleChatNum(userID);
        long chatTime = System.currentTimeMillis() - start;
        List<MessageDO> groupChatList = this.getAllGroupChatNum(userID);
        long groupTime = System.currentTimeMillis() - start;
        log.error("\u5fae\u5e94\u7528\u672a\u8bfb\u6d88\u606f===========" + pubpaltChatList + "\u8017\u65f6\uff1a" + pubplatTime + "ms,\u5355\u804a\u672a\u8bfb\u6d88\u606f===========" + singleChatList + "\u8017\u65f6\uff1a" + chatTime + "ms,\u7fa4\u804a\u672a\u8bfb\u6d88\u606f===========" + groupChatList + "\u8017\u65f6\uff1a" + groupTime + "ms");
        ArrayList<MessageDO> all = new ArrayList<MessageDO>();
        all.addAll(singleChatList);
        all.addAll(groupChatList);
        all.addAll(pubpaltChatList);
        return all;
    }

    public List<MessageDO> getUnreadMsg(String userID) {
        long start = System.currentTimeMillis();
        List<MessageDO> pubpaltChatList = this.getAllPubpaltChatNum(userID);
        long pubplatTime = System.currentTimeMillis() - start;
        List<MessageDO> singleChatList = this.getSingleChatNum(userID);
        long chatTime = System.currentTimeMillis() - start;
        List<MessageDO> groupChatList = this.getAllGroupChatNum(userID);
        long groupTime = System.currentTimeMillis() - start;
        log.error("\u5fae\u5e94\u7528\u672a\u8bfb\u6d88\u606f===========" + pubpaltChatList.size() + "\u8017\u65f6\uff1a" + pubplatTime + "ms,\u5355\u804a\u672a\u8bfb\u6d88\u606f===========" + singleChatList.size() + "\u8017\u65f6\uff1a" + chatTime + "ms,\u7fa4\u804a\u672a\u8bfb\u6d88\u606f===========" + groupChatList + "\u8017\u65f6\uff1a" + groupTime + "ms");
        ArrayList<MessageDO> all = new ArrayList<MessageDO>();
        all.addAll(singleChatList);
        all.addAll(groupChatList);
        all.addAll(pubpaltChatList);
        return all;
    }

    private List<MessageDO> getAllPubpaltChatNum(String userID) {
        long start = System.currentTimeMillis();
        List web = this.pubPlatService.getAppGroupListWithExtend("", "2", new ArrayList(), "WEB");
        log.error("\u67e5\u8be2\u5230web\u5e94\u7528\uff1a" + (System.currentTimeMillis() - start) + " ms");
        ArrayList webAppList = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)web)) {
            web.forEach(sysAppExtendGroupVo -> {
                List sysApplicationList = sysAppExtendGroupVo.getSysApplicationList();
                sysApplicationList.forEach(sysApp -> webAppList.add(sysApp));
            });
        }
        Criteria lastTimeCriteria = new Criteria();
        lastTimeCriteria.andOperator(new Criteria[]{Criteria.where((String)"userID").is((Object)userID), Criteria.where((String)"type").is((Object)"read"), Criteria.where((String)"mode").is((Object)(BaseMsgBean.Mode.PUBPLAT.ordinal() + ""))});
        List timeDOS = this.mongoTemplate.find(new Query().addCriteria((CriteriaDefinition)lastTimeCriteria), TimeDO.class);
        log.error("\u67e5\u8be2\u5230web\u5e94\u75282\uff1a" + (System.currentTimeMillis() - start) + " ms");
        HashMap<String, Long> userTimeMap = new HashMap<String, Long>();
        timeDOS.stream().filter(timeDO -> {
            long time = timeDO.getTime();
            return time > this.day7ago;
        }).forEach(timeDO -> {
            long time = timeDO.getTime();
            userTimeMap.put(timeDO.getObjID(), time);
        });
        webAppList.stream().map(ApplicationExtendVo::getAppId).forEach(pubID -> {
            if (!userTimeMap.containsKey(String.valueOf(pubID))) {
                userTimeMap.put(String.valueOf(pubID), this.day7ago);
            }
        });
        ArrayList criteriaList = new ArrayList();
        userTimeMap.forEach((pubID, userTime) -> {
            Criteria criteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"pubplatReceiverCode").regex(userID), Criteria.where((String)BASE_MESSAGE_RECEIVE_CODE).is(pubID), Criteria.where((String)"msgType").nin(new Object[]{BaseMsgBean.MsgType.MSGRECEIPT.ordinal(), BaseMsgBean.MsgType.IMPMSGRECEIPT.ordinal(), BaseMsgBean.MsgType.WITHDRAW.ordinal(), BaseMsgBean.MsgType.NOTICE.ordinal(), BaseMsgBean.MsgType.IMPTEXT.ordinal()}), Criteria.where((String)"mode").is((Object)BaseMsgBean.Mode.PUBPLAT.ordinal()), Criteria.where((String)BASE_MESSAGE_TIME).gt(userTime)});
            criteriaList.add(criteria);
            if (StrUtil.equals((CharSequence)"911304461782360064", (CharSequence)pubID)) {
                log.error("\u5fae\u5e94\u7528ID:{},\u6d88\u606f\u65f6\u95f4\uff1a{}", pubID, userTime);
            }
        });
        if (criteriaList.isEmpty()) {
            return new ArrayList<MessageDO>();
        }
        Criteria pubplatChatCriteria = new Criteria();
        pubplatChatCriteria.orOperator(criteriaList.toArray(new Criteria[0]));
        log.error("\u67e5\u8be2\u5230web\u5e94\u75283\uff1a" + (System.currentTimeMillis() - start) + " ms");
        List msgList = this.mongoTemplate.find(new Query().addCriteria((CriteriaDefinition)pubplatChatCriteria), MessageDO.class);
        log.error("\u67e5\u8be2\u5230web\u5e94\u75284\uff1a" + (System.currentTimeMillis() - start) + " ms");
        return msgList;
    }

    private List<MessageDO> getSingleChatNum(String userID) {
        List<Object> allUserList = new ArrayList();
        Criteria recentSendUser = new Criteria();
        recentSendUser.andOperator(new Criteria[]{Criteria.where((String)BASE_MESSAGE_RECEIVE_CODE).is((Object)userID), Criteria.where((String)"mode").is((Object)BaseMsgBean.Mode.CHAT.ordinal()), Criteria.where((String)BASE_MESSAGE_TIME).gt((Object)this.day7ago)});
        List messageDOList = this.mongoTemplate.find(new Query().addCriteria((CriteriaDefinition)recentSendUser), MessageDO.class);
        allUserList = messageDOList.stream().map(MessageDO::getSenderCode).collect(Collectors.toList());
        Criteria lastTimeCriteria = new Criteria();
        lastTimeCriteria.andOperator(new Criteria[]{Criteria.where((String)"userID").is((Object)userID), Criteria.where((String)"mode").is((Object)(BaseMsgBean.Mode.CHAT.ordinal() + "")), Criteria.where((String)"type").is((Object)"read")});
        List timeDOS = this.mongoTemplate.find(new Query().addCriteria((CriteriaDefinition)lastTimeCriteria), TimeDO.class);
        HashMap<String, Long> userTimeMap = new HashMap<String, Long>();
        timeDOS.stream().filter(timeDO -> {
            long time = timeDO.getTime();
            return time > this.day7ago;
        }).forEach(timeDO -> {
            long time = timeDO.getTime();
            userTimeMap.put(timeDO.getObjID(), time);
        });
        allUserList.forEach(userId -> {
            if (!userTimeMap.containsKey(userId)) {
                userTimeMap.put((String)userId, this.day7ago);
            }
        });
        Criteria singleChatCriteria = new Criteria();
        ArrayList criteriaList = new ArrayList();
        userTimeMap.forEach((uid, userTime) -> {
            Criteria criteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)BASE_MESSAGE_RECEIVE_CODE).is((Object)userID), Criteria.where((String)BASE_MESSAGE_SENDER_CODE).is(uid), Criteria.where((String)"msgType").nin(new Object[]{BaseMsgBean.MsgType.MSGRECEIPT.ordinal(), BaseMsgBean.MsgType.IMPMSGRECEIPT.ordinal(), BaseMsgBean.MsgType.WITHDRAW.ordinal(), BaseMsgBean.MsgType.NOTICE.ordinal(), BaseMsgBean.MsgType.IMPTEXT.ordinal()}), Criteria.where((String)"mode").is((Object)BaseMsgBean.Mode.CHAT.ordinal()), Criteria.where((String)BASE_MESSAGE_TIME).gt(userTime)});
            criteriaList.add(criteria);
        });
        if (criteriaList.isEmpty()) {
            return new ArrayList<MessageDO>();
        }
        singleChatCriteria.orOperator(criteriaList.toArray(new Criteria[0]));
        List singleChatNum = this.mongoTemplate.find(new Query().addCriteria((CriteriaDefinition)singleChatCriteria), MessageDO.class);
        List messageDOS = this.mongoTemplate.find(new Query().addCriteria((CriteriaDefinition)singleChatCriteria), MessageDO.class);
        log.info("\u5355\u804a\u672a\u8bfb\u6d88\u606f===========" + JSONUtil.toJsonStr((Object)messageDOS));
        return singleChatNum;
    }

    private List<MessageDO> getAllGroupChatNum(String userID) {
        List groupList = this.groupService.queryGroupList(Long.valueOf(userID), "0");
        List<String> roomIdList = groupList.stream().map(groupVO -> String.valueOf(groupVO.getRoomID())).collect(Collectors.toList());
        List<MessageDO> groupChatList = this.getGroupChatListNum(userID, roomIdList);
        if (groupChatList == null) {
            return new ArrayList<MessageDO>();
        }
        return groupChatList;
    }

    public List<MessageDO> getGroupChatNum(String groupID, String userID) {
        List groupList = this.groupService.queryGroupList(Long.valueOf(userID), "0");
        List<String> roomIdList = groupList.stream().filter(it -> StrUtil.equals((CharSequence)String.valueOf(it.getRoomID()), (CharSequence)groupID)).map(groupVO -> String.valueOf(groupVO.getRoomID())).collect(Collectors.toList());
        List<MessageDO> groupChatList = this.getGroupChatListNum(userID, roomIdList);
        if (groupChatList == null) {
            return new ArrayList<MessageDO>();
        }
        return groupChatList;
    }

    private List<MessageDO> getGroupChatListNum(String userID, List<String> roomIdList) {
        List<Object> groupChatList = new ArrayList<MessageDO>();
        if (!roomIdList.isEmpty()) {
            Criteria lastTimeCriteria = new Criteria();
            lastTimeCriteria.andOperator(new Criteria[]{Criteria.where((String)"objID").in(roomIdList), Criteria.where((String)"userID").is((Object)userID), Criteria.where((String)"type").is((Object)"read"), Criteria.where((String)"mode").is((Object)(BaseMsgBean.Mode.GROUPCHAT.ordinal() + ""))});
            List timeDOS = this.mongoTemplate.find(new Query().addCriteria((CriteriaDefinition)lastTimeCriteria), TimeDO.class);
            HashMap<String, Long> userTimeMap = new HashMap<String, Long>();
            timeDOS.stream().filter(timeDO -> {
                long time = timeDO.getTime();
                return time > this.day7ago;
            }).forEach(timeDO -> {
                long time = timeDO.getTime();
                userTimeMap.put(timeDO.getObjID(), time);
            });
            roomIdList.forEach(roomId -> {
                if (!userTimeMap.containsKey(roomId)) {
                    userTimeMap.put((String)roomId, this.day7ago);
                }
            });
            Criteria groupChatCriteria = new Criteria();
            ArrayList criteriaList = new ArrayList();
            userTimeMap.forEach((roomID, userTime) -> {
                Criteria criteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)BASE_MESSAGE_RECEIVE_CODE).is(roomID), Criteria.where((String)"msgType").nin(new Object[]{BaseMsgBean.MsgType.MSGRECEIPT.ordinal(), BaseMsgBean.MsgType.IMPMSGRECEIPT.ordinal(), BaseMsgBean.MsgType.WITHDRAW.ordinal(), BaseMsgBean.MsgType.NOTICE.ordinal(), BaseMsgBean.MsgType.IMPTEXT.ordinal()}), Criteria.where((String)BASE_MESSAGE_SENDER_CODE).ne((Object)userID), Criteria.where((String)"mode").is((Object)BaseMsgBean.Mode.GROUPCHAT.ordinal()), Criteria.where((String)BASE_MESSAGE_TIME).gt(userTime)});
                criteriaList.add(criteria);
            });
            if (criteriaList.isEmpty()) {
                return null;
            }
            groupChatCriteria.orOperator(criteriaList.toArray(new Criteria[0]));
            groupChatList = this.mongoTemplate.find(new Query().addCriteria((CriteriaDefinition)groupChatCriteria), MessageDO.class);
        }
        return groupChatList;
    }

    public Boolean updateUnreadMsgNum(int count) {
        SecurityUser user = BaseSecurityUtil.getUser();
        HussarCacheUtil.put((String)"eim_cache", (Object)("badgecache:" + user.getUserId()), (Object)count);
        return true;
    }
}

