/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.controller;

import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.group.GroupVO;
import com.jxdinfo.mp.im.feign.RemoteIMService;
import com.jxdinfo.mp.im.model.EventMsgBean;
import com.jxdinfo.mp.im.model.db.GroupDO;
import com.jxdinfo.mp.im.model.db.GroupUserDO;
import com.jxdinfo.mp.im.model.single.TimeDO;
import com.jxdinfo.mp.im.service.GroupMessageService;
import com.jxdinfo.mp.im.service.GroupService;
import com.jxdinfo.mp.im.service.GroupUserService;
import com.jxdinfo.mp.im.service.PubPlatMessageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@Api(tags={"\u7edf\u4e00\u5f85\u529e\u4efb\u52a1\u63a5\u53e3-\u5fae\u670d\u52a1"})
@ApiIgnore
public class RemoteIMController
implements RemoteIMService {
    @Resource
    private GroupMessageService groupMessageService;
    @Resource
    private GroupService groupService;
    @Resource
    private GroupUserService groupUserService;
    @Resource
    private PubPlatMessageService pubPlatMessageService;

    @ApiOperation(value="\u66f4\u65b0\u7fa4\u804a\u4e2d\u67d0\u4eba\u5df2\u8bfb\u65f6\u95f4")
    public Boolean updateGroupUserReceipt(@RequestBody EventMsgBean eventMsgBean) {
        return this.groupMessageService.updateGroupUserReceipt(Long.valueOf(eventMsgBean.getSenderCode()), Long.valueOf(eventMsgBean.getObjID()), Long.valueOf(eventMsgBean.getEventTime()));
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u6240\u5728\u7fa4\u7ec4\u7684\u72b6\u6001")
    public List<GroupVO> getGroupStatus(@LoginUser CurrentLoginUser currentLoginUser, @RequestParam(value="time", required=false) String time) {
        return this.groupService.getGroupStatusByUserID(currentLoginUser, time);
    }

    @ApiOperation(value="\u67e5\u8be2\u90e8\u95e8\u7fa4\u662f\u5426\u5b58\u5728")
    public List<GroupDO> selectGroup(@PathVariable(value="organiseID") Long organiseID) {
        return this.groupUserService.selectGroup(organiseID);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7236\u7ea7\u90e8\u95e8\u7fa4id")
    public List<Long> getParentIDList(@RequestBody List<Long> orgIDList) {
        return this.groupUserService.getOrgGroupIDList(orgIDList);
    }

    @ApiOperation(value="\u65b0\u589e\u7fa4\u7ec4\u6210\u5458")
    public Boolean addMember(@RequestBody List<GroupUserDO> groupUserDOList) {
        return this.groupUserService.saveBatch(groupUserDOList);
    }

    @ApiOperation(value="\u83b7\u53d6\u8be5\u7528\u6237\u52a0\u5165\u7684\u7fa4")
    public List<GroupUserDO> getGroupUserList(@PathVariable(value="userID") Long userID) {
        return this.groupUserService.getGroupUserList(userID);
    }

    @ApiOperation(value="\u5220\u9664\u4e0d\u5728\u5f53\u524d\u90e8\u95e8\u7684\u7fa4\u6210\u5458")
    public Integer deleteMember(@RequestParam(value="objID") Long objID, @RequestBody List<Long> orgIDList) {
        return this.groupUserService.deleteMember(objID, orgIDList);
    }

    @ApiOperation(value="\u5220\u9664\u6240\u6709\u7fa4\u4e2d\u7684\u7684\u6307\u5b9a\u79bb\u804c\u4eba\u5458")
    public Boolean deleteQuitUser(@RequestBody List<Long> outUserList) {
        return this.groupService.deleteQuitUser(outUserList);
    }

    @ApiOperation(value="\u83b7\u53d6\u7fa4\u7ec4\u5217\u8868 + \u67e5\u627e\u7fa4\u7ec4 'J_T_0007' + 'J_T_0010'")
    public PageDTO<GroupVO> findGroup(@RequestParam(required=false) @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") String searchKey, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") int pageNum, @RequestParam(required=false, defaultValue="20") @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") int pageSize, @RequestParam(required=false, defaultValue="20") @ApiParam(value="\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684id") Long userID) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        return this.groupService.findGroupPage(pageDTO, userID, searchKey);
    }

    @ApiOperation(value="\u6e05\u9664\u7528\u6237\u7fa4\u7ec4\u7f13\u5b58")
    public Boolean cleanGroupCache(@PathVariable @ApiParam(value="\u7528\u6237ID") Long userID) {
        return this.groupUserService.cleanGroupCache(userID);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e0e\u8be5\u5fae\u5e94\u7528\u5bf9\u8bdd\u72b6\u6001\uff08\u5df2\u8bfb/\u672a\u8bfb\uff09")
    public List<TimeDO> getTime(@RequestParam @ApiParam(value="\u5bf9\u8c61ID") String objID, @RequestParam @ApiParam(value="\u7528\u6237ids") List<Long> userIDS) {
        return this.pubPlatMessageService.getTime(objID, userIDS);
    }
}

