/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.mail.core.util.StrUtil;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.Role;
import com.jxdinfo.mp.common.utils.JqxSpringUtil;
import com.jxdinfo.mp.im.model.material.MaterialDTO;
import com.jxdinfo.mp.im.model.material.MaterialLibraryVO;
import com.jxdinfo.mp.im.model.single.PubMsgLogDTO;
import com.jxdinfo.mp.im.service.MaterialService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@Api(tags={"\u7d20\u6750\u5e93"})
@RequestMapping(value={"/v1/material"})
public class MaterialController {
    @Resource
    private MaterialService materialService;
    @Resource
    public Environment environment;

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u540d")
    @GetMapping(value={"/{materialId}/name"})
    public Result<List<String>> getUserNameList(@PathVariable(value="materialId") @ApiParam(value="\u6d88\u606fid") Long materialID) {
        return Result.succeed((Object)this.materialService.getUserNameList(materialID));
    }

    @ApiOperation(value="\u67e5\u8be2\u7d20\u6750\u5217\u8868")
    @GetMapping(value={"/list"})
    public Result<PageVO<MaterialLibraryVO>> getMaterialLibraryList(@RequestParam(value="pageNum", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageNum, @RequestParam(value="pageSize", defaultValue="20") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize, @RequestParam(value="type", required=false) @ApiParam(value="\u7d20\u6750\u7c7b\u578b") String type, @RequestParam(required=false) @ApiParam(value="title") String title, @ApiIgnore @LoginUser(isFull=true) CurrentLoginUser currentLoginUser) {
        SecurityUser user;
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        PageVO pageVO = new PageVO();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(!StrUtil.isEmpty((CharSequence)type), (Object)"MSG_TYPE", (Object)type);
        if (!StrUtil.isEmpty((CharSequence)title)) {
            queryWrapper.like((Object)"TITLE", (Object)JqxSpringUtil.replaceSpecialChar((String)title));
        }
        if ((user = BaseSecurityUtil.getUser()).isSuperAdmin() || user.getRolesList().contains(Long.parseLong(Objects.requireNonNull(this.environment.getProperty("mp.role.jqx_admin_role"))))) {
            queryWrapper.orderByDesc((Object)"CREATE_TIME");
            BeanUtils.copyProperties((Object)this.materialService.page((IPage)pageDTO, (Wrapper)queryWrapper), (Object)pageVO);
            return Result.succeed((Object)pageVO);
        }
        if (!currentLoginUser.getRoles().stream().map(Role::getRoleCode).collect(Collectors.toList()).contains("JS0000")) {
            queryWrapper.eq((Object)"CREATOR", (Object)currentLoginUser.getId());
            queryWrapper.orderByDesc((Object)"CREATE_TIME");
            BeanUtils.copyProperties((Object)this.materialService.page((IPage)pageDTO, (Wrapper)queryWrapper), (Object)pageVO);
            return Result.succeed((Object)pageVO);
        }
        queryWrapper.orderByDesc((Object)"CREATE_TIME");
        BeanUtils.copyProperties((Object)this.materialService.page((IPage)pageDTO, (Wrapper)queryWrapper), (Object)pageVO);
        return Result.succeed((Object)pageVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u56fe\u7247\u3001\u6587\u4ef6\u3001\u56fe\u6587\u7d20\u6750")
    @GetMapping(value={"/detail"})
    public Result<PubMsgLogDTO> getFileMaterial(@RequestParam(value="materialId") @ApiParam(value="\u7d20\u6750id") Long materialID) {
        return Result.succeed((Object)this.materialService.getMaterial(materialID));
    }

    @ApiOperation(value="\u5220\u9664\u7d20\u6750")
    @PostMapping(value={"/delete"})
    public Result<Boolean> deleteMaterial(@RequestBody @ApiParam(value="\u7d20\u6750id,\u591a\u4e2a\u4e4b\u95f4,\u5206\u9694") List<Long> materialIds) {
        return Result.succeed((Object)this.materialService.deleteMaterial(materialIds));
    }

    @ApiOperation(value="\u4fdd\u5b58\u7d20\u6750")
    @PostMapping(value={"/save"})
    public Result<Boolean> save(@RequestBody @ApiParam(value="\u7d20\u6750") MaterialDTO materialDTO, @ApiIgnore @LoginUser CurrentLoginUser loginUser) {
        return Result.succeed((Object)this.materialService.saveMaterial(materialDTO, loginUser, "urlSplicing"));
    }

    @ApiOperation(value="\u4fee\u6539\u7d20\u6750")
    @PostMapping(value={"/edit"})
    public Result<Boolean> update(@RequestBody @ApiParam(value="\u7d20\u6750") MaterialDTO materialDTO, @ApiIgnore @LoginUser CurrentLoginUser loginUser) {
        return Result.succeed((Object)this.materialService.updateMaterial(materialDTO, loginUser, "urlSplicing"));
    }
}

