/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppVisitAuthorizationService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eim.application.extend.service.ISysEimApplicationExtendService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workstation.application.model.SysWorkstationAppExtend;
import com.jxdinfo.hussar.workstation.application.service.ISysAppCommonService;
import com.jxdinfo.hussar.workstation.application.service.ISysAppVisitAuthorizeService;
import com.jxdinfo.hussar.workstation.application.service.ISysWorkstationAppService;
import com.jxdinfo.hussar.workstation.application.vo.SysApplicationVo;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.application.vo.WorkstationApplicationVo;
import com.jxdinfo.mp.im.dao.single.PubMsgLogMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class EimPubPlatService {
    @Resource
    private IHussarBaseUserBoService userBoService;
    @Resource
    private ISysAppVisitAuthorizeService sysAppVisitAuthorizeService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private ISysWorkstationAppService sysWorkstationAppService;
    @Resource
    private ISysAppCommonService sysAppCommonService;
    @Resource
    private ISysEimApplicationExtendService sysEimApplicationExtendService;
    @Resource
    private ISysAppVisitAuthorizationService sysAppVisitAuthorizationService;
    @Resource
    private PubMsgLogMapper pubMsgLogMapper;

    @GetMapping(value={"v1/pubPlat/manager/pageList"})
    public Result<Page<WorkstationApplicationVo>> getPageList(@RequestParam(value="searchKey", required=false) String searchKey, @RequestParam(value="pageNum", defaultValue="1") int pageNum, @RequestParam(value="pageSize", defaultValue="30") int pageSize, @RequestParam(value="classifyId", required=false) String classifyID, @RequestParam(value="appTypes", required=false) String appTypes) {
        SecurityUser user = BaseSecurityUtil.getUser();
        List rolesList = user.getRolesList();
        List appList = this.sysApplicationService.getManageAppList(null, searchKey, ToolUtil.isNotEmpty((Object)appTypes) ? Arrays.asList(appTypes.split(",")) : null);
        ArrayList list = new ArrayList();
        for (SysAppGroupVo sysAppGroupVo : appList) {
            list.addAll(sysAppGroupVo.getSysApplicationList());
        }
        List extendList = this.sysWorkstationAppService.list((Wrapper)new LambdaQueryWrapper().ne(SysWorkstationAppExtend::getPlatform, (Object)1));
        list.stream().filter(a -> {
            List extendList1 = extendList.stream().filter(b -> b.getAppId().equals(a.getId())).collect(Collectors.toList());
            return ToolUtil.isNotEmpty(extendList1);
        }).collect(Collectors.toList());
        ArrayList sysWorkstationAppVO = new ArrayList();
        list.forEach(f -> {
            WorkstationApplicationVo workstationAppVO = new WorkstationApplicationVo();
            BeanUtil.copyProperties((Object)f, (Object)workstationAppVO);
            sysWorkstationAppVO.add(workstationAppVO);
        });
        Set longList = list.stream().map(SysApplication::getAppGroupId).collect(Collectors.toSet());
        if (HussarUtils.isNotEmpty(longList)) {
            List appTypeStr = longList.stream().map(String::valueOf).collect(Collectors.toList());
            ApiResponse apiResponse = this.sysEimApplicationExtendService.listApplicationExtend("", "3", appTypeStr);
            List sysAppGroups = new ArrayList();
            if (ToolUtil.isNotEmpty((Object)apiResponse)) {
                sysAppGroups = (List)apiResponse.getData();
            }
            for (WorkstationApplicationVo workstationAppVO : sysWorkstationAppVO) {
                sysAppGroups.forEach(f -> {
                    if (f.getId().equals(workstationAppVO.getAppGroupId())) {
                        workstationAppVO.setGroupName(f.getGroupName());
                    }
                });
            }
            if (BaseSecurityUtil.getUser().isSuperAdmin()) {
                List<Map<String, String>> groupInfos = this.pubMsgLogMapper.getAppGroupName(appTypeStr.stream().map(Long::parseLong).collect(Collectors.toList()));
                for (WorkstationApplicationVo workstationAppVO : sysWorkstationAppVO) {
                    groupInfos.forEach(f -> {
                        if (String.valueOf(f.get("GROUP_ID")).equals(String.valueOf(workstationAppVO.getAppGroupId()))) {
                            workstationAppVO.setGroupName((String)f.get("GROUP_NAME"));
                        }
                    });
                }
            }
        }
        Page workstationAppVOPage = new Page();
        workstationAppVOPage.setSize((long)pageSize);
        workstationAppVOPage.setCurrent((long)pageNum);
        workstationAppVOPage.setRecords(sysWorkstationAppVO.subList((pageNum - 1) * pageSize, Math.min(pageNum * pageSize, sysWorkstationAppVO.size())));
        workstationAppVOPage.setTotal((long)sysWorkstationAppVO.size());
        return Result.succeed((Object)workstationAppVOPage);
    }

    @GetMapping(value={"/v1/pubPlat/manager/{pubPlatId}"})
    public Result<SysApplicationVo> getPubPlat(@PathVariable(value="pubPlatId") Long pubPlatID) {
        SysApplicationVo sysApplicationVo = (SysApplicationVo)this.sysAppCommonService.getAppDetail(pubPlatID).getData();
        return Result.succeed((Object)sysApplicationVo);
    }

    @GetMapping(value={"/v1/pubPlat/manager/{pubPlatId}/permissionId"})
    public List<String> getPermissionID(@PathVariable(value="pubPlatId") Long pubPlatID) {
        List temp;
        SysApplicationVo appInfoById = (SysApplicationVo)this.sysAppCommonService.getAppDetail(pubPlatID).getData();
        Map roleDateMap = (Map)this.sysAppVisitAuthorizationService.getAppRoleList(pubPlatID).getData();
        List permissionUsers = (List)roleDateMap.get("users");
        List permissionOrgans = (List)roleDateMap.get("organs");
        List permissionRoles = (List)roleDateMap.get("roles");
        List permissionPosts = (List)roleDateMap.get("posts");
        ArrayList<String> userIdList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)permissionUsers)) {
            userIdList.addAll(permissionUsers.stream().map(RoleVo::getId).map(String::valueOf).collect(Collectors.toList()));
        }
        if (ToolUtil.isNotEmpty((Object)permissionOrgans) && ToolUtil.isNotEmpty((Object)(temp = this.userBoService.getUsersByOrganUser(permissionOrgans.stream().map(RoleVo::getId).collect(Collectors.toList()), null)))) {
            userIdList.addAll(temp.stream().map(UserVo::getId).map(String::valueOf).collect(Collectors.toList()));
        }
        if (ToolUtil.isNotEmpty((Object)permissionRoles) && ToolUtil.isNotEmpty((Object)(temp = this.userBoService.getUserInfoByRoleId(permissionRoles.stream().map(RoleVo::getId).collect(Collectors.toList()))))) {
            userIdList.addAll(temp.stream().map(UserVo::getId).map(String::valueOf).collect(Collectors.toList()));
        }
        if (ToolUtil.isNotEmpty((Object)permissionPosts) && ToolUtil.isNotEmpty((Object)(temp = this.userBoService.getUsersByPostIds(permissionPosts.stream().map(RoleVo::getId).collect(Collectors.toList()))))) {
            userIdList.addAll(temp.stream().map(UserVo::getId).map(String::valueOf).collect(Collectors.toList()));
        }
        return userIdList;
    }
}

