/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.unifiedtodo.service;

import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveToDoDto;
import com.jxdinfo.mp.im.unifiedtodo.annotation.TodoMessagePush;
import com.jxdinfo.mp.im.unifiedtodo.config.UnifiedTodoProperties;
import com.jxdinfo.mp.im.unifiedtodo.dto.TodoPushMessageDTO;
import com.jxdinfo.mp.im.unifiedtodo.service.TodoMessageMergeService;
import com.jxdinfo.mp.im.unifiedtodo.service.TodoMessagePushService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TodoPushDeduplicationService {
    private static final Logger log = LoggerFactory.getLogger(TodoPushDeduplicationService.class);
    @Autowired
    private UnifiedTodoProperties unifiedTodoProperties;
    private static final String CACHE_NAME = "eim_cache";
    @Autowired
    private TodoMessageMergeService todoMessageMergeService;
    @Autowired
    private TodoMessagePushService todoMessagePushService;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(5);

    public void processPushMessage(TodoPushMessageDTO pushMessageDTO) {
        if (pushMessageDTO == null) {
            log.warn("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u63a8\u9001\u6d88\u606fDTO\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5904\u7406");
            return;
        }
        if (!StringUtils.hasText((String)pushMessageDTO.getBusinessid()) && StringUtils.hasText((String)pushMessageDTO.getTaskId())) {
            try {
                SaveToDoDto taskDetail = this.todoMessagePushService.getTaskDetailByTaskId(pushMessageDTO.getTaskId());
                if (taskDetail == null || !StringUtils.hasText((String)taskDetail.getBusinessid())) {
                    log.warn("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u6839\u636etaskId: {} \u672a\u67e5\u8be2\u5230\u6709\u6548\u7684businessId\uff0c\u8df3\u8fc7\u5904\u7406", (Object)pushMessageDTO.getTaskId());
                    return;
                }
                pushMessageDTO.setBusinessid(taskDetail.getBusinessid());
                log.debug("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u6839\u636etaskId: {} \u67e5\u8be2\u5230businessId: {}", (Object)pushMessageDTO.getTaskId(), (Object)taskDetail.getBusinessid());
            }
            catch (Exception e) {
                log.error("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u6839\u636etaskId: {} \u67e5\u8be2\u5f85\u529e\u8be6\u60c5\u5931\u8d25", (Object)pushMessageDTO.getTaskId(), (Object)e);
                return;
            }
        }
        if (!StringUtils.hasText((String)pushMessageDTO.getBusinessid())) {
            log.warn("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] businessid\u4e3a\u7a7a\u4e14\u65e0\u6cd5\u901a\u8fc7taskId\u83b7\u53d6\uff0c\u8df3\u8fc7\u5904\u7406: {}", (Object)JSONUtil.toJsonStr((Object)pushMessageDTO));
            return;
        }
        if (!this.unifiedTodoProperties.getDeduplication().isEnabled()) {
            log.debug("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u53bb\u91cd\u529f\u80fd\u672a\u542f\u7528\uff0c\u76f4\u63a5\u63a8\u9001");
            this.todoMessagePushService.pushTodoMessage(pushMessageDTO);
            return;
        }
        this.cacheAndSchedulePush(pushMessageDTO);
    }

    private boolean shouldStopPushDueToDeleteTask(TodoPushMessageDTO messageDTO) {
        log.info("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u68c0\u67e5DELETE_TASK\u5f00\u59cb\uff0csystemId: {}, taskId: {}, businessid: {}", new Object[]{messageDTO != null ? messageDTO.getSystemId() : "null", messageDTO != null ? messageDTO.getTaskId() : "null", messageDTO != null ? messageDTO.getBusinessid() : "null"});
        if (messageDTO == null || !StringUtils.hasText((String)messageDTO.getTaskId())) {
            log.info("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u5165\u53c2\u4e3a\u7a7a\u6216taskId\u4e3a\u7a7a\uff0c\u505c\u6b62\u63a8\u9001");
            return true;
        }
        try {
            String keyPattern = String.format("%s:cache:%s:", this.unifiedTodoProperties.getDeduplication().getRedisKeyPrefix(), messageDTO.getSystemId());
            log.info("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u7f13\u5b58\u952e\u524d\u7f00: {}", (Object)keyPattern);
            List cacheKeys = HussarCacheUtil.getKeysRightLike((String)CACHE_NAME, (String)keyPattern);
            log.info("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u547d\u4e2d\u7f13\u5b58\u952e\u6570\u91cf: {}", (Object)(CollectionUtils.isEmpty((Collection)cacheKeys) ? 0 : cacheKeys.size()));
            if (CollectionUtils.isEmpty((Collection)cacheKeys)) {
                log.info("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u672a\u547d\u4e2d\u4efb\u4f55\u7f13\u5b58\u952e\uff0c\u7ee7\u7eed\u63a8\u9001");
                return false;
            }
            for (String key : cacheKeys) {
                log.info("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u68c0\u67e5\u7f13\u5b58\u9879: {}", (Object)key);
                Object cachedData = HussarCacheUtil.get((String)CACHE_NAME, (Object)key);
                if (cachedData == null) continue;
                TodoPushMessageDTO cachedMessage = (TodoPushMessageDTO)this.objectMapper.readValue(cachedData.toString(), TodoPushMessageDTO.class);
                if (cachedMessage == null) {
                    log.info("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u53cd\u5e8f\u5217\u5316\u540e\u6d88\u606f\u4e3anull\uff0c\u8df3\u8fc7\uff0ckey: {}", (Object)key);
                    continue;
                }
                if (cachedMessage.getPushType() != TodoMessagePush.PushType.DELETE_TASK || !StringUtils.hasText((String)cachedMessage.getTaskId()) || !cachedMessage.getTaskId().equals(messageDTO.getTaskId())) continue;
                log.info("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u53d1\u73b0DELETE_TASK\u7c7b\u578b\u6d88\u606f\uff0ctaskId: {}\uff0c\u505c\u6b62\u63a8\u9001", (Object)cachedMessage.getTaskId());
                return true;
            }
        }
        catch (Exception e) {
            log.info("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u68c0\u67e5DELETE_TASK\u7c7b\u578b\u6d88\u606f\u5f02\u5e38\uff0ctaskId: {}\uff0c\u5f02\u5e38: {}", (Object)messageDTO.getTaskId(), (Object)e.getMessage());
            return false;
        }
        log.info("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u672a\u53d1\u73b0DELETE_TASK\u963b\u6b62\u6761\u4ef6\uff0c\u7ee7\u7eed\u63a8\u9001");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheAndSchedulePush(TodoPushMessageDTO pushMessageDTO) {
        try {
            String cacheKey = this.generateCacheKey(pushMessageDTO);
            String lockKey = cacheKey + ":lock";
            String lockResult = (String)HussarCacheUtil.putIfAbsent((String)CACHE_NAME, (Object)lockKey, (Object)"1", (long)5L);
            if (!"1".equals(lockResult)) {
                log.debug("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u83b7\u53d6\u9501\u5931\u8d25\uff0c\u53ef\u80fd\u6709\u5176\u4ed6\u7ebf\u7a0b\u6b63\u5728\u5904\u7406\uff0cbusinessid: {}", (Object)pushMessageDTO.getBusinessid());
                return;
            }
            try {
                TodoPushMessageDTO mergedMessage;
                Object existingMessage = HussarCacheUtil.get((String)CACHE_NAME, (Object)cacheKey);
                if (existingMessage != null) {
                    TodoPushMessageDTO oldMessage = (TodoPushMessageDTO)this.objectMapper.readValue(existingMessage.toString(), TodoPushMessageDTO.class);
                    mergedMessage = this.todoMessageMergeService.mergeMessages(oldMessage, pushMessageDTO);
                    log.debug("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u6d88\u606f\u5df2\u5408\u5e76\uff0cbusinessid: {}", (Object)pushMessageDTO.getBusinessid());
                } else {
                    mergedMessage = pushMessageDTO;
                    log.debug("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u9996\u6b21\u7f13\u5b58\u6d88\u606f\uff0cbusinessid: {}", (Object)pushMessageDTO.getBusinessid());
                    this.scheduleDelayedPush(cacheKey, pushMessageDTO.getBusinessid());
                }
                String messageJson = this.objectMapper.writeValueAsString((Object)mergedMessage);
                HussarCacheUtil.put((String)CACHE_NAME, (Object)cacheKey, (Object)messageJson, (long)((long)this.unifiedTodoProperties.getDeduplication().getTimeWindowSeconds() + 30L));
                log.debug("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u6d88\u606f\u7f13\u5b58\u5df2\u66f4\u65b0\uff0ckey: {}, businessid: {}", (Object)cacheKey, (Object)(mergedMessage == null ? "\u5408\u5e76\u540e\u7684\u6d88\u606f\u4e3a\u7a7a" : mergedMessage.getBusinessid()));
            }
            finally {
                HussarCacheUtil.evict((String)CACHE_NAME, (Object)lockKey);
                log.error("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u6570\u636e1\uff1a\u6e05\u9664\u6570\u636e\uff0ckeu\u4e3a\uff1a" + lockKey);
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            log.error("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u5e8f\u5217\u5316\u6d88\u606f\u5931\u8d25\uff0cbusinessid: {}", (Object)pushMessageDTO.getBusinessid(), (Object)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u7f13\u5b58\u6d88\u606f\u5f02\u5e38\uff0cbusinessid: {}", (Object)pushMessageDTO.getBusinessid(), (Object)e);
        }
    }

    private void scheduleDelayedPush(String cacheKey, String businessid) {
        long delaySeconds = this.unifiedTodoProperties.getDeduplication().getTimeWindowSeconds();
        this.scheduledExecutor.schedule(() -> {
            try {
                Object cachedMessage = HussarCacheUtil.get((String)CACHE_NAME, (Object)cacheKey);
                log.error("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u6570\u636e1\uff1akeu\u4e3a\uff1a" + cachedMessage);
                if (cachedMessage != null) {
                    TodoPushMessageDTO messageDTO = (TodoPushMessageDTO)this.objectMapper.readValue(cachedMessage.toString(), TodoPushMessageDTO.class);
                    if (this.shouldStopPushDueToDeleteTask(messageDTO)) {
                        log.info("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u68c0\u6d4b\u5230DELETE_TASK\u7c7b\u578b\u6d88\u606f\uff0c\u505c\u6b62\u63a8\u9001\uff0ctaskId: {}, businessid: {}", (Object)messageDTO.getTaskId(), (Object)businessid);
                        HussarCacheUtil.evict((String)CACHE_NAME, (Object)cacheKey);
                        return;
                    }
                    this.todoMessagePushService.pushTodoMessage(messageDTO);
                    HussarCacheUtil.evict((String)CACHE_NAME, (Object)cacheKey);
                    log.info("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u5ef6\u8fdf\u63a8\u9001\u5b8c\u6210\uff0cbusinessid: {}", (Object)businessid);
                } else {
                    log.debug("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u7f13\u5b58\u5df2\u8fc7\u671f\u6216\u88ab\u6e05\u7406\uff0cbusinessid: {}", (Object)businessid);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("[\u7edf\u4e00\u5f85\u529e\u63a8\u9001\u53bb\u91cd] \u5ef6\u8fdf\u63a8\u9001\u5f02\u5e38\uff0cbusinessid: {}", (Object)businessid, (Object)e);
            }
        }, delaySeconds, TimeUnit.SECONDS);
    }

    private String generateCacheKey(TodoPushMessageDTO pushMessageDTO) {
        return String.format("%s:cache:%s:%s", this.unifiedTodoProperties.getDeduplication().getRedisKeyPrefix(), pushMessageDTO.getSystemId(), pushMessageDTO.getBusinessid());
    }
}

