/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.utils.StringUtil;
import com.jxdinfo.mp.im.dao.sensitive.SensitiveWordMapper;
import com.jxdinfo.mp.im.model.sensitive.MessageType;
import com.jxdinfo.mp.im.model.sensitive.SensitiveWordDO;
import com.jxdinfo.mp.im.model.sensitive.SensitiveWordVO;
import com.jxdinfo.mp.im.service.SensitiveWordService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.activemq.command.ActiveMQTopic;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsMessagingTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SensitiveWordServiceImpl
extends ServiceImpl<SensitiveWordMapper, SensitiveWordDO>
implements SensitiveWordService {
    private static final Logger log = LoggerFactory.getLogger(SensitiveWordServiceImpl.class);
    @Resource
    private SensitiveWordMapper sensitiveWordMapper;
    @Resource
    private JmsMessagingTemplate jmsMessagingTemplate;
    private String topicName = "eimv5_sensitiveword_update";

    public Result<PageDTO<SensitiveWordVO>> querySensitiveWordsByContent(String content, int pageSize, int pageNum) {
        log.info("content={}", (Object)content);
        PageDTO pageDTO = new PageDTO();
        pageDTO.setCurrent((long)pageNum);
        pageDTO.setSize((long)pageSize);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.like(!StrUtil.isEmpty((CharSequence)content), (Object)"CONTENT", (Object)StringUtil.replaceSpecialChar((String)content))).eq((Object)"DATA_STATUS", (Object)1)).orderByDesc((Object)"CREATE_TIME");
        return Result.succeed(this.sensitiveWordMapper.querySensitiveWordsByContent(pageDTO, (Wrapper)queryWrapper));
    }

    public Result<Boolean> saveSensitiveWordsFromText(String content) {
        log.info("content={}", (Object)content);
        List<String> lists = Arrays.asList(content.replace(",", "\uff0c").split("\uff0c"));
        ArrayList<SensitiveWordDO> wordDOLists = new ArrayList<SensitiveWordDO>();
        for (String list : lists) {
            if (list.trim().length() > 20) {
                return Result.failed((String)("\u654f\u611f\u8bcd\uff08" + list + "\uff09\u957f\u5ea6\u5927\u4e8e20\uff0c\u8bf7\u4fee\u6539\uff01"));
            }
            log.info("!StrUtil.isEmpty(list.trim())\u7684\u503c={}", (Object)(!StrUtil.isEmpty((CharSequence)list.trim()) ? 1 : 0));
            if (StrUtil.isEmpty((CharSequence)list.trim())) continue;
            SensitiveWordDO sensitiveWordDO = new SensitiveWordDO();
            sensitiveWordDO.setObjID(String.valueOf(IdWorker.getId((Object)content)));
            sensitiveWordDO.setContent(list.trim());
            sensitiveWordDO.setDataStatus(Integer.valueOf(1));
            sensitiveWordDO.setCreateTime(LocalDateTime.now());
            wordDOLists.add(sensitiveWordDO);
        }
        log.info("wordDOLists\u7684\u503c={}\uff0cwordDOLists\u7684size={}", wordDOLists, (Object)wordDOLists.size());
        if (null == wordDOLists || wordDOLists.size() == 0) {
            return Result.failed((String)"\u8bf7\u8f93\u5165\u654f\u611f\u8bcd\uff01");
        }
        return Result.succeed((Object)this.saveBatch(wordDOLists));
    }

    public Result<Boolean> updateSensitiveWordById(SensitiveWordDO sensitiveWordDO) {
        if (sensitiveWordDO.getContent().trim().length() > 20) {
            return Result.failed((String)("\u654f\u611f\u8bcd\uff08" + sensitiveWordDO.getContent().trim() + "\uff09\u957f\u5ea6\u5927\u4e8e20\uff0c\u8bf7\u4fee\u6539\uff01"));
        }
        if (sensitiveWordDO.getContent().trim().length() == 0) {
            return Result.failed((String)"\u654f\u611f\u8bcd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\uff01");
        }
        sensitiveWordDO.setContent(sensitiveWordDO.getContent().trim());
        sensitiveWordDO.setLastTime(LocalDateTime.now());
        return Result.succeed((Object)this.updateById(sensitiveWordDO));
    }

    public Result<Boolean> deleteSensitiveWordsByIds(List<String> idList) {
        ArrayList<SensitiveWordDO> lists = new ArrayList<SensitiveWordDO>();
        for (String id : idList) {
            SensitiveWordDO sensitiveWordDO = new SensitiveWordDO();
            sensitiveWordDO.setObjID(id);
            sensitiveWordDO.setDataStatus(Integer.valueOf(0));
            sensitiveWordDO.setLastTime(LocalDateTime.now());
            lists.add(sensitiveWordDO);
        }
        return Result.succeed((Object)this.updateBatchById(lists));
    }

    public Result<Boolean> saveSensitiveWordsFromFile(MultipartFile file) throws IOException {
        ArrayList<SensitiveWordDO> sensitiveWordDOList = new ArrayList<SensitiveWordDO>();
        String str = this.MultipartFileToString(file);
        List<Object> sheetList = new ArrayList();
        try {
            sheetList = SensitiveWordServiceImpl.getExcelData(str);
        }
        catch (Exception e) {
            return Result.failed((String)"\u5bfc\u5165\u5931\u8d25");
        }
        int rowNum = sheetList.size();
        for (int i = 1; i < rowNum; ++i) {
            if (ToolUtil.isNotEmpty((Object)sheetList.get(i))) {
                List rowList = (List)sheetList.get(i);
                int columnNum = rowList.size();
                for (int j = 0; j < columnNum; ++j) {
                    if (ToolUtil.isNotEmpty(rowList.get(j))) {
                        String cellStr = (String)((Map)rowList.get(j)).get("value");
                        if (StrUtil.isEmpty((CharSequence)cellStr.trim())) continue;
                        SensitiveWordDO sensitiveWordDO = new SensitiveWordDO();
                        sensitiveWordDO.setObjID(String.valueOf(IdWorker.getId((Object)file)));
                        if (cellStr.trim().length() > 20) {
                            return Result.failed((String)("\u654f\u611f\u8bcd\uff08" + cellStr.trim().trim() + "\uff09\u957f\u5ea6\u5927\u4e8e20\uff0c\u8bf7\u4fee\u6539\uff01"));
                        }
                        sensitiveWordDO.setContent(cellStr.trim().trim());
                        sensitiveWordDO.setDataStatus(Integer.valueOf(1));
                        sensitiveWordDO.setCreateTime(LocalDateTime.now());
                        sensitiveWordDO.setLastTime(LocalDateTime.now());
                        sensitiveWordDOList.add(sensitiveWordDO);
                        continue;
                    }
                    ++columnNum;
                }
                continue;
            }
            ++rowNum;
        }
        if (null == sensitiveWordDOList || sensitiveWordDOList.size() == 0) {
            return Result.failed((String)"\u8bf7\u8f93\u5165\u654f\u611f\u8bcd\uff01");
        }
        return Result.succeed((Object)this.saveBatch(sensitiveWordDOList));
    }

    private String MultipartFileToString(MultipartFile multipartFile) {
        StringBuilder txtResult = new StringBuilder();
        try {
            String lineTxt;
            InputStreamReader isr = new InputStreamReader(multipartFile.getInputStream(), StandardCharsets.UTF_8);
            BufferedReader br = new BufferedReader(isr);
            while ((lineTxt = br.readLine()) != null) {
                txtResult.append(lineTxt);
            }
            isr.close();
            br.close();
            return txtResult.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static List<List<Map<String, String>>> getExcelData(String tableHtml) {
        Document document = Jsoup.parse((String)tableHtml);
        Elements tbody = document.select("tbody").select("tr");
        ArrayList<Integer> tdSize = new ArrayList<Integer>();
        for (Element element : tbody) {
            tdSize.add(element.select("td").size());
        }
        Collections.sort(tdSize);
        int rowCellNum = (Integer)tdSize.get(tdSize.size() - 1);
        Elements trAll = document.select("tr");
        int excelDataSize = trAll.size();
        ArrayList<List<Map<String, String>>> excelData = new ArrayList<List<Map<String, String>>>();
        for (int i = 0; i < excelDataSize; ++i) {
            excelData.add(new ArrayList());
            for (int j = 0; j < rowCellNum; ++j) {
                ((List)excelData.get(i)).add(new HashMap());
            }
        }
        for (int rowNum = 0; rowNum < excelData.size(); ++rowNum) {
            Element element = (Element)trAll.get(rowNum);
            Elements th = element.select("th");
            Elements td = element.select("td");
            int index = 0;
            for (int cellNum = 0; cellNum < ((List)excelData.get(rowNum)).size(); ++cellNum) {
                String cellHtml;
                if (((Map)((List)excelData.get(rowNum)).get(cellNum)).get("value") != null) continue;
                Element cell = null;
                String style = "";
                if (th.size() != 0) {
                    style = "th";
                    ((Map)((List)excelData.get(rowNum)).get(cellNum)).put("style", style);
                    if (th.size() > index) {
                        cell = (Element)th.get(index);
                    }
                }
                if (td.size() != 0) {
                    style = "td";
                    ((Map)((List)excelData.get(rowNum)).get(cellNum)).put("style", style);
                    if (td.size() > index) {
                        cell = (Element)td.get(index);
                    }
                }
                String value = cell == null ? "" : cell.text();
                String string = cellHtml = cell == null ? "" : cell.outerHtml();
                if (cellHtml.indexOf("rowspan") != -1 && cellHtml.indexOf("\"\"") == -1 || cellHtml.indexOf("colspan") != -1 && cellHtml.indexOf("\"\"") == -1) {
                    String rowspanValue = "0";
                    String colspanValue = "0";
                    if (cellHtml.indexOf("rowspan") != -1 && cellHtml.indexOf("\"\"") == -1) {
                        String rowspanValueStr = cellHtml.substring(cellHtml.indexOf("rowspan") + 7);
                        rowspanValueStr = rowspanValueStr.substring(rowspanValueStr.indexOf("\"") + 1);
                        rowspanValue = rowspanValueStr = rowspanValueStr.substring(0, rowspanValueStr.indexOf("\""));
                        ((Map)((List)excelData.get(rowNum)).get(cellNum)).put("rowspanValue", rowspanValue);
                    }
                    if (cellHtml.indexOf("colspan") != -1 && cellHtml.indexOf("\"\"") == -1) {
                        String colspanValueStr = cellHtml.substring(cellHtml.indexOf("colspan") + 7);
                        colspanValueStr = colspanValueStr.substring(colspanValueStr.indexOf("\"") + 1);
                        colspanValue = colspanValueStr = colspanValueStr.substring(0, colspanValueStr.indexOf("\""));
                        ((Map)((List)excelData.get(rowNum)).get(cellNum)).put("colspanValue", colspanValue);
                    }
                    if (Integer.parseInt(rowspanValue) > 0 && Integer.parseInt(colspanValue) > 0) {
                        for (int i = 1; i < Integer.parseInt(rowspanValue); ++i) {
                            ((Map)((List)excelData.get(rowNum + i)).get(cellNum)).put("value", value);
                            ((Map)((List)excelData.get(rowNum + i)).get(cellNum)).put("style", style);
                            for (int j = 1; j < Integer.parseInt(colspanValue); ++j) {
                                ((Map)((List)excelData.get(rowNum)).get(cellNum + j)).put("value", value);
                                ((Map)((List)excelData.get(rowNum)).get(cellNum + j)).put("style", style);
                                ((Map)((List)excelData.get(rowNum + i)).get(cellNum + j)).put("value", value);
                                ((Map)((List)excelData.get(rowNum + i)).get(cellNum + j)).put("style", style);
                            }
                        }
                    } else {
                        if (Integer.parseInt(rowspanValue) > 0) {
                            for (int i = 1; i < Integer.parseInt(rowspanValue); ++i) {
                                ((Map)((List)excelData.get(rowNum + i)).get(cellNum)).put("value", value);
                                ((Map)((List)excelData.get(rowNum + i)).get(cellNum)).put("style", style);
                            }
                        }
                        if (Integer.parseInt(colspanValue) > 0) {
                            for (int j = 1; j < Integer.parseInt(colspanValue); ++j) {
                                ((Map)((List)excelData.get(rowNum)).get(cellNum + j)).put("value", value);
                                ((Map)((List)excelData.get(rowNum)).get(cellNum + j)).put("style", style);
                            }
                        }
                    }
                }
                ((Map)((List)excelData.get(rowNum)).get(cellNum)).put("value", value);
                ++index;
            }
        }
        return excelData;
    }

    public Result<Boolean> notice(CurrentLoginUser currentLoginUser) {
        try {
            ActiveMQTopic topic = new ActiveMQTopic(this.topicName);
            MessageType messageType = new MessageType();
            messageType.setType(Integer.valueOf(1));
            messageType.setValue(Integer.valueOf(-1));
            if (ToolUtil.isNotEmpty((Object)currentLoginUser.getCompanyID())) {
                messageType.setCompanyId(currentLoginUser.getCompanyID().toString());
            }
            String json = JSON.toJSONString((Object)messageType);
            log.info(json);
            this.jmsMessagingTemplate.convertAndSend((Object)topic, (Object)json);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.succeed((Object)Boolean.FALSE);
        }
        return Result.succeed((Object)Boolean.TRUE);
    }
}

