/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.mp.common.model.group.GroupVO;
import com.jxdinfo.mp.im.dao.group.GroupMapper;
import com.jxdinfo.mp.im.dao.group.GroupUserMapper;
import com.jxdinfo.mp.im.model.db.GroupDO;
import com.jxdinfo.mp.im.model.db.GroupUserDO;
import com.jxdinfo.mp.im.model.group.GroupUserVO;
import com.jxdinfo.mp.im.service.GroupCacheService;
import com.jxdinfo.mp.im.service.GroupUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class GroupUserServiceImpl
extends ServiceImpl<GroupUserMapper, GroupUserDO>
implements GroupUserService {
    @Resource
    GroupCacheService groupCacheService;
    @Resource
    GroupUserMapper groupUserMapper;
    @Resource
    private GroupMapper groupMapper;

    public GroupUserDO getOne(Wrapper<GroupUserDO> queryWrapper) {
        return (GroupUserDO)super.getOne(queryWrapper);
    }

    public boolean updateById(GroupUserDO entity) {
        return super.updateById((Object)entity);
    }

    public boolean saveBatch(Collection<GroupUserDO> entityList) {
        return super.saveBatch(entityList);
    }

    public boolean update(GroupUserDO entity, Wrapper<GroupUserDO> updateWrapper) {
        return super.update((Object)entity, updateWrapper);
    }

    public boolean updateBatchById(Collection<GroupUserDO> entityList) {
        return super.updateBatchById(entityList);
    }

    public List<GroupUserVO> getAllRoomId(Long userID) {
        return this.groupUserMapper.getAllRoomId(userID);
    }

    public boolean cleanGroupCache(Long userID) {
        QueryWrapper groupUserWrapper = new QueryWrapper();
        groupUserWrapper.in((Object)"USER_ID", new Object[]{userID});
        ArrayList groupIDList = new ArrayList();
        List groupUserList = this.groupUserMapper.selectList((Wrapper)groupUserWrapper);
        groupUserList.forEach(groupUser -> groupIDList.add(groupUser.getGroupID()));
        this.groupCacheService.clearGroupChatCache(groupIDList);
        return true;
    }

    public List<GroupDO> selectGroup(Long organiseID) {
        QueryWrapper groupWrapper = new QueryWrapper();
        groupWrapper.eq((Object)"ADMIN_ID", (Object)organiseID);
        return this.groupMapper.selectList((Wrapper)groupWrapper);
    }

    public List<Long> getOrgGroupIDList(List<Long> orgIDList) {
        List<GroupVO> groupVOList = this.groupMapper.getOrgGroupList(orgIDList);
        ArrayList<Long> orgGroupIDList = new ArrayList<Long>();
        groupVOList.forEach(groupVO -> orgGroupIDList.add(groupVO.getRoomID()));
        return orgGroupIDList;
    }

    public List<GroupUserDO> getGroupUserList(Long userID) {
        return this.groupMapper.getGroupUserList(userID);
    }

    public int deleteMember(Long groupId, List<Long> orgIDList) {
        return this.groupMapper.deleteMember(groupId, orgIDList);
    }

    public int insertGroupUser(List<GroupUserDO> groupUserList) {
        this.groupUserMapper.insertGroupUser(groupUserList);
        return 0;
    }
}

