/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.im.dao.group.GroupMapper;
import com.jxdinfo.mp.im.model.single.ReceiptVO;
import com.jxdinfo.mp.im.service.GroupMessageService;
import com.jxdinfo.mp.im.service.GroupUserService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class GroupMessageServiceImpl
implements GroupMessageService {
    @Resource
    private GroupUserService groupUserService;
    @Resource
    private GroupMapper groupMapper;

    public PageDTO<ReceiptVO> getGroupReceiptList(PageDTO<ReceiptVO> pageDTO, Long groupID, Long userID) {
        ArrayList arrayList = new ArrayList();
        List<Object> rosterVOList = this.groupMapper.getAllUserByRoomID(groupID);
        rosterVOList = rosterVOList.stream().filter(rosterVO -> !rosterVO.getUserId().equals(userID)).collect(Collectors.toList());
        rosterVOList.forEach(rosterVO -> {
            ReceiptVO receiptVO = new ReceiptVO();
            receiptVO.setUserID(rosterVO.getUserId().toString());
            receiptVO.setReceiptTime(Long.valueOf(rosterVO.getReceiptTime() == null ? 0L : Long.parseLong(rosterVO.getReceiptTime())));
            arrayList.add(receiptVO);
        });
        pageDTO.setList(arrayList);
        pageDTO.setPageCount(Integer.valueOf(arrayList.size()));
        return pageDTO;
    }

    public Boolean updateGroupUserReceipt(Long userID, Long groupID, Long receiptTime) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"GROUP_ID", (Object)groupID);
        updateWrapper.eq((Object)"USER_ID", (Object)userID);
        updateWrapper.set((Object)"RECEIPT_TIME", (Object)receiptTime);
        return this.groupUserService.update((Wrapper)updateWrapper);
    }

    public PageDTO<RosterVO> getMessageReceiptUser(PageDTO<RosterVO> pageDTO, int type, long msgTime, Long groupID, Long userID) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"EGU.DATA_STATUS", (Object)"1");
        queryWrapper.eq((Object)"EGU.GROUP_ID", (Object)groupID);
        queryWrapper.ne((Object)"EGU.USER_ID", (Object)userID);
        if (type == 0) {
            queryWrapper.and(q -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)q.lt((Object)"EGU.RECEIPT_TIME", (Object)msgTime)).or()).isNull((Object)"EGU.RECEIPT_TIME");
            });
        } else {
            queryWrapper.ge((Object)"EGU.RECEIPT_TIME", (Object)msgTime);
        }
        return this.groupMapper.getAllUserByRoomIDPage(pageDTO, groupID, type, msgTime, userID);
    }
}

