/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.workstation.application.service.ISysWorkstationAppService;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.im.EimPubPlatService;
import com.jxdinfo.mp.im.dao.single.PubMsgLogMapper;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.push.PushMessageDTO;
import com.jxdinfo.mp.im.model.single.PubMsgLogDO;
import com.jxdinfo.mp.im.model.single.PubMsgLogDTO;
import com.jxdinfo.mp.im.service.DealMessageService;
import com.jxdinfo.mp.im.service.PubPlatMessageService;
import com.jxdinfo.mp.push.service.MessageProducerService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DealMessageServiceImpl
implements DealMessageService {
    @Autowired(required=false)
    private EimPubPlatService pubPlatService;
    @Resource
    private MessageProducerService pushService;
    @Resource
    private PubMsgLogMapper pubMsgLogMapper;
    @Resource
    private PubPlatMessageService pubPlatMessageService;
    @Resource
    private ISysWorkstationAppService sysWorkstationAppService;

    public boolean sendMsg(BaseMsgBean msgBean, String userIDs) {
        PushMessageDTO pushMessageDTO = new PushMessageDTO();
        if (ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser()) && ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser().getTenantId())) {
            msgBean.setCompID(ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser().getTenantId()) ? BaseSecurityUtil.getUser().getTenantId().toString() : null);
            msgBean.setCompName(BaseSecurityUtil.getUser().getTenantName());
        }
        if (StrUtil.isEmpty((CharSequence)userIDs)) {
            List<String> userIDList = this.pubPlatService.getPermissionID(Long.parseLong(msgBean.getReceiverCode()));
            if (userIDList.isEmpty()) {
                return false;
            }
            userIDs = CollUtil.join(userIDList.iterator(), (CharSequence)",");
        }
        if (!StrUtil.isEmpty((CharSequence)userIDs)) {
            this.pubMsgLogMapper.addArticlePerson(CollUtil.toList((Object[])userIDs.split(",")), Long.parseLong(msgBean.getMsgID()));
        }
        msgBean.setPubplatReceiverCode(userIDs);
        pushMessageDTO.setReceiverIds(userIDs);
        pushMessageDTO.setBaseMsgBean(msgBean);
        pushMessageDTO.setMode(msgBean.getMode());
        pushMessageDTO.setMsgType(msgBean.getMsgType());
        return this.pushService.sendMessage(pushMessageDTO);
    }

    @Transactional
    public boolean savePubMsg(PubMsgLogDTO pubMsgLogDTO, int state, CurrentLoginUser loginUser, String urlSplicing) {
        if (ToolUtil.isEmpty((Object)pubMsgLogDTO.getMsgID())) {
            pubMsgLogDTO.setMsgID(Long.valueOf(IdWorker.getId((Object)pubMsgLogDTO)));
        }
        String time = DateUtil.now();
        pubMsgLogDTO = this.pubPlatMessageService.executeMaterial(pubMsgLogDTO, loginUser, urlSplicing);
        PubMsgLogDO pubMsgLogDO = new PubMsgLogDO();
        pubMsgLogDO.setObjID(pubMsgLogDTO.getMsgID());
        pubMsgLogDO.setCreateTime(time);
        pubMsgLogDO.setMaterialID(pubMsgLogDTO.getMaterialDTO().getObjID());
        pubMsgLogDO.setMsgType(pubMsgLogDTO.getMaterialDTO().getMaterialType());
        pubMsgLogDO.setPubPlatID(pubMsgLogDTO.getPubPlatID());
        pubMsgLogDO.setUserID(null);
        pubMsgLogDO.setMode(Integer.valueOf(0));
        pubMsgLogDO.setSendTime(time);
        pubMsgLogDO.setState(Integer.valueOf(state));
        pubMsgLogDO.setUserIds(pubMsgLogDTO.getUserIdStr());
        pubMsgLogDO.setOrganIds(pubMsgLogDTO.getOrganiseIDs());
        pubMsgLogDO.setRoleIds(pubMsgLogDTO.getRoleIDs());
        return this.pubMsgLogMapper.insert(pubMsgLogDO) > 0;
    }
}

