/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.jxdinfo.hussar.application.service.ISysAppVisitAuthorizationService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.mp.im.service.AppPermissionDetail;
import com.jxdinfo.mp.im.service.IAppPermissionService;
import com.jxdinfo.mp.im.service.PermissionValidationResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppPermissionServiceImpl
implements IAppPermissionService {
    private static final Logger log = LoggerFactory.getLogger(AppPermissionServiceImpl.class);
    @Autowired
    private ISysAppVisitAuthorizationService sysAppVisitAuthorizationService;
    @Autowired
    private IHussarBaseUserBoService userBoService;
    private static final String CACHE_PREFIX = "PubPlat:users:";
    private static final String CACHE_NAME = "eim_cache";
    private static final long CACHE_EXPIRE_MINUTES = 5L;

    public List<String> getPermissionUserIds(Long appId) {
        if (appId == null) {
            log.warn("[\u6743\u9650\u7ba1\u7406] \u5fae\u5e94\u7528ID\u4e3a\u7a7a\uff0c\u8fd4\u56de\u7a7a\u5217\u8868");
            return new ArrayList<String>();
        }
        try {
            String cacheKey = CACHE_PREFIX + appId;
            List cachedUserIds = (List)HussarCacheUtil.get((String)CACHE_NAME, (Object)cacheKey);
            if (ToolUtil.isNotEmpty((Object)cachedUserIds)) {
                log.debug("[\u6743\u9650\u7ba1\u7406] \u4ece\u7f13\u5b58\u83b7\u53d6\u6743\u9650\u7528\u6237\uff0cappId: {}, \u7528\u6237\u6570: {}", (Object)appId, (Object)cachedUserIds.size());
                return cachedUserIds;
            }
            List<String> permissionUserIds = this.fetchPermissionUserIdsFromDB(appId);
            HussarCacheUtil.put((String)CACHE_NAME, (Object)cacheKey, permissionUserIds, (long)300L);
            log.info("[\u6743\u9650\u7ba1\u7406] \u83b7\u53d6\u5fae\u5e94\u7528\u6743\u9650\u7528\u6237\u5b8c\u6210\uff0cappId: {}, \u6743\u9650\u7528\u6237\u6570: {}", (Object)appId, (Object)permissionUserIds.size());
            return permissionUserIds;
        }
        catch (Exception e) {
            log.error("[\u6743\u9650\u7ba1\u7406] \u83b7\u53d6\u5fae\u5e94\u7528\u6743\u9650\u7528\u6237\u5931\u8d25\uff0cappId: {}", (Object)appId, (Object)e);
            return new ArrayList<String>();
        }
    }

    public Set<String> filterPermissionUsers(Set<String> userIds, Long appId) {
        if (CollUtil.isEmpty(userIds) || appId == null) {
            return userIds != null ? userIds : new HashSet<String>();
        }
        try {
            List<String> permissionUserIds = this.getPermissionUserIds(appId);
            HashSet<String> permissionUserSet = new HashSet<String>(permissionUserIds);
            Set<String> authorizedUsers = userIds.stream().filter(permissionUserSet::contains).collect(Collectors.toSet());
            Set unauthorizedUsers = userIds.stream().filter(userId -> !permissionUserSet.contains(userId)).collect(Collectors.toSet());
            log.info("[\u6743\u9650\u7ba1\u7406] \u6743\u9650\u8fc7\u6ee4\u5b8c\u6210\uff0cappId: {}, \u539f\u59cb\u7528\u6237\u6570: {}, \u6709\u6743\u9650\u7528\u6237\u6570: {}, \u65e0\u6743\u9650\u7528\u6237\u6570: {}", new Object[]{appId, userIds.size(), authorizedUsers.size(), unauthorizedUsers.size()});
            if (!unauthorizedUsers.isEmpty()) {
                log.warn("[\u6743\u9650\u7ba1\u7406] \u4ee5\u4e0b\u7528\u6237\u65e0\u5fae\u5e94\u7528\u6743\u9650\uff0c\u5df2\u8fc7\u6ee4: {}", unauthorizedUsers);
            }
            return authorizedUsers;
        }
        catch (Exception e) {
            log.error("[\u6743\u9650\u7ba1\u7406] \u6743\u9650\u8fc7\u6ee4\u5f02\u5e38\uff0cappId: {}", (Object)appId, (Object)e);
            return userIds;
        }
    }

    public Set<String> filterPermissionUsers(Set<String> userIds, String appId) {
        if (StrUtil.isEmpty((CharSequence)appId)) {
            return userIds != null ? userIds : new HashSet();
        }
        try {
            Long appIdLong = Long.parseLong(appId);
            return this.filterPermissionUsers(userIds, appIdLong);
        }
        catch (NumberFormatException e) {
            log.error("[\u6743\u9650\u7ba1\u7406] \u5fae\u5e94\u7528ID\u683c\u5f0f\u9519\u8bef\uff0cappId: {}", (Object)appId, (Object)e);
            return userIds != null ? userIds : new HashSet();
        }
    }

    public boolean hasPermission(String userId, Long appId) {
        if (StrUtil.isEmpty((CharSequence)userId) || appId == null) {
            return false;
        }
        List<String> permissionUserIds = this.getPermissionUserIds(appId);
        return permissionUserIds.contains(userId);
    }

    public List<String> getPubPlatPermissionUserIds(Long appId) {
        return this.getPermissionUserIds(appId);
    }

    public void clearPermissionCache(Long appId) {
        if (appId == null) {
            return;
        }
        String cacheKey = CACHE_PREFIX + appId;
        HussarCacheUtil.evict((String)CACHE_NAME, (Object)cacheKey);
        log.info("[\u6743\u9650\u7ba1\u7406] \u6e05\u9664\u6743\u9650\u7f13\u5b58\uff0cappId: {}", (Object)appId);
    }

    public void clearPermissionCache(List<Long> appIds) {
        if (CollUtil.isEmpty(appIds)) {
            return;
        }
        for (Long appId : appIds) {
            this.clearPermissionCache(appId);
        }
    }

    public List<String> refreshPermissionCache(Long appId) {
        if (appId == null) {
            return new ArrayList<String>();
        }
        this.clearPermissionCache(appId);
        return this.getPermissionUserIds(appId);
    }

    private List<String> fetchPermissionUserIdsFromDB(Long appId) {
        List permissionPostIds;
        List permissionRoleIds;
        List permissionOrganIds;
        List userTemp;
        Map roleDateMap = (Map)this.sysAppVisitAuthorizationService.getAppRoleList(appId).getData();
        List permissionUsers = (List)roleDateMap.get("users");
        List permissionOrgans = (List)roleDateMap.get("organs");
        List permissionRoles = (List)roleDateMap.get("roles");
        List permissionPosts = (List)roleDateMap.get("posts");
        ArrayList permissionUserIds = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)permissionUsers)) {
            permissionUserIds.addAll(permissionUsers.stream().map(RoleVo::getId).map(String::valueOf).collect(Collectors.toList()));
        }
        if (ToolUtil.isNotEmpty((Object)permissionOrgans) && ToolUtil.isNotEmpty((Object)(userTemp = this.userBoService.getUsersByOrganUser(permissionOrganIds = permissionOrgans.stream().map(RoleVo::getId).collect(Collectors.toList()), null)))) {
            permissionUserIds.addAll(userTemp.stream().map(UserVo::getId).map(String::valueOf).collect(Collectors.toList()));
        }
        if (ToolUtil.isNotEmpty((Object)permissionRoles) && ToolUtil.isNotEmpty((Object)(userTemp = this.userBoService.getUserInfoByRoleId(permissionRoleIds = permissionRoles.stream().map(RoleVo::getId).collect(Collectors.toList()))))) {
            permissionUserIds.addAll(userTemp.stream().map(UserVo::getId).map(String::valueOf).collect(Collectors.toList()));
        }
        if (ToolUtil.isNotEmpty((Object)permissionPosts) && ToolUtil.isNotEmpty((Object)(userTemp = this.userBoService.getUsersByPostIds(permissionPostIds = permissionPosts.stream().map(RoleVo::getId).collect(Collectors.toList()))))) {
            permissionUserIds.addAll(userTemp.stream().map(UserVo::getId).map(String::valueOf).collect(Collectors.toList()));
        }
        return permissionUserIds.stream().distinct().collect(Collectors.toList());
    }

    public AppPermissionDetail getAppPermissionDetail(Long appId) {
        if (appId == null) {
            log.warn("\u5fae\u5e94\u7528ID\u4e0d\u80fd\u4e3a\u7a7a");
            return new AppPermissionDetail(new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
        }
        try {
            Map roleDateMap = (Map)this.sysAppVisitAuthorizationService.getAppRoleList(appId).getData();
            if (roleDateMap == null) {
                log.warn("\u672a\u627e\u5230\u5fae\u5e94\u7528[{}]\u7684\u6743\u9650\u914d\u7f6e", (Object)appId);
                return new AppPermissionDetail(new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
            }
            List permissionUsers = (List)roleDateMap.get("users");
            List permissionOrgans = (List)roleDateMap.get("organs");
            List permissionRoles = (List)roleDateMap.get("roles");
            List permissionPosts = (List)roleDateMap.get("posts");
            ArrayList permissionUserIds = new ArrayList();
            if (ToolUtil.isNotEmpty((Object)permissionUsers)) {
                permissionUserIds.addAll(permissionUsers.stream().map(RoleVo::getId).map(String::valueOf).collect(Collectors.toList()));
            }
            List<Object> permissionOrganIds = new ArrayList();
            if (ToolUtil.isNotEmpty((Object)permissionOrgans)) {
                permissionOrganIds = permissionOrgans.stream().map(RoleVo::getId).collect(Collectors.toList());
            }
            List<Object> permissionRoleIds = new ArrayList();
            if (ToolUtil.isNotEmpty((Object)permissionRoles)) {
                permissionRoleIds = permissionRoles.stream().map(RoleVo::getId).collect(Collectors.toList());
            }
            List<Object> permissionPostIds = new ArrayList();
            if (ToolUtil.isNotEmpty((Object)permissionPosts)) {
                permissionPostIds = permissionPosts.stream().map(RoleVo::getId).collect(Collectors.toList());
            }
            return new AppPermissionDetail(permissionUserIds, permissionOrganIds, permissionRoleIds, permissionPostIds);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5fae\u5e94\u7528[{}]\u6743\u9650\u8be6\u60c5\u5931\u8d25", (Object)appId, (Object)e);
            return new AppPermissionDetail(new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
        }
    }

    public PermissionValidationResult validateUserPermissions(String userIds, Long appId) {
        if (StrUtil.isEmpty((CharSequence)userIds) || appId == null) {
            return PermissionValidationResult.success();
        }
        try {
            AppPermissionDetail permissionDetail = this.getAppPermissionDetail(appId);
            List permissionUserIds = permissionDetail.getPermissionUserIds();
            List inputUserIds = Arrays.stream(userIds.split(",")).map(String::trim).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList());
            List invalidUserIds = inputUserIds.stream().filter(userId -> !permissionUserIds.contains(userId)).collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(invalidUserIds)) {
                return PermissionValidationResult.failure((String)"\u5305\u542b\u4e0d\u53ef\u4ee5\u63a8\u9001\u6d88\u606f\u7684\u7528\u6237\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u6743\u9650\u4fe1\u606f", invalidUserIds);
            }
            return PermissionValidationResult.success();
        }
        catch (Exception e) {
            log.error("\u9a8c\u8bc1\u7528\u6237\u6743\u9650\u5931\u8d25\uff0cappId: {}, userIds: {}", new Object[]{appId, userIds, e});
            return PermissionValidationResult.failure((String)("\u6743\u9650\u9a8c\u8bc1\u5931\u8d25: " + e.getMessage()), null);
        }
    }

    public PermissionValidationResult validateOrganPermissions(String organIds, Long appId) {
        if (StrUtil.isEmpty((CharSequence)organIds) || appId == null) {
            return PermissionValidationResult.success();
        }
        try {
            AppPermissionDetail permissionDetail = this.getAppPermissionDetail(appId);
            List permissionOrganIds = permissionDetail.getPermissionOrganIds();
            List inputOrganIds = Arrays.stream(organIds.split(",")).map(String::trim).filter(CharSequenceUtil::isNotEmpty).map(Long::parseLong).collect(Collectors.toList());
            List invalidOrganIds = inputOrganIds.stream().filter(organId -> !permissionOrganIds.contains(organId)).map(String::valueOf).collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(invalidOrganIds)) {
                return PermissionValidationResult.failure((String)"\u5305\u542b\u4e0d\u53ef\u4ee5\u63a8\u9001\u6d88\u606f\u7684\u7ec4\u7ec7\u673a\u6784\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u6743\u9650\u4fe1\u606f", invalidOrganIds);
            }
            return PermissionValidationResult.success();
        }
        catch (Exception e) {
            log.error("\u9a8c\u8bc1\u7ec4\u7ec7\u6743\u9650\u5931\u8d25\uff0cappId: {}, organIds: {}", new Object[]{appId, organIds, e});
            return PermissionValidationResult.failure((String)("\u6743\u9650\u9a8c\u8bc1\u5931\u8d25: " + e.getMessage()), null);
        }
    }

    public PermissionValidationResult validateRolePermissions(String roleIds, Long appId) {
        if (StrUtil.isEmpty((CharSequence)roleIds) || appId == null) {
            return PermissionValidationResult.success();
        }
        try {
            AppPermissionDetail permissionDetail = this.getAppPermissionDetail(appId);
            List permissionRoleIds = permissionDetail.getPermissionRoleIds();
            List inputRoleIds = Arrays.stream(roleIds.split(",")).map(String::trim).filter(CharSequenceUtil::isNotEmpty).map(Long::parseLong).collect(Collectors.toList());
            List invalidRoleIds = inputRoleIds.stream().filter(roleId -> !permissionRoleIds.contains(roleId)).map(String::valueOf).collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(invalidRoleIds)) {
                return PermissionValidationResult.failure((String)"\u5305\u542b\u4e0d\u53ef\u4ee5\u63a8\u9001\u6d88\u606f\u7684\u89d2\u8272\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u6743\u9650\u4fe1\u606f", invalidRoleIds);
            }
            return PermissionValidationResult.success();
        }
        catch (Exception e) {
            log.error("\u9a8c\u8bc1\u89d2\u8272\u6743\u9650\u5931\u8d25\uff0cappId: {}, roleIds: {}", new Object[]{appId, roleIds, e});
            return PermissionValidationResult.failure((String)("\u6743\u9650\u9a8c\u8bc1\u5931\u8d25: " + e.getMessage()), null);
        }
    }
}

