/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.enums;

import com.jxdinfo.mp.common.enums.BaseErrorCode;

public enum GroupErrorCode implements BaseErrorCode
{
    GROUP_NOT_EXIST(20001, "\u7fa4\u804a\u4e0d\u5b58\u5728"),
    GROUP_ALREADY_EXIST(20002, "\u7fa4\u804a\u5df2\u5b58\u5728"),
    GROUP_NAME_EMPTY(20003, "\u7fa4\u804a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"),
    GROUP_NAME_TOO_LONG(20004, "\u7fa4\u804a\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26"),
    GROUP_DESCRIPTION_TOO_LONG(20005, "\u7fa4\u804a\u63cf\u8ff0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7200\u4e2a\u5b57\u7b26"),
    GROUP_MEMBER_LIMIT_EXCEEDED(20006, "\u7fa4\u804a\u6210\u5458\u6570\u91cf\u5df2\u8fbe\u4e0a\u9650"),
    GROUP_ALREADY_DISSOLVED(20007, "\u7fa4\u804a\u5df2\u89e3\u6563"),
    GROUP_STATUS_INVALID(20008, "\u7fa4\u804a\u72b6\u6001\u5f02\u5e38"),
    GROUP_PERMISSION_DENIED(20101, "\u65e0\u6743\u9650\u64cd\u4f5c\u8be5\u7fa4\u804a"),
    GROUP_NOT_ADMIN(20102, "\u60a8\u4e0d\u662f\u7fa4\u7ba1\u7406\u5458"),
    GROUP_NOT_OWNER(20103, "\u60a8\u4e0d\u662f\u7fa4\u4e3b"),
    GROUP_OWNER_CANNOT_QUIT(20104, "\u7fa4\u4e3b\u4e0d\u80fd\u9000\u51fa\u7fa4\u804a\uff0c\u8bf7\u5148\u8f6c\u8ba9\u7fa4\u4e3b"),
    GROUP_ADMIN_OPERATION_DENIED(20105, "\u7ba1\u7406\u5458\u65e0\u6743\u8fdb\u884c\u6b64\u64cd\u4f5c"),
    GROUP_MEMBER_NOT_EXIST(20201, "\u7528\u6237\u4e0d\u5728\u7fa4\u804a\u4e2d"),
    GROUP_MEMBER_ALREADY_EXIST(20202, "\u7528\u6237\u5df2\u5728\u7fa4\u804a\u4e2d"),
    GROUP_MEMBER_CANNOT_ADD_SELF(20203, "\u4e0d\u80fd\u6dfb\u52a0\u81ea\u5df1\u5230\u7fa4\u804a"),
    GROUP_MEMBER_LIST_EMPTY(20204, "\u6210\u5458\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a"),
    GROUP_MEMBER_INVALID(20205, "\u65e0\u6548\u7684\u7fa4\u6210\u5458"),
    GROUP_OWNER_CANNOT_BE_REMOVED(20206, "\u4e0d\u80fd\u79fb\u9664\u7fa4\u4e3b"),
    GROUP_ADMIN_CANNOT_REMOVE_ADMIN(20207, "\u7ba1\u7406\u5458\u4e0d\u80fd\u79fb\u9664\u5176\u4ed6\u7ba1\u7406\u5458"),
    GROUP_CREATE_FAILED(20301, "\u521b\u5efa\u7fa4\u804a\u5931\u8d25"),
    GROUP_UPDATE_FAILED(20302, "\u66f4\u65b0\u7fa4\u804a\u4fe1\u606f\u5931\u8d25"),
    GROUP_DELETE_FAILED(20303, "\u5220\u9664\u7fa4\u804a\u5931\u8d25"),
    GROUP_JOIN_FAILED(20304, "\u52a0\u5165\u7fa4\u804a\u5931\u8d25"),
    GROUP_QUIT_FAILED(20305, "\u9000\u51fa\u7fa4\u804a\u5931\u8d25"),
    GROUP_TRANSFER_FAILED(20306, "\u8f6c\u8ba9\u7fa4\u4e3b\u5931\u8d25"),
    GROUP_INVITE_FAILED(20307, "\u9080\u8bf7\u6210\u5458\u5931\u8d25"),
    GROUP_REMOVE_MEMBER_FAILED(20308, "\u79fb\u9664\u6210\u5458\u5931\u8d25"),
    PARAMETER_INVALID(20401, "\u53c2\u6570\u65e0\u6548"),
    PARAMETER_MISSING(20402, "\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570"),
    GROUP_SYSTEM_ERROR(20501, "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");

    private final int code;
    private final String message;

    private GroupErrorCode(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public int getResponseCode() {
        return 10001;
    }

    public static GroupErrorCode getByCode(int code) {
        for (GroupErrorCode errorCode : GroupErrorCode.values()) {
            if (errorCode.getCode() != code) continue;
            return errorCode;
        }
        return null;
    }

    public static boolean isGroupErrorCode(int code) {
        return code >= 20001 && code <= 20599;
    }
}

