/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.FileVO;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.WithDrawMsgBean;
import com.jxdinfo.mp.im.model.single.MessageDO;
import com.jxdinfo.mp.im.model.single.SingleMessageVO;
import com.jxdinfo.mp.im.model.single.VideoUserVO;
import com.jxdinfo.mp.im.service.MessageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u6d88\u606f\u76f8\u5173\u63a7\u5236\u5668"})
@RestController
@ApiVersion
@RequestMapping(value={"/v1/message"})
public class MessageController {
    private static final Logger log = LoggerFactory.getLogger(MessageController.class);
    @Resource
    private MessageService messageService;
    @Resource
    public Environment environment;

    @ApiOperation(value="\u540c\u6b65\u5386\u53f2\u6d88\u606f")
    @GetMapping(value={"/synchronization"})
    public Result<Map<String, Object>> getRecentMessage(@RequestParam(required=false) @ApiParam(value="\u540c\u6b65\u65f6\u95f4") String time, @RequestParam(required=false) @ApiParam(value="\u4e0a\u6b21\u540c\u6b65\u65f6\u95f4") String synctime, @RequestParam(required=false, defaultValue="20") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u6570") int pageNum, @ApiIgnore @LoginUser CurrentLoginUser loginUser) {
        long start = System.currentTimeMillis();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Integer property = (Integer)this.environment.getProperty("mp.im.sync_message_days", Integer.class, (Object)7);
        if (StrUtil.isEmpty((CharSequence)time)) {
            time = DateUtil.formatDateTime((Date)DateUtil.offsetDay((Date)DateUtil.date(), (int)(-property.intValue()))) + ":000";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        long startTimeStamp = 0L;
        try {
            startTimeStamp = sdf.parse(time).getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        if (pageNum == 1) {
            if (!StrUtil.isEmpty((CharSequence)synctime)) {
                resultMap.put("stamp", this.messageService.getOperationTimeByUserId(loginUser.getId().toString(), DateUtil.parseDateTime((CharSequence)synctime).getTime()));
            } else {
                resultMap.put("stamp", this.messageService.getOperationTimeByUserId(loginUser.getId().toString(), startTimeStamp));
            }
            resultMap.put("synctime", DateUtil.now());
        }
        PageVO pageVO = new PageVO();
        pageVO.setPageSize(Integer.valueOf(pageSize));
        pageVO.setPageNum(Integer.valueOf(pageNum));
        resultMap.put("log", this.messageService.getRecentMessages(pageVO, loginUser.getId().toString(), startTimeStamp, null));
        log.error("\u540c\u6b65\u5386\u53f2\u6d88\u606f\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start + "ms"));
        return Result.succeed(resultMap);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e2a\u4eba\u4e0e\u597d\u53cb\u804a\u5929\u8bb0\u5f55")
    @GetMapping(value={"/single/{friendID}"})
    public Result<PageVO<BaseMsgBean>> getSingleMessage(@PathVariable @ApiParam(value="\u597d\u53cbID") String friendID, @RequestParam(required=false) @ApiParam(value="\u6a21\u7cca\u67e5\u8be2\u6587\u4ef6\u540d\u3001\u6d88\u606f\u5185\u5bb9") String searchKey, @RequestParam(required=false) @ApiParam(value="\u6d88\u606f\u7c7b\u578b") Integer msgTypes, @RequestParam(required=false, defaultValue="20") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u6570") int pageNum, @ApiIgnore @LoginUser CurrentLoginUser loginUser) {
        PageVO pageVO = new PageVO();
        pageVO.setPageSize(Integer.valueOf(pageSize));
        pageVO.setPageNum(Integer.valueOf(pageNum));
        return Result.succeed((Object)this.messageService.getSingleMessage(friendID, loginUser.getId().toString(), pageVO, searchKey, msgTypes));
    }

    @ApiOperation(value="\u5220\u9664\u4e2a\u4eba\u4e0e\u597d\u53cb\u804a\u5929\u8bb0\u5f55")
    @GetMapping(value={"/deleteSingleHistory"})
    public Result<Boolean> deleteSingleHistory(@RequestParam @ApiParam(value="\u7528\u6237ID") Long userID, @RequestParam @ApiParam(value="\u597d\u53cbID") Long friendID, @ApiIgnore @LoginUser CurrentLoginUser loginUser) {
        return Result.succeed((Object)this.messageService.deleteSingleHistory(friendID, userID));
    }

    @ApiOperation(value="\u83b7\u53d6\u7fa4\u7ec4\u5386\u53f2\u804a\u5929\u8bb0\u5f55")
    @GetMapping(value={"/group/{groupID}"})
    public Result<PageVO<BaseMsgBean>> getGroupMessage(@PathVariable @ApiParam(value="\u7fa4\u7ec4Id") Long groupID, @RequestParam(required=false, defaultValue="20") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u6570") int pageNum, @ApiIgnore @LoginUser CurrentLoginUser loginUser, @RequestParam(required=false) @ApiParam(value="\u6a21\u7cca\u67e5\u8be2\u6587\u4ef6\u540d\u3001\u6d88\u606f\u5185\u5bb9") String searchKey, @RequestParam(required=false) @ApiParam(value="\u6d88\u606f\u7c7b\u578b") Integer msgTypes) {
        PageVO pageVO = new PageVO();
        pageVO.setPageSize(Integer.valueOf(pageSize));
        pageVO.setPageNum(Integer.valueOf(pageNum));
        return Result.succeed((Object)this.messageService.getGroupMessage(groupID, loginUser.getId(), pageVO, searchKey, msgTypes));
    }

    @ApiOperation(value="\u83b7\u53d6\u7fa4\u7ec4\u6587\u4ef6\u804a\u5929\u8bb0\u5f55")
    @GetMapping(value={"/group/{groupID}/file"})
    public Result<PageVO<FileVO>> getGroupMessageFile(@PathVariable @ApiParam(value="\u7fa4\u7ec4Id") Long groupID, @RequestParam(required=false, defaultValue="20") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u6570") int pageNum, @RequestParam(required=false) @ApiParam(value="\u641c\u7d22\u5173\u952e\u5b57") String searchKey, @ApiIgnore @LoginUser CurrentLoginUser loginUser) {
        PageVO pageVO = new PageVO();
        pageVO.setPageSize(Integer.valueOf(pageSize));
        pageVO.setPageNum(Integer.valueOf(pageNum));
        return Result.succeed((Object)this.messageService.getGroupMessageFile(groupID, searchKey, pageVO));
    }

    @ApiOperation(value="\u83b7\u53d6\u5fae\u5e94\u7528\u5386\u53f2\u8bb0\u5f55")
    @GetMapping(value={"/pubplat/{pubplatID}"})
    public Result<PageVO<BaseMsgBean>> getPubplatMessage(@PathVariable @ApiParam(value="\u5fae\u5e94\u7528ID") Long pubplatID, @RequestParam(required=false) @ApiParam(value="\u6807\u9898") String searchKey, @RequestParam(required=false) @ApiParam(value="\u7c7b\u578b") Integer msgTypes, @RequestParam(required=false, defaultValue="20") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u6570") int pageNum, @ApiIgnore @LoginUser CurrentLoginUser loginUser) {
        PageVO pageVO = new PageVO();
        pageVO.setPageSize(Integer.valueOf(pageSize));
        pageVO.setPageNum(Integer.valueOf(pageNum));
        Pattern pattern = Pattern.compile("^.*" + loginUser.getId() + ".*$", 2);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"mode").is((Object)2), Criteria.where((String)"receiverCode").is((Object)pubplatID.toString()), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"pubplatReceiverCode").is((Object)""), Criteria.where((String)"pubplatReceiverCode").regex(pattern)})});
        if (!StrUtil.isEmpty((CharSequence)searchKey)) {
            Pattern pattern1 = Pattern.compile("^.*" + searchKey + ".*$", 2);
            criteria.and("body").regex(pattern1);
        }
        if (msgTypes != null) {
            criteria.and("msgType").is((Object)msgTypes);
        }
        return Result.succeed((Object)this.messageService.getPubplatMessage(criteria, pageVO));
    }

    @ApiOperation(value="\u83b7\u53d6\u5fae\u5e94\u7528\u6700\u8fd1\u53d1\u9001\u7684\u4eba\u7684\u540d\u79f0")
    @GetMapping(value={"/pubplat/sender/{pubplatID}"})
    public Result<Map<String, Object>> getPubplatSenderCode(@PathVariable @ApiParam(value="\u5fae\u5e94\u7528ID") String pubplatID, @RequestParam(required=false, defaultValue="10") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false, defaultValue="0") @ApiParam(value="\u65f6\u95f4") String time) {
        return Result.succeed((Object)this.messageService.getPubplatSenderCode(pubplatID, pageSize, time));
    }

    @ApiOperation(value="\u83b7\u53d6\u5fae\u5e94\u7528\u63a8\u9001\u5386\u53f2")
    @GetMapping(value={"/pubplat/pubplatID/send"})
    public Result<PageVO<BaseMsgBean>> getPubplatHistory(@RequestParam(value="pubplatID") @ApiParam(value="\u5fae\u5e94\u7528ID") Long pubplatID, @RequestParam(required=false, defaultValue="20") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u6570") int pageNum, @RequestParam(required=false) String typeID, @RequestParam(required=false) String msgTitle) {
        PageVO pageVO = new PageVO();
        pageVO.setPageSize(Integer.valueOf(pageSize));
        pageVO.setPageNum(Integer.valueOf(pageNum));
        return Result.succeed((Object)this.messageService.getPubplatHistory(pubplatID, pageVO, typeID, msgTitle));
    }

    @ApiOperation(value="\u83b7\u53d6\u63a8\u9001\u5386\u53f2\u8be6\u60c5")
    @GetMapping(value={"/pubplat/{msgID}/history"})
    public Result<BaseMsgBean> getPubplatHistoryDetail(@PathVariable @ApiParam(value="\u6d88\u606fID") Long msgID) {
        return Result.succeed((Object)this.messageService.getMessage(msgID));
    }

    @ApiOperation(value="\u83b7\u53d6\u5ba2\u670d\u5386\u53f2\u8bb0\u5f55")
    @GetMapping(value={"/custom/{robotID}"})
    public Result<PageVO<BaseMsgBean>> getCustomChatMessage(@PathVariable @ApiParam(value="\u673a\u5668\u4ebaID") Long robotID, @RequestParam @ApiParam(value="\u63d0\u95ee\u8005ID") Long msgReceiverCode, @RequestParam(required=false, defaultValue="20") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u6570") int pageNum, @ApiIgnore @LoginUser CurrentLoginUser loginUser) {
        PageVO pageVO = new PageVO();
        pageVO.setPageSize(Integer.valueOf(pageSize));
        pageVO.setPageNum(Integer.valueOf(pageNum));
        return Result.succeed((Object)this.messageService.getCustomChatMessage(robotID, loginUser.getId(), msgReceiverCode, pageVO));
    }

    @ApiOperation(value="\u66f4\u65b0\u97f3\u89c6\u9891\u901a\u8bdd\u4eba\u5458")
    @PostMapping(value={"/updateVideoUser/{videoID}/user"})
    public Result<Boolean> updateVideoUser(@PathVariable Long videoID, @RequestParam String eventType, @RequestParam Long senderCode, @RequestParam String senderResource) {
        return Result.succeed((Object)this.messageService.updateVideoUser(videoID, eventType, senderCode, senderResource));
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u901a\u8bdd\u7684\u4eba\u5458")
    @GetMapping(value={"/getVideoUser/{videoID}/user"})
    public Result<List<VideoUserVO>> getVideoUser(@PathVariable Long videoID) {
        return Result.succeed((Object)this.messageService.getVideoUser(videoID));
    }

    @ApiOperation(value="\u66f4\u65b0\u89c6\u9891\u3001\u8bed\u97f3\u901a\u8bdd\u5728\u7ebf\u72b6\u6001 J_L_0013")
    @PostMapping(value={"/updateVideoState/{videoID}"})
    public Result<Boolean> updateVideoState(@PathVariable Long videoID, @RequestParam String eventType, @RequestParam String mode, @RequestParam Long senderCode, @RequestParam String senderResource) {
        return Result.succeed((Object)this.messageService.updateVideoState(videoID, eventType, mode, senderCode, senderResource));
    }

    @ApiOperation(value="\u8f6c\u53d1\u6d88\u606f")
    @PostMapping(value={"/forward/{msgID}"})
    public Result<Boolean> forwardMessage(@PathVariable Long msgID, @RequestBody List<HashMap<String, String>> receiverList, @RequestParam(required=false, defaultValue="") String objID, @ApiIgnore @LoginUser CurrentLoginUser loginUser) {
        int flag = this.messageService.forwardMessage(loginUser.getId(), loginUser.getUserName(), msgID, receiverList, objID);
        if (flag == -1) {
            return Result.failed((String)"\u9690\u79c1\u4fdd\u62a4\uff0c\u5305\u542b\u4e0d\u5141\u8bb8\u53d1\u9001\u6d88\u606f\u7528\u6237");
        }
        if (flag == -2) {
            return Result.succeed((Object)false);
        }
        return Result.succeed((Object)true);
    }

    @ApiOperation(value="\u5237\u65b0\u5ba2\u6237\u7aef\u8bf7\u6c42\u6d88\u606f\u7684\u65f6\u95f4,\u5bf9\u5e94J_U_0025")
    @PostMapping(value={"time"})
    public Result updateTime(@ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @RequestParam(name="objID") @ApiParam(value="\u7fa4ID\u3001\u4ebaID\u3001\u5fae\u5e94\u7528ID") String objID, @RequestParam(name="lastMsgTime", required=false) @ApiParam(value="\u6d88\u606f\u65f6\u95f4") String lastMsgTime, @RequestParam(name="mode") @ApiParam(value="\u65b9\u5f0f") String mode, @RequestParam(name="action") @ApiParam(value="\u64cd\u4f5c,\u5220\u9664\u5386\u53f2\u6d88\u606f2\u3001\u6253\u5f00\u7a97\u53e31\u3001\u5173\u95ed\u7a97\u53e30") String action, @RequestParam(name="resource") @ApiParam(value="\u8d44\u6e90") String resource) {
        return Result.succeed((Object)this.messageService.updateTime(currentLoginUser.getId(), objID, lastMsgTime, mode, action, resource));
    }

    @ApiOperation(value="\u64a4\u56de\u6d88\u606f")
    @PostMapping(value={"/withdraw"})
    public Result<Boolean> withDrawMessage(@ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @RequestBody @ApiParam(value="\u88ab\u64a4\u56de\u6d88\u606f\uff0c\u53ea\u9700\u8981objMsgID\u53c2\u6570") WithDrawMsgBean withDrawMsgBean) {
        withDrawMsgBean.setSenderCode(String.valueOf(currentLoginUser.getId()));
        withDrawMsgBean.setSenderName(currentLoginUser.getName());
        return this.messageService.withDrawMessage(withDrawMsgBean, 3);
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u804a\u8be6\u60c5")
    @GetMapping(value={"/single/list/{userID}"})
    public Result<PageVO<SingleMessageVO>> getSinglePeopleList(@PathVariable @ApiParam(value="\u8981\u770b\u7684\u4eba\u7684ID") Long userID, @RequestParam(required=false, defaultValue="20") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u6570") int pageNum, @RequestParam(required=false) @ApiParam(value="\u5173\u952e\u5b57") String searchKey) {
        PageVO singleMessageVOPageVO = new PageVO();
        singleMessageVOPageVO.setPageNum(Integer.valueOf(pageNum));
        singleMessageVOPageVO.setPageSize(Integer.valueOf(pageSize));
        return Result.succeed((Object)this.messageService.getSinglePeopleList(singleMessageVOPageVO, searchKey, userID));
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u804a\u4e0e\u597d\u53cb\u804a\u5929\u8bb0\u5f55")
    @GetMapping(value={"/single/{userID}/message/{friendID}"})
    public Result<PageVO<BaseMsgBean>> getSingleMessage(@PathVariable @ApiParam(value="\u597d\u53cbID") String userID, @PathVariable @ApiParam(value="\u5173\u8054\u7684\u8054\u7cfb\u4eba") String friendID, @RequestParam(required=false, defaultValue="20") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u6570") int pageNum) {
        PageVO pageVO = new PageVO();
        pageVO.setPageSize(Integer.valueOf(pageSize));
        pageVO.setPageNum(Integer.valueOf(pageNum));
        return Result.succeed((Object)this.messageService.getSingleMessage(friendID, userID, pageVO, "", null));
    }

    @ApiOperation(value="\u83b7\u53d6\u672a\u8bfb\u6d88\u606f\u6570\u91cf")
    @GetMapping(value={"/getUnreadMsgNum"})
    public Result<Long> getUnreadMsgNum(@RequestParam(value="token", required=false) String token, @RequestParam(value="userId") String userId) {
        List unreadMsgNum = this.messageService.getUnreadMsgNum(userId);
        return Result.succeed((Object)(unreadMsgNum == null ? 0L : (long)unreadMsgNum.size()));
    }

    @ApiOperation(value="\u66f4\u65b0\u672a\u8bfb\u6d88\u606f\u6570\u91cf")
    @PostMapping(value={"/updateUnreadMsgNum"})
    public Result<Boolean> updateUnreadMsgNum(@RequestParam(value="count") int count) {
        return Result.succeed((Object)this.messageService.updateUnreadMsgNum(count));
    }

    @ApiOperation(value="\u83b7\u53d6\u672a\u8bfb\u6d88\u606fID")
    @GetMapping(value={"/getUnreadMsg"})
    public Result<List<String>> getUnreadMsg(@RequestParam(value="token", required=false) String token, @RequestParam(value="userId") String userId) {
        List messageDOList = this.messageService.getUnreadMsgNum(userId);
        List msgIdList = messageDOList.stream().map(MessageDO::getMsgID).collect(Collectors.toList());
        return Result.succeed(msgIdList);
    }

    @ApiOperation(value="\u83b7\u53d6CRM\u672a\u8bfb\u6d88\u606f\u6570\u91cf")
    @GetMapping(value={"/getUnreadMsgNumCRM"})
    public Result<Long> getUnreadMsgNumCRM(@RequestParam(value="userId") String userId) {
        List unreadMsgNum = this.messageService.getUnreadMsgNum(userId);
        return Result.succeed((Object)(unreadMsgNum == null ? 0L : (long)unreadMsgNum.size()));
    }
}

