/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.incrementer.DefaultIdentifierGenerator;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.annotation.Permission;
import com.jxdinfo.mp.common.model.AdminEnum;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.HeadingImg;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.Role;
import com.jxdinfo.mp.common.utils.StringUtil;
import com.jxdinfo.mp.im.model.library.LibraryPermissionDO;
import com.jxdinfo.mp.im.model.library.LibraryTypeDO;
import com.jxdinfo.mp.im.model.library.LibraryTypeDTO;
import com.jxdinfo.mp.im.model.library.LibraryTypeVO;
import com.jxdinfo.mp.im.model.library.LibraryVO;
import com.jxdinfo.mp.im.service.IHeadImgService;
import com.jxdinfo.mp.im.service.LibraryPermissionService;
import com.jxdinfo.mp.im.service.LibraryService;
import com.jxdinfo.mp.im.service.LibraryTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u767e\u5e74\u73b0\u4ee3\u540e\u53f0\u7ba1\u7406"})
@ApiVersion
@RequestMapping(value={"v1/management/libraries"})
public class LibraryManageController {
    @Resource
    private LibraryService libraryService;
    @Resource
    private LibraryTypeService libraryTypeService;
    @Resource
    private LibraryPermissionService libraryPermissionService;
    @Autowired
    private IHeadImgService headImgService;
    private static final DefaultIdentifierGenerator defaultIdentifierGenerator = new DefaultIdentifierGenerator();

    @GetMapping(value={"/getTypeList"})
    @ApiOperation(value="\u83b7\u53d6\u767e\u5e74\u73b0\u4ee3\u7c7b\u578b\u5217\u8868")
    public Result<PageDTO<LibraryTypeVO>> getTypeList(@RequestParam(required=false) @ApiParam(value="\u521b\u5efa\u4eba\u59d3\u540d") String createUserName, @RequestParam(required=false) @ApiParam(value="\u7c7b\u578b\u540d\u79f0") String typeName, @RequestParam(defaultValue="1") @ApiParam(value="\u9875\u7801") Integer pageNum, @RequestParam(defaultValue="20") @ApiParam(value="\u9875\u9762\u5927\u5c0f") Integer pageSize) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.like(!StrUtil.isEmpty((CharSequence)typeName), (Object)"TYPE_NAME", (Object)StringUtil.replaceSpecialChar((String)typeName))).like(!StrUtil.isEmpty((CharSequence)createUserName), (Object)"CREATOR_NAME", (Object)StringUtil.replaceSpecialChar((String)createUserName))).orderByAsc((Object)"SHOW_ORDER");
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageSize(pageSize);
        pageDTO.setPageNum(pageNum);
        return Result.succeed((Object)((PageDTO)this.libraryTypeService.page((IPage)pageDTO, (Wrapper)queryWrapper)));
    }

    @PostMapping(value={"/types/save"})
    @ApiOperation(value="\u65b0\u589e\u767e\u5e74\u73b0\u4ee3\u7c7b\u578b")
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> saveType(@RequestBody @ApiParam(value="\u7c7b\u578b\u5b9e\u4f53\u7c7b") LibraryTypeDTO libraryTypeDTO, @LoginUser CurrentLoginUser currentLoginUser) {
        libraryTypeDTO.setCreateTime(LocalDateTime.now());
        libraryTypeDTO.setLastTime(LocalDateTime.now());
        libraryTypeDTO.setCreator(currentLoginUser.getId());
        libraryTypeDTO.setCreatorName(currentLoginUser.getUserName());
        return Result.succeed((Object)this.libraryTypeService.saveType(libraryTypeDTO));
    }

    @PostMapping(value={"/types/delete"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u767e\u5e74\u73b0\u4ee3\u7c7b\u578b")
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> deleteTypes(@RequestBody @ApiParam(value="\u7c7b\u578bids") List<Long> ids) {
        return Result.succeed((Object)this.libraryTypeService.removeByIds(ids));
    }

    @GetMapping(value={"/types/detail"})
    @ApiOperation(value="\u83b7\u53d6\u767e\u5e74\u73b0\u4ee3\u7c7b\u578b\u8be6\u60c5")
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE})
    public Result<LibraryTypeDTO> getTypeInfo(@RequestParam(value="id") String typeID) {
        LibraryTypeDTO libraryTypeDTO = new LibraryTypeDTO();
        BeanUtils.copyProperties((Object)this.libraryTypeService.getById((Serializable)((Object)typeID)), (Object)libraryTypeDTO);
        libraryTypeDTO.setHeadingImg((HeadingImg)this.headImgService.getById((Serializable)((Object)typeID)));
        return Result.succeed((Object)libraryTypeDTO);
    }

    @PostMapping(value={"types/edit"})
    @ApiOperation(value="\u4fee\u6539\u767e\u5e74\u73b0\u4ee3\u7c7b\u578b")
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> updateType(@RequestBody @ApiParam(value="\u7c7b\u578b\u5b9e\u4f53\u7c7b") LibraryTypeDTO libraryTypeDTO) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LibraryTypeDO libraryTypeDO = new LibraryTypeDO();
        libraryTypeDTO.setLastTime(LocalDateTime.now());
        libraryTypeDTO.setLastEditor(user.getUserId());
        BeanUtils.copyProperties((Object)libraryTypeDTO, (Object)libraryTypeDO);
        return Result.succeed((Object)(this.libraryTypeService.updateById((Object)libraryTypeDO) || this.headImgService.saveOrUpdate((Object)libraryTypeDTO.getHeadingImg()) ? 1 : 0));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u83b7\u53d6\u767e\u5e74\u73b0\u4ee3\u5217\u8868")
    public Result<PageDTO<LibraryVO>> getLibraryList(@RequestParam(required=false) @ApiParam(value="\u767e\u5e74\u73b0\u4ee3\u7c7b\u578b") String typeID, @RequestParam(required=false) @ApiParam(value="\u767e\u5e74\u73b0\u4ee3\u6807\u9898") String title, @RequestParam(required=false) @ApiParam(value="\u5185\u5bb9") String content, @RequestParam(defaultValue="1") @ApiParam(value="\u9875\u7801") Integer pageNum, @RequestParam(defaultValue="20") @ApiParam(value="\u9875\u9762\u5927\u5c0f") Integer pageSize, @LoginUser CurrentLoginUser currentLoginUser, @RequestParam @ApiParam(value="\u662f\u5426\u662f\u4f1a\u8bae\u7eaa\u8981") int judge) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageSize(pageSize);
        pageDTO.setPageNum(pageNum);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (judge == 1) {
            typeID = SpringContextHolder.environment.getProperty("mp.multi-tenant.hyjyId");
        }
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq(!StrUtil.isEmpty((CharSequence)typeID), (Object)"T.TYPE_ID", (Object)typeID)).eq(1 == judge, (Object)"Z.SENDER_CODE", (Object)currentLoginUser.getId())).like(!StrUtil.isEmpty((CharSequence)title), (Object)"Z.MSG_TITLE", (Object)StringUtil.replaceSpecialChar((String)title))).like(!StrUtil.isEmpty((CharSequence)content), (Object)"Z.BODY", (Object)StringUtil.replaceSpecialChar((String)content))).orderByDesc((Object)"Z.LAST_TIME");
        this.libraryService.getBackLibraryList(pageDTO, (Wrapper)queryWrapper);
        List libraryVOList = pageDTO.getList();
        libraryVOList.forEach(n -> {
            if (null != currentLoginUser.getRoles() && currentLoginUser.getRoles().stream().map(Role::getRoleId).collect(Collectors.toList()).contains(SpringContextHolder.environment.getProperty("mp.role.sysAdmin"))) {
                n.setManager("1");
            } else {
                n.setManager("0");
            }
        });
        pageDTO.setList(libraryVOList);
        return Result.succeed((Object)pageDTO);
    }

    @GetMapping(value={"/types/grant"})
    @ApiOperation(value="\u767e\u5e74\u73b0\u4ee3\u7c7b\u578b\u6388\u6743")
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE})
    public Result<Boolean> grant(@RequestParam @ApiParam(value="\u9700\u8981\u6388\u6743\u7684\u4eba\u5458") String peopleList, @RequestParam @ApiParam(value="\u9700\u8981\u6388\u6743\u7684\u89d2\u8272") String roleList, @RequestParam @ApiParam(value="\u9700\u8981\u6388\u6743\u7684\u90e8\u95e8") String deptList, @RequestParam @ApiParam(value="\u767e\u5e74\u73b0\u4ee3\u7c7b\u578bID") String typeID) {
        List<Long> list;
        ArrayList permissionList = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"B_ID", (Object)typeID);
        this.libraryPermissionService.remove((Wrapper)queryWrapper);
        if (StrUtil.isNotEmpty((CharSequence)peopleList)) {
            list = Arrays.stream(peopleList.split(",")).map(Long::parseLong).collect(Collectors.toList());
            list.forEach(n -> permissionList.add(LibraryManageController.getLibraryPermissionDO(n, Long.parseLong(typeID), 1)));
        }
        if (StrUtil.isNotEmpty((CharSequence)roleList)) {
            list = Arrays.stream(roleList.split(",")).map(Long::parseLong).collect(Collectors.toList());
            list.forEach(n -> permissionList.add(LibraryManageController.getLibraryPermissionDO(n, Long.parseLong(typeID), 3)));
        }
        if (StrUtil.isNotEmpty((CharSequence)deptList)) {
            list = Arrays.stream(deptList.split(",")).map(Long::parseLong).collect(Collectors.toList());
            list.forEach(n -> permissionList.add(LibraryManageController.getLibraryPermissionDO(n, Long.parseLong(typeID), 2)));
        }
        return Result.succeed((Object)this.libraryPermissionService.saveBatch(permissionList));
    }

    public static LibraryPermissionDO getLibraryPermissionDO(Long objID, Long bID, int permitType) {
        LibraryPermissionDO libraryPermissionDO = new LibraryPermissionDO();
        libraryPermissionDO.setObjID(objID);
        libraryPermissionDO.setPermiType(Integer.valueOf(permitType));
        libraryPermissionDO.setBID(bID);
        libraryPermissionDO.setPermitID(defaultIdentifierGenerator.nextId((Object)libraryPermissionDO));
        libraryPermissionDO.setCreateTime(LocalDateTime.now());
        libraryPermissionDO.setLastTime(LocalDateTime.now());
        return libraryPermissionDO;
    }

    @GetMapping(value={"/grant/list"})
    @ApiOperation(value="\u767e\u5e74\u73b0\u4ee3\u7c7b\u578b\u6388\u6743\u5217\u8868")
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE})
    public Result<HashMap> getGrantList(@RequestParam @ApiParam(value="\u767e\u5e74\u73b0\u4ee3\u7c7b\u578bid") String typeID) {
        return Result.succeed((Object)this.libraryPermissionService.getPermissionList(typeID));
    }
}

