/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.StrSplitter;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.annotation.Permission;
import com.jxdinfo.mp.common.constant.IMConstants;
import com.jxdinfo.mp.common.model.AdminEnum;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.group.GroupVO;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.MentionMsgBean;
import com.jxdinfo.mp.im.model.TextMsgBean;
import com.jxdinfo.mp.im.model.db.GroupDO;
import com.jxdinfo.mp.im.model.push.PushMessageDTO;
import com.jxdinfo.mp.im.service.GroupManageService;
import com.jxdinfo.mp.im.service.GroupService;
import com.jxdinfo.mp.im.service.GroupUserService;
import com.jxdinfo.mp.im.service.VideoUserService;
import com.jxdinfo.mp.push.service.MessageProducerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u7fa4\u7ec4\u76f8\u5173\u63a5\u53e3"})
@ApiVersion
@RestController
@RequestMapping(value={"/v1/groups"})
public class GroupManageController {
    private static final Logger log = LoggerFactory.getLogger(GroupManageController.class);
    @Resource
    private GroupService groupService;
    @Resource
    private GroupUserService groupUserService;
    @Resource
    private GroupManageService groupManageService;
    @Resource
    private MessageProducerService pushService;
    @Resource
    private VideoUserService videoUserService;
    @Resource
    private MongoTemplate mongoTemplate;

    @ApiOperation(value="\u7cfb\u7edf\u7ba1\u7406\u5458\u7fa4\u7ec4\u5220\u4eba,\u5df2\u6d4b")
    @GetMapping(value={"/manage/{roomID}/delete"})
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE, AdminEnum.IM_MANAGER_ROLE})
    public Result<Boolean> deleteGroupUser(@PathVariable @ApiParam(value="\u7fa4\u7ec4ID") Long roomID, @RequestParam @ApiParam(value="\u4eba\u5458\u96c6\u5408") String userIDs, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) throws Exception {
        List userIDList = StrSplitter.split((CharSequence)userIDs, (char)',', (int)0, (boolean)true, (boolean)true).stream().mapToLong(Long::parseLong).boxed().collect(Collectors.toList());
        return this.groupService.deleteGroupUser(roomID, userIDList);
    }

    @ApiOperation(value="\u83b7\u53d6\u7fa4\u7ec4\u5217\u8868(\u7cfb\u7edf\u7ba1\u7406\u5458\u7528)")
    @GetMapping(value={"list"})
    @Permission(manage={AdminEnum.JQX_ADMIN_ROLE, AdminEnum.IM_MANAGER_ROLE})
    public Result<PageDTO<GroupVO>> queryALLGroupList(@RequestParam(required=false) @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") String searchKey, @RequestParam(required=false, defaultValue="20") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u6570") int pageNum) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        return Result.succeed((Object)this.groupService.getAllGroupPage(pageDTO, searchKey));
    }

    @ApiOperation(value="\u540e\u53f0\u7fa4\u7ec4\u53d1\u9001\u6d88\u606f,\u5df2\u6d4b")
    @PostMapping(value={"{roomID}/message"})
    public Result<Boolean> sendGroupMessage(@PathVariable(value="roomID") Long roomID, @RequestBody @ApiParam(value="\u6d88\u606f\u5185\u5bb9") String text, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) throws JMSException {
        if (currentLoginUser == null) {
            return Result.failed((String)"\u8bf7\u5148\u767b\u5f55");
        }
        GroupDO groupDO = (GroupDO)this.groupService.getById((Serializable)roomID);
        TextMsgBean textMsgBean = new TextMsgBean();
        textMsgBean.setMsgID(String.valueOf(IdWorker.getId((Object)textMsgBean)));
        textMsgBean.setBody(text);
        textMsgBean.setMsgType(BaseMsgBean.MsgType.TEXT);
        textMsgBean.setResource("system");
        textMsgBean.setSenderCode(IMConstants.IM_SYSTEM_ID.toString());
        textMsgBean.setSenderName("\u7ba1\u7406\u5458");
        textMsgBean.setReceiverCode(roomID.toString());
        textMsgBean.setMode(BaseMsgBean.Mode.GROUPCHAT);
        textMsgBean.setReceiverName(groupDO.getGroupName());
        textMsgBean.setCompID(ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser().getTenantId()) ? BaseSecurityUtil.getUser().getTenantId().toString() : null);
        textMsgBean.setCompName(BaseSecurityUtil.getUser().getTenantName());
        textMsgBean.setMsgTime(DateUtil.now());
        PushMessageDTO pushMessageDTO = new PushMessageDTO();
        pushMessageDTO.setBaseMsgBean((BaseMsgBean)textMsgBean);
        pushMessageDTO.setMode(BaseMsgBean.Mode.GROUPCHAT);
        pushMessageDTO.setMsgType(BaseMsgBean.MsgType.TEXT);
        return Result.succeed((Object)this.pushService.sendMessage(pushMessageDTO));
    }

    @ApiOperation(value="\u540e\u53f0\u7fa4\u7ec4\u53d1\u9001@\u6d88\u606f,\u5df2\u6d4b")
    @PostMapping(value={"{roomID}/mentionMessage"})
    public Result<Boolean> sendMentionGroupMessage(@PathVariable(value="roomID") Long roomID, @RequestParam @ApiParam(value="@\u6d88\u606f\u7684\u6d88\u606f\u4f53") String content, @RequestParam @ApiParam(value="\u88ab@\u7684\u7fa4\u6210\u5458id,\u591a\u4e2a\u95f4\u7528,\u5206\u9694") String mentionUserIds, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        if (currentLoginUser == null) {
            return Result.failed((String)"\u8bf7\u5148\u767b\u5f55");
        }
        GroupDO groupDO = (GroupDO)this.groupService.getById((Serializable)roomID);
        MentionMsgBean mentionMsgBean = new MentionMsgBean();
        mentionMsgBean.setMsgID(String.valueOf(IdWorker.getId((Object)mentionMsgBean)));
        mentionMsgBean.setBody(content);
        mentionMsgBean.setMsgType(BaseMsgBean.MsgType.MENTION);
        mentionMsgBean.setResource("system");
        mentionMsgBean.setSenderCode(IMConstants.IM_SYSTEM_ID.toString());
        mentionMsgBean.setSenderName("\u7ba1\u7406\u5458");
        mentionMsgBean.setReceiverCode(roomID.toString());
        mentionMsgBean.setMode(BaseMsgBean.Mode.GROUPCHAT);
        mentionMsgBean.setReceiverName(groupDO.getGroupName());
        mentionMsgBean.setCompID(ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser().getTenantId()) ? BaseSecurityUtil.getUser().getTenantId().toString() : null);
        mentionMsgBean.setCompName(BaseSecurityUtil.getUser().getTenantName());
        mentionMsgBean.setMsgTime(DateUtil.now());
        mentionMsgBean.setMentionId(mentionUserIds);
        PushMessageDTO pushMessageDTO = new PushMessageDTO();
        pushMessageDTO.setBaseMsgBean((BaseMsgBean)mentionMsgBean);
        pushMessageDTO.setMode(BaseMsgBean.Mode.GROUPCHAT);
        pushMessageDTO.setMsgType(mentionMsgBean.getMsgType());
        return Result.succeed((Object)this.pushService.sendMessage(pushMessageDTO));
    }
}

