/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.constant.IMConstants;
import com.jxdinfo.mp.common.enums.BaseErrorCode;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.RosterVO;
import com.jxdinfo.mp.common.model.group.GroupVO;
import com.jxdinfo.mp.common.model.organization.ContactDTO;
import com.jxdinfo.mp.common.model.organization.ContactVO;
import com.jxdinfo.mp.im.enums.GroupErrorCode;
import com.jxdinfo.mp.im.model.NoticeMsgBean;
import com.jxdinfo.mp.im.model.db.GroupDO;
import com.jxdinfo.mp.im.model.db.GroupUserDO;
import com.jxdinfo.mp.im.model.group.GroupDTO;
import com.jxdinfo.mp.im.model.single.VideoUserDO;
import com.jxdinfo.mp.im.service.GroupManageService;
import com.jxdinfo.mp.im.service.GroupService;
import com.jxdinfo.mp.im.service.GroupUserService;
import com.jxdinfo.mp.im.service.VideoUserService;
import com.jxdinfo.mp.push.service.MessageProducerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u7fa4\u7ec4\u76f8\u5173\u63a5\u53e3"})
@ApiVersion
@RestController
@RequestMapping(value={"/v1/groups"})
public class GroupController {
    private static final Logger log = LoggerFactory.getLogger(GroupController.class);
    @Resource
    private GroupService groupService;
    @Resource
    private GroupUserService groupUserService;
    @Resource
    private GroupManageService groupManageService;
    @Resource
    private MessageProducerService pushService;
    @Resource
    private VideoUserService videoUserService;
    @Resource
    private MongoTemplate mongoTemplate;

    @ApiOperation(value="\u53d1\u5e03\u7f16\u8f91\u7fa4\u516c\u544a,\u5df2\u6d4b")
    @PostMapping(value={"notice/{roomID}"})
    public Result<Boolean> groupNotice(@PathVariable @ApiParam(value="\u7fa4\u7ec4ID") Long roomID, @RequestBody GroupVO groupVO, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        String notice = StrUtil.isEmpty((CharSequence)groupVO.getNotice()) ? "" : groupVO.getNotice();
        return this.groupService.groupNotice(roomID, notice, currentLoginUser);
    }

    @ApiOperation(value="\u4fee\u6539\u7fa4\u5934\u50cf,\u5df2\u6d4b")
    @PostMapping(value={"head/{roomID}"})
    public Result<Boolean> modifyGroupHead(@PathVariable Long roomID, @RequestParam(name="headImgId") @ApiParam(value="\u5934\u50cf\u56fe\u7247id") String headImgId, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        return this.groupService.modifyGroupHead(roomID, currentLoginUser.getId(), headImgId);
    }

    @ApiOperation(value="\u521b\u5efa\u7fa4\u7ec4 'J_T_0001',\u8be5\u63a5\u53e3\u9700\u8981\u4f20\u4e00\u4e2aGroupDTO")
    @PostMapping(value={"addGroup"})
    public Result<GroupVO> creatGroup(@RequestBody @ApiParam(value="\u7fa4\u804aDTO") GroupDTO groupDTO, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) throws Exception {
        try {
            if (groupDTO == null) {
                return Result.failed((BaseErrorCode)GroupErrorCode.PARAMETER_MISSING, (String)"\u7fa4\u804a\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            GroupVO result = this.groupService.createGroup(groupDTO, currentLoginUser.getUserName());
            if (result != null) {
                return Result.succeed((Object)result, (String)"\u7fa4\u804a\u521b\u5efa\u6210\u529f");
            }
            return Result.failed((BaseErrorCode)GroupErrorCode.GROUP_CREATE_FAILED);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u7fa4\u804a\u5931\u8d25\uff0c\u7528\u6237ID: {}, \u7fa4\u804a\u540d\u79f0: {}, \u9519\u8bef\u4fe1\u606f: {}", new Object[]{currentLoginUser.getId(), groupDTO != null ? groupDTO.getRoomName() : "null", e.getMessage(), e});
            return Result.failed((BaseErrorCode)GroupErrorCode.GROUP_CREATE_FAILED, (String)("\u521b\u5efa\u7fa4\u804a\u5931\u8d25: " + e.getMessage()));
        }
    }

    @ApiOperation(value="\u9000\u51fa\u7fa4\u7ec4'J_T_0002'")
    @PostMapping(value={"quit"})
    public Result<Boolean> quitGroup(@RequestParam @ApiParam(value="\u7fa4\u7ec4ID") Long roomID, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) throws Exception {
        return this.groupService.exitGroup(roomID, currentLoginUser);
    }

    @ApiOperation(value="\u7fa4\u4e3b\u7fa4\u7ec4\u5220\u4eba 'J_T_0004'")
    @PostMapping(value={"user/{roomID}/delete"})
    public Result<Boolean> deleteGroupUser(@PathVariable @ApiParam(value="\u7fa4\u7ec4ID") Long roomID, @RequestBody(required=false) @ApiParam(value="\u4eba\u5458\u96c6\u5408") List<RosterVO> userList, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) throws Exception {
        if (CollUtil.isNotEmpty(userList)) {
            return this.groupService.deleteGroupMember(roomID, userList, currentLoginUser, false);
        }
        return Result.failed((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u4eba\u5458");
    }

    @ApiOperation(value="\u7fa4\u7ec4\u52a0\u4eba 'J_T_0003',\u5df2\u6d4b")
    @PostMapping(value={"/{roomID}/user"})
    public Result<Boolean> addGroupMember(@RequestBody @ApiParam(value="\u7ec4\u7ec7\u673a\u6784DTO") ContactDTO contactDTO, @PathVariable Long roomID, @RequestParam(value="inviteUserID", required=false) @ApiParam(value="\u9080\u8bf7\u4ebaid") Long inviteUserID, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) throws Exception {
        if (roomID == null || roomID <= 0L) {
            return Result.failed((BaseErrorCode)GroupErrorCode.PARAMETER_INVALID);
        }
        if (contactDTO == null) {
            return Result.failed((BaseErrorCode)GroupErrorCode.PARAMETER_MISSING, (String)"\u8054\u7cfb\u4eba\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (inviteUserID == null) {
            return this.groupService.addGroupMember(contactDTO, roomID, currentLoginUser.getUserName(), null, String.valueOf(currentLoginUser.getId()));
        }
        return this.groupService.addGroupMember(contactDTO, roomID, null, inviteUserID, String.valueOf(currentLoginUser.getId()));
    }

    @ApiOperation(value="\u4fee\u6539\u7fa4\u8d44\u6599 'J_T_0005',\u5df2\u6d4b", notes="\u4fee\u6539\u6307\u5b9a\u7fa4\u7684\u7f6e\u9876\u3001\u4fdd\u5b58\u3001\u63d0\u9192\u72b6\u6001\uff0c\u5f53\u524d\u767b\u5f55\u4eba\u4e3a\u7fa4\u4e3b\uff0c\u8fd8\u53ef\u4ee5\u66f4\u65b0\u7fa4\u540d(\u5982\u679c\u6539\u53d8\u4e86)")
    @PostMapping(value={"/update"})
    public Result<Boolean> updateGroup(@RequestBody @ApiParam(value="\u7fa4\u7ec4\u4fe1\u606f") GroupDTO groupDTO, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) throws Exception {
        return this.groupService.updateGroup(groupDTO, currentLoginUser);
    }

    @ApiOperation(value="\u83b7\u53d6\u7fa4\u7ec4\u8be6\u60c5 'J_T_0006',\u5df2\u6d4b")
    @GetMapping(value={"{roomID}"})
    public Result<GroupVO> groupDetail(@PathVariable @ApiParam(value="\u7fa4\u7ec4ID") Long roomID, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) throws Exception {
        if (roomID == null || roomID <= 0L) {
            return Result.failed((BaseErrorCode)GroupErrorCode.PARAMETER_INVALID);
        }
        if (currentLoginUser == null || currentLoginUser.getId() == null) {
            return Result.failed((BaseErrorCode)GroupErrorCode.PARAMETER_INVALID);
        }
        return this.groupService.groupDetail(roomID, currentLoginUser.getId());
    }

    @ApiOperation(value="\u83b7\u53d6\u7fa4\u7ec4\u5217\u8868 + \u67e5\u627e\u7fa4\u7ec4,J_T_0007,J_T_0010,\u5df2\u6d4b")
    @GetMapping
    public Result<List<GroupVO>> queryGroupList(@RequestParam(required=false) @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") String searchKey, @RequestParam(required=false) String groupType, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) throws Exception {
        if (StrUtil.isNotEmpty((CharSequence)searchKey)) {
            return Result.succeed((Object)this.groupService.findGroup(currentLoginUser.getId(), searchKey));
        }
        return Result.succeed((Object)this.groupService.queryGroupList(currentLoginUser.getId(), groupType));
    }

    @ApiOperation(value="\u83b7\u53d6\u7fa4\u7ec4\u5217\u8868 + \u67e5\u627e\u7fa4\u7ec4,\u5206\u9875 'J_T_0007' + 'J_T_0010',\u5df2\u6d4b")
    @GetMapping(value={"page"})
    public Result<PageDTO<GroupVO>> queryGroupList(@RequestParam(required=false) @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") String searchKey, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") Integer pageNum, @RequestParam(required=false, defaultValue="20") @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") Integer pageSize, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) throws Exception {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(pageNum);
        pageDTO.setPageSize(pageSize);
        return Result.succeed((Object)this.groupService.findGroupPage(pageDTO, currentLoginUser.getId(), searchKey));
    }

    @ApiOperation(value="\u83b7\u53d6\u7fa4\u6210\u5458 'J_T_0008',\u5df2\u6d4b")
    @GetMapping(value={"/{roomID}/users"})
    public Result<PageVO<RosterVO>> groupUserList(@PathVariable @ApiParam(value="\u7fa4\u7ec4ID") Long roomID, @RequestParam(required=false, defaultValue="false") @ApiParam(value="\u662f\u5426\u8fd4\u56de\u5f53\u524d\u767b\u5f55\u7528\u6237") boolean includeMe, @RequestParam(defaultValue="1") int pageNum, @RequestParam(defaultValue="20") int pageSize, @RequestParam(required=false) String searchKey) {
        PageVO pageVO = new PageVO();
        pageVO.setPageSize(Integer.valueOf(pageSize));
        pageVO.setPageNum(Integer.valueOf(pageNum));
        return Result.succeed((Object)this.groupService.getGroupUserList(roomID, includeMe, pageVO, searchKey));
    }

    @ApiOperation(value="\u641c\u7d22\u7fa4\u6210\u5458 'J_T_0009',\u641c\u7d22\u4e0d\u4f1a\u8d70\u7f13\u5b58\uff01")
    @GetMapping(value={"/{roomID}/users/search"})
    public Result<List<RosterVO>> findGroupUserList(@PathVariable @ApiParam(value="\u7fa4\u7ec4ID") Long roomID, @RequestParam(required=false) boolean includeMe, @RequestParam(required=false) String searchKey) {
        String userName = StrUtil.isEmpty((CharSequence)searchKey) ? "" : searchKey;
        ArrayList<Long> excludeUserList = new ArrayList<Long>();
        if (!includeMe) {
            excludeUserList.add(BaseSecurityUtil.getUser().getId());
        }
        return Result.succeed((Object)this.groupService.findGroupUserList(roomID, userName, excludeUserList));
    }

    @ApiOperation(value="\u67e5\u627e\u4eba\u5458(\u5e26\u662f\u5426\u5df2\u7ecf\u6dfb\u52a0\u5230\u7fa4\u7ec4) 'J_T_0013'")
    @GetMapping(value={"/contacts"})
    public Result<List<RosterVO>> findUser(@RequestParam(required=false) @ApiParam(value="\u7fa4\u7ec4ID") Long roomID, @RequestParam(required=false) @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") String searchKey, @RequestParam(required=false) @ApiParam(value="\u7ec4\u7ec7ID") Long orgID, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") Integer pageNum, @RequestParam(required=false, defaultValue="-1") @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") Integer pageSize) {
        String userName = StrUtil.isEmpty((CharSequence)searchKey) ? "" : searchKey;
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageSize(pageSize);
        pageDTO.setPageNum(pageNum);
        return Result.succeed((Object)this.groupService.findUser(roomID, userName, orgID, pageDTO));
    }

    @ApiOperation(value="\u83b7\u53d6\u8054\u7cfb\u4eba(\u5e26\u662f\u5426\u662f\u7fa4\u7ec4\u6210\u5458) 'J_T_0014'")
    @GetMapping(value={"linkmen"})
    public Result<List<RosterVO>> getLinkMan(@RequestParam(required=false) @ApiParam(value="\u7fa4\u7ec4ID") Long roomID) {
        return Result.succeed((Object)this.groupService.getLinkMan(roomID));
    }

    @ApiOperation(value="\u83b7\u53d6\u90e8\u95e8\u548c\u4eba\u5458(\u5e26\u662f\u5426\u662f\u7fa4\u7ec4\u6210\u5458) 'J_T_0012'")
    @GetMapping(value={"/linkman"})
    public Result<PageVO<ContactVO>> getLinkMan(@RequestParam(required=false) @ApiParam(value="\u7fa4\u7ec4ID") Long roomID, @RequestParam(name="orgID", required=false) @ApiParam(value="\u90e8\u95e8id") Long orgID) {
        return Result.succeed((Object)this.groupService.getLinkMan(orgID, roomID));
    }

    @ApiOperation(value="\u8f6c\u8ba9\u7fa4\u7ec4 'J_T_0017',\u5df2\u6d4b")
    @PostMapping(value={"{roomID}/transfer"})
    public Result<Boolean> transferGroup(@PathVariable @ApiParam(value="\u7fa4\u7ec4ID") Long roomID, @RequestParam @ApiParam(value="\u539f\u7fa4\u4e3bID") Long userID, @RequestParam @ApiParam(value="\u65b0\u7fa4\u4e3bID") Long adminID, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        return this.groupService.transferGroup(roomID, userID, adminID, currentLoginUser, false);
    }

    @ApiOperation(value="\u53d8\u66f4\u7fa4\u4e3b,\u5df2\u6d4b")
    @GetMapping(value={"/manage/{roomID}"})
    public Result<Boolean> changeGroupAdmin(@PathVariable @ApiParam(value="\u7fa4\u7ec4ID") Long roomID, @RequestParam @ApiParam(value="\u65b0\u7fa4\u4e3bID") Long userID, @RequestParam @ApiParam(value="\u539f\u7fa4\u4e3bID") Long adminID, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        return this.groupService.changeGroupAdmin(roomID, userID, adminID);
    }

    @ApiOperation(value="\u89e3\u6563\u7fa4\u7ec4 'J_T_0018',\u5df2\u6d4b")
    @GetMapping(value={"/dissolve"})
    public Result<Boolean> ungroup(@RequestParam @ApiParam(value="\u7fa4\u7ec4ID") Long roomID, @RequestParam @ApiParam(value="\u7528\u6237ID") Long userID, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        return this.groupService.ungroup(roomID, userID, currentLoginUser);
    }

    @ApiOperation(value="\u6e05\u9664\u7528\u6237\u7fa4\u7ec4\u7f13\u5b58,\u5df2\u6d4b")
    @DeleteMapping(value={"cache/{userID}"})
    public Result<Boolean> cleanGroupCache(@PathVariable @ApiParam(value="\u7528\u6237ID") Long userID) {
        return Result.succeed((Object)this.groupUserService.cleanGroupCache(userID));
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u6240\u5728\u7fa4\u7ec4\u7684\u72b6\u6001,\u5df2\u6d4b")
    @PostMapping(value={"/status"})
    public Result<List<GroupVO>> getGroupStatus(@ApiIgnore @LoginUser CurrentLoginUser currentLoginUser, @RequestParam(value="time", required=false) @ApiParam(value="\u7fa4\u7ec4\u65f6\u95f4,\u4ec5\u7b5b\u9009\u8be5\u65f6\u95f4\u4e4b\u540e\u7684\u7fa4\u7ec4") String time) {
        return Result.succeed((Object)this.groupService.getGroupStatusByUserID(currentLoginUser, time));
    }

    @ApiOperation(value="\u521b\u5efa\u90e8\u95e8\u7fa4,\u5df2\u6d4b", notes="\u90e8\u95e8\u7fa4\u7684\u7fa4\u4e3bid\u4e3a\u90e8\u95e8id")
    @PostMapping(value={"/orgGroup"})
    public Result<Boolean> creatOrgGroup() {
        return Result.succeed((Object)this.groupService.createOrgGroup(IMConstants.DEFAULT_COMPANY_ID));
    }

    @ApiOperation(value="\u67e5\u8be2\u90e8\u95e8\u7fa4\u662f\u5426\u5b58\u5728,\u5df2\u6d4b")
    @GetMapping(value={"/organise/{organiseID}"})
    public Result<List<GroupDO>> selectGroup(@PathVariable(value="organiseID") Long organiseID) {
        return Result.succeed((Object)this.groupUserService.selectGroup(organiseID));
    }

    @ApiOperation(value="\u65b0\u589e\u7fa4\u7ec4\u6210\u5458,\u5df2\u6d4b")
    @PutMapping(value={"/user"})
    public Result<Boolean> addMember(@RequestBody List<GroupUserDO> groupUserDOList) {
        return Result.succeed((Object)this.groupUserService.saveBatch(groupUserDOList));
    }

    @ApiOperation(value="\u83b7\u53d6\u8be5\u7528\u6237\u52a0\u5165\u7684\u7fa4,\u5df2\u6d4b")
    @GetMapping(value={"/currentUser/{userID}"})
    public Result<List<GroupUserDO>> getGroupUserList(@PathVariable(value="userID") Long userID) {
        return Result.succeed((Object)this.groupUserService.getGroupUserList(userID));
    }

    @ApiOperation(value="\u5220\u9664\u4e0d\u5728\u6307\u5b9a\u90e8\u95e8\u7684\u7fa4\u6210\u5458")
    @DeleteMapping(value={"/user"})
    public Result<Integer> deleteMember(@RequestParam(value="groupId") Long groupId, @RequestParam @ApiParam(value="\u8981\u6307\u5b9a\u7684\u90e8\u95e8ID") List<Long> orgIDList) {
        return Result.succeed((Object)this.groupUserService.deleteMember(groupId, orgIDList));
    }

    @ApiOperation(value="\u5c06\u8fd0\u8425\u652f\u6491\u540c\u6b65\u8fc7\u6765\u7684\u4eba\u540c\u6b65\u5230\u90e8\u95e8\u7fa4")
    @PostMapping(value={"/allUser"})
    public Result<Boolean> synchroGroup() {
        return Result.succeed((Object)this.groupService.synchroGroup());
    }

    @ApiOperation(value="\u5220\u9664\u6240\u6709\u7fa4\u4e2d\u7684\u7684\u6307\u5b9a\u79bb\u804c\u4eba\u5458,\u5df2\u6d4b")
    @DeleteMapping(value={"/quitedUser"})
    public Result<Boolean> deleteQuitUser(@RequestBody @ApiParam(value="\u79bb\u804c\u4eba\u5458\u5217\u8868") List<Long> outUserList) {
        return Result.succeed((Object)this.groupService.deleteQuitUser(outUserList));
    }

    @ApiOperation(value="\u53d1\u8d77\u8bed\u97f3\u6216\u89c6\u9891\u901a\u8bdd J_L_0010")
    @PostMapping(value={"/rtc"})
    public Result<Boolean> startVideoAudio(@RequestParam(value="videoId") @ApiParam(value="\u97f3\u89c6\u9891Id") Long videoId, @RequestParam(value="videoType") @ApiParam(value="\u97f3\u89c6\u9891\u7c7b\u578b") String videoType, @RequestParam(value="roomId") @ApiParam(value="\u7fa4\u7ec4Id") Long roomId, @RequestParam(value="roomName") @ApiParam(value="\u7fa4\u7ec4\u540d\u79f0") String roomName, @RequestBody @ApiParam(value="\u9080\u8bf7\u7684\u4ebalist") List<VideoUserDO> videoUserDOList, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        videoUserDOList.forEach(v -> {
            v.setVideoID(videoId);
            v.setDataStatus(Long.valueOf(4L));
            v.setCreateTime(DateUtil.now());
            v.setModifyTime(DateUtil.now());
        });
        VideoUserDO videoUserDO = new VideoUserDO();
        videoUserDO.setUserID(currentLoginUser.getId());
        videoUserDO.setUserName(currentLoginUser.getUserName());
        videoUserDO.setVideoID(videoId);
        videoUserDO.setDataStatus(Long.valueOf(5L));
        videoUserDO.setCreateTime(DateUtil.now());
        videoUserDO.setModifyTime(DateUtil.now());
        videoUserDOList.add(videoUserDO);
        this.videoUserService.saveBatch(videoUserDOList);
        String body = currentLoginUser.getUserName() + "\u53d1\u8d77\u4e86" + ("1".equals(videoType) ? "\u89c6\u9891" : "\u8bed\u97f3") + "\u901a\u8bdd";
        this.groupManageService.sendRoomNotice(roomId, roomName, videoId + "", body, currentLoginUser.getId(), currentLoginUser.getUserName(), videoUserDOList.stream().map(v -> v.getUserID() + "").collect(Collectors.toList()), NoticeMsgBean.EventType.VIDEOSTART);
        return Result.succeed((Object)true);
    }

    @ApiOperation(value="\u7ed3\u675f\u8bed\u97f3\u6216\u89c6\u9891\u901a\u8bdd J_L_0010")
    @DeleteMapping(value={"/rtc"})
    public Result<Boolean> endVideoAudio(@RequestParam(value="videoId") @ApiParam(value="\u97f3\u89c6\u9891Id") Long videoId, @RequestParam(value="videoType") @ApiParam(value="\u97f3\u89c6\u9891\u7c7b\u578b") String videoType, @RequestParam(value="roomId") @ApiParam(value="\u7fa4\u7ec4Id") Long roomID, @RequestParam(value="roomName") @ApiParam(value="\u7fa4\u7ec4\u540d\u79f0") String roomName, @RequestBody List<VideoUserDO> videoUserDOList, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"VIDEOID", (Object)videoId);
        updateWrapper.set((Object)"DATASTATUS", (Object)0);
        updateWrapper.set((Object)"MODIFYTIME", (Object)DateUtil.now());
        this.videoUserService.update((Wrapper)updateWrapper);
        String body = ("1".equals(videoType) ? "\u89c6\u9891" : "\u8bed\u97f3") + "\u901a\u8bdd\u7ed3\u675f";
        this.groupManageService.sendRoomNotice(roomID, roomName, videoId + "", body, currentLoginUser.getId(), currentLoginUser.getUserName(), videoUserDOList.stream().map(v -> v.getUserID() + "").collect(Collectors.toList()), NoticeMsgBean.EventType.VIDEOEND);
        return Result.succeed((Object)true);
    }

    @ApiOperation(value="\u9080\u8bf7\u4eba\u52a0\u5165\u89c6\u9891\u901a\u8bdd J_L_0010")
    @PostMapping(value={"/rtc/user"})
    public Result<Boolean> inviteVideoAudio(@RequestParam(value="videoId") @ApiParam(value="\u97f3\u89c6\u9891Id") Long videoId, @RequestParam(value="videoType") @ApiParam(value="\u97f3\u89c6\u9891\u7c7b\u578b") String videoType, @RequestParam(value="roomId") @ApiParam(value="\u7fa4\u7ec4Id") Long roomId, @RequestParam(value="roomName") @ApiParam(value="\u7fa4\u7ec4\u540d\u79f0") String roomName, @RequestBody List<VideoUserDO> videoUserDOList, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        videoUserDOList.forEach(v -> {
            v.setVideoID(videoId);
            v.setDataStatus(Long.valueOf(4L));
            v.setCreateTime(DateUtil.now());
            v.setModifyTime(DateUtil.now());
        });
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"VIDEO_ID", (Object)videoId);
        List allUserList = this.videoUserService.list((Wrapper)queryWrapper);
        queryWrapper.eq((Object)"DATA_STATUS", (Object)5);
        List currentUserList = this.videoUserService.list((Wrapper)queryWrapper);
        List updateUserIDList = videoUserDOList.stream().map(VideoUserDO::getUserID).filter(s -> allUserList.stream().map(VideoUserDO::getUserID).collect(Collectors.toList()).contains(s)).collect(Collectors.toList());
        if (!CollUtil.isEmpty(updateUserIDList)) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"VIDEO_ID", (Object)videoId);
            updateWrapper.in((Object)"USER_ID", updateUserIDList);
            updateWrapper.set((Object)"DATA_STATUS", (Object)4);
            updateWrapper.set((Object)"LAST_TIME", (Object)DateUtil.now());
            this.videoUserService.update((Wrapper)updateWrapper);
        }
        this.videoUserService.saveBatch((Collection)videoUserDOList.stream().filter(s -> !allUserList.stream().map(v -> v.getUserID() + "").collect(Collectors.toList()).contains(s.getUserID())).collect(Collectors.toList()));
        GroupDO groupDO = new GroupDO();
        groupDO.setGroupId(roomId);
        groupDO.setGroupName(roomName);
        String userNameStr = videoUserDOList.stream().map(VideoUserDO::getUserName).collect(Collectors.joining("\uff0c"));
        String body = currentLoginUser.getUserName() + "\u9080\u8bf7" + userNameStr + "\u52a0\u5165\u4e86" + ("1".equals(videoType) ? "\u89c6\u9891" : "\u8bed\u97f3") + "\u901a\u8bdd";
        VideoUserDO videoUserDO = new VideoUserDO();
        videoUserDO.setUserID(currentLoginUser.getId());
        videoUserDO.setUserName(currentLoginUser.getUserName());
        videoUserDOList.add(videoUserDO);
        this.groupManageService.sendRoomNotice(roomId, roomName, videoId + "", body, currentLoginUser.getId(), currentLoginUser.getUserName(), videoUserDOList.stream().map(v -> v.getUserID() + "").collect(Collectors.toList()), NoticeMsgBean.EventType.VIDEOSTART);
        return Result.succeed((Object)true);
    }

    @ApiOperation(value="\u628a\u4eba\u8e22\u51fa\u97f3\u89c6\u9891\u901a\u8bdd J_L_0010")
    public Result<Boolean> deleteVideoAudioUser(@RequestParam(value="videoId") @ApiParam(value="\u97f3\u89c6\u9891Id") Long videoId, @RequestParam(value="videoType") @ApiParam(value="\u97f3\u89c6\u9891\u7c7b\u578b") String videoType, @RequestParam(value="roomId") @ApiParam(value="\u7fa4\u7ec4Id") Long roomID, @RequestParam(value="roomName") @ApiParam(value="\u7fa4\u7ec4\u540d\u79f0") String roomName, @RequestBody List<VideoUserDO> videoUserDOList, @ApiIgnore @LoginUser CurrentLoginUser currentLoginUser) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"VIDEO_ID", (Object)videoId);
        updateWrapper.in((Object)"USER_ID", (Collection)videoUserDOList.stream().map(v -> v.getUserID() + "").collect(Collectors.toList()));
        updateWrapper.set((Object)"DATA_STATUS", (Object)6);
        updateWrapper.set((Object)"LAST_TIME", (Object)DateUtil.now());
        this.videoUserService.update((Wrapper)updateWrapper);
        String body = "\u4f60\u88ab\u79fb\u51fa" + ("1".equals(videoType) ? "\u89c6\u9891" : "\u8bed\u97f3") + "\u901a\u8bdd";
        this.groupManageService.sendRoomNotice(roomID, roomName, videoId + "", body, currentLoginUser.getId(), currentLoginUser.getUserName(), videoUserDOList.stream().map(v -> v.getUserID() + "").collect(Collectors.toList()), NoticeMsgBean.EventType.VIDEOSTART);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"DATA_STATUS", (Object)5);
        queryWrapper.eq((Object)"VIDEO_ID", (Object)videoId);
        String userIDs = this.videoUserService.list((Wrapper)queryWrapper).stream().map(v -> v.getUserID() + "").collect(Collectors.joining(","));
        return Result.succeed((Object)true);
    }
}

