/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.im.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.mp.common.annotation.ApiVersion;
import com.jxdinfo.mp.common.annotation.LoginUser;
import com.jxdinfo.mp.common.model.CurrentLoginUser;
import com.jxdinfo.mp.common.model.PageDTO;
import com.jxdinfo.mp.common.model.PageVO;
import com.jxdinfo.mp.common.model.Result;
import com.jxdinfo.mp.common.model.Role;
import com.jxdinfo.mp.common.utils.JqxSpringUtil;
import com.jxdinfo.mp.common.utils.StringUtil;
import com.jxdinfo.mp.im.dao.material.ArticlePraiseMapper;
import com.jxdinfo.mp.im.model.material.ArticleDO;
import com.jxdinfo.mp.im.model.material.ArticlePraiseDO;
import com.jxdinfo.mp.im.model.material.ArticleVO;
import com.jxdinfo.mp.im.service.ArticlePraiseService;
import com.jxdinfo.mp.im.service.ArticleService;
import com.jxdinfo.mp.im.util.NewsUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u56fe\u6587\u8d44\u6e90\u76f8\u5173\u63a7\u5236\u5668,\u5df2\u6d4b"})
@RestController
@ApiVersion
@RequestMapping(value={"/v1/article"})
public class ArticleController {
    @Resource
    private ArticleService articleService;
    @Resource
    private ArticlePraiseService articlePraiseService;
    @Resource
    private ArticlePraiseMapper articlePraiseMapper;
    @Resource
    private Environment environment;
    @Resource
    private OssService ossService;

    @ApiOperation(value="\u83b7\u53d6article\u56fe\u6587\u8be6\u60c5,\u5df2\u6d4b")
    @GetMapping(value={"/detail"})
    public Result<ArticleDO> queryWebMsg(@RequestParam String objID) {
        ArticleDO articleDO = (ArticleDO)this.articleService.getById((Serializable)((Object)objID));
        if (articleDO != null && StringUtils.isNotEmpty((CharSequence)articleDO.getHtmlBody())) {
            articleDO.setHtmlBody(articleDO.getHtmlBody().replaceAll("<code class=\"language-xml\">", "").replaceAll("</code>", "").replaceAll("&gt;", ">").replaceAll("&lt;", "<"));
        }
        return Result.succeed((Object)articleDO);
    }

    @ApiOperation(value="\u65b0\u589earticle\u56fe\u6587,\u5df2\u6d4b")
    @PostMapping(value={"/add"})
    public Result<Boolean> addArticle(@RequestBody ArticleDO articleDO, @ApiIgnore @LoginUser CurrentLoginUser loginUser) {
        return Result.succeed((Object)this.articleService.save((Object)articleDO));
    }

    @ApiOperation(value="\u4fee\u6539article\u56fe\u6587,\u5df2\u6d4b")
    @PostMapping(value={"/edit"})
    public Result<Boolean> editArticle(@RequestBody ArticleDO articleDO, @ApiIgnore @LoginUser(isFull=true) CurrentLoginUser loginUser) {
        if (!loginUser.getRoles().stream().map(Role::getRoleCode).collect(Collectors.toList()).contains("JS0000")) {
            if (!loginUser.getId().equals(articleDO.getCreator())) {
                return Result.succeed((Object)false, (String)"\u53ea\u80fd\u4fee\u6539\u81ea\u5df1\u7ef4\u62a4\u7684\u56fe\u6587\u8d44\u6e90");
            }
            return Result.succeed((Object)this.articleService.updateById((Object)articleDO));
        }
        return Result.succeed((Object)this.articleService.updateById((Object)articleDO));
    }

    @ApiOperation(value="\u5220\u9664article\u56fe\u6587,\u5df2\u6d4b")
    @GetMapping(value={"/delete"})
    public Result<Boolean> deleteArticle(@RequestParam(value="objID") String objID, @RequestParam(value="creator") @ApiParam(value="\u4f5c\u8005,\u591a\u4e2a\u7528,\u5206\u9694") String createUserID, @ApiIgnore @LoginUser(isFull=true) CurrentLoginUser loginUser) {
        List createUserIDS = CollUtil.toList((Object[])createUserID.split(",")).stream().map(Long::parseLong).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.in((Object)"MSG_ID", (Collection)CollUtil.toList((Object[])objID.split(",")))).in((Object)"CREATOR", createUserIDS);
        if (!loginUser.getRoles().stream().map(Role::getRoleCode).collect(Collectors.toList()).contains("JS0000")) {
            boolean flag = true;
            for (Long userID : createUserIDS) {
                if (loginUser.getId().equals(userID)) continue;
                flag = false;
                break;
            }
            if (!flag) {
                return Result.succeed((Object)false, (String)"\u5b58\u5728\u56fe\u6587\u4e0d\u662f\u60a8\u521b\u5efa\u7684");
            }
            this.articleService.remove((Wrapper)wrapper);
        } else {
            this.articleService.remove((Wrapper)wrapper);
        }
        return Result.succeed((Object)true);
    }

    @ApiOperation(value="\u83b7\u53d6article\u56fe\u6587\u5217\u8868,\u5df2\u6d4b")
    @GetMapping(value={"/list"})
    public Result<PageVO<ArticleVO>> getArticleList(@ApiIgnore @LoginUser(isFull=true) CurrentLoginUser currentLoginUser, @RequestParam(required=false) @ApiParam(value="\u56fe\u6587\u6216\u65b0\u95fb") String sourceType, @RequestParam(required=false) @ApiParam(value="\u80fd\u5426\u5206\u4eab") Integer isShare, @RequestParam(required=false) @ApiParam(value="\u6807\u9898") String searchKey, @RequestParam(required=false, defaultValue="20") @ApiParam(value="\u5206\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875\u6570") int pageNum) {
        PageVO pageVO = new PageVO();
        if ("1".equals(sourceType)) {
            PageDTO newsVOPageDTO = new PageDTO();
            newsVOPageDTO.setPageNum(Integer.valueOf(pageNum));
            newsVOPageDTO.setPageSize(Integer.valueOf(pageSize));
            QueryWrapper queryWrapper = new QueryWrapper();
            if (!NewsUtil.getRoleIDs((List)currentLoginUser.getRoles()).contains(this.environment.getProperty("mp.role.sysAdmin"))) {
                queryWrapper.eq((Object)"EN.CREATEUSERID", (Object)currentLoginUser.getId());
            }
            queryWrapper.like(StrUtil.isNotEmpty((CharSequence)searchKey), (Object)"EN.TITLE", (Object)StringUtil.replaceSpecialChar((String)searchKey));
            queryWrapper.eq((Object)"EN.NEWSTYPE", (Object)0);
            queryWrapper.orderByDesc((Object)"EN.CREATETIME");
            PageDTO newsPageDTO = this.articleService.getNewsList(newsVOPageDTO, queryWrapper);
            ArrayList articleVOS = new ArrayList();
            newsPageDTO.getList().forEach(newsVO -> {
                ArticleVO articleVO = new ArticleVO();
                if (StrUtil.isNotEmpty((CharSequence)newsVO.getUrl())) {
                    newsVO.setEditLink(Integer.valueOf(1));
                } else {
                    newsVO.setEditLink(Integer.valueOf(0));
                }
                articleVO.setObjId(newsVO.getNewsID());
                articleVO.setAuthor(newsVO.getCreateUserName());
                articleVO.setIsShare(newsVO.getShare());
                articleVO.setMsgTitle(newsVO.getTitle());
                BeanUtil.copyProperties((Object)newsVO, (Object)articleVO, (String[])new String[0]);
                articleVO.setCreateTime(NewsUtil.subDateTime((String)newsVO.getCreateTime()));
                articleVO.setModifyTime(NewsUtil.subDateTime((String)newsVO.getModifyTime()));
                articleVOS.add(articleVO);
            });
            newsVOPageDTO.setList(articleVOS);
            newsVOPageDTO.setPageCount(newsPageDTO.getPageCount());
            BeanUtil.copyProperties((Object)newsVOPageDTO, (Object)pageVO, (String[])new String[0]);
            return Result.succeed((Object)pageVO);
        }
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(Integer.valueOf(pageNum));
        pageDTO.setPageSize(Integer.valueOf(pageSize));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(isShare != null, (Object)"IS_SHARE", (Object)isShare);
        if (!StrUtil.isEmpty((CharSequence)searchKey)) {
            queryWrapper.like((Object)"MSG_TITLE", (Object)JqxSpringUtil.replaceSpecialChar((String)searchKey));
        }
        queryWrapper.orderByDesc((Object)"CREATE_TIME");
        BeanUtils.copyProperties((Object)this.articleService.page((IPage)pageDTO, (Wrapper)queryWrapper), (Object)pageVO);
        return Result.succeed((Object)pageVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e2a\u4eba\u662f\u5426\u70b9\u8d5e")
    @GetMapping(value={"/{msgID}/praise"})
    public Result<ArticlePraiseDO> getReadPraiseInfo(@PathVariable @ApiParam(value="\u56fe\u6587\u8d44\u6e90\u7684ID") Long msgID, @ApiIgnore @LoginUser(isFull=true) CurrentLoginUser currentLoginUser) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"MSG_ID", (Object)msgID)).eq((Object)"B_ID", (Object)currentLoginUser.getId())).eq((Object)"TYPE", (Object)0);
        ArticlePraiseDO articlePraiseDO = new ArticlePraiseDO();
        long count = this.articlePraiseMapper.selectCount((Wrapper)queryWrapper);
        if (count == 0L) {
            articlePraiseDO.setThumbState("0");
        } else {
            articlePraiseDO.setThumbState("1");
        }
        return Result.succeed((Object)articlePraiseDO);
    }

    @ApiOperation(value="\u83b7\u53d6\u70b9\u8d5e\u6570\u76ee,\u5df2\u6d4b")
    @GetMapping(value={"/{msgID}/praiseNum"})
    public Result<Long> getReadPraiseCount(@PathVariable @ApiParam(value="\u56fe\u6587\u8d44\u6e90\u7684ID") Long msgID) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"MSG_ID", (Object)msgID)).eq((Object)"TYPE", (Object)0);
        return Result.succeed((Object)this.articlePraiseService.count((Wrapper)queryWrapper));
    }

    @ApiOperation(value="\u70b9\u8d5e,\u5df2\u6d4b")
    @PostMapping(value={"/{msgID}/praise"})
    public Result<Boolean> insertReadPraiseInfo(@PathVariable @ApiParam(value="\u56fe\u6587\u8d44\u6e90\u7684ID") Long msgID, @ApiIgnore @LoginUser(isFull=true) CurrentLoginUser currentLoginUser, @RequestParam(value="praise") @ApiParam(value="\u662f\u5426\u70b9\u8d5e") String praise) {
        if ("1".equals(praise)) {
            ArticlePraiseDO articlePraiseDO = new ArticlePraiseDO();
            articlePraiseDO.setMsgID(msgID);
            articlePraiseDO.setBID(currentLoginUser.getId());
            articlePraiseDO.setBName(currentLoginUser.getUserName());
            articlePraiseDO.setType(Integer.valueOf(0));
            articlePraiseDO.setDataStatus("1");
            return Result.succeed((Object)this.articlePraiseService.save((Object)articlePraiseDO));
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"MSG_ID", (Object)msgID)).eq((Object)"B_ID", (Object)currentLoginUser.getId())).eq((Object)"TYPE", (Object)0);
        return Result.succeed((Object)this.articlePraiseService.remove((Wrapper)queryWrapper));
    }

    @ApiOperation(value="\u83b7\u53d6\u9605\u8bfb\u6570,\u5df2\u6d4b")
    @GetMapping(value={"/{msgID}/read"})
    public Result<Long> getReadCount(@PathVariable @ApiParam(value="\u56fe\u6587\u8d44\u6e90\u7684ID") Long msgID) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"MSG_ID", (Object)msgID)).eq((Object)"TYPE", (Object)1);
        return Result.succeed((Object)this.articlePraiseService.count((Wrapper)queryWrapper));
    }

    @ApiOperation(value="\u9605\u8bfb,\u5df2\u6d4b")
    @PostMapping(value={"/{msgID}/read"})
    public Result<ArticleDO> readArticle(@PathVariable @ApiParam(value="\u56fe\u6587\u8d44\u6e90\u7684ID") Long msgID, @ApiIgnore @LoginUser(isFull=true) CurrentLoginUser currentLoginUser) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"MSG_ID", (Object)msgID)).eq((Object)"TYPE", (Object)1)).eq((Object)"B_ID", (Object)currentLoginUser.getId());
        if (this.articlePraiseService.count((Wrapper)queryWrapper) > 0L) {
            return Result.succeed((Object)this.articleService.getById((Serializable)msgID));
        }
        ArticlePraiseDO articlePraiseDO = new ArticlePraiseDO();
        articlePraiseDO.setMsgID(msgID);
        articlePraiseDO.setBID(currentLoginUser.getId());
        articlePraiseDO.setBName(currentLoginUser.getUserName());
        articlePraiseDO.setType(Integer.valueOf(1));
        articlePraiseDO.setDataStatus("1");
        Result.succeed((Object)this.articlePraiseService.save((Object)articlePraiseDO));
        return Result.succeed((Object)this.articleService.getById((Serializable)msgID));
    }

    @ApiOperation(value="\u663e\u793a\u56fe\u7247")
    @GetMapping(value={"/showImg"})
    public ResponseEntity<byte[]> backgroundDownload(@RequestParam(value="fileId") String id, HttpServletResponse response) {
        try {
            byte[] fileBytes = (byte[])this.ossService.backgroundDownload(Long.valueOf(Long.parseLong(id))).getData();
            return ResponseEntity.ok().body((Object)fileBytes);
        }
        catch (Exception e) {
            throw new HussarException("\u83b7\u53d6\u56fe\u7247\u5931\u8d25");
        }
    }
}

