/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.common.model.hussar;

import com.jxdinfo.mp.common.model.hussar.IResultCode;
import com.jxdinfo.mp.common.model.hussar.ResultCode;
import java.io.Serializable;
import java.util.Optional;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class ApiResponse<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int code;
    private boolean success;
    private T data;
    private String msg;

    private ApiResponse(IResultCode resultCode) {
        this(resultCode, null, resultCode.getMessage());
    }

    private ApiResponse(IResultCode resultCode, String msg) {
        this(resultCode, null, msg);
    }

    private ApiResponse(IResultCode resultCode, T data, String msg) {
        this(resultCode.getCode(), data, msg);
    }

    public ApiResponse() {
    }

    private ApiResponse(int code, T data, String msg) {
        this.code = code;
        this.data = data;
        this.msg = msg;
        this.success = ResultCode.SUCCESS.code == code;
    }

    private static <T> ApiResponse<T> createInstance(T data, int code, String msg) {
        ApiResponse<T> apiResponse = new ApiResponse<T>();
        apiResponse.setCode(code);
        apiResponse.setData(data);
        apiResponse.setMsg(msg);
        apiResponse.setSuccess(ResultCode.SUCCESS.code == code);
        return apiResponse;
    }

    private static <T> ApiResponse<T> createInstance(T data, IResultCode resultCode) {
        ApiResponse<T> apiResponse = new ApiResponse<T>();
        apiResponse.setCode(resultCode.getCode());
        apiResponse.setData(data);
        apiResponse.setMsg(resultCode.getMessage());
        apiResponse.setSuccess(ResultCode.SUCCESS.code == resultCode.getCode());
        return apiResponse;
    }

    public static boolean isSuccess(@Nullable ApiResponse<?> result) {
        return Optional.ofNullable(result).map(x -> ObjectUtils.nullSafeEquals((Object)ResultCode.SUCCESS.code, (Object)x.code)).orElse(Boolean.FALSE);
    }

    public static boolean isNotSuccess(@Nullable ApiResponse<?> result) {
        return !ApiResponse.isSuccess(result);
    }

    public static <T> ApiResponse<T> success(T data, String msg) {
        return ApiResponse.createInstance(data, ResultCode.SUCCESS.getCode(), msg);
    }

    public static <T> ApiResponse<T> success(T data) {
        return ApiResponse.createInstance(data, ResultCode.SUCCESS);
    }

    public static <T> ApiResponse<T> success(int code, T data, String msg) {
        return ApiResponse.createInstance(data, code, msg);
    }

    public static <T> ApiResponse<T> success(String msg) {
        return ApiResponse.createInstance(null, ResultCode.SUCCESS.getCode(), msg);
    }

    public static <T> ApiResponse<T> success() {
        return ApiResponse.createInstance(null, ResultCode.SUCCESS.getCode(), ResultCode.SUCCESS.message);
    }

    public static <T> ApiResponse<T> success(int code, String msg) {
        return ApiResponse.createInstance(null, code, msg);
    }

    public static <T> ApiResponse<T> success(IResultCode resultCode) {
        return ApiResponse.createInstance(null, resultCode);
    }

    public static <T> ApiResponse<T> success(IResultCode resultCode, String msg) {
        return ApiResponse.createInstance(null, resultCode.getCode(), msg);
    }

    public static <T> ApiResponse<T> fail(String msg) {
        return ApiResponse.createInstance(null, ResultCode.FAILURE.getCode(), msg);
    }

    public static <T> ApiResponse<T> fail(int code, T data, String msg) {
        return ApiResponse.createInstance(data, code, msg);
    }

    public static <T> ApiResponse<T> fail(int code, String msg) {
        return ApiResponse.createInstance(null, code, msg);
    }

    public static <T> ApiResponse<T> fail(IResultCode resultCode) {
        return ApiResponse.createInstance(null, resultCode);
    }

    public static <T> ApiResponse<T> fail(IResultCode resultCode, String msg) {
        return ApiResponse.createInstance(null, resultCode.getCode(), msg);
    }

    public static <T> ApiResponse<T> status(boolean flag) {
        return flag ? ApiResponse.success(ResultCode.SUCCESS.getMessage()) : ApiResponse.fail(ResultCode.FAILURE.getMessage());
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}

