/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.common.utils.gson;

import cn.hutool.core.util.StrUtil;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class LocalDateTimeDeserializer
implements JsonDeserializer<LocalDateTime> {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public LocalDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String dateString = json.getAsString();
        if (StrUtil.isEmpty((CharSequence)dateString)) {
            return null;
        }
        return LocalDateTime.parse(dateString, formatter);
    }
}

