/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.mp.common.utils;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.mp.common.utils.CsvUtil;
import com.jxdinfo.mp.common.utils.GsonUtil;
import com.jxdinfo.mp.common.utils.StringUtil;
import com.jxdinfo.mp.common.utils.dao.SyncMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Uuid2LongUtil {
    private static final Logger log = LoggerFactory.getLogger(Uuid2LongUtil.class);
    private static HashMap<String, String> idMap;
    static long startTime;

    private static void readDB2Cache() {
        SyncMapper syncMapper = (SyncMapper)SpringContextUtil.getBean(SyncMapper.class);
        List<Map<String, String>> mapList = syncMapper.getSyncList();
        for (Map<String, String> map : mapList) {
            if (!ToolUtil.isNotEmpty((Object)map.get("UUID")) || !ToolUtil.isNotEmpty((Object)map.get("LONG_ID"))) continue;
            idMap.put(map.get("UUID").toUpperCase(), String.valueOf(map.get("LONG_ID")));
        }
    }

    public static synchronized long getUniqueId(String oriValue) {
        if (System.currentTimeMillis() - startTime > 14400000L) {
            Uuid2LongUtil.readDB2Cache();
            startTime = System.currentTimeMillis();
        }
        long uniqueId = 0L;
        try {
            uniqueId = Long.parseLong(oriValue);
            return uniqueId;
        }
        catch (NumberFormatException e) {
            log.info("\u539f\u59cb\u503c\u4e0d\u662f\u6570\u5b57ID: {}", (Object)oriValue);
            try {
                String value = idMap.get(oriValue.toUpperCase());
                if (ToolUtil.isNotEmpty((Object)value) && !value.startsWith("2099")) {
                    uniqueId = Long.parseLong(value);
                } else {
                    uniqueId = Uuid2LongUtil.queryUniqueIdFromDatabase(oriValue);
                    idMap.put(oriValue.toUpperCase(), String.valueOf(uniqueId));
                }
            }
            catch (Exception e2) {
                log.error("\u83b7\u53d6\u552f\u4e00ID\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)oriValue, (Object)e2);
                uniqueId = StringUtil.getUniqueId(oriValue);
                idMap.put(oriValue.toUpperCase(), String.valueOf(uniqueId));
            }
            return uniqueId;
        }
    }

    private static long queryUniqueIdFromDatabase(String oriValue) {
        long uniqueId = 0L;
        SyncMapper syncMapper = (SyncMapper)SpringContextUtil.getBean(SyncMapper.class);
        List<Long> userIdList = syncMapper.getUserIdByUUID(oriValue);
        if (ToolUtil.isNotEmpty(userIdList)) {
            uniqueId = userIdList.get(0);
            return uniqueId;
        }
        List<Long> struIdList = syncMapper.getStruIdByUUID(oriValue);
        if (ToolUtil.isNotEmpty(struIdList)) {
            uniqueId = struIdList.get(0);
            return uniqueId;
        }
        if (oriValue.startsWith("2099") && ToolUtil.isNotEmpty(userIdList = syncMapper.getUserIdByUUID(oriValue))) {
            uniqueId = userIdList.get(0);
            return uniqueId;
        }
        return StringUtil.getUniqueId(oriValue);
    }

    static {
        startTime = System.currentTimeMillis();
        try {
            idMap = new CsvUtil().csvReader("/userid_mapping.csv");
            Uuid2LongUtil.readDB2Cache();
            log.error("\u8bfb\u53d6\u5230\u7684\u6240\u6709\u6570\u636e\uff1a{}", (Object)GsonUtil.getInstance().toJson(idMap));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u6570\u636e\u8f6c\u6362\u5173\u7cfb\u8868\u52a0\u8f7d\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }
}

