/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.utils.sentence;

import cn.hutool.core.collection.CollectionUtil;
import com.jxdinfo.idp.icpac.utils.SignUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectUtil {
    private static final Logger log = LoggerFactory.getLogger(RedirectUtil.class);
    private static final String DATA_ID = "data-id";
    private static final String DATA_CONTENT = "content";

    private RedirectUtil() {
        throw new IllegalStateException("\u5de5\u5177\u7c7b\u4e0d\u5141\u8bb8\u88ab\u5b9e\u4f8b\u5316");
    }

    public static int redirectStartPos(String targetStr, String totalText, int startPos, int subLength) {
        if (StringUtils.isEmpty((CharSequence)targetStr) || StringUtils.isEmpty((CharSequence)totalText)) {
            return -1;
        }
        if (targetStr.compareTo(totalText) == 0) {
            return startPos;
        }
        if (totalText.length() <= startPos || targetStr.length() <= startPos) {
            return -1;
        }
        char posChar0 = targetStr.charAt(startPos);
        char[] totalChar = RedirectUtil.transToChars(totalText);
        return RedirectUtil.getPos(totalChar, startPos, posChar0);
    }

    public static int redirectEndPos(String targetStr, String totalText, int startPos, int endPos) {
        if (StringUtils.isEmpty((CharSequence)targetStr) || StringUtils.isEmpty((CharSequence)totalText)) {
            return -1;
        }
        if (targetStr.compareTo(totalText) == 0) {
            return endPos;
        }
        if (totalText.length() <= endPos || targetStr.length() <= endPos) {
            return -1;
        }
        char posChar0 = targetStr.charAt(endPos);
        char[] totalChar = RedirectUtil.transToChars(totalText);
        int virtualEndPos = RedirectUtil.getPos(totalChar, endPos, posChar0);
        if (virtualEndPos < startPos) {
            return -1;
        }
        return virtualEndPos;
    }

    private static char[] transToChars(String var) {
        return var.toCharArray();
    }

    private static int getPos(char[] totalChar, int startPos, char tagChar) {
        if (totalChar[startPos] == tagChar) {
            return startPos;
        }
        int left = startPos;
        for (int right = startPos; left >= 0 || right < totalChar.length; --left, ++right) {
            if (left >= 0 && totalChar[left] == tagChar) {
                return left;
            }
            if (right >= totalChar.length || totalChar[right] != tagChar) continue;
            return right;
        }
        return -1;
    }

    public static void markSentenceP(Map<String, String> matchTextMap, Elements pList) {
        try {
            for (Element element : pList) {
                Matcher matcher;
                String signText = element.text();
                List<Element> elementList = SignUtil.findTextElements(element);
                if (StringUtils.isEmpty((CharSequence)signText) || !signText.contains("sign_")) continue;
                String allText = RedirectUtil.getAllText(elementList);
                if (signText.contains("sign_p") && (matcher = SignUtil.matchSignPProp(signText)) != null) {
                    String signId = matcher.group(1);
                    element.attr(DATA_ID, DATA_CONTENT + signId);
                }
                if (!signText.contains("sign_span")) continue;
                TreeSet<Integer> indexSet = new TreeSet<Integer>();
                HashMap<Integer, Element> eCache = new HashMap<Integer, Element>();
                HashMap<Integer, Element> delECache = new HashMap<Integer, Element>();
                List<String> signs = SignUtil.matchSignSpan(signText);
                if (CollectionUtil.isNotEmpty(signs)) {
                    for (String sign : signs) {
                        Matcher matcher2 = SignUtil.matchSignSpanProp(sign);
                        if (matcher2 == null) continue;
                        String signId = matcher2.group(1);
                        String matchText = matchTextMap.get(signId);
                        int eIndex = Integer.parseInt(matcher2.group(2));
                        int eLength = Integer.parseInt(matcher2.group(3));
                        int eEndIndex = Math.min(eIndex + eLength, allText.length());
                        if (matchText != null) {
                            int endIndex;
                            int startIndex = RedirectUtil.redirectStartPos(matchText, allText, eIndex, eLength);
                            if (startIndex != -1) {
                                eIndex = startIndex;
                            }
                            if ((endIndex = RedirectUtil.redirectEndPos(matchText, allText, eIndex, eEndIndex)) != -1) {
                                eEndIndex = endIndex;
                            }
                        }
                        if (eLength == 0) {
                            Element span = delECache.computeIfAbsent(eIndex, k -> new Element("span"));
                            span.attr(DATA_ID, DATA_CONTENT + signId);
                            indexSet.add(eIndex);
                        }
                        for (int i = eIndex; i < eEndIndex && i < allText.length(); ++i) {
                            Element span = (Element)eCache.get(i);
                            if (null == span) {
                                span = new Element("span");
                                eCache.put(i, span);
                                indexSet.add(i);
                            }
                            span.text(String.valueOf(allText.charAt(i)));
                            span.attr(DATA_ID, DATA_CONTENT + signId);
                        }
                    }
                }
                int textLength = allText.length();
                indexSet.removeIf(index -> index >= textLength);
                List indexList = indexSet.stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
                int currentStartIndex = -1;
                int currentEIndex = 0;
                Element current = elementList.get(currentEIndex);
                String currentText = SignUtil.text(current.toString());
                int beforeTextLength = currentText.length();
                boolean handleFlag = true;
                for (Integer index2 : indexList) {
                    Element delElement;
                    while (index2 >= beforeTextLength && ++currentEIndex < elementList.size()) {
                        if (currentStartIndex != -1 && currentStartIndex < currentText.length() - 1) {
                            current.appendText(allText.substring(currentStartIndex + 1));
                        }
                        current = elementList.get(currentEIndex);
                        currentText = SignUtil.text(current.toString());
                        beforeTextLength += currentText.length();
                        currentStartIndex = -1;
                        handleFlag = true;
                    }
                    int currentIndex = index2 - beforeTextLength + currentText.length();
                    if (handleFlag) {
                        current.text("");
                        handleFlag = false;
                    }
                    if (currentIndex - currentStartIndex > 1) {
                        String commonText = currentText.substring(currentStartIndex + 1, currentIndex);
                        current.appendText(commonText);
                    }
                    if (eCache.get(index2) != null) {
                        current.appendChild((Node)eCache.get(index2));
                    }
                    if ((delElement = (Element)delECache.get(index2)) != null) {
                        String length = delElement.attr("length");
                        if ("-1".equals(length)) {
                            current.appendChild((Node)delElement);
                        }
                        if (eCache.get(index2) == null) {
                            current.appendText(String.valueOf(allText.charAt(index2)));
                        }
                        if ("0".equals(length)) {
                            current.appendChild((Node)delElement);
                        }
                    }
                    currentStartIndex = currentIndex;
                }
                if (currentStartIndex >= currentText.length() - 1) continue;
                current.appendText(currentText.substring(currentStartIndex + 1));
            }
        }
        catch (Exception e) {
            log.error("\u76f8\u4f3c\u5ea6\u6807\u8bb0\u5f02\u5e38", (Throwable)e);
        }
    }

    private static String getAllText(List<Element> elements) {
        StringBuilder buffer = new StringBuilder();
        for (Element element : elements) {
            buffer.append(SignUtil.text(element.toString()));
        }
        return buffer.toString();
    }

    public static void adaptiveWith(Document doc) {
        Elements divList = doc.getElementsByTag("div");
        for (Element element : divList) {
            String style = element.attr("style");
            Pattern pattern = Pattern.compile("(width.*?;)");
            Matcher matcher = pattern.matcher(style);
            if (matcher.find()) {
                style = style.replace(matcher.group(), "");
            }
            element.attr("style", style);
        }
    }
}

