/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.utils.handlehtml;

import com.jxdinfo.idp.icpac.utils.SignUtil;
import com.jxdinfo.idp.icpac.utils.handlehtml.AbstractHtmlHandler;
import java.util.Map;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ContrastHtmlHandler
extends AbstractHtmlHandler {
    private Map<String, String> typeMap;

    @Override
    public void after() {
        for (Map.Entry<String, String> entry : this.typeMap.entrySet()) {
            Elements elements = this.document.getElementsByAttributeValueContaining("data-id", entry.getKey());
            for (Element element : elements) {
                this.addElementClass(element, entry.getValue());
            }
        }
    }

    private void addElementClass(Element element, String type) {
        element.addClass(SignUtil.getEClass(type));
        String className = element.className();
        if (className.contains("border-left")) {
            element.removeClass("border-left");
            element.addClass("border-left" + type);
        } else if (className.contains("border-right")) {
            element.removeClass("border-right");
            element.addClass("border-right" + type);
        }
    }

    public Map<String, String> getTypeMap() {
        return this.typeMap;
    }

    public void setTypeMap(Map<String, String> typeMap) {
        this.typeMap = typeMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContrastHtmlHandler)) {
            return false;
        }
        ContrastHtmlHandler other = (ContrastHtmlHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$typeMap = this.getTypeMap();
        Map<String, String> other$typeMap = other.getTypeMap();
        return !(this$typeMap == null ? other$typeMap != null : !((Object)this$typeMap).equals(other$typeMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContrastHtmlHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $typeMap = this.getTypeMap();
        result = result * 59 + ($typeMap == null ? 43 : ((Object)$typeMap).hashCode());
        return result;
    }

    public String toString() {
        return "ContrastHtmlHandler(typeMap=" + this.getTypeMap() + ")";
    }
}

