/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.utils;

import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.utils.ReadWordUtil;
import com.jxdinfo.idp.icpac.utils.entity.WordLocation;
import com.jxdinfo.idp.icpac.utils.entity.word.WordCatalog;
import com.jxdinfo.idp.icpac.utils.entity.word.WordChapterInfo;
import com.jxdinfo.idp.icpac.utils.entity.word.WordParagraphInfo;
import com.jxdinfo.idp.icpac.utils.entity.word.WordStructureInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class WordCatalogUtils {
    public static List<WordCatalog> getCatalog(FileBytesInfo fileBytesInfo) {
        return WordCatalogUtils.getCatalog(new ByteArrayInputStream(fileBytesInfo.getFileBytes()), fileBytesInfo.getFileName());
    }

    public static List<WordCatalog> getCatalogNoTree(FileBytesInfo fileBytesInfo) {
        return WordCatalogUtils.getCatalogNoTree(new ByteArrayInputStream(fileBytesInfo.getFileBytes()), fileBytesInfo.getFileName());
    }

    private static List<WordCatalog> getCatalogNoTree(ByteArrayInputStream is, String fileName) {
        return WordCatalogUtils.getCatalogNoTree(ReadWordUtil.getWordInfo(is, fileName));
    }

    public static List<WordCatalog> getCatalog(InputStream is, String fileName) {
        WordStructureInfo wordInfo = ReadWordUtil.getWordInfo(is, fileName);
        List<WordChapterInfo> chapterInfos = wordInfo.getChapterInfos();
        Map<String, WordChapterInfo> catalogMap = WordCatalogUtils.getCatalogCollection(chapterInfos);
        HashMap<String, WordCatalog> visitedTitle = new HashMap<String, WordCatalog>();
        ArrayList<WordCatalog> result = new ArrayList<WordCatalog>();
        int index = 0;
        for (WordChapterInfo chapterInfo : chapterInfos) {
            WordCatalog catalog = WordCatalogUtils.getCatalog(visitedTitle, catalogMap, chapterInfo, index);
            if (catalog != null) {
                result.add(catalog);
            }
            ++index;
        }
        return result;
    }

    private static WordCatalog getCatalog(Map<String, WordCatalog> visitedTitle, Map<String, WordChapterInfo> catalogMap, WordChapterInfo chapterInfo, int index) {
        WordCatalog returnValue = null;
        String titleName = chapterInfo.getTitleName();
        titleName = titleName.trim().replaceAll("\n", "").replaceAll("\t", "");
        WordCatalog parentCatalog = visitedTitle.get(titleName + "_" + index);
        List<WordParagraphInfo> paragraphInfoList = chapterInfo.getPInfoList();
        if (parentCatalog != null || StringUtils.isEmpty((CharSequence)titleName)) {
            return null;
        }
        WordParagraphInfo paragraphInfo = paragraphInfoList.get(0);
        WordLocation wordLocation = new WordLocation();
        WordLocation.ParagraphLocation pLocation = wordLocation.newPLocation();
        pLocation.setIndex(paragraphInfo.getIndex());
        parentCatalog = new WordCatalog("_" + index, titleName, wordLocation);
        visitedTitle.put(titleName + "_" + index, parentCatalog);
        returnValue = parentCatalog;
        ++index;
        int len = paragraphInfoList.size();
        for (int i = 1; i < len; ++i) {
            paragraphInfo = paragraphInfoList.get(i);
            String text = paragraphInfo.getText();
            text = text.trim().replaceAll("\n", "").replaceAll("\t", "");
            WordChapterInfo info = catalogMap.get("_" + index);
            if (info == null) continue;
            WordCatalog catalog = WordCatalogUtils.getCatalog(visitedTitle, catalogMap, info, index);
            if (catalog != null) {
                parentCatalog.addSubCatalog(catalog);
            }
            ++index;
        }
        return returnValue;
    }

    private static Map<String, WordChapterInfo> getCatalogCollection(List<WordChapterInfo> chapterInfos) {
        int index = 0;
        HashMap<String, WordChapterInfo> map = new HashMap<String, WordChapterInfo>();
        for (WordChapterInfo chapterInfo : chapterInfos) {
            String titleName = chapterInfo.getTitleName().trim().replaceAll("\n", "").replaceAll("\t", "");
            if (StringUtils.isNotEmpty((CharSequence)titleName)) {
                map.put(titleName + "_" + index, chapterInfo);
            }
            ++index;
        }
        return map;
    }

    public static List<WordCatalog> getCatalogNoTree(WordStructureInfo wordInfo) {
        ArrayList<WordCatalog> result = new ArrayList<WordCatalog>();
        int index = 0;
        for (WordChapterInfo chapterInfo : wordInfo.getChapterInfos()) {
            String titleName = chapterInfo.getTitleName();
            if (StringUtils.isEmpty((CharSequence)(titleName = titleName.trim().replaceAll("\n", "").replaceAll("\t", "")))) continue;
            WordParagraphInfo paragraphInfo = chapterInfo.getPInfoList().get(0);
            WordLocation wordLocation = new WordLocation();
            WordLocation.ParagraphLocation pLocation = wordLocation.newPLocation();
            pLocation.setIndex(paragraphInfo.getIndex());
            WordCatalog wordCatalog = new WordCatalog("_" + index, titleName, wordLocation);
            ++index;
            result.add(wordCatalog);
        }
        return result;
    }
}

