/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.utils;

import com.jxdinfo.idp.icpac.common.document.location.WordLocation;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.utils.handlehtml.DefaultHtmlHandler;
import com.jxdinfo.idp.icpac.utils.handlehtml.HtmlHandler;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class MarkHtmlUtil {
    private static final Logger log = LoggerFactory.getLogger(MarkHtmlUtil.class);
    private HtmlHandler handler;
    private Map<String, WordLocation> locationMap;
    private Map<String, String> matchTextMap;

    public MarkHtmlUtil() {
        this.handler = new DefaultHtmlHandler();
    }

    public MarkHtmlUtil(Map<String, WordLocation> locationMap, Map<String, String> matchTextMap) {
        this.handler = new DefaultHtmlHandler();
        this.locationMap = locationMap;
        this.matchTextMap = matchTextMap;
    }

    public MarkHtmlUtil(HtmlHandler handler, Map<String, WordLocation> locationMap, Map<String, String> matchTextMap) {
        this.handler = handler;
        this.locationMap = locationMap;
        this.matchTextMap = matchTextMap;
    }

    public void execute(HttpServletResponse response, FileBytesInfo bytesInfo) {
        try {
            this.handler.handle(response, bytesInfo, this.locationMap, this.matchTextMap);
            this.handler.after();
            this.handler.response(response, bytesInfo);
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u6807\u8bb0html\u5f02\u5e38", (Throwable)e);
        }
    }

    public void execute(HttpServletResponse response, MultipartFile file) {
        try {
            FileBytesInfo bytesInfo = new FileBytesInfo();
            bytesInfo.setFileBytes(file.getBytes());
            bytesInfo.setFileName(file.getName());
            this.handler.handle(response, bytesInfo, this.locationMap, this.matchTextMap);
            this.handler.after();
            this.handler.response(response, bytesInfo);
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u6807\u8bb0html\u5f02\u5e38", (Throwable)e);
        }
    }

    public HtmlHandler getHandler() {
        return this.handler;
    }

    public Map<String, WordLocation> getLocationMap() {
        return this.locationMap;
    }

    public Map<String, String> getMatchTextMap() {
        return this.matchTextMap;
    }

    public void setHandler(HtmlHandler handler) {
        this.handler = handler;
    }

    public void setLocationMap(Map<String, WordLocation> locationMap) {
        this.locationMap = locationMap;
    }

    public void setMatchTextMap(Map<String, String> matchTextMap) {
        this.matchTextMap = matchTextMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarkHtmlUtil)) {
            return false;
        }
        MarkHtmlUtil other = (MarkHtmlUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HtmlHandler this$handler = this.getHandler();
        HtmlHandler other$handler = other.getHandler();
        if (this$handler == null ? other$handler != null : !this$handler.equals(other$handler)) {
            return false;
        }
        Map<String, WordLocation> this$locationMap = this.getLocationMap();
        Map<String, WordLocation> other$locationMap = other.getLocationMap();
        if (this$locationMap == null ? other$locationMap != null : !((Object)this$locationMap).equals(other$locationMap)) {
            return false;
        }
        Map<String, String> this$matchTextMap = this.getMatchTextMap();
        Map<String, String> other$matchTextMap = other.getMatchTextMap();
        return !(this$matchTextMap == null ? other$matchTextMap != null : !((Object)this$matchTextMap).equals(other$matchTextMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MarkHtmlUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HtmlHandler $handler = this.getHandler();
        result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
        Map<String, WordLocation> $locationMap = this.getLocationMap();
        result = result * 59 + ($locationMap == null ? 43 : ((Object)$locationMap).hashCode());
        Map<String, String> $matchTextMap = this.getMatchTextMap();
        result = result * 59 + ($matchTextMap == null ? 43 : ((Object)$matchTextMap).hashCode());
        return result;
    }

    public String toString() {
        return "MarkHtmlUtil(handler=" + this.getHandler() + ", locationMap=" + this.getLocationMap() + ", matchTextMap=" + this.getMatchTextMap() + ")";
    }
}

