/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.third.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckChapterDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckChapterHolder;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckDoc;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckDocQuery;
import com.jxdinfo.idp.icpac.service.DuplicateCheckChapterService;
import com.jxdinfo.idp.icpac.third.service.ThirdDuplicateCheckService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/duplicateChecking"})
public class ThirdDuplicateCheckController {
    @Resource
    private ThirdDuplicateCheckService service;
    @Resource
    private DuplicateCheckChapterService checkChapterService;

    @PostMapping(value={"/getOptionalDoc"})
    public ApiResponse<Page<? extends DuplicateCheckDoc>> getOptionalDoc(@RequestBody DuplicateCheckDocQuery docQuery) {
        return ApiResponse.data(this.service.getOptionalDoc(docQuery));
    }

    @PostMapping(value={"updateUserCustomChapter"})
    public ApiResponse<Void> updateUserCustomChapter(@RequestBody DuplicateCheckChapterHolder checkChapterHolder) {
        this.service.updateUserCustomChapter(checkChapterHolder);
        return ApiResponse.success();
    }

    @GetMapping(value={"/getUserCustomChapter/{projectId}/{belongUser}"})
    public ApiResponse<List<DuplicateCheckChapterDto>> getUserCustomChapter(@PathVariable(value="projectId") String projectId, @PathVariable(value="belongUser") String belongUser) {
        return ApiResponse.data(this.checkChapterService.getByProjectId(projectId, belongUser));
    }

    @PostMapping(value={"/resetCheckDuplicate"})
    public ApiResponse<Void> resetCheckDuplicate(@RequestBody DuplicateCheckDocQuery query) throws Exception {
        this.service.resetCheckDuplicate(query);
        return ApiResponse.success();
    }
}

