/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.similaritycompare.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.icpac.similaritycompare.entity.po.SimilarityResult;
import com.jxdinfo.idp.icpac.similaritycompare.entity.po.SimilaritySentence;
import com.jxdinfo.idp.icpac.similaritycompare.entity.po.SimilarityTask;
import com.jxdinfo.idp.icpac.similaritycompare.mapper.SimilaritySentenceMapper;
import com.jxdinfo.idp.icpac.similaritycompare.service.ISimilarityResultService;
import com.jxdinfo.idp.icpac.similaritycompare.service.ISimilaritySentenceService;
import com.jxdinfo.idp.icpac.similaritycompare.service.ISimilarityTaskService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SimilaritySentenceServiceImpl
extends ServiceImpl<SimilaritySentenceMapper, SimilaritySentence>
implements ISimilaritySentenceService {
    private static final Logger log = LoggerFactory.getLogger(SimilaritySentenceServiceImpl.class);
    @Resource
    private ISimilarityResultService resultService;
    @Resource
    private ISimilarityTaskService taskService;

    @Override
    public SimilarityTask getTaskBySentenceId(String sentenceId) {
        SimilaritySentence sentence = (SimilaritySentence)this.getById((Serializable)((Object)sentenceId));
        SimilarityResult result = (SimilarityResult)this.resultService.getById((Serializable)((Object)sentence.getResultId()));
        return (SimilarityTask)this.taskService.getById((Serializable)((Object)result.getTaskId()));
    }

    @Override
    public List<SimilaritySentence> getSentencesOfSameTask(String taskId) {
        LambdaQueryWrapper resultQuery = new LambdaQueryWrapper();
        resultQuery.eq(SimilarityResult::getTaskId, (Object)taskId);
        List resultList = this.resultService.list((Wrapper)resultQuery);
        List resultIds = resultList.stream().map(SimilarityResult::getId).collect(Collectors.toList());
        LambdaQueryWrapper sentenceQuery = new LambdaQueryWrapper();
        sentenceQuery.in(SimilaritySentence::getResultId, resultIds);
        if (resultIds != null && !resultIds.isEmpty()) {
            return this.list((Wrapper)sentenceQuery);
        }
        return new ArrayList<SimilaritySentence>();
    }
}

