/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.similaritycompare.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.util.user.UserUtils;
import com.jxdinfo.idp.common.util.uuid.IdUtils;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.common.util.FileUtils;
import com.jxdinfo.idp.icpac.doccontrast.util.Word2HtmlUtil;
import com.jxdinfo.idp.icpac.docexamine.entity.location.SentenceContent;
import com.jxdinfo.idp.icpac.docexamine.entity.location.WordLocation;
import com.jxdinfo.idp.icpac.similaritycompare.entity.LocationMappingPool;
import com.jxdinfo.idp.icpac.similaritycompare.entity.LocationSimSentence;
import com.jxdinfo.idp.icpac.similaritycompare.entity.dto.SimilarExecuteDTO;
import com.jxdinfo.idp.icpac.similaritycompare.entity.po.SimilarityResult;
import com.jxdinfo.idp.icpac.similaritycompare.entity.po.SimilaritySentence;
import com.jxdinfo.idp.icpac.similaritycompare.entity.po.SimilarityTask;
import com.jxdinfo.idp.icpac.similaritycompare.entity.query.DocInfoQuery;
import com.jxdinfo.idp.icpac.similaritycompare.entity.query.SimilarityResultQuery;
import com.jxdinfo.idp.icpac.similaritycompare.entity.query.SimilarityTaskQuery;
import com.jxdinfo.idp.icpac.similaritycompare.entity.resp.SimilarSentences;
import com.jxdinfo.idp.icpac.similaritycompare.entity.resp.SimilarityResponse;
import com.jxdinfo.idp.icpac.similaritycompare.entity.vo.SimilarityTaskVO;
import com.jxdinfo.idp.icpac.similaritycompare.mapper.SimilaritySentenceMapper;
import com.jxdinfo.idp.icpac.similaritycompare.service.ISimilarityCompareService;
import com.jxdinfo.idp.icpac.similaritycompare.service.ISimilarityResultService;
import com.jxdinfo.idp.icpac.similaritycompare.service.ISimilaritySentenceService;
import com.jxdinfo.idp.icpac.similaritycompare.service.ISimilarityTaskService;
import com.jxdinfo.idp.icpac.similaritycompare.service.RmiService;
import com.jxdinfo.idp.icpac.utils.sentence.ReadAsSentencesUtil;
import com.jxdinfo.idp.icpac.utils.sentence.RedirectUtil;
import com.jxdinfo.idp.icpac.utils.sentence.TransDoubleUtil;
import com.jxdinfo.idp.interf.DocService;
import com.jxdinfo.idp.vo.DocInfoVo;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SimilarityCompareServiceImpl
implements ISimilarityCompareService {
    private static final Logger log = LoggerFactory.getLogger(SimilarityCompareServiceImpl.class);
    @Resource
    private ISimilarityTaskService taskService;
    @Resource
    private RmiService rmiService;
    @Resource
    private ISimilarityResultService resultService;
    @Resource
    private ISimilaritySentenceService sentenceService;
    @Resource
    private SimilaritySentenceMapper sentenceMapper;
    @Autowired
    private DocService iDocService;

    @Override
    public String saveFile(MultipartFile file) throws Exception {
        return "";
    }

    @Override
    public SimilarityTask execute(SimilarExecuteDTO taskDTO) {
        SimilarityTask task = this.addTask(taskDTO);
        List<SimilarityResponse> responseList = this.rmiService.contractSim(taskDTO);
        Map<Integer, SentenceContent> searchLocation = ReadAsSentencesUtil.readSentencesForMap(taskDTO.getLeftFileId(), taskDTO.getSimThresminSentenceLen());
        Map<Integer, SentenceContent> baseLocation = ReadAsSentencesUtil.readSentencesForMap(taskDTO.getRightFileId(), taskDTO.getSimThresminSentenceLen());
        if (responseList.size() != searchLocation.size()) {
            log.error("\u76f8\u4f3c\u5ea6\u670d\u52a1\u5206\u53e5\u6570\u4e0e\u5206\u53e5\u5de5\u5177\u7ed3\u679c\u4e0d\u540c");
        }
        ArrayList<SimilarityResult> resultList = new ArrayList<SimilarityResult>();
        ArrayList<SimilaritySentence> sentenceList = new ArrayList<SimilaritySentence>();
        responseList = responseList.stream().filter(item -> item.getSimilar_sentences() != null && !item.getSimilar_sentences().isEmpty()).collect(Collectors.toList());
        for (SimilarityResponse response : responseList) {
            Integer sentenceIndex = response.getId();
            SimilarityResult result = new SimilarityResult();
            result.setId(IdUtils.simpleUUID());
            result.setSentenceIndex(sentenceIndex);
            result.setTaskId(task.getId());
            SentenceContent sentenceContent = searchLocation.get(sentenceIndex);
            WordLocation wordLocation = new WordLocation();
            wordLocation.setPLocation(sentenceContent == null ? null : sentenceContent.transForP());
            result.setLocation(JSON.toJSONString((Object)wordLocation));
            result.setBaseSentence(sentenceContent == null ? "" : sentenceContent.getSentenceStr());
            resultList.add(result);
            for (SimilarSentences sentence : response.getSimilar_sentences()) {
                SimilaritySentence sc = new SimilaritySentence();
                sc.setResultId(result.getId());
                Integer baseSentenceId = sentence.getSim_id();
                try {
                    sc.setSimilarity(TransDoubleUtil.transToDouble(sentence.getSimilarty(), 2));
                }
                catch (NumberFormatException e) {
                    sc.setSimilarity("0.00");
                    log.error("\u53e5\u5b50\u76f8\u4f3c\u5ea6\u8f6c\u5316\u5f02\u5e38", (Throwable)e);
                }
                SentenceContent baseContent = baseLocation.get(baseSentenceId);
                WordLocation baseWordLocation = new WordLocation();
                baseWordLocation.setPLocation(baseContent == null ? null : baseContent.transForP());
                sc.setSentenceIndex(baseSentenceId);
                sc.setLocation(JSON.toJSONString((Object)baseWordLocation));
                sc.setSimSentence(baseContent == null ? null : baseContent.getSentenceStr());
                sentenceList.add(sc);
            }
        }
        this.resultService.saveBatch(resultList);
        this.sentenceService.saveBatch(sentenceList);
        DocInfoVo docInfoVoL = this.iDocService.getDocInfo(taskDTO.getLeftFileId());
        DocInfoVo docInfoVoR = this.iDocService.getDocInfo(taskDTO.getRightFileId());
        task.setLeftFileName(docInfoVoL.getName());
        task.setRightFileName(docInfoVoR.getName());
        task.setLeftCreateTime(String.valueOf(docInfoVoL.getCreateTime()));
        task.setRightCreateTime(String.valueOf(docInfoVoR.getCreateTime()));
        return task;
    }

    @Override
    public SimilarityTask addTask(SimilarExecuteDTO taskDTO) {
        SimilarityTask task = new SimilarityTask();
        task.setLeftFileId(taskDTO.getLeftFileId());
        task.setRightFileId(taskDTO.getRightFileId());
        task.setLeftFileSize(taskDTO.getLeftSize());
        task.setRightFileSize(taskDTO.getRightSize());
        task.setCreator(String.valueOf(UserUtils.getLoginUserId()));
        task.setCreateTime(new Date());
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        String[] Units2 = new String[]{"BYTE", "KB", "MB", "GB", "TB"};
        Double leftSize = (double)taskDTO.getLeftSize();
        int leftPoint = 0;
        while (leftSize / 1024.0 > 1.0) {
            leftSize = leftSize / 1024.0;
            ++leftPoint;
        }
        task.setLeftUnit(Units2[leftPoint]);
        task.setLeftFileSize(taskDTO.getLeftSize());
        Double rightSize = (double)taskDTO.getRightSize();
        int rightPoint = 0;
        while (rightSize / 1024.0 > 1.0) {
            rightSize = rightSize / 1024.0;
            ++rightPoint;
        }
        task.setRightUnit(Units2[rightPoint]);
        task.setRightFileSize(taskDTO.getRightSize());
        this.taskService.save(task);
        task.setLeftFileSize((int)Double.parseDouble(decimalFormat.format(leftSize)));
        task.setRightFileSize((int)Double.parseDouble(decimalFormat.format(rightSize)));
        return task;
    }

    @Override
    public Page<SimilarityTaskVO> getHistoryList(SimilarityTaskQuery query) {
        return this.taskService.getPageList(query);
    }

    @Override
    public void getStream(HttpServletResponse response, DocInfoQuery docInfoQuery) {
        FileBytesInfo fileInfo = new FileBytesInfo();
        try {
            fileInfo = FileUtils.getBytesInfo(Long.parseLong(docInfoQuery.getFileId()));
        }
        catch (Exception e) {
            throw new BusinessException("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
        }
        List<String> paragraphs = ReadAsSentencesUtil.readParagraphs(fileInfo);
        LinkedHashMap<String, String> matchTextMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, WordLocation.ParagraphLocation> pLocationMap = new LinkedHashMap<String, WordLocation.ParagraphLocation>();
        LinkedHashMap<String, WordLocation.TableLocation> tLocationMap = new LinkedHashMap<String, WordLocation.TableLocation>();
        if (docInfoQuery.isBaseFile()) {
            LambdaQueryWrapper resultQuery = new LambdaQueryWrapper();
            resultQuery.eq(SimilarityResult::getTaskId, (Object)docInfoQuery.getTaskId());
            List resultList = this.resultService.list((Wrapper)resultQuery);
            Iterator iterator = resultList.iterator();
            while (iterator.hasNext()) {
                SimilarityResult result = (SimilarityResult)iterator.next();
                WordLocation location = (WordLocation)JSON.parseObject((String)result.getLocation(), WordLocation.class);
                pLocationMap.put(result.getId(), location.getPLocation());
                Integer pIndex = location.getPLocation() == null ? -1 : location.getPLocation().getIndex();
                String matchTextStr = pIndex == -1 || pIndex >= paragraphs.size() ? "" : paragraphs.get(pIndex);
                matchTextMap.put(result.getId(), matchTextStr);
            }
        } else {
            List<SimilaritySentence> sentenceList = this.filterSentences(docInfoQuery.getTaskId());
            for (SimilaritySentence sentence : sentenceList) {
                WordLocation location = (WordLocation)JSON.parseObject((String)sentence.getLocation(), WordLocation.class);
                pLocationMap.put(sentence.getId(), location.getPLocation());
                Integer pIndex = location.getPLocation() == null ? -1 : location.getPLocation().getIndex();
                String matchTextStr = pIndex == -1 || pIndex >= paragraphs.size() ? "" : paragraphs.get(pIndex);
                matchTextMap.put(sentence.getId(), matchTextStr);
            }
        }
        try {
            Map<String, Object> htmlInfo = Word2HtmlUtil.wordToHtml(fileInfo, pLocationMap, tLocationMap);
            Document doc = Jsoup.parse((String)((String)htmlInfo.get("htmlStr")));
            Elements pList = doc.getElementsByTag("p");
            RedirectUtil.markSentenceP(matchTextMap, pList);
            if (fileInfo.getFileName().endsWith(".docx")) {
                RedirectUtil.adaptiveWith(doc);
            }
            response.reset();
            response.setContentType("text/html;charset=UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileInfo.getFileName());
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(doc.html().getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            log.error("word\u6587\u6863\u8f6chtml\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public SimilarityResult getSimSentences(String resultId, boolean enable) {
        if (enable) {
            SimilarityResult result = (SimilarityResult)this.resultService.getById((Serializable)((Object)resultId));
            if (result != null) {
                LambdaQueryWrapper sentenceQuery = new LambdaQueryWrapper();
                sentenceQuery.eq(SimilaritySentence::getResultId, (Object)resultId);
                List sentences = this.sentenceService.list((Wrapper)sentenceQuery);
                result.setSimSentences(sentences);
            }
            return result;
        }
        SimilaritySentence baseSentence = (SimilaritySentence)this.sentenceService.getById((Serializable)((Object)resultId));
        SimilarityTask task = this.sentenceService.getTaskBySentenceId(resultId);
        List<SimilaritySentence> sentences = this.sentenceService.getSentencesOfSameTask(task.getId());
        SimilarityResult result = new SimilarityResult();
        result.setId(baseSentence.getId());
        result.setSentenceIndex(baseSentence.getSentenceIndex());
        result.setBaseSentence(baseSentence.getSimSentence());
        result.setTaskId(task.getId());
        ArrayList<SimilaritySentence> virSentences = new ArrayList<SimilaritySentence>();
        if (sentences != null && !sentences.isEmpty()) {
            List sentencesFilter0 = sentences.stream().filter(e -> baseSentence.getSentenceIndex().equals(e.getSentenceIndex())).collect(Collectors.toList());
            for (SimilaritySentence sentence : sentencesFilter0) {
                SimilarityResult resultVar = (SimilarityResult)this.resultService.getById((Serializable)((Object)sentence.getResultId()));
                SimilaritySentence sentenceVar = new SimilaritySentence();
                sentenceVar.setId(resultVar.getId());
                sentenceVar.setSimilarity(sentence.getSimilarity());
                sentenceVar.setSimSentence(resultVar.getBaseSentence());
                sentenceVar.setSentenceIndex(resultVar.getSentenceIndex());
                virSentences.add(sentenceVar);
            }
        }
        result.setSimSentences(virSentences);
        return result;
    }

    @Override
    public List<SimilarityResult> getAllSimSentences(SimilarityResultQuery resultQuery, boolean enable) {
        String taskId = resultQuery.getTaskId();
        if (enable) {
            List<SimilaritySentence> sentencesGroup = this.filterSentences(taskId);
            LambdaQueryWrapper resultQueryWrapper = new LambdaQueryWrapper();
            resultQueryWrapper.eq(SimilarityResult::getTaskId, (Object)taskId);
            List resultList = this.resultService.list((Wrapper)resultQueryWrapper);
            if (resultList != null) {
                for (SimilarityResult result : resultList) {
                    LambdaQueryWrapper sentenceQuery = new LambdaQueryWrapper();
                    sentenceQuery.eq(SimilaritySentence::getResultId, (Object)result.getId());
                    List sentences = this.sentenceService.list((Wrapper)sentenceQuery);
                    if (sentences == null || sentencesGroup == null) continue;
                    List indexs = sentences.stream().map(SimilaritySentence::getSentenceIndex).collect(Collectors.toList());
                    List<SimilaritySentence> filterS = sentencesGroup.stream().filter(x -> indexs.contains(x.getSentenceIndex())).collect(Collectors.toList());
                    result.setSimSentences(filterS);
                }
                for (SimilarityResult result : resultList) {
                    List<SimilaritySentence> sentences = result.getSimSentences();
                    if (sentences == null) continue;
                    sentences = sentences.stream().map(e -> {
                        e.setResultId(result.getId());
                        return e;
                    }).collect(Collectors.toList());
                    result.setSimSentences(sentences);
                }
            }
            return resultList;
        }
        ArrayList<SimilarityResult> resultList = new ArrayList<SimilarityResult>();
        List<SimilarityResult> similarityResultAll = this.resultService.getAllResult(taskId);
        List<SimilaritySentence> sentencesAll = this.sentenceService.getSentencesOfSameTask(taskId);
        List<SimilaritySentence> sentencesGroup = this.filterSentences(taskId);
        if (similarityResultAll == null) {
            return new ArrayList<SimilarityResult>();
        }
        Map<String, SimilarityResult> sRMapping = similarityResultAll.stream().collect(Collectors.toMap(SimilarityResult::getId, e -> e, (u1, u2) -> u1));
        for (SimilaritySentence sentence : sentencesGroup) {
            SimilarityResult result = new SimilarityResult();
            result.setId(sentence.getId());
            result.setSentenceIndex(sentence.getSentenceIndex());
            result.setBaseSentence(sentence.getSimSentence());
            result.setTaskId(taskId);
            ArrayList<SimilaritySentence> virSentences = new ArrayList<SimilaritySentence>();
            if (sentencesGroup != null && !sentencesGroup.isEmpty()) {
                List sentencesFilter0 = sentencesAll.stream().filter(e -> sentence.getSentenceIndex().equals(e.getSentenceIndex())).collect(Collectors.toList());
                for (SimilaritySentence sentencefilter : sentencesFilter0) {
                    SimilarityResult resultVar = sRMapping.get(sentencefilter.getResultId());
                    SimilaritySentence sentenceVar = new SimilaritySentence();
                    sentenceVar.setId(resultVar.getId());
                    sentenceVar.setResultId(sentence.getId());
                    sentenceVar.setSimilarity(sentencefilter.getSimilarity());
                    sentenceVar.setSimSentence(resultVar.getBaseSentence());
                    sentenceVar.setSentenceIndex(resultVar.getSentenceIndex());
                    virSentences.add(sentenceVar);
                }
            }
            result.setSimSentences(virSentences);
            resultList.add(result);
        }
        return resultList;
    }

    @Override
    public void delSimTask(String taskIds) {
        List<String> ids = Arrays.asList(taskIds.split(","));
        if (!ids.isEmpty()) {
            this.taskService.removeTaskFile(taskIds);
            this.taskService.removeByIds(ids);
            LambdaQueryWrapper resultQuery = new LambdaQueryWrapper();
            resultQuery.in(SimilarityResult::getTaskId, ids);
            List resultList = this.resultService.list((Wrapper)resultQuery);
            if (resultList != null && !resultList.isEmpty()) {
                List resultId = resultList.stream().map(SimilarityResult::getId).collect(Collectors.toList());
                LambdaQueryWrapper sentenceQuery = new LambdaQueryWrapper();
                sentenceQuery.in(SimilaritySentence::getResultId, resultId);
                this.sentenceService.remove((Wrapper)sentenceQuery);
                this.resultService.removeByIds(resultId);
            }
        }
    }

    @Override
    public List<LocationMappingPool> getMappingPool(String taskId, boolean leftEnable) {
        SimilarityResultQuery query = new SimilarityResultQuery();
        query.setTaskId(taskId);
        List<SimilarityResult> resultList = this.getAllSimSentences(query, true);
        ArrayList<LocationMappingPool> pool = new ArrayList<LocationMappingPool>();
        List<SimilaritySentence> sentences = this.filterSentences(taskId);
        if (resultList == null || resultList.isEmpty()) {
            return new ArrayList<LocationMappingPool>();
        }
        if (leftEnable) {
            for (SimilarityResult result : resultList) {
                LocationMappingPool mappingPool = new LocationMappingPool();
                if (sentences != null) {
                    List sentenceIndexs = result.getSimSentences().stream().map(SimilaritySentence::getSentenceIndex).collect(Collectors.toList());
                    List<LocationSimSentence> sentenceList = sentences.stream().filter(e -> e.getSentenceIndex() != null && sentenceIndexs.contains(e.getSentenceIndex())).map(this::transSentence).collect(Collectors.toList());
                    mappingPool.setSentenceList(sentenceList);
                }
                mappingPool.setResultId(result.getId());
                pool.add(mappingPool);
            }
        } else {
            List resultId = resultList.stream().map(SimilarityResult::getId).collect(Collectors.toList());
            LambdaQueryWrapper sentenceQuery = new LambdaQueryWrapper();
            sentenceQuery.in(SimilaritySentence::getResultId, resultId);
            List sentencesVar = this.sentenceService.list((Wrapper)sentenceQuery);
            for (SimilaritySentence sentence : sentences) {
                LocationMappingPool mappingPool = new LocationMappingPool();
                if (resultList != null) {
                    List resultIds = sentencesVar.stream().filter(e -> Objects.equals(sentence.getSentenceIndex(), e.getSentenceIndex())).map(SimilaritySentence::getResultId).distinct().collect(Collectors.toList());
                    List<LocationSimSentence> sentenceList = resultList.stream().filter(e -> resultIds.contains(e.getId())).map(this::transSentenceOfR).collect(Collectors.toList());
                    mappingPool.setSentenceList(sentenceList);
                }
                mappingPool.setResultId(sentence.getId());
                pool.add(mappingPool);
            }
        }
        return pool;
    }

    private List<SimilaritySentence> filterSentences(String taskId) {
        List<SimilaritySentence> sentenceList = this.sentenceMapper.getSentences(taskId);
        if (sentenceList != null && !sentenceList.isEmpty()) {
            List<Object> filterSentenceIds = new ArrayList();
            Map<Integer, List<SimilaritySentence>> sameSentence = sentenceList.stream().collect(Collectors.groupingBy(SimilaritySentence::getSentenceIndex));
            for (Map.Entry<Integer, List<SimilaritySentence>> entry : sameSentence.entrySet()) {
                if (entry.getValue().size() < 2) continue;
                List<SimilaritySentence> sentences = entry.getValue();
                List filterIds = sentences.stream().filter(sentence -> sentence.getResultSentenceIndex() != null && sentence.getResultSentenceIndex() != Collections.min(sentences, Comparator.comparingInt(SimilaritySentence::getResultSentenceIndex)).getResultSentenceIndex()).map(SimilaritySentence::getId).collect(Collectors.toList());
                filterSentenceIds.addAll(filterIds);
            }
            List<Object> finalFilterSentenceIds = filterSentenceIds = filterSentenceIds.stream().distinct().collect(Collectors.toList());
            sentenceList = sentenceList.stream().filter(e -> !finalFilterSentenceIds.contains(e.getId())).collect(Collectors.toList());
            return sentenceList;
        }
        return sentenceList;
    }

    private LocationSimSentence transSentence(SimilaritySentence sentence) {
        LocationSimSentence simSentence = new LocationSimSentence();
        simSentence.setSentenceId(sentence.getId());
        simSentence.setSentenceValue(sentence.getSimSentence());
        simSentence.setSentenceIndex(sentence.getSentenceIndex());
        return simSentence;
    }

    private LocationSimSentence transSentenceOfR(SimilarityResult result) {
        LocationSimSentence simSentence = new LocationSimSentence();
        simSentence.setSentenceId(result.getId());
        simSentence.setSentenceValue(result.getBaseSentence());
        simSentence.setSentenceIndex(result.getSentenceIndex());
        return simSentence;
    }
}

