/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.similaritycompare.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.icpac.similaritycompare.entity.LocationMappingPool;
import com.jxdinfo.idp.icpac.similaritycompare.entity.dto.SimilarExecuteDTO;
import com.jxdinfo.idp.icpac.similaritycompare.entity.po.SimilarityResult;
import com.jxdinfo.idp.icpac.similaritycompare.entity.po.SimilarityTask;
import com.jxdinfo.idp.icpac.similaritycompare.entity.query.DocInfoQuery;
import com.jxdinfo.idp.icpac.similaritycompare.entity.query.SimilarityResultQuery;
import com.jxdinfo.idp.icpac.similaritycompare.entity.query.SimilarityTaskQuery;
import com.jxdinfo.idp.icpac.similaritycompare.entity.vo.SimilarityTaskVO;
import com.jxdinfo.idp.icpac.similaritycompare.service.ISimilarityCompareService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/icpac/similarityCompare"})
public class SimilarityCompareController {
    private static final Logger log = LoggerFactory.getLogger(SimilarityCompareController.class);
    @Autowired
    private ISimilarityCompareService similarityCompareService;

    @PostMapping(value={"/saveFile"})
    public ApiResponse<String> saveFile(MultipartFile file) throws Exception {
        return ApiResponse.success((String)this.similarityCompareService.saveFile(file));
    }

    @PostMapping(value={"/execute"})
    public ApiResponse<SimilarityTask> execute(@RequestBody SimilarExecuteDTO executeDTO) {
        return ApiResponse.success((Object)this.similarityCompareService.execute(executeDTO));
    }

    @PostMapping(value={"/stream"})
    public void getStream(HttpServletResponse response, @RequestBody DocInfoQuery docInfoQuery) {
        this.similarityCompareService.getStream(response, docInfoQuery);
    }

    @GetMapping(value={"/getSimSentences"})
    public ApiResponse<SimilarityResult> getSimSentences(@RequestParam(value="resultId") String resultId, @RequestParam(value="enable") boolean enable) {
        return ApiResponse.success((Object)this.similarityCompareService.getSimSentences(resultId, enable));
    }

    @PostMapping(value={"/getAllSimSentences"})
    public ApiResponse<List<SimilarityResult>> getAllSimSentences(@RequestBody SimilarityResultQuery resultQuery, @RequestParam(value="enable") boolean enable) {
        return ApiResponse.success(this.similarityCompareService.getAllSimSentences(resultQuery, enable));
    }

    @GetMapping(value={"/getMappingPool"})
    public ApiResponse<List<LocationMappingPool>> getMappingPool(@RequestParam(value="taskId") String taskId, @RequestParam(value="isLeft") boolean isLeft) {
        return ApiResponse.success(this.similarityCompareService.getMappingPool(taskId, isLeft));
    }

    @PostMapping(value={"/historyList"})
    public ApiResponse<Page<SimilarityTaskVO>> historyList(@RequestBody SimilarityTaskQuery taskQuery) {
        return ApiResponse.success(this.similarityCompareService.getHistoryList(taskQuery));
    }

    @GetMapping(value={"/batchDel"})
    public ApiResponse batchDel(@RequestParam(value="ids") String ids) {
        this.similarityCompareService.delSimTask(ids);
        return ApiResponse.success();
    }
}

