/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSimilarSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckSentence;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckSentenceQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckSimilarSentenceQuery;
import com.jxdinfo.idp.icpac.mapper.DuplicateCheckSentenceMapper;
import com.jxdinfo.idp.icpac.service.DuplicateCheckSentenceService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckSimilarSentenceService;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DuplicateCheckSentenceServiceImpl
extends ServiceImpl<DuplicateCheckSentenceMapper, DuplicateCheckSentence>
implements DuplicateCheckSentenceService {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckSentenceServiceImpl.class);
    @Resource
    private DuplicateCheckSentenceMapper mapper;
    @Resource
    private DuplicateCheckSimilarSentenceService similarSentenceService;
    @Resource
    private SqlSessionFactory sqlSessionFactory;

    @Override
    public void saveBatch(List<DuplicateCheckSentenceDto> sentenceDtoList) {
        if (CollectionUtils.isEmpty(sentenceDtoList)) {
            return;
        }
        ArrayList<DuplicateCheckSimilarSentenceDto> similarSentenceList = new ArrayList<DuplicateCheckSimilarSentenceDto>();
        for (DuplicateCheckSentenceDto sentenceDto : sentenceDtoList) {
            similarSentenceList.addAll(sentenceDto.getSimilarSentenceList());
        }
        List<DuplicateCheckSentence> baseResults = DuplicateCheckSentence.toEntity(sentenceDtoList);
        this.insertBatch(baseResults);
        this.similarSentenceService.saveBatch(similarSentenceList);
    }

    private void insertBatch(List<DuplicateCheckSentence> baseResults) {
        long startTime = System.currentTimeMillis();
        String prefix = "SELECT 1";
        SqlSession sqlSession = null;
        Connection connection = null;
        Statement statement = null;
        int size = baseResults.size();
        int commitSize = 3000;
        int commitCount = size / commitSize + 1;
        try {
            sqlSession = this.sqlSessionFactory.openSession();
            connection = sqlSession.getConnection();
            connection.setAutoCommit(false);
            statement = connection.prepareStatement(prefix);
            int index = 0;
            for (int i = 0; i < commitCount; ++i) {
                StringBuilder sql = new StringBuilder("INSERT INTO idp_icpac_duplicate_check_sentence (id, doc_id, sentence,location,sentence_index,file_name,ignore_flag,belong_chapter) values");
                int baseSqlLen = sql.length();
                int newCommitSize = commitSize * (i + 1);
                while (index < size && index < newCommitSize) {
                    DuplicateCheckSentence checkSentence = baseResults.get(index);
                    String sentence = checkSentence.getSentence();
                    if (sentence.contains("'")) {
                        sentence = sentence.replaceAll("'", "\\\\'");
                    }
                    sql.append("('").append(checkSentence.getId()).append("','").append(checkSentence.getDocId()).append("','").append(sentence).append("','").append(checkSentence.getLocation()).append("','").append(checkSentence.getSentenceIndex()).append("','").append(checkSentence.getFileName()).append("','").append(checkSentence.getIgnoreFlag()).append("','").append(checkSentence.getBelongChapter()).append("'),");
                    ++index;
                }
                if (sql.length() <= baseSqlLen) continue;
                statement.addBatch(sql.substring(0, sql.lastIndexOf(",")));
                statement.executeBatch();
                statement.clearBatch();
                connection.commit();
            }
        }
        catch (SQLException e) {
            log.error("\u63d2\u5165\u51fa\u9519,", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ignored) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ignored) {}
            }
            if (sqlSession != null) {
                sqlSession.close();
            }
            log.info("\u63d2\u5165\u7ed3\u675f,\u8017\u8d39\u65f6\u95f4\uff1a{}", (Object)((System.currentTimeMillis() - startTime) / 1000L));
        }
    }

    @Override
    public List<String> deleteByDocIds(List<String> docIds) {
        if (CollectionUtils.isEmpty(docIds)) {
            return new ArrayList<String>();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(DuplicateCheckSentence::getDocId, docIds);
        List sentenceList = this.list((Wrapper)wrapper);
        List<String> ids = sentenceList.stream().map(DuplicateCheckSentence::getId).collect(Collectors.toList());
        this.removeByIds(ids);
        return ids;
    }

    @Override
    public Page<? extends DuplicateCheckSentence> getSentenceList(DuplicateCheckSentenceQuery query) {
        Page<DuplicateCheckSentenceDto> page = query.getPage(DuplicateCheckSentenceDto.class);
        List<DuplicateCheckSentenceDto> list = this.mapper.getSentenceList(query, page);
        page.setRecords(list);
        return page;
    }

    @Override
    public List<DuplicateCheckSentenceDto> getSentenceListNoPage(DuplicateCheckSentenceQuery query) {
        return this.mapper.getSentenceList(query, null);
    }

    @Override
    public void updateIgnoreSentence(String sentenceId, String ingoreFlag) {
        DuplicateCheckSentence sentence = new DuplicateCheckSentence();
        sentence.setIgnoreFlag(ingoreFlag);
        sentence.setId(sentenceId);
        this.updateById(sentence);
    }

    @Override
    public Page<DuplicateCheckSentenceDto> getSentenceWithMaxSimiSentencePage(DuplicateCheckSentenceQuery sentenceQuery) {
        Page<DuplicateCheckSentenceDto> page = sentenceQuery.getPage(DuplicateCheckSentenceDto.class);
        List<DuplicateCheckSentenceDto> sentenceList = this.mapper.getSentenceList(sentenceQuery, page);
        if (CollectionUtils.isEmpty(sentenceList)) {
            return page;
        }
        this.getMaxSimilaritySentence(sentenceList);
        page.setRecords(sentenceList);
        return page;
    }

    @Override
    public List<DuplicateCheckSentenceDto> getSentenceWithMaxSimiSentence(DuplicateCheckSentenceQuery sentenceQuery) {
        List<DuplicateCheckSentenceDto> sentenceList = this.getSentenceListNoPage(sentenceQuery);
        if (CollectionUtils.isEmpty(sentenceList)) {
            return new ArrayList<DuplicateCheckSentenceDto>();
        }
        this.getMaxSimilaritySentence(sentenceList);
        return sentenceList;
    }

    private void getMaxSimilaritySentence(List<DuplicateCheckSentenceDto> sentenceList) {
        ArrayList<String> sentenceIdList = new ArrayList<String>();
        HashMap<String, DuplicateCheckSentenceDto> idObjMap = new HashMap<String, DuplicateCheckSentenceDto>();
        for (DuplicateCheckSentenceDto sentenceDto : sentenceList) {
            sentenceIdList.add(sentenceDto.getId());
            idObjMap.put(sentenceDto.getId(), sentenceDto);
        }
        DuplicateCheckSimilarSentenceQuery similarSentenceQuery = new DuplicateCheckSimilarSentenceQuery();
        similarSentenceQuery.setSentenceIds(sentenceIdList);
        List<DuplicateCheckSimilarSentenceDto> similarSentenceList = this.similarSentenceService.getMaxSimilaritySentence(similarSentenceQuery);
        for (DuplicateCheckSimilarSentenceDto similarSentenceDto : similarSentenceList) {
            String sentenceId = similarSentenceDto.getSentenceId();
            DuplicateCheckSentenceDto sentence = (DuplicateCheckSentenceDto)idObjMap.get(sentenceId);
            if (sentence == null || sentence.getSimilarSentenceList().size() != 0) continue;
            sentence.addSimilarSentence(similarSentenceDto);
        }
    }

    @Override
    public Page<? extends DuplicateCheckSentence> getSentenceWithSimilarityDoc(DuplicateCheckSentenceQuery query) {
        Page<DuplicateCheckSentenceDto> page = query.getPage(DuplicateCheckSentenceDto.class);
        List<DuplicateCheckSentenceDto> list = this.mapper.getSentenceWithSimilarityDoc(query, page);
        page.setRecords(list);
        return page;
    }
}

