/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.service.impl;

import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.user.UserUtils;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckChapterDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckProjectDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckProject;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckTableConfig;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckProjectQuery;
import com.jxdinfo.idp.icpac.listen.baseinfo.DuplicateCheckProjectChain;
import com.jxdinfo.idp.icpac.listen.event.DuplicateCheckEvent;
import com.jxdinfo.idp.icpac.listen.event.MultiSimilarityEventType;
import com.jxdinfo.idp.icpac.mapper.DuplicateCheckProjectMapper;
import com.jxdinfo.idp.icpac.service.DuplicateCheckChapterService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckProjectService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckTableConfigService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DuplicateCheckProjectServiceImpl
extends ServiceImpl<DuplicateCheckProjectMapper, DuplicateCheckProject>
implements DuplicateCheckProjectService {
    private static final String TMP_PROJECT_NAME = "tmp_duplicate_document_lib";
    @Resource
    private DuplicateCheckProjectMapper mapper;
    @Resource
    private DuplicateCheckChapterService duplicateCheckChapterService;
    @Resource
    private DuplicateCheckDocService duplicateCheckDocService;
    @Resource
    private DuplicateCheckTableConfigService tableConfigService;

    @Override
    public DuplicateCheckProjectDto insertOrUpdate(DuplicateCheckProjectDto baseInfoDto) {
        if (CollectionUtils.isEmpty(baseInfoDto.getChapterList())) {
            baseInfoDto.setSpecialChapter("0");
        }
        if (StringUtils.isEmpty((CharSequence)baseInfoDto.getId())) {
            return this.insert(baseInfoDto);
        }
        return this.update(baseInfoDto);
    }

    @Override
    public List<DuplicateCheckProjectDto> listDocLibrary(DuplicateCheckProjectQuery projectQuery) {
        String belongUser = projectQuery.getBelongUser();
        return this.listNoPage(projectQuery);
    }

    @Override
    public Boolean delete(List<String> ids) {
        this.removeByIds(ids);
        DuplicateCheckProjectChain.publish(new DuplicateCheckEvent(ids, MultiSimilarityEventType.DELETE));
        return true;
    }

    @Override
    public Page<? extends DuplicateCheckProject> list(DuplicateCheckProjectQuery query) {
        Page<DuplicateCheckProjectDto> page = query.getPage(DuplicateCheckProjectDto.class);
        List<DuplicateCheckProjectDto> list = this.mapper.list(query, page);
        page.setRecords(list);
        return page;
    }

    @Override
    public List<DuplicateCheckProjectDto> listNoPage(DuplicateCheckProjectQuery query) {
        return this.mapper.list(query, null);
    }

    @Override
    public DuplicateCheckProjectDto detail(String id) {
        return DuplicateCheckProjectDto.toDto((DuplicateCheckProject)this.getById((Serializable)((Object)id)));
    }

    @Override
    public DuplicateCheckProjectDto detailWithConfigInfo(String id, String belongUser) {
        List<DuplicateCheckTableConfig> tableConfigList;
        DuplicateCheckProjectDto projectDto = this.detail(id);
        List<DuplicateCheckChapterDto> chapterDtoList = this.duplicateCheckChapterService.getByProjectId(id, belongUser);
        if (chapterDtoList != null && !chapterDtoList.isEmpty()) {
            projectDto.setChapterList(chapterDtoList);
        }
        if ((tableConfigList = this.tableConfigService.listByProjectId(id)) != null && !tableConfigList.isEmpty()) {
            projectDto.setTableConfigList(tableConfigList);
        }
        return projectDto;
    }

    private DuplicateCheckProjectDto insert(DuplicateCheckProjectDto projectDto) {
        if (StringUtils.isEmpty((CharSequence)projectDto.getProjectName())) {
            projectDto.setProjectName(TMP_PROJECT_NAME);
        }
        if (projectDto.getWordLength() == null) {
            projectDto.setWordLength(10);
        }
        if (projectDto.getSimilarityBounds() == null) {
            projectDto.setSimilarityBounds(60.0);
        }
        projectDto.setCreator(String.valueOf(UserUtils.getLoginUserId()));
        projectDto.setCreateTime(LocalDateTime.now());
        projectDto.setUpdateTime(LocalDateTime.now());
        projectDto.setId(IdUtil.simpleUUID());
        this.duplicateCheckChapterService.insert(projectDto.getChapterList(), projectDto.getId());
        this.save(DuplicateCheckProject.toEntity(projectDto));
        return projectDto;
    }

    private DuplicateCheckProjectDto update(DuplicateCheckProjectDto projectDto) {
        if (StringUtils.isEmpty((CharSequence)projectDto.getProjectName())) {
            projectDto.setProjectName(TMP_PROJECT_NAME);
        }
        projectDto.setUpdateTime(LocalDateTime.now());
        this.duplicateCheckChapterService.update(projectDto.getChapterList(), projectDto.getId(), null);
        this.updateById(DuplicateCheckProject.toEntity(projectDto));
        return projectDto;
    }

    @Override
    public List<DuplicateCheckProjectDto> getTmpDocumentLib() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DuplicateCheckProject::getProjectName, (Object)TMP_PROJECT_NAME);
        return DuplicateCheckProjectDto.toDto(this.list((Wrapper)wrapper));
    }

    @Override
    public List<DuplicateCheckProject> uniqueName(DuplicateCheckProjectDto projectInfo) {
        if (projectInfo == null || StringUtils.isEmpty((CharSequence)projectInfo.getProjectName())) {
            return new ArrayList<DuplicateCheckProject>();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(DuplicateCheckProject::getProjectName, (Object)projectInfo.getProjectName())).eq(DuplicateCheckProject::getBelongUser, (Object)projectInfo.getBelongUser())).ne(DuplicateCheckProject::getId, (Object)projectInfo.getId());
        return this.list((Wrapper)wrapper);
    }
}

