/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.service.impl;

import cn.hutool.core.util.IdUtil;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckProjectDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckDocQuery;
import com.jxdinfo.idp.icpac.core.asyncexecutor.DuplicateCheckTask;
import com.jxdinfo.idp.icpac.core.asyncexecutor.DuplicateCheckTaskExecutor;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckOperationEnum;
import com.jxdinfo.idp.icpac.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckExecutorService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckPdfChapterConfigService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckProjectService;
import com.jxdinfo.idp.icpac.service.handler.resulthandler.DefaultResultHandler;
import com.jxdinfo.idp.icpac.service.handler.resulthandler.NotifyResultHandler;
import com.jxdinfo.idp.icpac.service.handler.sentencehandler.SentenceHandlerManagement;
import com.jxdinfo.idp.icpac.utils.DuplicateCheckProgress;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DuplicateCheckExecutorServiceImpl
implements DuplicateCheckExecutorService {
    @Resource
    private DuplicateCheckDocService docService;
    @Resource
    private DuplicateCheckProjectService projectService;
    @Resource
    private DuplicateCheckPdfChapterConfigService pdfChapterConfigService;

    private DuplicateCheckTask prepareCheckDuplicate(DuplicateCheckDocQuery query) throws Exception {
        if (StringUtils.isEmpty((CharSequence)query.getId())) {
            throw new RuntimeException("\u6ca1\u6709\u7ed9\u5b9adocId\uff0c\u65e0\u6cd5\u9884\u652f\u6267\u884c\u67d0\u4e2a\u67e5\u91cd");
        }
        DuplicateCheckProgress.setProgress(query.getId(), 0);
        DuplicateCheckDocDto docDto = this.docService.simpleDetail(query.getId());
        docDto = this.tryNewDoc(query, docDto);
        DuplicateCheckProjectDto projectDto = this.projectService.detailWithConfigInfo(docDto.getProjectId(), query.getBelongUser());
        DuplicateCheckInfo checkInfo = new DuplicateCheckInfo(docDto.getId(), docDto.getFile(), projectDto.getSimilarityBounds(), projectDto.getWordLength(), DuplicateCheckOperationEnum.CHECK, SentenceHandlerManagement.get(docDto.getFile()));
        checkInfo.addAttachment("chapterConfig", projectDto.getChapterList());
        checkInfo.addAttachment("tableConfig", projectDto.getTableConfigList());
        checkInfo.addAttachment("docId", docDto.getId());
        checkInfo.addAttachment("projectId", projectDto.getId());
        checkInfo.addAttachment("chooseIdList", query.getChooseIdList());
        checkInfo.addAttachment("simThresh", projectDto.getSimilarityBounds());
        checkInfo.addAttachment("pdfChapterConfig", this.pdfChapterConfigService.select());
        String kyFlag = docDto.getKyFlag();
        checkInfo.addAttachment("updateLib", kyFlag);
        checkInfo.setFormat(query.getFormat());
        if (Objects.equals(kyFlag, "1")) {
            return new DuplicateCheckTask(checkInfo, new NotifyResultHandler(this.docService));
        }
        return new DuplicateCheckTask(checkInfo, new DefaultResultHandler(this.docService));
    }

    private DuplicateCheckDocDto tryNewDoc(DuplicateCheckDocQuery query, DuplicateCheckDocDto docDto) throws Exception {
        String kyFlag = docDto.getKyFlag();
        if (StringUtils.isNotEmpty((CharSequence)query.getProjectId()) && Objects.equals(kyFlag, "1")) {
            DuplicateCheckDocDto newDoc = new DuplicateCheckDocDto();
            newDoc.setFileName(docDto.getFileName());
            newDoc.setFilePath(docDto.getFilePath());
            newDoc.setThirdFileId("mn_" + IdUtil.simpleUUID());
            newDoc.setProjectId(query.getProjectId());
            return DuplicateCheckDocDto.toDto(this.docService.insert(newDoc));
        }
        return docDto;
    }

    @Override
    public void asyncCheckDuplicate(DuplicateCheckDocQuery query) throws Exception {
        DuplicateCheckTask duplicateCheckTask = this.prepareCheckDuplicate(query);
        DuplicateCheckTaskExecutor.executor(duplicateCheckTask);
    }

    @Override
    public void syncCheckDuplicate(DuplicateCheckDocQuery query) throws Exception {
        DuplicateCheckTask duplicateCheckTask = this.prepareCheckDuplicate(query);
        duplicateCheckTask.run();
    }

    @Override
    public void notifyCheckServer(DuplicateCheckDocQuery query) throws Exception {
        DuplicateCheckTask duplicateCheckTask = this.prepareCheckDuplicate(query);
        duplicateCheckTask.run();
    }
}

