/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.service.impl;

import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.util.DoubleUtils;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckDocDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckResultDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.dto.DuplicateCheckSentenceDto;
import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckDoc;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckDocQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckResultQuery;
import com.jxdinfo.idp.duplicatecheck.api.entity.query.DuplicateCheckSentenceQuery;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.common.util.FileUtils;
import com.jxdinfo.idp.icpac.core.asyncexecutor.DuplicateCheckTask;
import com.jxdinfo.idp.icpac.core.asyncexecutor.DuplicateCheckTaskExecutor;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckOperationEnum;
import com.jxdinfo.idp.icpac.listen.baseinfo.DuplicateCheckProjectChain;
import com.jxdinfo.idp.icpac.listen.baseinfo.DuplicateCheckProjectListener;
import com.jxdinfo.idp.icpac.listen.event.DuplicateCheckEvent;
import com.jxdinfo.idp.icpac.listen.event.MultiSimilarityEventType;
import com.jxdinfo.idp.icpac.mapper.DuplicateCheckDocMapper;
import com.jxdinfo.idp.icpac.service.DuplicateCheckDocService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckResultService;
import com.jxdinfo.idp.icpac.service.DuplicateCheckSentenceService;
import com.jxdinfo.idp.icpac.slice.FileSliceManager;
import com.jxdinfo.idp.icpac.slice.entity.PreparationFileInfo;
import com.jxdinfo.idp.icpac.utils.DuplicateCheckProgress;
import com.jxdinfo.idp.interf.DocService;
import com.jxdinfo.idp.vo.DocInfoVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DuplicateCheckDocServiceImpl
extends ServiceImpl<DuplicateCheckDocMapper, DuplicateCheckDoc>
implements DuplicateCheckDocService,
DuplicateCheckProjectListener {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCheckDocServiceImpl.class);
    protected static final long TIME_OUT = 10000L;
    protected static final long B = 1024L;
    protected static final int KB = 0x100000;
    @Resource
    private DuplicateCheckDocMapper mapper;
    @Resource
    private DuplicateCheckResultService resultService;
    @Resource
    private DuplicateCheckSentenceService sentenceService;
    @Resource
    private FileSliceManager fileSliceManager;
    @Autowired
    private DocService iDocService;

    public DuplicateCheckDocServiceImpl() {
        DuplicateCheckProjectChain.register(this);
    }

    @Override
    public void onEvent(DuplicateCheckEvent event) {
        if (event.getEventType() == MultiSimilarityEventType.DELETE) {
            List projectIds = (List)event.getData();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(DuplicateCheckDoc::getProjectId, (Collection)projectIds);
            List docInfoList = this.list((Wrapper)wrapper);
            List<String> ids = docInfoList.stream().map(DuplicateCheckDoc::getId).collect(Collectors.toList());
            this.removeByIds(ids);
            this.cascadeDelete(ids, null);
        }
    }

    @Override
    public Page<? extends DuplicateCheckDoc> list(DuplicateCheckDocQuery query) {
        Page<DuplicateCheckDocDto> page = query.getPage(DuplicateCheckDocDto.class);
        List<DuplicateCheckDocDto> docInfoList = this.mapper.list(query, page);
        page.setRecords(docInfoList);
        return page;
    }

    @Override
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        DuplicateCheckProgress.clear(ids);
        DuplicateCheckDoc checkDoc = (DuplicateCheckDoc)this.getById((Serializable)((Object)ids.get(0)));
        if (checkDoc == null) {
            return;
        }
        List checkDocList = this.listByIds(ids);
        String projectId = checkDoc.getProjectId();
        this.removeByIds(ids);
        this.cascadeDelete(ids, projectId);
        List historyDocList = checkDocList.stream().filter(k -> Objects.equals(k.getKyFlag(), "1")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(historyDocList)) {
            this.calcSimilarityAfterDelDoc(projectId);
        }
    }

    @Override
    public void calcSimilarityAfterDelSentence(String docId) {
        DuplicateCheckSentenceQuery sentenceQuery = new DuplicateCheckSentenceQuery();
        sentenceQuery.setDocId(docId);
        sentenceQuery.setIgnoreFlag("1");
        List<DuplicateCheckSentenceDto> sentenceDtoList = this.sentenceService.getSentenceListNoPage(sentenceQuery);
        DuplicateCheckDoc checkDoc = (DuplicateCheckDoc)this.getById((Serializable)((Object)docId));
        DuplicateCheckDoc doc = this.calcSimilarity(docId, checkDoc.getCandidateSentenceNum(), sentenceDtoList);
        this.updateById(doc);
    }

    private DuplicateCheckDoc calcSimilarity(String docId, int candidateSentenceNum, Collection<DuplicateCheckSentenceDto> sentenceDtoList) {
        double maxSimilarity = 0.0;
        double docSimilarity = 0.0;
        if (CollectionUtils.isNotEmpty(sentenceDtoList)) {
            BigDecimal docSimilarityD = new BigDecimal(0);
            for (DuplicateCheckSentenceDto sentence : sentenceDtoList) {
                if (Double.compare(maxSimilarity, sentence.getSimilarity()) < 0) {
                    maxSimilarity = sentence.getSimilarity();
                }
                docSimilarityD = docSimilarityD.add(BigDecimal.valueOf(sentence.getSimilarity()));
            }
            docSimilarity = DoubleUtils.towDecimal((Double)(docSimilarityD.doubleValue() / (double)candidateSentenceNum));
        }
        DuplicateCheckDoc doc = new DuplicateCheckDoc();
        doc.setId(docId);
        doc.setMaxSimilarity(maxSimilarity);
        doc.setDocSimilarity(docSimilarity);
        doc.setCandidateSentenceNum(candidateSentenceNum);
        return doc;
    }

    @Override
    public void calcSimilarityAfterDelDoc(String projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(DuplicateCheckDoc::getProjectId, (Object)projectId)).eq(DuplicateCheckDoc::getKyFlag, (Object)"0");
        List docList = this.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)docList)) {
            return;
        }
        DuplicateCheckSentenceQuery sentenceQuery = new DuplicateCheckSentenceQuery();
        List<String> docIdList = docList.stream().map(DuplicateCheckDoc::getId).collect(Collectors.toList());
        sentenceQuery.setDocIds(docIdList);
        sentenceQuery.setIgnoreFlag("1");
        List<DuplicateCheckSentenceDto> sentenceDtoList = this.sentenceService.getSentenceListNoPage(sentenceQuery);
        HashMap<String, List> docIdListMap = new HashMap<String, List>();
        for (DuplicateCheckSentenceDto sentenceDto : sentenceDtoList) {
            docIdListMap.computeIfAbsent(sentenceDto.getDocId(), k -> new ArrayList()).add(sentenceDto);
        }
        ArrayList<DuplicateCheckDoc> updateDoc = new ArrayList<DuplicateCheckDoc>();
        for (DuplicateCheckDoc doc : docList) {
            updateDoc.add(this.calcSimilarity(doc.getId(), doc.getCandidateSentenceNum(), (Collection)docIdListMap.get(doc.getId())));
        }
        this.updateBatchById(updateDoc);
    }

    private void cascadeDelete(List<String> ids, String projectId) {
        this.sentenceService.deleteByDocIds(ids);
        this.resultService.deleteByDocIds(ids);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(DuplicateCheckDoc::getProjectId, (Object)projectId)).eq(DuplicateCheckDoc::getKyFlag, (Object)"0");
        List checkDocList = this.list((Wrapper)wrapper);
        List<String> idList = checkDocList.stream().map(DuplicateCheckDoc::getId).collect(Collectors.toList());
        DuplicateCheckResultQuery resultQuery = new DuplicateCheckResultQuery();
        resultQuery.setUploadDocIds(idList);
        List<DuplicateCheckResultDto> resultDtos = this.resultService.list(resultQuery);
        if (CollectionUtils.isEmpty(resultDtos)) {
            this.sentenceService.deleteByDocIds(idList);
        } else {
            for (DuplicateCheckResultDto resultDto : resultDtos) {
                idList.remove(resultDto.getUploadDocId());
            }
            this.sentenceService.deleteByDocIds(idList);
        }
        if (StringUtils.isNotEmpty((CharSequence)projectId)) {
            DuplicateCheckInfo checkInfo = new DuplicateCheckInfo("mn_checkId", DuplicateCheckOperationEnum.DELETE);
            checkInfo.addAttachment("uploadIds", ids);
            checkInfo.addAttachment("projectId", projectId);
            DuplicateCheckTask duplicateCheckTask = new DuplicateCheckTask(checkInfo, null);
            DuplicateCheckTaskExecutor.executor(duplicateCheckTask);
        }
    }

    @Override
    public DuplicateCheckDoc sliceUploadFile(PreparationFileInfo preparationFileInfo) throws Exception {
        DuplicateCheckDocDto docDto = new DuplicateCheckDocDto();
        docDto.setProjectId(preparationFileInfo.getProjectId());
        docDto.setFileSliceId(preparationFileInfo.getSliceId());
        docDto.setSource("local");
        docDto.setKyFlag("0");
        docDto.setFileId(preparationFileInfo.getFileId());
        return this.insert(docDto);
    }

    @Override
    public DuplicateCheckDocDto detail(String id) {
        DuplicateCheckDoc docInfo = (DuplicateCheckDoc)this.getById((Serializable)((Object)id));
        if (docInfo == null) {
            return new DuplicateCheckDocDto();
        }
        DuplicateCheckDocDto docInfoDto = DuplicateCheckDocDto.toDto(docInfo);
        Map<String, List<DuplicateCheckResultDto>> idObjMap = this.resultService.listByDocIdsForMap(Collections.singletonList(id));
        docInfoDto.setResultList(idObjMap.get(docInfoDto.getId()));
        return docInfoDto;
    }

    @Override
    public List<DuplicateCheckDocDto> listByProjectId(String projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DuplicateCheckDoc::getProjectId, (Object)projectId);
        List docInfos = this.list((Wrapper)wrapper);
        return DuplicateCheckDocDto.toDto(docInfos);
    }

    @Override
    public DuplicateCheckDoc insert(DuplicateCheckDocDto docInfoDto) throws Exception {
        try {
            String projectId = docInfoDto.getProjectId();
            if (StringUtils.isEmpty((CharSequence)projectId)) {
                throw new IllegalArgumentException("\u6587\u6863\u4e0d\u77e5\u9053\u5bf9\u5e94\u7684\u57fa\u7840\u4fe1\u606fid\uff0c\u4f20\u5165\u7684\u57fa\u7840\u4fe1\u606fid\u4e3a\u7a7a");
            }
            this.fillInfo(docInfoDto);
            this.save(docInfoDto);
            return docInfoDto;
        }
        catch (Exception e) {
            if (StringUtils.isNotEmpty((CharSequence)docInfoDto.getId())) {
                this.delete(Collections.singletonList(docInfoDto.getId()));
            }
            throw e;
        }
    }

    private void fillInfo(DuplicateCheckDocDto docDto) throws Exception {
        docDto.setId(IdUtil.simpleUUID());
        docDto.setTaskStatus("0");
        docDto.setStartTime(LocalDateTime.now());
        docDto.setFileId(docDto.getFileId());
        DocInfoVo docInfoVo = this.iDocService.getDocInfo(docDto.getFileId());
        docDto.setFilePath(docInfoVo.getFilePath());
        docDto.setFileName(docInfoVo.getName());
        docDto.setThirdFileId("mn_" + IdUtil.simpleUUID());
        docDto.setCreator("local");
        if (Double.valueOf(docInfoVo.getFileSize()) < 1024.0) {
            docDto.setFileSize(docInfoVo.getFileSize());
            docDto.setFileUnit("B");
        } else if (Double.valueOf(docInfoVo.getFileSize()) < 1048576.0) {
            docDto.setFileSize(String.valueOf(DoubleUtils.towDecimal((Double)(Double.valueOf(docInfoVo.getFileSize()) / 1024.0 * 1.0))));
            docDto.setFileUnit("KB");
        } else {
            docDto.setFileSize(String.valueOf(DoubleUtils.towDecimal((Double)(Double.valueOf(docInfoVo.getFileSize()) / 1048576.0))));
            docDto.setFileUnit("MB");
        }
    }

    @Override
    public DuplicateCheckDocDto simpleDetail(String id) {
        DuplicateCheckDocQuery docQuery = new DuplicateCheckDocQuery();
        docQuery.setId(id);
        List<DuplicateCheckDocDto> docDtoList = this.mapper.list(docQuery, null);
        if (CollectionUtils.isEmpty(docDtoList)) {
            return new DuplicateCheckDocDto();
        }
        DuplicateCheckDocDto checkDocDto = docDtoList.get(0);
        String fileId = checkDocDto.getFileId();
        if (StringUtils.isNotEmpty((CharSequence)fileId)) {
            FileBytesInfo bytesInfo = FileUtils.getBytesInfo(Long.parseLong(fileId));
            MockMultipartFile file = new MockMultipartFile(bytesInfo.getFileName(), bytesInfo.getFileName() + "." + bytesInfo.getFileFormat(), null, bytesInfo.getFileBytes());
            checkDocDto.setFile((MultipartFile)file);
        }
        return checkDocDto;
    }

    @Override
    public void deleteByThirdFileId(String thirdFileId) {
        log.info("\u7ed9\u5b9a\u5220\u9664\u7684\u4e09\u65b9\u7684fileId\u4e3a\uff1a{}", (Object)thirdFileId);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DuplicateCheckDoc::getThirdFileId, (Object)thirdFileId);
        List deleteDocList = this.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)deleteDocList)) {
            return;
        }
        List<String> delIds = deleteDocList.stream().map(DuplicateCheckDoc::getId).collect(Collectors.toList());
        this.delete(delIds);
    }

    @Override
    public void deleteByFileName(String fileName, String kyFlag, String projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(DuplicateCheckDoc::getFileName, (Object)fileName)).eq(DuplicateCheckDoc::getKyFlag, (Object)kyFlag)).eq(DuplicateCheckDoc::getProjectId, (Object)projectId);
        List list = this.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.delete(list.stream().map(DuplicateCheckDoc::getId).collect(Collectors.toList()));
        }
    }

    @Override
    public Page<? extends DuplicateCheckDoc> listInfo(DuplicateCheckDocQuery docQuery) {
        Page<DuplicateCheckDoc> page = docQuery.getPage(DuplicateCheckDoc.class);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(DuplicateCheckDoc::getKyFlag, (Object)docQuery.getKyFlag())).eq(DuplicateCheckDoc::getProjectId, (Object)docQuery.getProjectId());
        if (StringUtils.isNotEmpty((CharSequence)docQuery.getFileName())) {
            wrapper.like(DuplicateCheckDoc::getFileName, (Object)docQuery.getFileName());
        }
        return (Page)this.page((IPage)page, (Wrapper)wrapper);
    }

    @Override
    public void insertCheckResult(DuplicateCheckDocDto docDto) {
        this.resultService.saveBatch(docDto.getResultList());
        this.sentenceService.saveBatch(docDto.getSentenceList());
    }
}

