/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.doccontrast.util;

import cn.hutool.core.collection.CollectionUtil;
import com.jxdinfo.idp.icpac.common.entity.FileBytesInfo;
import com.jxdinfo.idp.icpac.doccontrast.util.CompareUtil;
import com.jxdinfo.idp.icpac.doccontrast.util.StringUtils;
import com.jxdinfo.idp.icpac.docexamine.entity.location.WordLocation;
import com.jxdinfo.idp.icpac.utils.ReadWordUtil;
import com.jxdinfo.idp.icpac.utils.entity.word.WordCellInfo;
import com.jxdinfo.idp.icpac.utils.entity.word.WordParagraphInfo;
import com.jxdinfo.idp.icpac.utils.entity.word.WordRowInfo;
import com.jxdinfo.idp.icpac.utils.entity.word.WordStructureInfo;
import com.jxdinfo.idp.icpac.utils.entity.word.WordTableInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    private static final Logger log = LoggerFactory.getLogger(SignUtil.class);
    public static final String UP = "up";
    public static final String DOWN = "down";
    public static final String EXAMINE_POINT_CLASS_SUSPECT = "suspect-class";
    public static final String EXAMINE_POINT_CLASS_MUST_CHANGE = "must-change-class";
    public static final String EXAMINE_POINT_CLASS_PROMPT = "prompt-class";
    public static final String SIGN_P = "<sign_p:%s>";
    public static final String SIGN_P_DEL = "<sign_p_del:%s:%s>";
    public static final String SIGN_SPAN = "<sign_span:%s:%d:%d:%d>";
    public static final String SIGN_TABLE = "<sign_table:%s>";
    public static final String SIGN_CELL = "<sign_cell:%s>";
    public static final String SIGN_P_REGULAR = "<sign_p:(.*?)>";
    public static final String SIGN_P_DEL_REGULAR = "<sign_p_del:(.*?):(.*?)>";
    public static final String SIGN_SPAN_REGULAR = "<sign_span:(.*?):(.*?):(.*?):(.*?)>";
    public static final String SIGN_TABLE_REGULAR = "<sign_table:(.*?)>";
    public static final String SIGN_CELL_REGULAR = "<sign_cell:(.*?)>";
    public static final String LABEL_REGULAR = "<.*>(.*)</.*>";
    public static final String TEXT_REGULAR = "(?<=>)(?![\\\\w\\\\W]*<sign.*>)(.*)";

    public static String markSignP(String id) {
        return String.format(SIGN_P, id);
    }

    public static String markSignPDel(String id, String direction) {
        return String.format(SIGN_P_DEL, id, direction);
    }

    public static String markTable(String id) {
        return String.format(SIGN_TABLE, id);
    }

    public static String markCell(String id) {
        return String.format(SIGN_CELL, id);
    }

    public static String markSignSpan(String id, Integer index, Integer length, Integer type) {
        return String.format(SIGN_SPAN, id, index, length, type);
    }

    private static Matcher matchProp(String text, String regular) {
        Pattern pattern = Pattern.compile(regular);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher;
        }
        return null;
    }

    public static Matcher matchSignPProp(String text) {
        return SignUtil.matchProp(text, SIGN_P_REGULAR);
    }

    public static Matcher matchSignPDelProp(String text) {
        return SignUtil.matchProp(text, SIGN_P_DEL_REGULAR);
    }

    public static Matcher matchSignSpanProp(String text) {
        return SignUtil.matchProp(text, SIGN_SPAN_REGULAR);
    }

    public static Matcher matchSignCellProp(String text) {
        return SignUtil.matchProp(text, SIGN_CELL_REGULAR);
    }

    public static Matcher matchSignTableProp(String text) {
        return SignUtil.matchProp(text, SIGN_TABLE_REGULAR);
    }

    private static String match(String text, String regular) {
        Pattern pattern = Pattern.compile(regular);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    private static List<String> batchMatch(String text, String regular) {
        ArrayList<String> groups = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regular);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            groups.add(matcher.group());
        }
        return groups;
    }

    public static String matchSignP(String text) {
        return SignUtil.match(text, SIGN_P_REGULAR);
    }

    public static String matchSignTable(String text) {
        return SignUtil.match(text, SIGN_TABLE_REGULAR);
    }

    public static List<String> batchMatchSignP(String text) {
        return SignUtil.batchMatch(text, SIGN_P_REGULAR);
    }

    public static List<String> matchSignPDel(String text) {
        return SignUtil.batchMatch(text, SIGN_P_DEL_REGULAR);
    }

    public static List<String> matchSignSpan(String text) {
        return SignUtil.batchMatch(text, SIGN_SPAN_REGULAR);
    }

    public static String matchText(String text) {
        Pattern pattern = Pattern.compile(TEXT_REGULAR);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static List<Element> findTextElements(Element root) {
        ArrayList<Element> elements = new ArrayList();
        List nodes = root.childNodes();
        for (Node node : nodes) {
            if (!(node instanceof TextNode)) continue;
            Element element = new Element("span");
            TextNode textNode = (TextNode)node;
            element.text(textNode.getWholeText());
            node.replaceWith((Node)element);
        }
        Elements children = root.children();
        if (CollectionUtil.isEmpty((Collection)children)) {
            String text = SignUtil.text(root.toString());
            if (StringUtils.isNotEmpty(text)) {
                root.text(SignUtil.matchText(text));
            }
            elements.add(root);
        }
        elements = SignUtil.findNodeElements((List<Element>)children);
        return elements;
    }

    private static List<Element> findNodeElements(List<Element> elements) {
        ArrayList<Element> result = new ArrayList<Element>();
        boolean flag = true;
        for (Element element : elements) {
            String eText = element.text();
            if (flag && !eText.contains("sign_")) continue;
            if (StringUtils.isNotEmpty(eText)) {
                if (eText.contains("sign_")) {
                    flag = false;
                    String pureText = SignUtil.matchText(eText);
                    element.text(pureText);
                }
                result.add(element);
                continue;
            }
            eText = SignUtil.text(element.toString());
            if ("".equals(eText) || eText == null) continue;
            result.add(element);
        }
        return result;
    }

    public static String getEClass(String type) {
        switch (type) {
            case "1": {
                return "add-class";
            }
            case "2": {
                return "change-class";
            }
            case "3": {
                return "del-class";
            }
        }
        return "equal-class";
    }

    public static String getPointTypeClass(String type) {
        switch (type) {
            case "0": {
                return EXAMINE_POINT_CLASS_SUSPECT;
            }
            case "1": {
                return EXAMINE_POINT_CLASS_MUST_CHANGE;
            }
        }
        return EXAMINE_POINT_CLASS_PROMPT;
    }

    private static String text(String element, String regular) {
        Pattern pattern = Pattern.compile(regular);
        Matcher matcher = pattern.matcher(element);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static String text(String element) {
        return SignUtil.text(element, LABEL_REGULAR);
    }

    public static Document markLabel(String fileName, String htmlStr, Map<String, String> matchTextMap, Map<String, String> eTypeMap, String contentType, Map<String, String> typeMap) {
        Document doc;
        block41: {
            doc = Jsoup.parse((String)htmlStr);
            Elements pList = doc.getElementsByTag("p");
            try {
                Matcher matcher;
                for (Element element : pList) {
                    String signClass;
                    String signId;
                    List<String> signs;
                    String signText = element.text();
                    if (StringUtils.isEmpty(signText) || !signText.contains("sign_")) continue;
                    List<Element> elementList = SignUtil.findTextElements(element);
                    String allText = SignUtil.getAllText(elementList);
                    if (signText.contains("sign_p_del") && StringUtils.isNotEmpty(signs = SignUtil.matchSignPDel(signText))) {
                        for (String sign : signs) {
                            Matcher matcher2 = SignUtil.matchSignPDelProp(sign);
                            if (matcher2 == null) continue;
                            String signId2 = matcher2.group(1);
                            String position = matcher2.group(2);
                            Element affixElement = new Element("p");
                            affixElement.attr("data-id", "content" + (String)signId2);
                            affixElement.attr("class", SignUtil.getEClass(eTypeMap.get(signId2)));
                            affixElement.attr("data-type", contentType);
                            affixElement.addClass("border-left" + eTypeMap.get(signId2)).addClass("border-right" + eTypeMap.get(signId2));
                            if (UP.equals(position)) {
                                Element clone = element.clone();
                                element.empty();
                                element.appendChild((Node)affixElement);
                                element.appendChildren((Collection)clone.children());
                            }
                            if (!DOWN.equals(position)) continue;
                            element.appendChild((Node)affixElement);
                        }
                    }
                    if (signText.contains("sign_p") && (matcher = SignUtil.matchSignPProp(signText)) != null) {
                        signId = matcher.group(1);
                        element.attr("data-id", "content" + signId);
                        signClass = eTypeMap.get(signId);
                        element.attr("data-type", contentType);
                        element.addClass(SignUtil.getEClass(signClass)).addClass("border-left" + signClass).addClass("border-right" + signClass);
                    }
                    if (signText.contains("sign_span")) {
                        TreeSet<Integer> indexSet = new TreeSet<Integer>();
                        HashMap<Integer, Element> eCache = new HashMap<Integer, Element>();
                        HashMap<Integer, Element> delECache = new HashMap<Integer, Element>();
                        List<String> signs2 = SignUtil.matchSignSpan(signText);
                        if (CollectionUtil.isNotEmpty(signs2)) {
                            for (String sign : signs2) {
                                Matcher matcher3 = SignUtil.matchSignSpanProp(sign);
                                if (matcher3 == null) continue;
                                String signId3 = matcher3.group(1);
                                String matchText = matchTextMap.get(signId3);
                                int eIndex = Integer.parseInt(matcher3.group(2));
                                int eLength = Integer.parseInt(matcher3.group(3));
                                int eEndIndex = Math.min(eIndex + eLength, allText.length());
                                if (matchText != null) {
                                    if (eIndex >= allText.length()) {
                                        int index2 = CompareUtil.relocate(allText, matchText, eIndex);
                                        if (index2 != -1) {
                                            eIndex = index2;
                                        }
                                    } else {
                                        int index3;
                                        String targetText = allText.substring(eIndex, eEndIndex);
                                        if (!targetText.contains(matchText) && (index3 = CompareUtil.relocate(allText, matchText, eIndex)) != -1) {
                                            eIndex = index3;
                                        }
                                    }
                                }
                                eEndIndex = Math.min(eIndex + eLength, allText.length());
                                if (eLength == 0 || eLength == -1) {
                                    Element span = delECache.computeIfAbsent(eIndex, k -> new Element("span"));
                                    span.attr("data-type", contentType);
                                    span.attr("data-id", "content" + signId3);
                                    span.addClass(SignUtil.getEClass(eTypeMap.get(signId3))).attr("length", String.valueOf(eLength)).addClass("border-left" + eTypeMap.get(signId3)).addClass("border-right" + eTypeMap.get(signId3));
                                    indexSet.add(eIndex);
                                }
                                for (int i = eIndex; i < eEndIndex && i < allText.length(); ++i) {
                                    Element span = (Element)eCache.get(i);
                                    if (null == span) {
                                        span = new Element("span");
                                        eCache.put(i, span);
                                        indexSet.add(i);
                                    }
                                    span.text(String.valueOf(allText.charAt(i)));
                                    String eType = eTypeMap.get(signId3);
                                    span.addClass(SignUtil.getEClass(eType));
                                    if (i == eIndex) {
                                        span.addClass("border-left" + eType);
                                    }
                                    if (i == eEndIndex - 1) {
                                        span.addClass("border-right" + eType);
                                    }
                                    span.attr("data-type", contentType);
                                    String type = typeMap.get(signId3);
                                    if ("-1".equals(type) || "1".equals(type)) {
                                        span.attr("name", signId3);
                                    }
                                    if (!"-1".equals(type) && !"0".equals(type)) continue;
                                    span.attr("data-id", "content" + signId3);
                                }
                            }
                        }
                        int textLength = allText.length();
                        indexSet.removeIf(index -> index >= textLength);
                        List indexList = indexSet.stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
                        int currentStartIndex = -1;
                        int currentEIndex = 0;
                        Element current = elementList.get(currentEIndex);
                        String currentText = SignUtil.text(current.toString());
                        int beforeTextLength = currentText.length();
                        boolean handleFlag = true;
                        for (Integer index4 : indexList) {
                            Element delElement;
                            while (index4 >= beforeTextLength && ++currentEIndex < elementList.size()) {
                                if (currentStartIndex != -1 && currentStartIndex < currentText.length() - 1) {
                                    current.appendText(currentText.substring(currentStartIndex + 1));
                                }
                                current = elementList.get(currentEIndex);
                                currentText = SignUtil.text(current.toString());
                                beforeTextLength += currentText.length();
                                currentStartIndex = -1;
                                handleFlag = true;
                            }
                            int currentIndex = index4 - beforeTextLength + currentText.length();
                            if (handleFlag) {
                                current.text("");
                                handleFlag = false;
                            }
                            if (currentIndex - currentStartIndex > 1) {
                                String commonText = currentText.substring(currentStartIndex + 1, currentIndex);
                                current.appendText(commonText);
                            }
                            if (eCache.get(index4) != null) {
                                current.appendChild((Node)eCache.get(index4));
                            }
                            if ((delElement = (Element)delECache.get(index4)) != null) {
                                String length = delElement.attr("length");
                                if ("-1".equals(length)) {
                                    current.appendChild((Node)delElement);
                                }
                                if (eCache.get(index4) == null) {
                                    current.appendText(String.valueOf(allText.charAt(index4)));
                                }
                                if ("0".equals(length)) {
                                    current.appendChild((Node)delElement);
                                }
                            }
                            currentStartIndex = currentIndex;
                        }
                        if (currentStartIndex != -1 && currentStartIndex < currentText.length() - 1) {
                            current.appendText(currentText.substring(currentStartIndex + 1));
                        }
                    }
                    if (signText.contains("sign_cell") && (matcher = SignUtil.matchSignCellProp(signText)) != null) {
                        signId = matcher.group(1);
                        Element parent = element.parent();
                        Element div = new Element("div");
                        div.attr("style", "width:100%; min-height:32px");
                        if (parent != null) {
                            div.appendChildren((Collection)parent.childNodes());
                        }
                        parent.children().remove();
                        parent.appendChild((Node)div);
                        String type = typeMap.get(signId);
                        if ("-1".equals(type) || "1".equals(type)) {
                            div.attr("name", signId);
                        }
                        if ("-1".equals(type) || "0".equals(type)) {
                            div.attr("data-id", "content" + signId);
                        }
                        String signClass2 = eTypeMap.get(signId);
                        div.attr("data-type", contentType);
                        div.addClass(SignUtil.getEClass(signClass2));
                    }
                    if (!signText.contains("sign_table") || (matcher = SignUtil.matchSignTableProp(signText)) == null) continue;
                    String singId = matcher.group(1);
                    signClass = eTypeMap.get(singId);
                    Element table = SignUtil.getTable(element);
                    String type = typeMap.get(singId);
                    if ("-1".equals(type) || "1".equals(type)) {
                        table.attr("name", singId);
                    }
                    if ("-1".equals(type) || "0".equals(type)) {
                        table.attr("data-id", "content" + singId);
                    }
                    if (table == null) continue;
                    table.attr("data-id", "content" + singId).attr("data-type", contentType).addClass(SignUtil.getEClass(signClass));
                }
                if (!fileName.endsWith(".docx")) break block41;
                Elements divList = doc.getElementsByTag("div");
                for (Element element : divList) {
                    String style = element.attr("style");
                    Pattern pattern = Pattern.compile("(width.*?;)");
                    matcher = pattern.matcher(style);
                    if (matcher.find()) {
                        style = style.replace(matcher.group(), "");
                    }
                    element.attr("style", style);
                }
            }
            catch (Exception e) {
                log.error("html\u521b\u5efa\u6807\u7b7e\u5f02\u5e38", (Throwable)e);
                for (Element element : pList) {
                    if (!element.text().contains("sign_")) continue;
                    SignUtil.findTextElements(element);
                }
            }
        }
        return doc;
    }

    public static XWPFDocument preMarkLabelDocx(Map<String, WordLocation> locationMap, XWPFDocument document) {
        return null;
    }

    private static String getAllText(List<Element> elements) {
        StringBuilder buffer = new StringBuilder();
        for (Element element : elements) {
            buffer.append(SignUtil.text(element.toString()));
        }
        return buffer.toString();
    }

    private static Element getTable(Element element) {
        Element parent = element.parent();
        if (parent != null) {
            if ("table".equals(parent.tagName())) {
                return parent;
            }
            return SignUtil.getTable(parent);
        }
        return null;
    }

    public static void handleDocxTable(Document document, FileBytesInfo fileInfo) {
        Elements tables = document.getElementsByTag("table");
        WordStructureInfo wordInfo = ReadWordUtil.getWordInfo(fileInfo);
        List<WordTableInfo> tableInfos = wordInfo.getTableInfos();
        try {
            for (int i = 0; i < tables.size() && i < tableInfos.size(); ++i) {
                Element table = (Element)tables.get(i);
                String originStyle = table.attr("style");
                table.attr("style", originStyle + "width: 100%;");
                table.children().remove();
                Element tbody = new Element("tbody");
                table.appendChild((Node)tbody);
                WordTableInfo tableInfo = tableInfos.get(i);
                List<WordRowInfo> rows = tableInfo.getRows();
                for (WordRowInfo row : rows) {
                    Element tr = new Element("tr");
                    tbody.appendChild((Node)tr);
                    List<WordCellInfo> cells = row.getCells();
                    for (WordCellInfo cell : cells) {
                        Integer colSpan = cell.getColSpan();
                        Integer rowSpan = cell.getRowSpan();
                        if (rowSpan == null) continue;
                        Element td = new Element("td");
                        tr.appendChild((Node)td);
                        td.attr("colspan", String.valueOf(colSpan)).attr("rowspan", String.valueOf(rowSpan));
                        List<WordParagraphInfo> paragraphs = cell.getParagraphs();
                        if (!CollectionUtil.isNotEmpty(paragraphs)) continue;
                        Element p = new Element("p");
                        td.appendChild((Node)p);
                        for (WordParagraphInfo paragraph : paragraphs) {
                            Element span = new Element("span");
                            p.appendChild((Node)span);
                            span.text(paragraph.getText());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

