/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.icpac.core.dochandler.impl;

import com.jxdinfo.idp.duplicatecheck.api.entity.po.DuplicateCheckPdfChapterConfig;
import com.jxdinfo.idp.icpac.core.dochandler.DocumentHandler;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckCandidateSentence;
import com.jxdinfo.idp.icpac.core.entity.DuplicateCheckInfo;
import com.jxdinfo.idp.icpac.core.entity.PDFContrastRequest;
import com.jxdinfo.idp.icpac.core.handler.SentenceHandler;
import com.jxdinfo.idp.icpac.core.rmi.feign.MutilFormatRestorationFeignHttp;
import com.jxdinfo.idp.icpac.utils.FilenameUtils;
import com.jxdinfo.idp.icpac.utils.entity.WordElementInfo;
import com.jxdinfo.idp.icpac.utils.entity.word.WordChapterInfo;
import com.jxdinfo.idp.icpac.utils.entity.word.WordParagraphInfo;
import com.jxdinfo.idp.icpac.utils.entity.word.WordStructureInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

public class PdfDocumentHandler
implements DocumentHandler {
    private static final Logger log = LoggerFactory.getLogger(PdfDocumentHandler.class);
    @Autowired
    private MutilFormatRestorationFeignHttp iMutilFormatRestorationFeignHttp;
    private static final Pattern CHAPTER_PATTERN = Pattern.compile("^((\\d+\\.?)+)");
    private static final Pattern CAESURA_NOISE_PATTERN = Pattern.compile("^((\\d+\u3001)+)");
    private static final Pattern MONTH_NOISE_PATTERN = Pattern.compile("^(\\d{4}[\u5e74/-]\\d{1,2})[\u6708/-]\\d{1,2}\u65e5?");
    private final Map<String, PDFChapter> chapterCollection = new HashMap<String, PDFChapter>();

    @Override
    public List<DuplicateCheckCandidateSentence> handleDoc(DuplicateCheckInfo info) throws Exception {
        MultipartFile file = info.getFile();
        if (!this.canParsePdf(file)) {
            log.warn("\u5f53\u524d\u7684pdf\uff1a'{}' \u4e0d\u662f\u7535\u5b50\u7248 \u800c\u662f\u626b\u63cf\u4ef6", (Object)info.getFile().getOriginalFilename());
            return new ArrayList<DuplicateCheckCandidateSentence>();
        }
        this.parseBookMark(file);
        file = this.pdf2Word(file);
        WordStructureInfo wordStructureInfo = this.parseDocx(file);
        List pdfChapterConfig = info.getAttachment("pdfChapterConfig", List.class);
        HashMap<Integer, Set<String>> levelChapterMap = new HashMap<Integer, Set<String>>();
        for (DuplicateCheckPdfChapterConfig chapterConfig : pdfChapterConfig) {
            levelChapterMap.computeIfAbsent(chapterConfig.getLevel(), k -> new HashSet()).add(chapterConfig.getChapterName());
        }
        List<WordChapterInfo> wordChapterInfos = this.assembleChapter(wordStructureInfo.getElementInfos(), levelChapterMap);
        wordStructureInfo.setChapterInfos(wordChapterInfos);
        SentenceHandler sentenceHandler = info.getSentenceHandler();
        if (sentenceHandler == null) {
            throw new RuntimeException("\u7ed9\u5b9a\u7684\u81ea\u5b9a\u4e49\u7684\u53e5\u5b50\u5904\u7406\u5668\u4e3a\u7a7a\uff0c\u6ca1\u6709\u529e\u6cd5\u83b7\u53d6\u81ea\u5b9a\u4e49\u7684\u53e5\u5b50\u5904\u7406\u5668");
        }
        return sentenceHandler.handleSentence(wordStructureInfo.getChapterInfos(), info);
    }

    private void parseBookMark(MultipartFile file) throws IOException {
    }

    private void printBookmark(PDOutlineItem bookmark, int level, PDFChapter parent) throws IOException {
        String title = bookmark.getTitle();
        PDFChapter pdfChapter = new PDFChapter(title.replaceAll(" ", "").trim(), parent, level);
        this.chapterCollection.put(title, pdfChapter);
        Iterable children = bookmark.children();
        if (children != null) {
            for (PDOutlineItem child : children) {
                this.printBookmark(child, level + 1, pdfChapter);
            }
        }
    }

    private boolean canParsePdf(MultipartFile file) throws IOException {
        return true;
    }

    private WordStructureInfo parseDocx(MultipartFile file) {
        WordStructureInfo result = new WordStructureInfo();
        try (XWPFDocument document = new XWPFDocument((InputStream)new ByteArrayInputStream(file.getBytes()));){
            ArrayList<WordElementInfo> elementInfos = new ArrayList<WordElementInfo>();
            result.setElementInfos(elementInfos);
            List paragraphList = document.getParagraphs();
            int pIndex = -1;
            int index = -1;
            for (XWPFParagraph paragraph : paragraphList) {
                String text = paragraph.getParagraphText();
                if (StringUtils.isEmpty((CharSequence)text)) continue;
                WordParagraphInfo info = new WordParagraphInfo();
                elementInfos.add(info);
                info.setPoiIndex(++pIndex);
                info.setText(text);
                info.setIndex(++index);
            }
        }
        catch (IOException e) {
            log.error("docx\u6587\u6863+\u3010" + file.getOriginalFilename() + "\u3011\u52a0\u8f7d\u5f02\u5e38\uff01");
        }
        return result;
    }

    private List<WordChapterInfo> assembleChapter(List<WordElementInfo> elementInfos, Map<Integer, Set<String>> levelChapterMap) {
        WordChapterInfo before = null;
        ArrayList<WordChapterInfo> chapterList = new ArrayList<WordChapterInfo>();
        HashMap<Integer, List> chapterInfoMap = new HashMap<Integer, List>();
        for (WordElementInfo elementInfo : elementInfos) {
            WordChapterInfo chapterInfo;
            WordParagraphInfo paragraphInfo = (WordParagraphInfo)elementInfo;
            String text = paragraphInfo.getText();
            Matcher matcher = CHAPTER_PATTERN.matcher(paragraphInfo.getText());
            String chapterNo = null;
            if (matcher.find()) {
                chapterNo = matcher.group();
            }
            if (this.chapterCollection.size() > 0) {
                PDFChapter chapter = this.chapterCollection.get(text.replaceAll(" ", "").trim());
                if (chapter != null) {
                    WordChapterInfo chapterInfo2 = new WordChapterInfo();
                    chapterInfo2.setTitleName(paragraphInfo.getText());
                    chapter.setChapterInfo(chapterInfo2);
                    PDFChapter parent = chapter.getParent();
                    if (parent != null && parent.getChapterInfo() != null) {
                        WordChapterInfo parentChapterInfo = parent.getChapterInfo();
                        parentChapterInfo.addChildChapter(chapterInfo2);
                    } else {
                        chapterList.add(chapterInfo2);
                    }
                    before = chapterInfo2;
                    continue;
                }
            } else if (this.isChapter(chapterNo, paragraphInfo, before, levelChapterMap)) {
                chapterInfo = new WordChapterInfo();
                chapterInfo.setTitleName(paragraphInfo.getText());
                String[] chapterNoArr = chapterNo.split("\\.");
                int level = chapterNoArr.length - 1;
                List chapterInfoList = (List)chapterInfoMap.get(level - 1);
                if (chapterInfoList == null) {
                    chapterList.add(chapterInfo);
                } else {
                    WordChapterInfo parent = (WordChapterInfo)chapterInfoList.get(chapterInfoList.size() - 1);
                    parent.addChildChapter(chapterInfo);
                    chapterInfo.setParent(parent);
                }
                chapterInfoMap.computeIfAbsent(level, k -> new ArrayList()).add(chapterInfo);
                before = chapterInfo;
                continue;
            }
            if (before == null) {
                chapterInfo = new WordChapterInfo();
                chapterInfo.setTitleName("virtual_chapter");
                chapterInfo.addParagraph(elementInfo);
                chapterInfo.setLevel(null);
                chapterList.add(chapterInfo);
                continue;
            }
            before.addParagraph(elementInfo);
        }
        return chapterList;
    }

    private boolean isChapter(String chapterNo, WordParagraphInfo paragraphInfo, WordChapterInfo before, Map<Integer, Set<String>> levelChapterMap) {
        int bIndex;
        if (StringUtils.isEmpty((CharSequence)chapterNo)) {
            return false;
        }
        String text = paragraphInfo.getText();
        Matcher matcher = CAESURA_NOISE_PATTERN.matcher(text);
        if (matcher.find()) {
            return false;
        }
        matcher = MONTH_NOISE_PATTERN.matcher(text);
        if (matcher.find()) {
            return false;
        }
        String[] currentChapterNoArr = chapterNo.split("\\.");
        int level = currentChapterNoArr.length;
        Set<String> chapterConfigs = levelChapterMap.get(level);
        if (CollectionUtils.isNotEmpty(chapterConfigs)) {
            boolean isChapter = chapterConfigs.contains(paragraphInfo.getText().replaceAll(chapterNo, "").trim());
            return isChapter;
        }
        if (before == null) {
            return true;
        }
        String titleName = before.getTitleName();
        Matcher beforeMatch = CHAPTER_PATTERN.matcher(titleName);
        String beforeChapterNo = "";
        if (beforeMatch.find()) {
            beforeChapterNo = beforeMatch.group();
        }
        String[] beforeChapterNoArr = beforeChapterNo.split("\\.");
        int cIndex = 0;
        int cLen = level;
        int bLen = beforeChapterNoArr.length;
        for (bIndex = 0; cIndex < cLen && bIndex < bLen; ++cIndex, ++bIndex) {
            try {
                String currentFirst = currentChapterNoArr[cIndex];
                String beforeFirst = beforeChapterNoArr[bIndex];
                int cInt = Integer.parseInt(currentFirst);
                int bInt = Integer.parseInt(beforeFirst);
                if (cInt == bInt || cInt - bInt == 1) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return cIndex == level || bIndex == beforeChapterNoArr.length;
    }

    private MultipartFile pdf2Word(MultipartFile file) throws Exception {
        log.info("\u5f00\u59cbpdf\u8f6cword\u64cd\u4f5c");
        String filename = file.getOriginalFilename();
        PDFContrastRequest contrastRequest = new PDFContrastRequest();
        contrastRequest.setFile(file);
        contrastRequest.setFile_type("PDF");
        contrastRequest.setFilter_header_footer("1");
        contrastRequest.setMerge_cross_paraph("1");
        contrastRequest.setFilter_catalog("1");
        byte[] wordBytes = (byte[])this.iMutilFormatRestorationFeignHttp.turnPDFToWord(contrastRequest).getData();
        if (wordBytes == null || !this.isSuccess(wordBytes)) {
            String message = "\u67e5\u91cd\u670d\u52a1\u7ed9\u5b9a\u7684pdf\u8f6cword\u4e3anull";
            if (wordBytes != null) {
                message = new String(wordBytes, StandardCharsets.UTF_8);
            }
            throw new RuntimeException(filename + "\u8f6cword\u51fa\u73b0\u5f02\u5e38:" + message);
        }
        String filePrefix = FilenameUtils.getFilePrefix(filename);
        log.info("\u5f00\u59cbpdf\u8f6cword\u64cd\u4f5c\u7ed3\u675f");
        return new MockMultipartFile(filePrefix + ".docx", filePrefix + ".docx", null, wordBytes);
    }

    private boolean isSuccess(byte[] wordBytes) {
        StringBuilder codeSb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            codeSb.append(String.format("%02x", wordBytes[i]));
        }
        return "504B0304".equalsIgnoreCase(codeSb.toString());
    }

    private class PDFChapter {
        private String chapterStr;
        private PDFChapter parent;
        private int level = 0;
        private WordChapterInfo chapterInfo;

        public PDFChapter(String chapterStr, PDFChapter parent, int level) {
            this.chapterStr = chapterStr;
            this.parent = parent;
            this.level = level;
        }

        public String getChapterStr() {
            return this.chapterStr;
        }

        public PDFChapter getParent() {
            return this.parent;
        }

        public int getLevel() {
            return this.level;
        }

        public WordChapterInfo getChapterInfo() {
            return this.chapterInfo;
        }

        public void setChapterStr(String chapterStr) {
            this.chapterStr = chapterStr;
        }

        public void setParent(PDFChapter parent) {
            this.parent = parent;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public void setChapterInfo(WordChapterInfo chapterInfo) {
            this.chapterInfo = chapterInfo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PDFChapter)) {
                return false;
            }
            PDFChapter other = (PDFChapter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLevel() != other.getLevel()) {
                return false;
            }
            String this$chapterStr = this.getChapterStr();
            String other$chapterStr = other.getChapterStr();
            if (this$chapterStr == null ? other$chapterStr != null : !this$chapterStr.equals(other$chapterStr)) {
                return false;
            }
            PDFChapter this$parent = this.getParent();
            PDFChapter other$parent = other.getParent();
            if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
                return false;
            }
            WordChapterInfo this$chapterInfo = this.getChapterInfo();
            WordChapterInfo other$chapterInfo = other.getChapterInfo();
            return !(this$chapterInfo == null ? other$chapterInfo != null : !((Object)this$chapterInfo).equals(other$chapterInfo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PDFChapter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLevel();
            String $chapterStr = this.getChapterStr();
            result = result * 59 + ($chapterStr == null ? 43 : $chapterStr.hashCode());
            PDFChapter $parent = this.getParent();
            result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
            WordChapterInfo $chapterInfo = this.getChapterInfo();
            result = result * 59 + ($chapterInfo == null ? 43 : ((Object)$chapterInfo).hashCode());
            return result;
        }

        public String toString() {
            return "PdfDocumentHandler.PDFChapter(chapterStr=" + this.getChapterStr() + ", parent=" + this.getParent() + ", level=" + this.getLevel() + ", chapterInfo=" + this.getChapterInfo() + ")";
        }

        public PDFChapter(String chapterStr, PDFChapter parent, int level, WordChapterInfo chapterInfo) {
            this.chapterStr = chapterStr;
            this.parent = parent;
            this.level = level;
            this.chapterInfo = chapterInfo;
        }
    }
}

